/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.helper.ProfProvider;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.ShieldProf;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteTest;

public class PreShieldProfTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) {
        int numberRequired = Integer.parseInt(prereq.getOperand());
        int runningTotal = 0;
        String aString = prereq.getKey();
        boolean isType = aString.startsWith("TYPE") && aString.length() > 5;
        boolean isShieldType = aString.startsWith("SHIELDTYPE") && aString.length() > 11;
        String typeString = null;
        if (isType) {
            typeString = "SHIELD." + aString.substring(5);
        } else if (isShieldType) {
            typeString = "SHIELD." + aString.substring(11);
        }
        Equipment keyEquip = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, aString);
        for (ProfProvider<ShieldProf> spp : display.getShieldProfList()) {
            if (keyEquip != null && spp.providesProficiency(keyEquip.getShieldProf())) {
                ++runningTotal;
                continue;
            }
            if (keyEquip != null && spp.providesEquipmentType(keyEquip.getType())) {
                ++runningTotal;
                continue;
            }
            if (isType && spp.providesEquipmentType(typeString)) {
                ++runningTotal;
                continue;
            }
            if (!isShieldType || !spp.providesEquipmentType(typeString)) continue;
            ++runningTotal;
        }
        runningTotal = prereq.getOperator().compare(runningTotal, numberRequired);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String kindHandled() {
        return "profwithshield";
    }
}

