/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.prof;

import pcgen.core.kit.KitProf;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CountToken
extends AbstractToken
implements CDOMPrimaryToken<KitProf> {
    @Override
    public String getTokenName() {
        return "COUNT";
    }

    @Override
    public Class<KitProf> getTokenClass() {
        return KitProf.class;
    }

    @Override
    public ParseResult parseToken(LoadContext context, KitProf kitProf, String value) {
        try {
            Integer quan = Integer.valueOf(value);
            if (quan <= 0) {
                return new ParseResult.Fail(this.getTokenName() + " expected an integer > 0", context);
            }
            kitProf.setCount(quan);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>", context);
        }
    }

    @Override
    public String[] unparse(LoadContext context, KitProf kitProf) {
        Integer bd = kitProf.getCount();
        if (bd == null) {
            return null;
        }
        return new String[]{bd.toString()};
    }
}

