/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit;

import pcgen.core.kit.KitBio;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AgeToken
extends AbstractNonEmptyToken<KitBio>
implements CDOMPrimaryToken<KitBio> {
    @Override
    public String getTokenName() {
        return "AGE";
    }

    @Override
    public Class<KitBio> getTokenClass() {
        return KitBio.class;
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, KitBio kitName, String value) {
        try {
            kitName.setCharacterAge(new Integer(value));
        }
        catch (NumberFormatException e) {
            return new ParseResult.Fail("Illegal value for AGE: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, KitBio kitName) {
        Integer bd = kitName.getCharacterAge();
        if (bd == null) {
            return null;
        }
        return new String[]{bd.toString()};
    }
}

