/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode;

import java.net.URI;
import java.util.StringTokenizer;
import pcgen.core.GameMode;
import pcgen.persistence.lst.EquipIconLstToken;
import pcgen.util.Logging;

public class IconToken
implements EquipIconLstToken {
    @Override
    public String getTokenName() {
        return "ICON";
    }

    @Override
    public boolean parse(GameMode gameMode, String value, URI source) {
        StringTokenizer aTok = new StringTokenizer(value, "|", false);
        if (aTok.countTokens() < 2) {
            Logging.log(Logging.LST_ERROR, this.getTokenName() + " expecting '|', format is: " + "EquipType|IconPath was: " + value);
            return false;
        }
        if (aTok.countTokens() > 3) {
            Logging.log(Logging.LST_ERROR, this.getTokenName() + " too many '|', format is: " + "EquipType|IconPath|Priority was: " + value);
            return false;
        }
        String equipType = aTok.nextToken();
        String iconPath = aTok.nextToken();
        int priority = 10;
        if (aTok.hasMoreElements()) {
            String priorityToken = aTok.nextToken();
            try {
                priority = Integer.parseInt(priorityToken);
            }
            catch (NumberFormatException ex) {
                Logging.log(Logging.LST_ERROR, this.getTokenName() + " expected an integer priority .  Found: " + priorityToken + " in " + value);
                return false;
            }
        }
        gameMode.setEquipTypeIcon(equipType.intern(), iconPath.intern(), priority);
        return true;
    }
}

