/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.auto;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.content.ConditionalSelectionActor;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class EquipToken
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
ChooseSelectionActor<Equipment> {
    private static final Class<Equipment> EQUIPMENT_CLASS = Equipment.class;

    @Override
    public String getParentToken() {
        return "AUTO";
    }

    @Override
    public String getTokenName() {
        return "EQUIP";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        String equipItems;
        Prerequisite prereq = null;
        boolean isPre = false;
        if (value.indexOf("[") == -1) {
            equipItems = value;
            StringTokenizer tok = new StringTokenizer(equipItems, "|");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (!PreParserFactory.isPreReqString(token)) continue;
                if (isPre) {
                    String errorText = "Invalid " + this.getTokenName() + ": " + value + "  PRExxx must be at the END of the Token";
                    Logging.errorPrint(errorText);
                    return new ParseResult.Fail(errorText, context);
                }
                prereq = this.getPrerequisite(token);
                if (prereq == null) {
                    return new ParseResult.Fail("Error generating Prerequisite " + prereq + " in " + this.getFullName(), context);
                }
                int preStart = value.indexOf(token) - 1;
                equipItems = value.substring(0, preStart);
                isPre = true;
            }
        } else {
            return new ParseResult.Fail("Use of [] for Prerequisites is no longer supported, please use | based standard", context);
        }
        ParseResult pr = this.checkForIllegalSeparator('|', equipItems);
        if (!pr.passed()) {
            return pr;
        }
        StringTokenizer tok = new StringTokenizer(equipItems, "|");
        while (tok.hasMoreTokens()) {
            String aProf = tok.nextToken();
            if ("%LIST".equals(aProf)) {
                ChooseSelectionActor<Equipment> cra;
                if (prereq == null) {
                    cra = this;
                } else {
                    ConditionalSelectionActor<Equipment> cca = new ConditionalSelectionActor<Equipment>(this);
                    cca.addPrerequisite(prereq);
                    cra = cca;
                }
                context.getObjectContext().addToList(obj, ListKey.NEW_CHOOSE_ACTOR, cra);
                continue;
            }
            CDOMReference<Equipment> ref = TokenUtilities.getTypeOrPrimitive(context, EQUIPMENT_CLASS, aProf);
            if (ref == null) {
                return ParseResult.INTERNAL_ERROR;
            }
            context.getObjectContext().addToList(obj, ListKey.EQUIPMENT, new QualifiedObject<CDOMReference<Equipment>>(ref, prereq));
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Collection<ChooseSelectionActor<?>> listAdded;
        ArrayList<String> list = new ArrayList<String>();
        PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
        Changes<ChooseSelectionActor<?>> listChanges = context.getObjectContext().getListChanges(obj, ListKey.NEW_CHOOSE_ACTOR);
        Changes<QualifiedObject<CDOMReference<Equipment>>> changes = context.getObjectContext().getListChanges(obj, ListKey.EQUIPMENT);
        Collection<QualifiedObject<CDOMReference<Equipment>>> added = changes.getAdded();
        HashMapToList m = new HashMapToList();
        if (added != null) {
            for (QualifiedObject<CDOMReference<Equipment>> qo : added) {
                m.addToListFor(qo.getPrerequisiteList(), qo.getRawObject());
            }
        }
        if ((listAdded = listChanges.getAdded()) != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor chooseSelectionActor : listAdded) {
                if (!chooseSelectionActor.getSource().equals(this.getTokenName())) continue;
                try {
                    list.add(chooseSelectionActor.getLstFormat());
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + e);
                    return null;
                }
            }
        }
        for (List list2 : m.getKeySet()) {
            List eq = m.getListFor((Object)list2);
            WeightedCollection refs = new WeightedCollection(ReferenceUtilities.REFERENCE_SORTER);
            refs.addAll(eq);
            String ab = ReferenceUtilities.joinLstFormat(refs, "|");
            if (list2 != null && !list2.isEmpty()) {
                if (list2.size() > 1) {
                    context.addWriteMessage("Error: " + obj.getClass().getSimpleName() + " had more than one Prerequisite for " + this.getFullName());
                    return null;
                }
                Prerequisite p = (Prerequisite)list2.get(0);
                StringWriter swriter = new StringWriter();
                try {
                    prereqWriter.write(swriter, p);
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + e);
                    return null;
                }
                ab = ab + '|' + swriter.toString();
            }
            list.add(ab);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public void applyChoice(ChooseDriver obj, Equipment e, PlayerCharacter pc) {
        e = e.clone();
        e.setQty(1.0);
        e.setAutomatic(true);
        pc.addAutoEquipment(e, obj);
    }

    @Override
    public void removeChoice(ChooseDriver obj, Equipment e, PlayerCharacter pc) {
        pc.removeAutoEquipment(e, obj);
    }

    @Override
    public Class<Equipment> getChoiceClass() {
        return EQUIPMENT_CLASS;
    }

    @Override
    public String getSource() {
        return this.getTokenName();
    }

    @Override
    public String getLstFormat() {
        return "%LIST";
    }
}

