/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import pcgen.gui2.util.JTableEx;
import pcgen.gui2.util.event.DynamicTableColumnModelListener;
import pcgen.gui2.util.table.DefaultDynamicTableColumnModel;
import pcgen.gui2.util.table.DynamicTableColumnModel;

public class JDynamicTable
extends JTableEx {
    private final DynamicTableColumnModelListener listener = new DynamicTableColumnModelListener(){

        @Override
        public void availableColumnAdded(TableColumnModelEvent event) {
            int index = event.getToIndex();
            TableColumn column = JDynamicTable.this.dynamicColumnModel.getAvailableColumns().get(index);
            JDynamicTable.this.menu.insert(JDynamicTable.this.createMenuItem(column), index);
            JDynamicTable.this.cornerButton.setVisible(true);
        }

        @Override
        public void availableColumnRemove(TableColumnModelEvent event) {
            JDynamicTable.this.menu.remove(event.getFromIndex());
            if (JDynamicTable.this.menu.getComponentCount() == 0) {
                JDynamicTable.this.cornerButton.setVisible(false);
            }
        }
    };
    private final JButton cornerButton = new JButton(new CornerAction());
    private DynamicTableColumnModel dynamicColumnModel = null;
    private JPopupMenu menu = new JPopupMenu();

    @Override
    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
        }
    }

    @Override
    protected void unconfigureEnclosingScrollPane() {
        Container gp;
        super.unconfigureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.setCorner("UPPER_RIGHT_CORNER", null);
        }
    }

    protected DynamicTableColumnModel createDefaultDynamicTableColumnModel() {
        return new DefaultDynamicTableColumnModel(this.getColumnModel(), 1);
    }

    private JCheckBoxMenuItem createMenuItem(TableColumn column) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        boolean visible = this.dynamicColumnModel.isVisible(column);
        item.setSelected(visible);
        item.setAction(new MenuAction(column, visible));
        return item;
    }

    @Override
    public void setColumnModel(TableColumnModel columnModel) {
        if (this.dynamicColumnModel != null) {
            this.dynamicColumnModel.removeDynamicTableColumnModelListener(this.listener);
            this.cornerButton.setVisible(false);
        }
        super.setColumnModel(columnModel);
    }

    public void setColumnModel(DynamicTableColumnModel columnModel) {
        if (this.dynamicColumnModel != null) {
            this.dynamicColumnModel.removeDynamicTableColumnModelListener(this.listener);
        }
        this.dynamicColumnModel = columnModel;
        columnModel.addDynamicTableColumnModelListener(this.listener);
        super.setColumnModel(columnModel);
        List<TableColumn> columns = columnModel.getAvailableColumns();
        this.menu.removeAll();
        if (!columns.isEmpty()) {
            for (TableColumn column : columns) {
                this.menu.add(this.createMenuItem(column));
            }
            this.cornerButton.setVisible(true);
        } else {
            this.cornerButton.setVisible(false);
        }
    }

    private class MenuAction
    extends AbstractAction {
        private boolean visible;
        private TableColumn column;

        public MenuAction(TableColumn column, boolean visible) {
            super(column.getHeaderValue().toString());
            this.visible = visible;
            this.column = column;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.visible = !this.visible;
            JDynamicTable.this.dynamicColumnModel.setVisible(this.column, this.visible);
        }
    }

    private class CornerAction
    extends AbstractAction {
        public CornerAction() {
            super("...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container parent = JDynamicTable.this.getParent();
            JDynamicTable.this.menu.setVisible(true);
            JDynamicTable.this.menu.show(parent, parent.getWidth() - JDynamicTable.this.menu.getWidth(), 0);
        }
    }
}

