/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.prefs;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.prefs.PCGenPrefsPanel;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.JComboBoxEx;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;

public class SourcesPanel
extends PCGenPrefsPanel {
    private static String in_sources = LanguageBundle.getString("in_Prefs_sources");
    private JCheckBox campLoad = new JCheckBox();
    private JCheckBox charCampLoad = new JCheckBox();
    private JCheckBox allowOptsInSource = new JCheckBox();
    private JCheckBox saveCustom = new JCheckBox();
    private JCheckBox showOGL = new JCheckBox();
    private JCheckBox showMature = new JCheckBox();
    private JCheckBox showSponsors = new JCheckBox();
    private JComboBoxEx sourceOptions = new JComboBoxEx();
    private JCheckBox loadURL = new JCheckBox();
    private JCheckBox allowOverride = new JCheckBox();
    private JCheckBox skipSourceSelect = new JCheckBox();
    private JCheckBox useAdvancedSourceSelect = new JCheckBox();
    private JCheckBox allowMultiLineObjectsSelect = new JCheckBox();

    public SourcesPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, in_sources);
        title1.setTitleJustification(4);
        this.setBorder(title1);
        this.setLayout(gridbag);
        c.fill = 2;
        c.anchor = 21;
        c.insets = new Insets(2, 2, 2, 2);
        Utility.buildConstraints(c, 0, 0, 0, 1, 0.0, 0.0);
        this.campLoad.setText(LanguageBundle.getString("in_Prefs_autoLoadAtStart"));
        gridbag.setConstraints(this.campLoad, c);
        this.add(this.campLoad);
        Utility.buildConstraints(c, 0, 1, 0, 1, 0.0, 0.0);
        this.charCampLoad.setText(LanguageBundle.getString("in_Prefs_autoLoadWithPC"));
        gridbag.setConstraints(this.charCampLoad, c);
        this.add(this.charCampLoad);
        Utility.buildConstraints(c, 0, 2, 0, 1, 0.0, 0.0);
        this.allowOptsInSource.setText(LanguageBundle.getString("in_Prefs_allowOptionInSource"));
        gridbag.setConstraints(this.allowOptsInSource, c);
        this.add(this.allowOptsInSource);
        Utility.buildConstraints(c, 0, 3, 0, 1, 0.0, 0.0);
        this.saveCustom.setText(LanguageBundle.getString("in_Prefs_saveCustom"));
        gridbag.setConstraints(this.saveCustom, c);
        this.add(this.saveCustom);
        Utility.buildConstraints(c, 0, 4, 0, 1, 0.0, 0.0);
        this.showOGL.setText(LanguageBundle.getString("in_Prefs_displayOGL"));
        gridbag.setConstraints(this.showOGL, c);
        this.add(this.showOGL);
        Utility.buildConstraints(c, 0, 6, 0, 1, 0.0, 0.0);
        this.showSponsors.setText(LanguageBundle.getString("in_Prefs_displaySponsors"));
        gridbag.setConstraints(this.showSponsors, c);
        this.add(this.showSponsors);
        Utility.buildConstraints(c, 0, 7, 0, 1, 0.0, 0.0);
        this.showMature.setText(LanguageBundle.getString("in_Prefs_displayMature"));
        gridbag.setConstraints(this.showMature, c);
        this.add(this.showMature);
        Utility.buildConstraints(c, 0, 8, 1, 1, 0.0, 0.0);
        JLabel label = new JLabel(LanguageBundle.getString("in_Prefs_sourceDisplay"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 3, 8, 1, 1, 0.0, 0.0);
        this.sourceOptions = new JComboBoxEx(new String[]{LanguageBundle.getString("in_Prefs_sdLong"), LanguageBundle.getString("in_Prefs_sdMedium"), LanguageBundle.getString("in_Prefs_sdShort"), LanguageBundle.getString("in_Prefs_sdPage"), LanguageBundle.getString("in_Prefs_sdWeb")});
        gridbag.setConstraints(this.sourceOptions, c);
        this.add(this.sourceOptions);
        Utility.buildConstraints(c, 0, 9, 0, 1, 0.0, 0.0);
        this.loadURL.setText(LanguageBundle.getString("in_Prefs_loadURLs"));
        gridbag.setConstraints(this.loadURL, c);
        this.add(this.loadURL);
        this.loadURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (((JCheckBox)evt.getSource()).isSelected()) {
                    ShowMessageDelegate.showMessageDialog(LanguageBundle.getString("in_Prefs_urlBlocked"), "PCGen", MessageType.WARNING);
                }
            }
        });
        Utility.buildConstraints(c, 0, 10, 0, 1, 0.0, 0.0);
        this.allowOverride.setText(LanguageBundle.getString("in_Prefs_allowOverride"));
        gridbag.setConstraints(this.allowOverride, c);
        this.add(this.allowOverride);
        Utility.buildConstraints(c, 0, 11, 0, 1, 0.0, 0.0);
        this.skipSourceSelect.setText(LanguageBundle.getString("in_Prefs_skipSourceSelect"));
        gridbag.setConstraints(this.skipSourceSelect, c);
        this.add(this.skipSourceSelect);
        Utility.buildConstraints(c, 0, 12, 0, 1, 0.0, 0.0);
        this.useAdvancedSourceSelect.setText(LanguageBundle.getString("in_Prefs_useAdvancedSourceSelect"));
        gridbag.setConstraints(this.useAdvancedSourceSelect, c);
        this.add(this.useAdvancedSourceSelect);
        Utility.buildConstraints(c, 0, 13, 0, 1, 0.0, 0.0);
        this.allowMultiLineObjectsSelect.setText(LanguageBundle.getString("in_Prefs_allowMultiLineObjectsSelect"));
        gridbag.setConstraints(this.allowMultiLineObjectsSelect, c);
        this.add(this.allowMultiLineObjectsSelect);
        Utility.buildConstraints(c, 5, 20, 0, 1, 1.0, 1.0);
        c.fill = 1;
        label = new JLabel();
        gridbag.setConstraints(label, c);
        this.add(label);
    }

    @Override
    public String getTitle() {
        return in_sources;
    }

    @Override
    public void setOptionsBasedOnControls() {
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("autoloadSourcesAtStart", this.campLoad.isSelected());
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("autoloadSourcesWithPC", this.charCampLoad.isSelected());
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("optionAllowedInSources", this.allowOptsInSource.isSelected());
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("saveCustomInLst", this.saveCustom.isSelected());
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("showLicense", this.showOGL.isSelected());
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("showMatureOnLoad", this.showMature.isSelected());
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("showSponsorsOnLoad", this.showSponsors.isSelected());
        SettingsHandler.setLoadURLs(this.loadURL.isSelected());
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("allowOverrideDuplicates", this.allowOverride.isSelected());
        UIPropertyContext.getInstance().setBoolean("SourceSelectionDialog.skipOnStart", this.skipSourceSelect.isSelected());
        UIPropertyContext.getInstance().setBoolean("SourceSelectionDialog.useBasic", !this.useAdvancedSourceSelect.isSelected());
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("optionSourcesAllowMultiLine", this.allowMultiLineObjectsSelect.isSelected());
        switch (this.sourceOptions.getSelectedIndex()) {
            case 0: {
                Globals.setSourceDisplay(SourceFormat.LONG);
                break;
            }
            case 1: {
                Globals.setSourceDisplay(SourceFormat.MEDIUM);
                break;
            }
            case 2: {
                Globals.setSourceDisplay(SourceFormat.SHORT);
                break;
            }
            case 3: {
                Globals.setSourceDisplay(SourceFormat.PAGE);
                break;
            }
            case 4: {
                Globals.setSourceDisplay(SourceFormat.WEB);
                break;
            }
            default: {
                Logging.errorPrint("In PreferencesDialog.setOptionsBasedOnControls (sourceOptions) the index " + this.sourceOptions.getSelectedIndex() + " is unsupported.");
            }
        }
    }

    @Override
    public void applyOptionValuesToControls() {
        this.campLoad.setSelected(PCGenSettings.OPTIONS_CONTEXT.initBoolean("autoloadSourcesAtStart", false));
        this.charCampLoad.setSelected(PCGenSettings.OPTIONS_CONTEXT.initBoolean("autoloadSourcesWithPC", true));
        this.allowOptsInSource.setSelected(PCGenSettings.OPTIONS_CONTEXT.initBoolean("optionAllowedInSources", true));
        this.saveCustom.setSelected(PCGenSettings.OPTIONS_CONTEXT.getBoolean("saveCustomInLst"));
        this.showOGL.setSelected(PCGenSettings.OPTIONS_CONTEXT.getBoolean("showLicense"));
        this.showMature.setSelected(PCGenSettings.OPTIONS_CONTEXT.getBoolean("showMatureOnLoad"));
        this.showSponsors.setSelected(PCGenSettings.OPTIONS_CONTEXT.getBoolean("showSponsorsOnLoad"));
        this.loadURL.setSelected(SettingsHandler.isLoadURLs());
        this.allowOverride.setSelected(PCGenSettings.OPTIONS_CONTEXT.initBoolean("allowOverrideDuplicates", true));
        this.skipSourceSelect.setSelected(UIPropertyContext.getInstance().getBoolean("SourceSelectionDialog.skipOnStart"));
        this.useAdvancedSourceSelect.setSelected(!UIPropertyContext.getInstance().getBoolean("SourceSelectionDialog.useBasic"));
        this.allowMultiLineObjectsSelect.setSelected(PCGenSettings.OPTIONS_CONTEXT.getBoolean("optionSourcesAllowMultiLine"));
        switch (Globals.getSourceDisplay()) {
            case LONG: {
                this.sourceOptions.setSelectedIndex(0);
                break;
            }
            case MEDIUM: {
                this.sourceOptions.setSelectedIndex(1);
                break;
            }
            case SHORT: {
                this.sourceOptions.setSelectedIndex(2);
                break;
            }
            case PAGE: {
                this.sourceOptions.setSelectedIndex(3);
                break;
            }
            case WEB: {
                this.sourceOptions.setSelectedIndex(4);
                break;
            }
            default: {
                Logging.errorPrint("In PreferencesDialog.applyOptionValuesToControls (source display) the option " + (Object)((Object)Globals.getSourceDisplay()) + " is unsupported.");
            }
        }
    }
}

