/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SubstitutionClass;
import pcgen.core.analysis.SubstitutionLevelSupport;
import pcgen.core.chooser.CDOMChooserFacadeImpl;
import pcgen.core.prereq.PrereqHandler;
import pcgen.facade.core.ChooserFacade;
import pcgen.gui2.facade.Gui2InfoFactory;
import pcgen.system.LanguageBundle;
import pcgen.util.chooser.ChooserFactory;

public class SubstitutionClassApplication {
    public static void checkForSubstitutionClass(PCClass cl, int aLevel, PlayerCharacter aPC) {
        List<SubstitutionClass> substitutionClassList = cl.getListFor(ListKey.SUBSTITUTION_CLASS);
        if (substitutionClassList == null || substitutionClassList.isEmpty()) {
            return;
        }
        ArrayList<PCClass> choiceList = new ArrayList<PCClass>();
        SubstitutionClassApplication.buildSubstitutionClassChoiceList(cl, choiceList, aPC.getLevel(cl), aPC);
        if (choiceList.size() <= 1) {
            return;
        }
        CDOMChooserFacadeImpl<PCClass> chooserFacade = new CDOMChooserFacadeImpl<PCClass>(LanguageBundle.getString("in_SubstLvlChoice"), choiceList, new ArrayList(), 1);
        chooserFacade.setDefaultView(ChooserFacade.ChooserTreeViewType.NAME);
        chooserFacade.setInfoFactory(new Gui2InfoFactory(aPC));
        ChooserFactory.getDelegate().showGeneralChooser(chooserFacade);
        List<PCClass> selectedList = chooserFacade.getFinalSelected();
        PCClass selected = null;
        if (!selectedList.isEmpty()) {
            selected = selectedList.get(0);
        }
        if (!selectedList.isEmpty() && selected instanceof SubstitutionClass) {
            SubstitutionClass sc = (SubstitutionClass)selected;
            SubstitutionLevelSupport.applyLevelArrayModsToLevel(sc, cl, aLevel, aPC);
            aPC.setSubstitutionClassName(aPC.getActiveClassLevel(cl, aLevel), sc.getKeyName());
            return;
        }
        aPC.removeSubstitutionClassName(aPC.getActiveClassLevel(cl, aLevel));
    }

    private static void buildSubstitutionClassChoiceList(PCClass cl, List<PCClass> choiceList, int level, PlayerCharacter aPC) {
        for (SubstitutionClass sc : cl.getListFor(ListKey.SUBSTITUTION_CLASS)) {
            if (!PrereqHandler.passesAll(sc.getPrerequisiteList(), aPC, cl) || !sc.hasOriginalClassLevel(level) || !SubstitutionLevelSupport.qualifiesForSubstitutionLevel(cl, sc, aPC, level)) continue;
            choiceList.add(sc);
        }
        Collections.sort(choiceList);
        choiceList.add(0, cl);
    }
}

