/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.Comparator;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillRankControl;

public final class SkillComparator
implements Comparator<Skill> {
    public static final int RESORT_NAME = 0;
    public static final int RESORT_TRAINED = 1;
    public static final boolean RESORT_ASCENDING = true;
    public static final boolean RESORT_DESCENDING = false;
    private boolean sortOrder = true;
    private int sort = 0;
    private final PlayerCharacter pc;

    public SkillComparator(PlayerCharacter aPC, int sort, boolean sortOrder) {
        this.sort = sort;
        this.sortOrder = sortOrder;
        this.pc = aPC;
    }

    @Override
    public int compare(Skill obj1, Skill obj2) {
        Skill s2;
        Skill s1;
        if (this.sortOrder || this.sort == 1) {
            s1 = obj1;
            s2 = obj2;
        } else {
            s1 = obj2;
            s2 = obj1;
        }
        switch (this.sort) {
            case 1: {
                float r1 = SkillRankControl.getTotalRank(this.pc, s1).floatValue();
                float r2 = SkillRankControl.getTotalRank(this.pc, s2).floatValue();
                if (r1 > 0.0f && r2 <= 0.0f) {
                    return this.sortOrder ? -1 : 1;
                }
                if (r1 <= 0.0f && r2 > 0.0f) {
                    return this.sortOrder ? 1 : -1;
                }
                return s1.getOutputName().compareToIgnoreCase(s2.getOutputName());
            }
        }
        return s1.getOutputName().compareToIgnoreCase(s2.getOutputName());
    }
}

