/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.HashSet;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObjectUtilities;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.SubClassFacet;
import pcgen.cdom.facet.analysis.FavoredClassFacet;
import pcgen.cdom.facet.analysis.HasAnyFavoredClassFacet;
import pcgen.cdom.facet.model.ClassFacet;
import pcgen.core.PCClass;

public class MultiClassFacet {
    private FavoredClassFacet favoredClassFacet;
    private HasAnyFavoredClassFacet hasAnyFavoredClassFacet;
    private ClassFacet classFacet;
    private SubClassFacet subClassFacet;

    public double getMultiClassXPMultiplier(CharID id) {
        HashSet<PCClass> unfavoredClasses = new HashSet<PCClass>();
        TreeSet<Loadable> favored = new TreeSet<Loadable>(CDOMObjectUtilities.CDOM_SORTER);
        favored.addAll(this.favoredClassFacet.getSet(id));
        TreeSet<Loadable> aList = favored;
        boolean hasAny = this.hasAnyFavoredClassFacet.contains(id, Boolean.TRUE);
        PCClass maxClass = null;
        PCClass secondClass = null;
        int maxClassLevel = 0;
        int secondClassLevel = 0;
        int xpPenalty = 0;
        double xpMultiplier = 1.0;
        for (PCClass pcClass : this.classFacet.getSet(id)) {
            if (!pcClass.hasXPPenalty()) continue;
            String subClassKey = (String)this.subClassFacet.get(id, pcClass);
            PCClass evalClass = pcClass;
            if (subClassKey != null && !subClassKey.equals("None")) {
                evalClass = pcClass.getSubClassKeyed(subClassKey);
            }
            if (aList.contains(evalClass)) continue;
            unfavoredClasses.add(pcClass);
            int pcClassLevel = this.classFacet.getLevel(id, pcClass);
            if (pcClassLevel > maxClassLevel) {
                if (hasAny) {
                    secondClassLevel = maxClassLevel;
                    secondClass = maxClass;
                }
                maxClassLevel = pcClassLevel;
                maxClass = pcClass;
                continue;
            }
            if (pcClassLevel <= secondClassLevel || !hasAny) continue;
            secondClassLevel = pcClassLevel;
            secondClass = pcClass;
        }
        if (hasAny && secondClassLevel > 0) {
            maxClassLevel = secondClassLevel;
            unfavoredClasses.remove(maxClass);
            maxClass = secondClass;
        }
        if (maxClassLevel > 0) {
            unfavoredClasses.remove(maxClass);
            for (PCClass aClass : unfavoredClasses) {
                if (maxClassLevel - this.classFacet.getLevel(id, aClass) <= 1) continue;
                ++xpPenalty;
            }
            xpMultiplier = 1.0 - (double)xpPenalty * 0.2;
            if (xpMultiplier < 0.0) {
                xpMultiplier = 0.0;
            }
        }
        return xpMultiplier;
    }

    public void setFavoredClassFacet(FavoredClassFacet favoredClassFacet) {
        this.favoredClassFacet = favoredClassFacet;
    }

    public void setHasAnyFavoredClassFacet(HasAnyFavoredClassFacet hasAnyFavoredClassFacet) {
        this.hasAnyFavoredClassFacet = hasAnyFavoredClassFacet;
    }

    public void setClassFacet(ClassFacet classFacet) {
        this.classFacet = classFacet;
    }

    public void setSubClassFacet(SubClassFacet subClassFacet) {
        this.subClassFacet = subClassFacet;
    }
}

