/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.Collection;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.AvailableSpellFacet;
import pcgen.cdom.facet.ConditionallyAvailableSpellFacet;
import pcgen.cdom.facet.MasterAvailableSpellFacet;
import pcgen.cdom.facet.SpellListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.helper.AvailableSpell;
import pcgen.core.spell.Spell;

public class SpellListToAvailableSpellFacet
implements DataFacetChangeListener<CharID, CDOMList<Spell>> {
    private MasterAvailableSpellFacet masterAvailableSpellFacet;
    private SpellListFacet spellListFacet;
    private ConditionallyAvailableSpellFacet conditionallyAvailableSpellFacet;
    private AvailableSpellFacet availableSpellFacet;

    private void add(CharID id, AvailableSpell as, Object source) {
        if (as.hasPrerequisites()) {
            this.conditionallyAvailableSpellFacet.add(id, as, source);
        } else {
            this.availableSpellFacet.add(id, as.getSpelllist(), as.getLevel(), as.getSpell(), source);
        }
    }

    private void remove(CharID id, AvailableSpell as, Object source) {
        if (as.hasPrerequisites()) {
            this.conditionallyAvailableSpellFacet.remove(id, as, source);
        } else {
            this.availableSpellFacet.remove(id, as.getSpelllist(), as.getLevel(), as.getSpell(), source);
        }
    }

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMList<Spell>> dfce) {
        CharID id = dfce.getCharID();
        CDOMList<Spell> list = dfce.getCDOMObject();
        Collection spells = this.masterAvailableSpellFacet.getSet(id.getDatasetID());
        for (AvailableSpell as : spells) {
            if (!as.getSpelllist().equals(list)) continue;
            this.add(id, as, this);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMList<Spell>> dfce) {
        CharID id = dfce.getCharID();
        CDOMList<Spell> list = dfce.getCDOMObject();
        Collection spells = this.masterAvailableSpellFacet.getSet(id.getDatasetID());
        for (AvailableSpell as : spells) {
            if (!as.getSpelllist().equals(list)) continue;
            this.remove(id, as, this);
        }
    }

    public void init() {
        this.spellListFacet.addDataFacetChangeListener(this);
    }

    public void setSpellListFacet(SpellListFacet spellListFacet) {
        this.spellListFacet = spellListFacet;
    }

    public void setMasterAvailableSpellFacet(MasterAvailableSpellFacet masterAvailableSpellFacet) {
        this.masterAvailableSpellFacet = masterAvailableSpellFacet;
    }

    public void setConditionallyAvailableSpellFacet(ConditionallyAvailableSpellFacet conditionallyAvailableSpellFacet) {
        this.conditionallyAvailableSpellFacet = conditionallyAvailableSpellFacet;
    }

    public void setAvailableSpellFacet(AvailableSpellFacet availableSpellFacet) {
        this.availableSpellFacet = availableSpellFacet;
    }
}

