/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.ArrayList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.LevelInfoFacet;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.analysis.LevelFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.ClassFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.pclevelinfo.PCLevelInfo;

public class MonsterClassFacet
implements DataFacetChangeListener<CharID, CDOMObject> {
    private LevelFacet levelFacet;
    private ClassFacet classFacet;
    private FormulaResolvingFacet formulaResolvingFacet;
    private LevelInfoFacet levelInfoFacet;
    private RaceFacet raceFacet;
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        LevelCommandFactory lcf;
        CharID id = dfce.getCharID();
        CDOMObject cdo = dfce.getCDOMObject();
        ClassFacet.ClassInfo ci = this.classFacet.removeAllClasses(id);
        for (int i = this.levelInfoFacet.getCount(id) - 1; i >= 0; --i) {
            PCLevelInfo pli = this.levelInfoFacet.get(id, i);
            String classKeyName = pli.getClassKeyName();
            PCClass aClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, classKeyName);
            if (!aClass.isMonster()) continue;
            this.levelInfoFacet.remove(id, pli);
        }
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        ArrayList existingLevelInfo = new ArrayList(this.levelInfoFacet.getSet(id));
        this.levelInfoFacet.removeAll(id);
        if (!pc.isImporting() && (lcf = cdo.get(ObjectKey.MONSTER_CLASS)) != null) {
            int levelCount = this.formulaResolvingFacet.resolve(id, lcf.getLevelCount(), "").intValue();
            pc.incrementClassLevel(levelCount, lcf.getPCClass(), true);
        }
        this.levelInfoFacet.addAll(id, existingLevelInfo);
        if (!pc.isImporting() && ci != null && !ci.isEmpty()) {
            int totalLevels = this.levelFacet.getTotalLevels(id);
            for (PCClass pcClass : ci.getClassSet()) {
                if (pcClass.isMonster()) continue;
                this.classFacet.addClass(id, pcClass);
                int cLevels = ci.getLevel(pcClass);
                this.classFacet.setLevel(id, pcClass, cLevels);
                pc.setSkillPool(pcClass, 0);
                int cMod = 0;
                for (int j = 0; j < cLevels; ++j) {
                    cMod += pc.recalcSkillPointMod(pcClass, ++totalLevels);
                }
                pc.setSkillPool(pcClass, cMod);
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        LevelCommandFactory lcf = cdo.get(ObjectKey.MONSTER_CLASS);
        if (lcf != null) {
            CharID id = dfce.getCharID();
            int levelCount = this.formulaResolvingFacet.resolve(id, lcf.getLevelCount(), "").intValue();
            PlayerCharacter pc = this.trackingFacet.getPC(id);
            pc.incrementClassLevel(-levelCount, lcf.getPCClass(), true);
        }
    }

    public void setLevelFacet(LevelFacet levelFacet) {
        this.levelFacet = levelFacet;
    }

    public void setClassFacet(ClassFacet classFacet) {
        this.classFacet = classFacet;
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setLevelInfoFacet(LevelInfoFacet levelInfoFacet) {
        this.levelInfoFacet = levelInfoFacet;
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void init() {
        this.raceFacet.addDataFacetChangeListener(this);
    }
}

