/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.List;
import java.util.ListIterator;
import pcgen.base.formula.Formula;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui2.UIPropertyContext;

public class AddLevelFacet
implements DataFacetChangeListener<CharID, PCTemplate> {
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);
    private TemplateFacet templateFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, PCTemplate> dfce) {
        PCTemplate template = dfce.getCDOMObject();
        CharID id = dfce.getCharID();
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (!pc.isImporting()) {
            for (LevelCommandFactory lcf : template.getSafeListFor(ListKey.ADD_LEVEL)) {
                this.add(lcf.getLevelCount(), lcf.getPCClass(), pc);
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, PCTemplate> dfce) {
        PCTemplate template = dfce.getCDOMObject();
        CharID id = dfce.getCharID();
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        List<LevelCommandFactory> lcfList = template.getSafeListFor(ListKey.ADD_LEVEL);
        ListIterator<LevelCommandFactory> it = lcfList.listIterator(lcfList.size());
        while (it.hasPrevious()) {
            LevelCommandFactory lcf = it.previous();
            this.remove(lcf.getLevelCount(), lcf.getPCClass(), pc);
        }
    }

    private void add(Formula levels, PCClass cl, PlayerCharacter pc) {
        this.apply(pc, cl, levels.resolve(pc, "").intValue());
    }

    public void remove(Formula levels, PCClass cl, PlayerCharacter pc) {
        this.apply(pc, cl, -levels.resolve(pc, "").intValue());
    }

    private void apply(PlayerCharacter pc, PCClass pcClass, int levels) {
        boolean tempShowHP = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        boolean tempFeatDlg = SettingsHandler.getShowFeatDialogAtLevelUp();
        SettingsHandler.setShowFeatDialogAtLevelUp(false);
        int tempChoicePref = UIPropertyContext.getSingleChoiceAction();
        UIPropertyContext.setSingleChoiceAction(2);
        pc.incrementClassLevel(levels, pcClass, true, true);
        UIPropertyContext.setSingleChoiceAction(tempChoicePref);
        SettingsHandler.setShowFeatDialogAtLevelUp(tempFeatDlg);
        SettingsHandler.setShowHPDialogAtLevelUp(tempShowHP);
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    public void init() {
        this.templateFacet.addDataFacetChangeListener(this);
    }
}

