/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import pcgen.core.GameMode;
import pcgen.persistence.lst.GameModeLstToken;
import pcgen.util.Logging;

public class OutputSheetToken
implements GameModeLstToken {
    public boolean parse(GameMode gameMode, String value, URI source) {
        String[] tokens = value.split("\\|");
        ArrayList<String> validTags = new ArrayList<String>(Arrays.asList("HTM", "PDF", "TXT"));
        if (tokens.length == 2) {
            String[] subtokens;
            if (tokens[0].equals("DIRECTORY")) {
                gameMode.setOutputSheetDirectory(tokens[1]);
                return true;
            }
            if (tokens[0].startsWith("DEFAULT.") && (subtokens = tokens[0].split("\\.")).length == 2) {
                if (validTags.contains(subtokens[1])) {
                    gameMode.setOutputSheetDefault(subtokens[1], tokens[1]);
                    return true;
                }
                Logging.log((Level)Logging.LST_ERROR, (String)("Invalid token " + this.getTokenName() + ":" + value + ". Invalid DEFAULT.x subtoken" + " in " + source.toString()));
                return false;
            }
        }
        Logging.log((Level)Logging.LST_ERROR, (String)("Invalid token " + this.getTokenName() + ":" + value + ". Expected OUTPUTSHEET:DIRECTORY|x or OUTPUTSHEET:DEFAULT.x|y " + " in " + source.toString()));
        return false;
    }

    public String getTokenName() {
        return "OUTPUTSHEET";
    }
}

