/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.io.File;
import java.util.function.Function;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.DisplayName;
import org.gradle.internal.build.BuildProjectRegistry;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.internal.build.BuildWorkGraphController;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.Path;

@ServiceScope(value={Scope.Build.class})
public interface BuildState {
    public DisplayName getDisplayName();

    public BuildIdentifier getBuildIdentifier();

    public Path getIdentityPath();

    public boolean isImplicitBuild();

    public boolean isImportableBuild();

    default public Path calculateIdentityPathForProject(Path projectPath) {
        return this.getIdentityPath().append(projectPath);
    }

    public void ensureProjectsLoaded();

    public boolean isProjectsLoaded();

    public boolean isProjectsCreated();

    public void ensureProjectsConfigured();

    public BuildProjectRegistry getProjects();

    public void assertCanAdd(IncludedBuildSpec var1);

    public File getBuildRootDir();

    public GradleInternal getMutableModel();

    public BuildWorkGraphController getWorkGraph();

    public <T> T withToolingModels(Function<? super BuildToolingModelController, T> var1);

    public ExecutionResult<Void> beforeModelReset();

    public void resetModel();

    public ExecutionResult<Void> beforeModelDiscarded(boolean var1);
}

