/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tiles;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.fluent.BasicTheme;
import com.jgoodies.fluent.FluentLayouts;
import com.jgoodies.fluent.internal.FluentResources;
import com.jgoodies.fluent.internal.IFluentResources;
import com.jgoodies.fluent.internal.Releasable;
import com.jgoodies.fluent.tiles.Hub;
import com.jgoodies.fluent.tiles.HubSection;
import com.jgoodies.fluent.tiles.HubSectionView;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.Forms;
import com.jgoodies.layout.factories.Paddings;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class HubView
implements Releasable {
    public static final int BASE_TILE_SIZE_WINDOWS = 48;
    public static final int BASE_TILE_SIZE_OTHER = 54;
    public static final int DEFAULT_BASE_TILE_SIZE = SystemUtils.IS_OS_WINDOWS ? 48 : 54;
    private final Hub hub;
    private final int baseTileSize;
    private final BasicTheme theme;
    private final IFluentResources resources;
    private final JGComponentFactory factory;
    private final List<HubSectionView> views;
    private Font headerFont;
    private Font sectionHeaderFont;

    public HubView(Hub hub) {
        this(hub, null, DEFAULT_BASE_TILE_SIZE);
    }

    public HubView(Hub hub, int effectiveBaseTileSize) {
        this(hub, null, effectiveBaseTileSize);
    }

    public HubView(Hub hub, BasicTheme theme) {
        this(hub, theme, DEFAULT_BASE_TILE_SIZE);
    }

    public HubView(Hub hub, BasicTheme theme, int effectiveBaseTileSize) {
        this.hub = Preconditions.checkNotNull(hub, "The %s must not be null.", "hub");
        this.baseTileSize = effectiveBaseTileSize;
        this.resources = FluentResources.getInstance();
        this.theme = theme != null ? theme : this.resources.getTheme();
        this.factory = JGComponentFactory.getCurrent();
        this.views = new ArrayList<HubSectionView>();
    }

    public Hub getHub() {
        return this.hub;
    }

    public Font getHeaderFont() {
        return this.headerFont != null ? this.headerFont : this.resources.getHubFont();
    }

    public void setHeaderFont(Font headerFont) {
        this.headerFont = headerFont;
    }

    public Font getSectionHeaderFont() {
        return this.sectionHeaderFont != null ? this.sectionHeaderFont : this.resources.getHubSectionFont();
    }

    public void setSectionHeaderFont(Font titleFont) {
        this.sectionHeaderFont = titleFont;
    }

    public BasicTheme getTheme() {
        return this.theme != null ? this.theme : this.resources.getTheme();
    }

    public boolean isHorizontal() {
        return this.hub.getOrientation() == Hub.Orientation.HORIZONTAL;
    }

    @Override
    public void release() {
        for (HubSectionView view : this.views) {
            view.release();
        }
        this.views.clear();
    }

    public JComponent buildPanel() {
        this.release();
        return this.isHorizontal() ? this.buildHorizontalPanel() : this.buildVerticalPanel();
    }

    public JScrollPane buildScrollablePanel() {
        return this.buildScrollablePanel(FluentLayouts.HUB_PADDING_DEFAULT);
    }

    public JScrollPane buildScrollablePanel(String encodedSizes) {
        return this.buildScrollablePanel(Paddings.createPadding(encodedSizes, new Object[0]));
    }

    public JScrollPane buildScrollablePanel(Paddings.Padding padding) {
        JScrollPane scrollPane = this.factory.createStrippedScrollPane(Forms.padded(this.buildPanel(), padding));
        scrollPane.getHorizontalScrollBar().setUnitIncrement(ScreenScaling.toPhysical(12));
        scrollPane.getVerticalScrollBar().setUnitIncrement(ScreenScaling.toPhysical(12));
        if (this.theme.background() == null) {
            scrollPane.setOpaque(false);
            scrollPane.getViewport().setOpaque(false);
        } else {
            scrollPane.getViewport().setBackground(this.theme.background());
        }
        return scrollPane;
    }

    private JComponent buildHorizontalPanel() {
        int sections = this.hub.getSections().size();
        if (sections == 0) {
            JPanel emptyContent = new JPanel(null);
            emptyContent.setOpaque(false);
            return emptyContent;
        }
        FormBuilder builder = (FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("pref, %s*(16epx, pref)", this.hub.getSections().size() - 1)).rows("p, t:p", new Object[0])).add(Strings.isNotBlank(this.hub.getHeader()), this.buildHeader()).xyw(1, 1, this.hub.getSections().size() * 2 - 1);
        int x = 1;
        for (HubSection section : this.hub.getSections()) {
            HubSectionView view = new HubSectionView(this, section, this.baseTileSize);
            this.views.add(view);
            builder.add(view.buildPanel()).xy(x, 2);
            x += 2;
        }
        return builder.build();
    }

    private JComponent buildVerticalPanel() {
        FormBuilder builder = (FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("left:pref", new Object[0])).rows("p, p, %s*(16epx, p)", this.hub.getSections().size() - 1)).add(Strings.isNotBlank(this.hub.getHeader()), this.buildHeader()).xy(1, 1);
        int y = 2;
        for (HubSection section : this.hub.getSections()) {
            HubSectionView view = new HubSectionView(this, section, this.baseTileSize);
            this.views.add(view);
            builder.add(view.buildPanel()).xy(1, y);
            y += 2;
        }
        return builder.build();
    }

    private JComponent buildHeader() {
        JLabel label = this.factory.createLabel(this.hub.getHeader());
        label.setFont(this.getHeaderFont());
        label.setForeground(this.getTheme().foreground());
        return Forms.single("pref", "top:72epx", label);
    }
}

