/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler.model;

import java.util.List;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.stmt.Statement;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.BlockIterable;
import org.spockframework.compiler.model.ISpecVisitor;
import org.spockframework.compiler.model.Node;
import org.spockframework.compiler.model.Spec;

public abstract class Method
extends Node<Spec, MethodNode> {
    private Block firstBlock;
    private Block lastBlock;

    public Method(Spec parent, MethodNode code) {
        super(parent, code);
        this.setName(code.getName());
    }

    public Block getFirstBlock() {
        return this.firstBlock;
    }

    public Block getLastBlock() {
        return this.lastBlock;
    }

    public List<Statement> getStatements() {
        return AstUtil.getStatements((MethodNode)this.getAst());
    }

    public Iterable<Block> getBlocks() {
        return new BlockIterable(this.firstBlock);
    }

    public Block addBlock(Block block) {
        if (this.firstBlock == null) {
            this.firstBlock = this.lastBlock = block;
        } else {
            this.lastBlock.setNext(block);
            block.setPrevious(this.lastBlock);
            this.lastBlock = block;
        }
        return block;
    }

    @Override
    public void accept(ISpecVisitor visitor) throws Exception {
        visitor.visitMethod(this);
        for (Block b : this.getBlocks()) {
            b.accept(visitor);
        }
        visitor.visitMethodAgain(this);
    }
}

