/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.system;

import java.io.IOException;
import okhttp3.RequestBody;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.ACLPolicy;
import org.rundeck.client.api.model.ACLPolicyItem;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.commands.projects.ACLs;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.ACLOutputFormatOption;
import picocli.CommandLine;

@CommandLine.Command(description={"Manage System ACLs"}, name="acls")
public class ACLs
extends BaseCommand {
    @CommandLine.Command(description={"list system acls"})
    public void list(@CommandLine.Mixin ACLOutputFormatOption options) throws IOException, InputError {
        ACLPolicyItem items = (ACLPolicyItem)this.apiCall(RundeckApi::listSystemAcls);
        org.rundeck.client.tool.commands.projects.ACLs.outputListResult(options, this.getRdOutput(), items, "system");
    }

    @CommandLine.Command(description={"get a system ACL definition"})
    public void get(@CommandLine.Mixin ACLs.ACLNameRequiredOptions options) throws IOException, InputError {
        ACLPolicy aclPolicy = (ACLPolicy)this.apiCall(api -> api.getSystemAclPolicy(options.getName()));
        org.rundeck.client.tool.commands.projects.ACLs.outputPolicyResult(this.getRdOutput(), aclPolicy);
    }

    @CommandLine.Command(description={"Update an existing system ACL definition. [@|red DEPRECATED|@: use @|bold rd system acls update|@]"}, hidden=true)
    @Deprecated
    public void upload(@CommandLine.Mixin ACLs.ACLNameRequiredOptions aclNameOptions, @CommandLine.Mixin ACLs.ACLFileOptions aclFileOptions) throws IOException, InputError {
        this.getRdOutput().info("@|faint rd system acls upload command is deprecated, use: rd system acls update|@");
        this.update(aclNameOptions, aclFileOptions);
    }

    @CommandLine.Command(description={"Update an existing system ACL definition"})
    public void update(@CommandLine.Mixin ACLs.ACLNameRequiredOptions aclNameOptions, @CommandLine.Mixin ACLs.ACLFileOptions aclFileOptions) throws IOException, InputError {
        ACLPolicy aclPolicy = org.rundeck.client.tool.commands.projects.ACLs.performACLModify(aclFileOptions, (body, api) -> api.updateSystemAclPolicy(aclNameOptions.getName(), (RequestBody)body), this.getRdTool(), this.getRdOutput());
        org.rundeck.client.tool.commands.projects.ACLs.outputPolicyResult(this.getRdOutput(), aclPolicy);
    }

    @CommandLine.Command(description={"Create a system ACL definition"})
    public void create(@CommandLine.Mixin ACLs.ACLNameRequiredOptions aclNameOptions, @CommandLine.Mixin ACLs.ACLFileOptions aclFileOptions) throws IOException, InputError {
        ACLPolicy aclPolicy = org.rundeck.client.tool.commands.projects.ACLs.performACLModify(aclFileOptions, (body, api) -> api.createSystemAclPolicy(aclNameOptions.getName(), (RequestBody)body), this.getRdTool(), this.getRdOutput());
        org.rundeck.client.tool.commands.projects.ACLs.outputPolicyResult(this.getRdOutput(), aclPolicy);
    }

    @CommandLine.Command(description={"Delete a system ACL definition"})
    public void delete(@CommandLine.Mixin ACLs.ACLNameRequiredOptions aclNameOptions) throws IOException, InputError {
        this.apiCall(api -> api.deleteSystemAclPolicy(aclNameOptions.getName()));
        this.getRdOutput().output(String.format("Deleted System ACL Policy: %s", aclNameOptions.getName()));
    }
}

