/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.jvm.JavaVersionParser;
import org.gradle.internal.jvm.inspection.JavaInstallationCapability;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.serialization.Cached;

public interface JvmInstallationMetadata {
    public static DefaultJvmInstallationMetadata from(File javaHome, String javaVersion, String javaVendor, String runtimeName, String runtimeVersion, String jvmName, String jvmVersion, String jvmVendor, String architecture) {
        return new DefaultJvmInstallationMetadata(javaHome, javaVersion, javaVendor, runtimeName, runtimeVersion, jvmName, jvmVersion, jvmVendor, architecture);
    }

    public static JvmInstallationMetadata failure(File javaHome, String errorMessage) {
        return new FailureInstallationMetadata(javaHome, errorMessage, null);
    }

    public static JvmInstallationMetadata failure(File javaHome, Exception cause) {
        return new FailureInstallationMetadata(javaHome, cause.getMessage(), cause);
    }

    public Path getJavaHome();

    public JavaVersion getLanguageVersion();

    public int getJavaMajorVersion();

    public JvmVendor getVendor();

    public String getJavaVersion();

    public String getRuntimeName();

    public String getRuntimeVersion();

    public String getJvmName();

    public String getJvmVersion();

    public String getJvmVendor();

    public String getArchitecture();

    public String getDisplayName();

    public Set<JavaInstallationCapability> getCapabilities();

    public String getErrorMessage();

    public Throwable getErrorCause();

    public boolean isValidInstallation();

    public static class DefaultJvmInstallationMetadata
    implements JvmInstallationMetadata {
        private final Path javaHome;
        private final JavaVersion languageVersion;
        private final int javaMajorVersion;
        private final String javaVersion;
        private final String javaVendor;
        private final String runtimeName;
        private final String runtimeVersion;
        private final String jvmName;
        private final String jvmVersion;
        private final String jvmVendor;
        private final String architecture;
        private final Cached<Set<JavaInstallationCapability>> capabilities = Cached.of(this::gatherCapabilities);

        private DefaultJvmInstallationMetadata(File javaHome, String javaVersion, String javaVendor, String runtimeName, String runtimeVersion, String jvmName, String jvmVersion, String jvmVendor, String architecture) {
            this.javaHome = javaHome.toPath();
            this.languageVersion = JavaVersion.toVersion((Object)javaVersion);
            this.javaMajorVersion = JavaVersionParser.parseMajorVersion((String)javaVersion);
            this.javaVersion = javaVersion;
            this.javaVendor = javaVendor;
            this.runtimeName = runtimeName;
            this.runtimeVersion = runtimeVersion;
            this.jvmName = jvmName;
            this.jvmVersion = jvmVersion;
            this.jvmVendor = jvmVendor;
            this.architecture = architecture;
        }

        @Override
        public Path getJavaHome() {
            return this.javaHome;
        }

        @Override
        public JavaVersion getLanguageVersion() {
            return this.languageVersion;
        }

        @Override
        public int getJavaMajorVersion() {
            return this.javaMajorVersion;
        }

        @Override
        public JvmVendor getVendor() {
            return JvmVendor.fromString(this.javaVendor);
        }

        @Override
        public String getJavaVersion() {
            return this.javaVersion;
        }

        @Override
        public String getRuntimeName() {
            return this.runtimeName;
        }

        @Override
        public String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        @Override
        public String getJvmName() {
            return this.jvmName;
        }

        @Override
        public String getJvmVersion() {
            return this.jvmVersion;
        }

        @Override
        public String getJvmVendor() {
            return this.jvmVendor;
        }

        @Override
        public String getArchitecture() {
            return this.architecture;
        }

        @Override
        public String getDisplayName() {
            String vendor = this.determineVendorName();
            String installationType = this.determineInstallationType(vendor);
            return MessageFormat.format("{0}{1}", vendor, installationType);
        }

        private String determineVendorName() {
            JvmVendor.KnownJvmVendor vendor = this.getVendor().getKnownVendor();
            if (vendor == JvmVendor.KnownJvmVendor.ORACLE && this.jvmName != null && this.jvmName.contains("OpenJDK")) {
                return "OpenJDK";
            }
            return this.getVendor().getDisplayName();
        }

        private String determineInstallationType(String vendor) {
            if (this.getCapabilities().contains((Object)JavaInstallationCapability.JAVA_COMPILER)) {
                if (!vendor.toLowerCase(Locale.ROOT).contains("jdk")) {
                    return " JDK";
                }
                return "";
            }
            return " JRE";
        }

        @Override
        public Set<JavaInstallationCapability> getCapabilities() {
            return (Set)this.capabilities.get();
        }

        private Set<JavaInstallationCapability> gatherCapabilities() {
            boolean isJ9vm;
            EnumSet<JavaInstallationCapability> capabilities = EnumSet.noneOf(JavaInstallationCapability.class);
            if (this.getToolByExecutable("javac").exists()) {
                capabilities.add(JavaInstallationCapability.JAVA_COMPILER);
            }
            if (this.getToolByExecutable("javadoc").exists()) {
                capabilities.add(JavaInstallationCapability.JAVADOC_TOOL);
            }
            if (isJ9vm = this.jvmName.contains("J9")) {
                capabilities.add(JavaInstallationCapability.J9_VIRTUAL_MACHINE);
            }
            return capabilities;
        }

        private File getToolByExecutable(String name) {
            return new File(new File(this.javaHome.toFile(), "bin"), OperatingSystem.current().getExecutableName(name));
        }

        @Override
        public String getErrorMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Throwable getErrorCause() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValidInstallation() {
            return true;
        }

        public String toString() {
            return "DefaultJvmInstallationMetadata{languageVersion=" + this.languageVersion + ", javaVersion='" + this.javaVersion + '\'' + ", javaVendor='" + this.javaVendor + '\'' + ", runtimeName='" + this.runtimeName + '\'' + ", runtimeVersion='" + this.runtimeVersion + '\'' + ", jvmName='" + this.jvmName + '\'' + ", jvmVersion='" + this.jvmVersion + '\'' + ", jvmVendor='" + this.jvmVendor + '\'' + ", architecture='" + this.architecture + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultJvmInstallationMetadata that = (DefaultJvmInstallationMetadata)o;
            return Objects.equals(this.javaHome, that.javaHome) && Objects.equals(this.javaVersion, that.javaVersion) && Objects.equals(this.javaVendor, that.javaVendor) && Objects.equals(this.runtimeName, that.runtimeName) && Objects.equals(this.runtimeVersion, that.runtimeVersion) && Objects.equals(this.jvmName, that.jvmName) && Objects.equals(this.jvmVersion, that.jvmVersion) && Objects.equals(this.jvmVendor, that.jvmVendor) && Objects.equals(this.architecture, that.architecture);
        }

        public int hashCode() {
            return Objects.hash(this.javaHome, this.javaVersion, this.javaVendor, this.runtimeName, this.runtimeVersion, this.jvmName, this.jvmVersion, this.jvmVendor, this.architecture);
        }
    }

    public static class FailureInstallationMetadata
    implements JvmInstallationMetadata {
        private final File javaHome;
        private final String errorMessage;
        @Nullable
        private final Exception cause;

        private FailureInstallationMetadata(File javaHome, String errorMessage, @Nullable Exception cause) {
            this.javaHome = javaHome;
            this.errorMessage = errorMessage;
            this.cause = cause;
        }

        @Override
        public Path getJavaHome() {
            return this.javaHome.toPath();
        }

        @Override
        public JavaVersion getLanguageVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public int getJavaMajorVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public JvmVendor getVendor() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getJavaVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getRuntimeName() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getRuntimeVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getJvmName() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getJvmVersion() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getJvmVendor() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getArchitecture() {
            throw this.unsupportedOperation();
        }

        @Override
        public String getDisplayName() {
            return "Invalid installation: " + this.getErrorMessage();
        }

        @Override
        public Set<JavaInstallationCapability> getCapabilities() {
            return Collections.emptySet();
        }

        private UnsupportedOperationException unsupportedOperation() {
            return new UnsupportedOperationException("Installation is not valid. Original error message: " + this.getErrorMessage());
        }

        @Override
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public Throwable getErrorCause() {
            return this.cause;
        }

        @Override
        public boolean isValidInstallation() {
            return false;
        }
    }
}

