/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import gd.xml.tiny.ParsedXML;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.IGame;

public class GunEmplacementEncoder {
    public static void encode(Entity entity, Writer writer) throws IOException {
        GunEmplacement gunEmplacement = (GunEmplacement)entity;
        writer.write("<cf>");
        writer.write(Integer.toString(gunEmplacement.getConstructionFactor()));
        writer.write("<cf/>");
        if (gunEmplacement.hasTurret() && gunEmplacement.isTurretLocked()) {
            writer.write("<turretLocked facing=\"");
            writer.write(Integer.toString(gunEmplacement.getSecondaryFacing()));
            writer.write("\"/>");
        }
    }

    public static Entity decode(ParsedXML parsedXML, IGame iGame) {
        if (!parsedXML.getName().equals("class") || !"GunEmplacement".equals(parsedXML.getAttribute("name"))) {
            throw new IllegalStateException("Not passed an GunEmplacement node.");
        }
        GunEmplacement gunEmplacement = new GunEmplacement();
        Enumeration enumeration = parsedXML.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
            String string2 = parsedXML2.getName();
            if (string2.equals("cf")) {
                string = parsedXML2.getContent().trim();
                try {
                    gunEmplacement.setConstructionFactor(Integer.parseInt(string));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException("Invalid integer value for cf element: " + string);
                }
            }
            if (!string2.equals("turretLocked")) continue;
            string = parsedXML2.getAttribute("facing");
            gunEmplacement.setTurretLocked(true);
            try {
                gunEmplacement.setSecondaryFacing(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException("Invalid integer value for facing attribute: " + string);
            }
        }
        return gunEmplacement;
    }
}

