/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Minefield;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.StreakHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreakLRMHandler
extends StreakHandler {
    private static final long serialVersionUID = -3848472655779311898L;

    public StreakLRMHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            int n = Compute.directBlowInfantryDamage(this.wtype.getRackSize() * 2, this.bDirect ? this.toHit.getMoS() / 3 : 0, 3, ((Infantry)this.target).isMechanized());
            return n;
        }
        return 1;
    }

    @Override
    protected int calcnCluster() {
        return 5;
    }

    @Override
    protected boolean specialResolution(Vector<Report> vector, Entity entity, boolean bl) {
        if (!bl && this.target.getTargetType() == 5) {
            this.r = new Report(3255);
            this.r.indent(1);
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
            Coords coords = this.target.getPosition();
            Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (enumeration.hasMoreElements()) {
                Minefield minefield = enumeration.nextElement();
                if (!this.server.clearMinefield(minefield, this.ae, 5, vector)) continue;
                arrayList.add(minefield);
            }
            for (Minefield minefield : arrayList) {
                this.server.removeMinefield(minefield);
            }
            return true;
        }
        return false;
    }
}

