/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Set;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.IntSetSerializer;
import org.gradle.internal.serialize.InterningStringSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;

public class ClassAnalysisSerializer
extends AbstractSerializer<ClassAnalysis> {
    private final StringInterner interner;
    private final SetSerializer<String> stringSetSerializer;

    public ClassAnalysisSerializer(StringInterner interner) {
        this.stringSetSerializer = new SetSerializer((Serializer)new InterningStringSerializer(interner), false);
        this.interner = interner;
    }

    public ClassAnalysis read(Decoder decoder) throws Exception {
        String className = this.interner.intern(decoder.readString());
        boolean relatedToAll = decoder.readBoolean();
        Set classes = (Set)this.stringSetSerializer.read(decoder);
        IntSet constants = IntSetSerializer.INSTANCE.read(decoder);
        Set superTypes = (Set)this.stringSetSerializer.read(decoder);
        return new ClassAnalysis(className, classes, relatedToAll, constants, superTypes);
    }

    public void write(Encoder encoder, ClassAnalysis value) throws Exception {
        encoder.writeString((CharSequence)value.getClassName());
        encoder.writeBoolean(value.isDependencyToAll());
        this.stringSetSerializer.write(encoder, value.getClassDependencies());
        IntSetSerializer.INSTANCE.write(encoder, value.getConstants());
        this.stringSetSerializer.write(encoder, value.getSuperTypes());
    }
}

