/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.CurrentTaskExecution;
import org.gradle.api.internal.changedetection.state.HistoricalTaskExecution;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecutionFingerprintSerializer;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.changedetection.state.TaskHistoryStore;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.api.internal.changedetection.state.mirror.FileSystemSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.MerkleDirectorySnapshotBuilder;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalDirectorySnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshotVisitor;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.HistoricalFileCollectionFingerprint;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.impl.EmptyHistoricalFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.Serializer;
import org.gradle.normalization.internal.InputNormalizationHandlerInternal;
import org.gradle.normalization.internal.InputNormalizationStrategy;
import org.gradle.util.DeprecationLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class CacheBackedTaskHistoryRepository
implements TaskHistoryRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheBackedTaskHistoryRepository.class);
    private final PersistentIndexedCache<String, HistoricalTaskExecution> taskHistoryCache;
    private final StringInterner stringInterner;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ValueSnapshotter valueSnapshotter;
    private final FileCollectionFingerprinterRegistry fingerprinterRegistry;

    public CacheBackedTaskHistoryRepository(TaskHistoryStore cacheAccess, Serializer<HistoricalFileCollectionFingerprint> fileCollectionFingerprintSerializer, StringInterner stringInterner, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ValueSnapshotter valueSnapshotter, FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        this.stringInterner = stringInterner;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.valueSnapshotter = valueSnapshotter;
        this.fingerprinterRegistry = fingerprinterRegistry;
        TaskExecutionFingerprintSerializer serializer = new TaskExecutionFingerprintSerializer(fileCollectionFingerprintSerializer);
        this.taskHistoryCache = cacheAccess.createCache("taskHistory", String.class, serializer, 10000, false);
    }

    @Override
    public TaskHistoryRepository.History getHistory(final TaskInternal task, final TaskProperties taskProperties) {
        final InputNormalizationStrategy normalizationStrategy = ((InputNormalizationHandlerInternal)task.getProject().getNormalization()).buildFinalStrategy();
        return new TaskHistoryRepository.History(){
            private boolean previousExecutionLoadAttempted;
            private HistoricalTaskExecution previousExecution;
            private CurrentTaskExecution currentExecution;

            @Override
            public HistoricalTaskExecution getPreviousExecution() {
                if (!this.previousExecutionLoadAttempted) {
                    this.previousExecutionLoadAttempted = true;
                    this.previousExecution = CacheBackedTaskHistoryRepository.this.loadPreviousExecution(task);
                }
                return this.previousExecution;
            }

            @Override
            public CurrentTaskExecution getCurrentExecution() {
                if (this.currentExecution == null) {
                    this.currentExecution = CacheBackedTaskHistoryRepository.this.createExecution(task, taskProperties, this.getPreviousExecution(), normalizationStrategy);
                }
                return this.currentExecution;
            }

            @Override
            public void updateCurrentExecution() {
                CacheBackedTaskHistoryRepository.this.updateExecution(this.getPreviousExecution(), this.getCurrentExecution(), task, taskProperties, normalizationStrategy);
            }

            @Override
            public void updateCurrentExecutionWithOutputs(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> newOutputSnapshot) {
                CacheBackedTaskHistoryRepository.this.updateExecution(this.getCurrentExecution(), task, (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)newOutputSnapshot);
            }

            @Override
            public void persist() {
                CacheBackedTaskHistoryRepository.this.taskHistoryCache.put((Object)task.getPath(), (Object)this.getCurrentExecution().archive());
            }
        };
    }

    private CurrentTaskExecution createExecution(TaskInternal task, TaskProperties taskProperties, @Nullable HistoricalTaskExecution previousExecution, InputNormalizationStrategy normalizationStrategy) {
        Class<?> taskClass = task.getClass();
        List<ContextAwareTaskAction> taskActions = task.getTaskActions();
        ImplementationSnapshot taskImplementation = new ImplementationSnapshot(taskClass.getName(), this.classLoaderHierarchyHasher.getClassLoaderHash(taskClass.getClassLoader()));
        ImmutableList<ImplementationSnapshot> taskActionImplementations = CacheBackedTaskHistoryRepository.collectActionImplementations(taskActions, this.classLoaderHierarchyHasher);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Implementation for {}: {}", (Object)task, (Object)taskImplementation);
            LOGGER.debug("Action implementations for {}: {}", (Object)task, taskActionImplementations);
        }
        ImmutableSortedMap<String, ValueSnapshot> previousInputProperties = previousExecution == null ? ImmutableSortedMap.of() : previousExecution.getInputProperties();
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = CacheBackedTaskHistoryRepository.snapshotTaskInputProperties(task, taskProperties, previousInputProperties, this.valueSnapshotter);
        ImmutableSortedSet<String> outputPropertyNames = CacheBackedTaskHistoryRepository.getOutputPropertyNamesForCacheKey(taskProperties);
        ImmutableSet<String> declaredOutputFilePaths = CacheBackedTaskHistoryRepository.getDeclaredOutputFilePaths(taskProperties, this.stringInterner);
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles = CacheBackedTaskHistoryRepository.fingerprintTaskFiles(task, "Input", normalizationStrategy, taskProperties.getInputFileProperties(), this.fingerprinterRegistry);
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputFiles = CacheBackedTaskHistoryRepository.fingerprintTaskFiles(task, "Output", normalizationStrategy, taskProperties.getOutputFileProperties(), this.fingerprinterRegistry);
        OverlappingOutputs overlappingOutputs = CacheBackedTaskHistoryRepository.detectOverlappingOutputs(outputFiles, previousExecution);
        return new CurrentTaskExecution(taskImplementation, taskActionImplementations, inputProperties, outputPropertyNames, declaredOutputFilePaths, inputFiles, outputFiles, overlappingOutputs);
    }

    private void updateExecution(final @Nullable HistoricalTaskExecution previousExecution, CurrentTaskExecution currentExecution, TaskInternal task, TaskProperties taskProperties, InputNormalizationStrategy normalizationStrategy) {
        final ImmutableSortedMap outputFilesAfter = CacheBackedTaskHistoryRepository.fingerprintTaskFiles(task, "Output", normalizationStrategy, taskProperties.getOutputFileProperties(), this.fingerprinterRegistry);
        ImmutableSortedMap newOutputFingerprint = currentExecution.getDetectedOverlappingOutputs() == null ? outputFilesAfter : ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(currentExecution.getOutputFingerprints(), (Maps.EntryTransformer)new Maps.EntryTransformer<String, CurrentFileCollectionFingerprint, CurrentFileCollectionFingerprint>(){

            public CurrentFileCollectionFingerprint transformEntry(String propertyName, CurrentFileCollectionFingerprint beforeExecution) {
                CurrentFileCollectionFingerprint afterExecution = (CurrentFileCollectionFingerprint)outputFilesAfter.get((Object)propertyName);
                HistoricalFileCollectionFingerprint afterPreviousExecution = CacheBackedTaskHistoryRepository.getFingerprintAfterPreviousExecution(previousExecution, propertyName);
                return CacheBackedTaskHistoryRepository.filterOutputFingerprint(afterPreviousExecution, beforeExecution, afterExecution);
            }
        }));
        this.updateExecution(currentExecution, task, newOutputFingerprint);
    }

    private void updateExecution(CurrentTaskExecution currentExecution, TaskInternal task, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> newOutputFingerprint) {
        currentExecution.setSuccessful(task.getState().getFailure() == null);
        currentExecution.setOutputFingerprintsAfterExecution(newOutputFingerprint);
    }

    private static CurrentFileCollectionFingerprint filterOutputFingerprint(@Nullable HistoricalFileCollectionFingerprint afterPreviousExecution, CurrentFileCollectionFingerprint beforeExecution, CurrentFileCollectionFingerprint afterExecution) {
        CurrentFileCollectionFingerprint filesFingerprint;
        final Map<String, PhysicalSnapshot> beforeExecutionSnapshots = CacheBackedTaskHistoryRepository.getAllSnapshots(beforeExecution);
        if (!beforeExecution.getSnapshots().isEmpty() && !afterExecution.getSnapshots().isEmpty()) {
            Object afterPreviousSnapshots = afterPreviousExecution != null ? afterPreviousExecution.getSnapshots() : ImmutableMap.of();
            ArrayList<FileSystemSnapshot> newRoots = new ArrayList<FileSystemSnapshot>();
            MutableBoolean hasBeenFiltered = new MutableBoolean(false);
            afterExecution.visitRoots(new PhysicalSnapshotVisitor((Map)afterPreviousSnapshots, hasBeenFiltered, newRoots){
                private MerkleDirectorySnapshotBuilder merkleBuilder;
                private boolean currentRootFiltered = false;
                private PhysicalDirectorySnapshot currentRoot;
                final /* synthetic */ Map val$afterPreviousSnapshots;
                final /* synthetic */ MutableBoolean val$hasBeenFiltered;
                final /* synthetic */ List val$newRoots;
                {
                    this.val$afterPreviousSnapshots = map2;
                    this.val$hasBeenFiltered = mutableBoolean;
                    this.val$newRoots = list;
                }

                @Override
                public boolean preVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
                    if (this.merkleBuilder == null) {
                        this.merkleBuilder = MerkleDirectorySnapshotBuilder.noSortingRequired();
                        this.currentRoot = directorySnapshot;
                        this.currentRootFiltered = false;
                    }
                    this.merkleBuilder.preVisitDirectory(directorySnapshot);
                    return true;
                }

                @Override
                public void visit(PhysicalSnapshot fileSnapshot) {
                    if (!CacheBackedTaskHistoryRepository.isOutputEntry(fileSnapshot, beforeExecutionSnapshots, this.val$afterPreviousSnapshots)) {
                        this.val$hasBeenFiltered.set(true);
                        this.currentRootFiltered = true;
                        return;
                    }
                    if (this.merkleBuilder == null) {
                        this.val$newRoots.add(fileSnapshot);
                    } else {
                        this.merkleBuilder.visit(fileSnapshot);
                    }
                }

                @Override
                public void postVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
                    boolean isOutputDir = CacheBackedTaskHistoryRepository.isOutputEntry(directorySnapshot, beforeExecutionSnapshots, this.val$afterPreviousSnapshots);
                    boolean includedDir = this.merkleBuilder.postVisitDirectory(isOutputDir);
                    if (!includedDir) {
                        this.currentRootFiltered = true;
                        this.val$hasBeenFiltered.set(true);
                    }
                    if (this.merkleBuilder.isRoot()) {
                        PhysicalSnapshot result = this.merkleBuilder.getResult();
                        if (result != null) {
                            this.val$newRoots.add(this.currentRootFiltered ? result : this.currentRoot);
                        }
                        this.merkleBuilder = null;
                        this.currentRoot = null;
                    }
                }
            });
            filesFingerprint = !hasBeenFiltered.get() ? afterExecution : DefaultCurrentFileCollectionFingerprint.from(newRoots, AbsolutePathFingerprintingStrategy.IGNORE_MISSING);
        } else {
            filesFingerprint = afterExecution;
        }
        return filesFingerprint;
    }

    private static Map<String, PhysicalSnapshot> getAllSnapshots(CurrentFileCollectionFingerprint fingerprint) {
        GetAllSnapshotsVisitor afterExecutionVisitor = new GetAllSnapshotsVisitor();
        fingerprint.visitRoots(afterExecutionVisitor);
        return afterExecutionVisitor.getSnapshots();
    }

    private static boolean isOutputEntry(PhysicalSnapshot fileSnapshot, Map<String, PhysicalSnapshot> beforeSnapshots, Map<String, NormalizedFileSnapshot> afterPreviousSnapshots) {
        if (fileSnapshot.getType() == FileType.Missing) {
            return false;
        }
        PhysicalSnapshot beforeSnapshot = beforeSnapshots.get(fileSnapshot.getAbsolutePath());
        if (beforeSnapshot == null) {
            return true;
        }
        if (!fileSnapshot.isContentAndMetadataUpToDate(beforeSnapshot)) {
            return true;
        }
        return afterPreviousSnapshots.containsKey(fileSnapshot.getAbsolutePath());
    }

    private static ImmutableList<ImplementationSnapshot> collectActionImplementations(Collection<ContextAwareTaskAction> taskActions, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        if (taskActions.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder actionImplementations = ImmutableList.builder();
        for (ContextAwareTaskAction taskAction : taskActions) {
            String typeName = taskAction.getActionClassName();
            HashCode classLoaderHash = classLoaderHierarchyHasher.getClassLoaderHash(taskAction.getClassLoader());
            actionImplementations.add((Object)new ImplementationSnapshot(typeName, classLoaderHash));
        }
        return actionImplementations.build();
    }

    private static ImmutableSortedMap<String, ValueSnapshot> snapshotTaskInputProperties(TaskInternal task, TaskProperties taskProperties, ImmutableSortedMap<String, ValueSnapshot> previousInputProperties, ValueSnapshotter valueSnapshotter) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        Map inputPropertyValues = (Map)taskProperties.getInputPropertyValues().create();
        assert (inputPropertyValues != null);
        for (Map.Entry entry : inputPropertyValues.entrySet()) {
            String propertyName = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                ValueSnapshot previousSnapshot = (ValueSnapshot)previousInputProperties.get((Object)propertyName);
                if (previousSnapshot == null) {
                    builder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(value));
                    continue;
                }
                builder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(value, previousSnapshot));
            }
            catch (Exception e) {
                throw new UncheckedIOException(String.format("Unable to store input properties for %s. Property '%s' with value '%s' cannot be serialized.", task, propertyName, value), (Throwable)e);
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fingerprintTaskFiles(TaskInternal task, String title, InputNormalizationStrategy normalizationStrategy, SortedSet<? extends TaskFilePropertySpec> fileProperties, FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (TaskFilePropertySpec taskFilePropertySpec : fileProperties) {
            CurrentFileCollectionFingerprint result;
            try {
                FileCollectionFingerprinter fingerprinter = fingerprinterRegistry.getFingerprinter(taskFilePropertySpec.getNormalizer());
                LOGGER.debug("Fingerprinting property {} for {}", (Object)taskFilePropertySpec, (Object)task);
                result = fingerprinter.fingerprint(taskFilePropertySpec.getPropertyFiles(), normalizationStrategy);
            }
            catch (Exception e) {
                throw new UncheckedIOException(String.format("Failed to capture fingerprint of %s files for %s property '%s' during up-to-date check.", title.toLowerCase(), task, taskFilePropertySpec.getPropertyName()), (Throwable)e);
            }
            builder.put((Object)taskFilePropertySpec.getPropertyName(), (Object)result);
        }
        return builder.build();
    }

    @Nullable
    private static OverlappingOutputs detectOverlappingOutputs(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> taskOutputs, @Nullable HistoricalTaskExecution previousExecution) {
        for (Map.Entry entry : taskOutputs.entrySet()) {
            String propertyName = (String)entry.getKey();
            FileCollectionFingerprint beforeExecution = (FileCollectionFingerprint)entry.getValue();
            HistoricalFileCollectionFingerprint afterPreviousExecution = CacheBackedTaskHistoryRepository.getFingerprintAfterPreviousExecution(previousExecution, propertyName);
            OverlappingOutputs overlappingOutputs = OverlappingOutputs.detect(propertyName, afterPreviousExecution, beforeExecution);
            if (overlappingOutputs == null) continue;
            return overlappingOutputs;
        }
        return null;
    }

    private static HistoricalFileCollectionFingerprint getFingerprintAfterPreviousExecution(@Nullable HistoricalTaskExecution previousExecution, String propertyName) {
        ImmutableSortedMap<String, HistoricalFileCollectionFingerprint> previousFingerprints;
        HistoricalFileCollectionFingerprint afterPreviousExecution;
        if (previousExecution != null && (afterPreviousExecution = (HistoricalFileCollectionFingerprint)(previousFingerprints = previousExecution.getOutputFingerprints()).get(propertyName)) != null) {
            return afterPreviousExecution;
        }
        return EmptyHistoricalFileCollectionFingerprint.INSTANCE;
    }

    @Nullable
    private HistoricalTaskExecution loadPreviousExecution(TaskInternal task) {
        return (HistoricalTaskExecution)this.taskHistoryCache.get((Object)task.getPath());
    }

    private static ImmutableSortedSet<String> getOutputPropertyNamesForCacheKey(TaskProperties taskProperties) {
        ImmutableSortedSet<TaskOutputFilePropertySpec> fileProperties = taskProperties.getOutputFileProperties();
        ArrayList outputPropertyNames = Lists.newArrayListWithCapacity((int)fileProperties.size());
        for (TaskOutputFilePropertySpec propertySpec : fileProperties) {
            CacheableTaskOutputFilePropertySpec cacheablePropertySpec;
            if (!(propertySpec instanceof CacheableTaskOutputFilePropertySpec) || (cacheablePropertySpec = (CacheableTaskOutputFilePropertySpec)propertySpec).getOutputFile() == null) continue;
            outputPropertyNames.add(propertySpec.getPropertyName());
        }
        return ImmutableSortedSet.copyOf((Collection)outputPropertyNames);
    }

    private static ImmutableSet<String> getDeclaredOutputFilePaths(TaskProperties taskProperties, StringInterner stringInterner) {
        ImmutableSortedSet.Builder declaredOutputFilePaths = ImmutableSortedSet.naturalOrder();
        FileCollectionInternal outputFiles = (FileCollectionInternal)taskProperties.getOutputFiles();
        outputFiles.visitRootElements(new FileCollectionVisitor((ImmutableSet.Builder)declaredOutputFilePaths, stringInterner){
            final /* synthetic */ ImmutableSet.Builder val$declaredOutputFilePaths;
            final /* synthetic */ StringInterner val$stringInterner;
            {
                this.val$declaredOutputFilePaths = builder;
                this.val$stringInterner = stringInterner;
            }

            @Override
            public void visitCollection(FileCollectionInternal fileCollection) {
                CacheBackedTaskHistoryRepository.addAllPaths((Iterable)((Object)fileCollection), (ImmutableSet.Builder<String>)this.val$declaredOutputFilePaths, this.val$stringInterner);
            }

            @Override
            public void visitTree(FileTreeInternal fileTree) {
                DeprecationLogger.nagUserWithDeprecatedIndirectUserCodeCause((String)"The ability to add non-directory-based file trees as declared outputs");
                CacheBackedTaskHistoryRepository.addAllPaths((Iterable)((Object)fileTree), (ImmutableSet.Builder<String>)this.val$declaredOutputFilePaths, this.val$stringInterner);
            }

            @Override
            public void visitDirectoryTree(DirectoryFileTree directoryTree) {
                CacheBackedTaskHistoryRepository.addPath(directoryTree.getDir(), (ImmutableSet.Builder<String>)this.val$declaredOutputFilePaths, this.val$stringInterner);
            }
        });
        return declaredOutputFilePaths.build();
    }

    private static void addAllPaths(Iterable<File> files, ImmutableSet.Builder<String> builder, StringInterner stringInterner) {
        for (File file : files) {
            CacheBackedTaskHistoryRepository.addPath(file, builder, stringInterner);
        }
    }

    private static void addPath(File file, ImmutableSet.Builder<String> builder, StringInterner stringInterner) {
        builder.add((Object)stringInterner.intern(file.getAbsolutePath()));
    }

    private static class GetAllSnapshotsVisitor
    implements PhysicalSnapshotVisitor {
        private final Map<String, PhysicalSnapshot> snapshots = new HashMap<String, PhysicalSnapshot>();

        private GetAllSnapshotsVisitor() {
        }

        @Override
        public boolean preVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
            this.snapshots.put(directorySnapshot.getAbsolutePath(), directorySnapshot);
            return true;
        }

        @Override
        public void visit(PhysicalSnapshot fileSnapshot) {
            this.snapshots.put(fileSnapshot.getAbsolutePath(), fileSnapshot);
        }

        @Override
        public void postVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
        }

        public Map<String, PhysicalSnapshot> getSnapshots() {
            return this.snapshots;
        }
    }
}

