/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.operation.AssignmentTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public final class OverloadedAssignmentTranslator
extends AssignmentTranslator {
    @NotNull
    private final ResolvedCall<? extends FunctionDescriptor> resolvedCall;

    @NotNull
    public static JsExpression doTranslate(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        return new OverloadedAssignmentTranslator(expression2, context).translate();
    }

    private OverloadedAssignmentTranslator(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        super(expression2, context);
        this.resolvedCall = CallUtilKt.getFunctionResolvedCallWithAssert(expression2, context.bindingContext());
    }

    @NotNull
    private JsExpression translate() {
        if (this.isVariableReassignment) {
            return this.reassignment();
        }
        KtExpression left = this.expression.getLeft();
        assert (left != null);
        return this.overloadedMethodInvocation(AccessTranslationUtils.getAccessTranslator(left, this.context()));
    }

    @NotNull
    private JsExpression reassignment() {
        KtExpression left = this.expression.getLeft();
        assert (left != null);
        AccessTranslator accessTranslator = AccessTranslationUtils.getAccessTranslator(left, this.context()).getCached();
        JsExpression newValue2 = this.overloadedMethodInvocation(accessTranslator);
        return accessTranslator.translateAsSet(newValue2);
    }

    @NotNull
    private JsExpression overloadedMethodInvocation(AccessTranslator accessTranslator) {
        JsBlock innerBlock = new JsBlock();
        TranslationContext innerContext = this.context().innerBlock(innerBlock);
        JsExpression oldValue = accessTranslator.translateAsGet();
        JsBlock argumentBlock = new JsBlock();
        TranslationContext argumentContext = innerContext.innerBlock(argumentBlock);
        KtExpression argumentPsi = this.expression.getRight();
        assert (argumentPsi != null);
        JsExpression argument = Translation.translateAsExpression(argumentPsi, argumentContext);
        if (!argumentBlock.isEmpty()) {
            oldValue = innerContext.defineTemporary(oldValue);
            innerContext.addStatementsToCurrentBlockFrom(argumentBlock);
        }
        HashMap<KtExpression, JsExpression> aliases = new HashMap<KtExpression, JsExpression>();
        aliases.put(argumentPsi, argument);
        innerContext = innerContext.innerContextWithAliasesForExpressions(aliases);
        JsExpression result2 = CallTranslator.translate(innerContext, this.resolvedCall, oldValue);
        this.context().addStatementsToCurrentBlockFrom(innerBlock);
        return result2;
    }
}

