/*
 *   Copyright 2013 Marco Martin <mart@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2 or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.1
import QtQuick.Layouts 1.1
import org.kde.plasma.plasmoid 2.0
import org.kde.plasma.core 2.0 as PlasmaCore
import org.kde.plasma.components 2.0 as PlasmaComponents

PlasmaCore.SvgItem {
    Layout.minimumWidth: 150
    Layout.minimumHeight: 150
    svg: PlasmaCore.Svg { imagePath: "widgets/notes" }
    elementId: "yellow-notes"

    Connections {
        target: plasmoid
        onExternalData: {
            if (mimetype === "text/plain") {
                noteText.text = data
            }
        }
    }

    PlasmaComponents.TextArea {
        id: noteText
        anchors.fill: parent
        anchors.margins: 20
        text: plasmoid.configuration.Text
        onTextChanged: plasmoid.configuration.Text = text
    }
}
