/*
   Copyright (c) 2013 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2013:DUAL/GPL:standard
    
    Unless you and Broadcom execute a separate written software license
    agreement governing use of this software, this software is licensed
    to you under the terms of the GNU General Public License version 2
    (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
    with the following added to such license:
    
       As a special exception, the copyright holders of this software give
       you permission to link this software with independent modules, and
       to copy and distribute the resulting executable under terms of your
       choice, provided that you also meet, for each linked independent
       module, the terms and conditions of the license of that module.
       An independent module is a module which is not derived from this
       software.  The special exception does not apply to any modifications
       of the software.
    
    Not withstanding the above, under no circumstances may you combine
    this software in any way with any other Broadcom software provided
    under a license other than the GPL, without Broadcom's express prior
    written consent.
    
    :> 
*/             

#ifndef __UBUS_H_INCLUDED
#define __UBUS_H_INCLUDED

/*  File automatically generated by Reggae at 15/08/2013  10:55:15   */

#include "access_macros.h"
#include "packing.h"


/*****************************************************************************************/
/* Ubus registers including Master and Slave ports                                       */
/*****************************************************************************************/

/*****************************************************************************************/
/* Functions offsets and addresses                                                       */
/*****************************************************************************************/
#define UBUS_UBUS_MASTER_0_BRDG_REG_OFFSET 	( 0x00000000 )
#define UBUS_UBUS_MASTER_0_BRDG_REG_ADDRESS	( UBUS_UBUS_MASTER_0_OFFSET + UBUS_UBUS_MASTER_0_BRDG_REG_OFFSET )

#define UBUS_UBUS_MASTER_1_BRDG_REG_OFFSET 	( 0x00000000 )
#define UBUS_UBUS_MASTER_1_BRDG_REG_ADDRESS	( UBUS_UBUS_MASTER_1_OFFSET + UBUS_UBUS_MASTER_1_BRDG_REG_OFFSET )

#define UBUS_UBUS_MASTER_2_BRDG_REG_OFFSET 	( 0x00000000 )
#define UBUS_UBUS_MASTER_2_BRDG_REG_ADDRESS	( UBUS_UBUS_MASTER_2_OFFSET + UBUS_UBUS_MASTER_2_BRDG_REG_OFFSET )

#define UBUS_UBUS_SLAVE_BRDG_REG_OFFSET 	( 0x00000000 )
#define UBUS_UBUS_SLAVE_BRDG_REG_ADDRESS	( UBUS_UBUS_SLAVE_OFFSET + UBUS_UBUS_SLAVE_BRDG_REG_OFFSET )

#define UBUS_UBUS_MISC_EGPHY_OFFSET 	( 0x00000000 )
#define UBUS_UBUS_MISC_EGPHY_ADDRESS	( UBUS_UBUS_MISC_OFFSET + UBUS_UBUS_MISC_EGPHY_OFFSET )

/*   'd' is module index   */
/*   'i' is block index    */
/*   'j' is function index */
/*   'e' is function entry */
/*   'k' is register index */

/*****************************************************************************************/
/* BRDG_EN                                                                               */
/* bridge enable                                                                         */
/*****************************************************************************************/

#define UBUS_UBUS_MASTER_BRDG_REG_EN_R0_RSRV_VALUE                ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_EN_R0_RSRV_VALUE_RESET_VALUE    ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_EN_EN_DISABLE_VALUE             ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_EN_EN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_EN_EN_ENABLE_VALUE              ( 0x1 )


#define UBUS_UBUS_MASTER_BRDG_REG_EN_OFFSET ( 0x00000000 )

#define UBUS_UBUS_MASTER_0_BRDG_REG_EN_ADDRESS   	( UBUS_UBUS_MASTER_0_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_EN_OFFSET )
#define UBUS_UBUS_MASTER_0_BRDG_REG_EN_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_0_BRDG_REG_EN_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_0_BRDG_REG_EN_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_0_BRDG_REG_EN_ADDRESS ), (v) )

#define UBUS_UBUS_MASTER_1_BRDG_REG_EN_ADDRESS   	( UBUS_UBUS_MASTER_1_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_EN_OFFSET )
#define UBUS_UBUS_MASTER_1_BRDG_REG_EN_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_1_BRDG_REG_EN_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_1_BRDG_REG_EN_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_1_BRDG_REG_EN_ADDRESS ), (v) )

#define UBUS_UBUS_MASTER_2_BRDG_REG_EN_ADDRESS   	( UBUS_UBUS_MASTER_2_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_EN_OFFSET )
#define UBUS_UBUS_MASTER_2_BRDG_REG_EN_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_2_BRDG_REG_EN_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_2_BRDG_REG_EN_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_2_BRDG_REG_EN_ADDRESS ), (v) )


extern uint32_t UBUS_UBUS_MASTER_BRDG_REG_EN_ARRAY [ ] ;

#define UBUS_UBUS_MASTER_BRDG_REG_EN_WRITE( i, v )	WRITE_32( UBUS_UBUS_MASTER_BRDG_REG_EN_ARRAY [ i ], (v) )
#define UBUS_UBUS_MASTER_BRDG_REG_EN_READ( i, r ) 	READ_32( UBUS_UBUS_MASTER_BRDG_REG_EN_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BRDG_ENABLE */
	uint32_t en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG_EN ;
#else
typedef struct
{	uint32_t en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BRDG_ENABLE */
	uint32_t r0	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG_EN ;
#endif

/*****************************************************************************************/
/* RQUSTOR_CTRL                                                                          */
/* Requestor side contol. These registers are releated to ubus requestor control         */
/*****************************************************************************************/

#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_MAX_PKT_LEN_MAX_PACKET_LEN_VALUE             ( 0x90 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_MAX_PKT_LEN_MAX_PACKET_LEN_VALUE_RESET_VALUE ( 0x90 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_R0_RSRV_VALUE                                ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_R0_RSRV_VALUE_RESET_VALUE                    ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_DEV_ERR_NORMAL_VALUE                         ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_DEV_ERR_NORMAL_VALUE_RESET_VALUE             ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_DEV_ERR_ERR_VALUE                            ( 0x1 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_REQOUT_ESWAP_NO_SWAP_VALUE                   ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_REQOUT_ESWAP_NO_SWAP_VALUE_RESET_VALUE       ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_REQOUT_ESWAP_SWAP_VALUE                      ( 0x1 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_REPIN_ESWAP_NO_SWAP_VALUE                    ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_REPIN_ESWAP_NO_SWAP_VALUE_RESET_VALUE        ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_REPIN_ESWAP_SWAP_VALUE                       ( 0x1 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_ENDIAN_MODE_LL_VALUE                         ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_ENDIAN_MODE_LB_VALUE                         ( 0x1 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_ENDIAN_MODE_BL_VALUE                         ( 0x2 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_ENDIAN_MODE_BB_VALUE                         ( 0x3 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_ENDIAN_MODE_BB_VALUE_RESET_VALUE             ( 0x3 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_R1_RSRV_VALUE                                ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_R1_RSRV_VALUE_RESET_VALUE                    ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_PKT_TAG_TAG_DIS_VALUE                        ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_PKT_TAG_TAG_DIS_VALUE_RESET_VALUE            ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_PKT_TAG_TAG_EN_VALUE                         ( 0x1 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_PKT_ID_PKT_ID_VALUE                          ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_PKT_ID_PKT_ID_VALUE_RESET_VALUE              ( 0x0 )


#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_OFFSET ( 0x00000004 )

#define UBUS_UBUS_MASTER_0_BRDG_REG_REQ_CNTRL_ADDRESS   	( UBUS_UBUS_MASTER_0_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_OFFSET )
#define UBUS_UBUS_MASTER_0_BRDG_REG_REQ_CNTRL_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_0_BRDG_REG_REQ_CNTRL_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_0_BRDG_REG_REQ_CNTRL_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_0_BRDG_REG_REQ_CNTRL_ADDRESS ), (v) )

#define UBUS_UBUS_MASTER_1_BRDG_REG_REQ_CNTRL_ADDRESS   	( UBUS_UBUS_MASTER_1_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_OFFSET )
#define UBUS_UBUS_MASTER_1_BRDG_REG_REQ_CNTRL_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_1_BRDG_REG_REQ_CNTRL_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_1_BRDG_REG_REQ_CNTRL_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_1_BRDG_REG_REQ_CNTRL_ADDRESS ), (v) )

#define UBUS_UBUS_MASTER_2_BRDG_REG_REQ_CNTRL_ADDRESS   	( UBUS_UBUS_MASTER_2_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_OFFSET )
#define UBUS_UBUS_MASTER_2_BRDG_REG_REQ_CNTRL_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_2_BRDG_REG_REQ_CNTRL_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_2_BRDG_REG_REQ_CNTRL_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_2_BRDG_REG_REQ_CNTRL_ADDRESS ), (v) )


extern uint32_t UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_ARRAY [ ] ;

#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_WRITE( i, v )	WRITE_32( UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_ARRAY [ i ], (v) )
#define UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_READ( i, r ) 	READ_32( UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Max_Packet_len */
	uint32_t max_pkt_len 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r0          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dev_error */
	uint32_t dev_err     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reqout_eswap */
	uint32_t reqout_eswap	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* repin_eswap */
	uint32_t repin_eswap 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* endian_mode */
	uint32_t endian_mode 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1          	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* packet_tag */
	uint32_t pkt_tag     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* packet_id */
	uint32_t pkt_id      	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL ;
#else
typedef struct
{	uint32_t pkt_id      	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* packet_id */
	uint32_t pkt_tag     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* packet_tag */
	uint32_t r1          	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t endian_mode 	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* endian_mode */
	uint32_t repin_eswap 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* repin_eswap */
	uint32_t reqout_eswap	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reqout_eswap */
	uint32_t dev_err     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dev_error */
	uint32_t r0          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t max_pkt_len 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Packet_len */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL ;
#endif

/*****************************************************************************************/
/* HYST_CTRL                                                                             */
/* control the command / data queue full and empty indications.                          */
/*****************************************************************************************/

#define UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_R1_RSRV_VALUE                       ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_R1_RSRV_VALUE_RESET_VALUE           ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_DATA_SPACE_DSPACE_VALUE             ( 0xC )
#define UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_DATA_SPACE_DSPACE_VALUE_RESET_VALUE ( 0xC )
#define UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_R0_RSRV_VALUE                       ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_R0_RSRV_VALUE_RESET_VALUE           ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_CMD_SPACE_HSPACE_VALUE              ( 0xC )
#define UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_CMD_SPACE_HSPACE_VALUE_RESET_VALUE  ( 0xC )


#define UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_OFFSET ( 0x00000008 )

#define UBUS_UBUS_MASTER_0_BRDG_REG_HYST_CTRL_ADDRESS   	( UBUS_UBUS_MASTER_0_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_OFFSET )
#define UBUS_UBUS_MASTER_0_BRDG_REG_HYST_CTRL_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_0_BRDG_REG_HYST_CTRL_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_0_BRDG_REG_HYST_CTRL_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_0_BRDG_REG_HYST_CTRL_ADDRESS ), (v) )

#define UBUS_UBUS_MASTER_1_BRDG_REG_HYST_CTRL_ADDRESS   	( UBUS_UBUS_MASTER_1_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_OFFSET )
#define UBUS_UBUS_MASTER_1_BRDG_REG_HYST_CTRL_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_1_BRDG_REG_HYST_CTRL_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_1_BRDG_REG_HYST_CTRL_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_1_BRDG_REG_HYST_CTRL_ADDRESS ), (v) )

#define UBUS_UBUS_MASTER_2_BRDG_REG_HYST_CTRL_ADDRESS   	( UBUS_UBUS_MASTER_2_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_OFFSET )
#define UBUS_UBUS_MASTER_2_BRDG_REG_HYST_CTRL_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_2_BRDG_REG_HYST_CTRL_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_2_BRDG_REG_HYST_CTRL_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_2_BRDG_REG_HYST_CTRL_ADDRESS ), (v) )


extern uint32_t UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_ARRAY [ ] ;

#define UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_WRITE( i, v )	WRITE_32( UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_ARRAY [ i ], (v) )
#define UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_READ( i, r ) 	READ_32( UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1        	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DATA_SPACE */
	uint32_t data_space	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r0        	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CMD_SPACE */
	uint32_t cmd_space 	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL ;
#else
typedef struct
{	uint32_t cmd_space 	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CMD_SPACE */
	uint32_t r0        	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t data_space	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DATA_SPACE */
	uint32_t r1        	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL ;
#endif

/*****************************************************************************************/
/* High_Priority                                                                         */
/* controls the high priority mechanism                                                  */
/*****************************************************************************************/

#define UBUS_UBUS_MASTER_BRDG_REG_HP_R2_RSRV_VALUE                               ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_R2_RSRV_VALUE_RESET_VALUE                   ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_CNT_TOTAL_HP_CNT_TOTAL_VALUE             ( 0xF )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_CNT_TOTAL_HP_CNT_TOTAL_VALUE_RESET_VALUE ( 0xF )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_R1_RSRV_VALUE                               ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_R1_RSRV_VALUE_RESET_VALUE                   ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_CNT_HIGH_HP_CNT_HIGH_VALUE               ( 0x8 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_CNT_HIGH_HP_CNT_HIGH_VALUE_RESET_VALUE   ( 0x8 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_R0_RSRV_VALUE                               ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_R0_RSRV_VALUE_RESET_VALUE                   ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_COMB_SEL_VALUE                           ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_COMB_SEL_VALUE_RESET_VALUE               ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_COMB_COMBINE_VALUE                       ( 0x1 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_SEL_EXTERNAL_VALUE                       ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_SEL_EXTERNAL_VALUE_RESET_VALUE           ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_SEL_INTERNAL_VALUE                       ( 0x1 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_EN_DISABLE_VALUE                         ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_EN_DISABLE_VALUE_RESET_VALUE             ( 0x0 )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_HP_EN_EN_VALUE                              ( 0x1 )


#define UBUS_UBUS_MASTER_BRDG_REG_HP_OFFSET ( 0x0000000C )

#define UBUS_UBUS_MASTER_0_BRDG_REG_HP_ADDRESS   	( UBUS_UBUS_MASTER_0_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_HP_OFFSET )
#define UBUS_UBUS_MASTER_0_BRDG_REG_HP_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_0_BRDG_REG_HP_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_0_BRDG_REG_HP_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_0_BRDG_REG_HP_ADDRESS ), (v) )

#define UBUS_UBUS_MASTER_1_BRDG_REG_HP_ADDRESS   	( UBUS_UBUS_MASTER_1_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_HP_OFFSET )
#define UBUS_UBUS_MASTER_1_BRDG_REG_HP_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_1_BRDG_REG_HP_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_1_BRDG_REG_HP_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_1_BRDG_REG_HP_ADDRESS ), (v) )

#define UBUS_UBUS_MASTER_2_BRDG_REG_HP_ADDRESS   	( UBUS_UBUS_MASTER_2_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_HP_OFFSET )
#define UBUS_UBUS_MASTER_2_BRDG_REG_HP_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_2_BRDG_REG_HP_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_2_BRDG_REG_HP_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_2_BRDG_REG_HP_ADDRESS ), (v) )


extern uint32_t UBUS_UBUS_MASTER_BRDG_REG_HP_ARRAY [ ] ;

#define UBUS_UBUS_MASTER_BRDG_REG_HP_WRITE( i, v )	WRITE_32( UBUS_UBUS_MASTER_BRDG_REG_HP_ARRAY [ i ], (v) )
#define UBUS_UBUS_MASTER_BRDG_REG_HP_READ( i, r ) 	READ_32( UBUS_UBUS_MASTER_BRDG_REG_HP_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r2          	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* hp_cnt_total */
	uint32_t hp_cnt_total	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1          	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* hp_cnt_high */
	uint32_t hp_cnt_high 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r0          	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* hp_combine */
	uint32_t hp_comb     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* hp_sel */
	uint32_t hp_sel      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* hp_en */
	uint32_t hp_en       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG_HP ;
#else
typedef struct
{	uint32_t hp_en       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* hp_en */
	uint32_t hp_sel      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* hp_sel */
	uint32_t hp_comb     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* hp_combine */
	uint32_t r0          	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t hp_cnt_high 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* hp_cnt_high */
	uint32_t r1          	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t hp_cnt_total	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* hp_cnt_total */
	uint32_t r2          	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG_HP ;
#endif

/*****************************************************************************************/
/* REPLY_ADDRESS                                                                         */
/* holds the termination address used for the read reply command                         */
/*****************************************************************************************/

#define UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD_ADD_REPLY_ADD_VALUE             ( 0xFFFF0000 )
#define UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD_ADD_REPLY_ADD_VALUE_RESET_VALUE ( 0xFFFF0000 )


#define UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD_OFFSET ( 0x00000010 )

#define UBUS_UBUS_MASTER_0_BRDG_REG_REPLY_ADD_ADDRESS   	( UBUS_UBUS_MASTER_0_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD_OFFSET )
#define UBUS_UBUS_MASTER_0_BRDG_REG_REPLY_ADD_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_0_BRDG_REG_REPLY_ADD_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_0_BRDG_REG_REPLY_ADD_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_0_BRDG_REG_REPLY_ADD_ADDRESS ), (v) )

#define UBUS_UBUS_MASTER_1_BRDG_REG_REPLY_ADD_ADDRESS   	( UBUS_UBUS_MASTER_1_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD_OFFSET )
#define UBUS_UBUS_MASTER_1_BRDG_REG_REPLY_ADD_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_1_BRDG_REG_REPLY_ADD_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_1_BRDG_REG_REPLY_ADD_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_1_BRDG_REG_REPLY_ADD_ADDRESS ), (v) )

#define UBUS_UBUS_MASTER_2_BRDG_REG_REPLY_ADD_ADDRESS   	( UBUS_UBUS_MASTER_2_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD_OFFSET )
#define UBUS_UBUS_MASTER_2_BRDG_REG_REPLY_ADD_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_2_BRDG_REG_REPLY_ADD_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_2_BRDG_REG_REPLY_ADD_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_2_BRDG_REG_REPLY_ADD_ADDRESS ), (v) )


extern uint32_t UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD_ARRAY [ ] ;

#define UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD_WRITE( i, v )	WRITE_32( UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD_ARRAY [ i ], (v) )
#define UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD_READ( i, r ) 	READ_32( UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* address */
	uint32_t add	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD ;
#else
typedef struct
{	uint32_t add	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* address */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD ;
#endif

/*****************************************************************************************/
/* REPLY_DATA                                                                            */
/* holds the data value for the read reply command. the data held in this register will  */
/* be returned to runner                                                                 */
/*****************************************************************************************/

#define UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA_DATA_REPLY_DATA_VALUE             ( 0xDEADBEAF )
#define UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA_DATA_REPLY_DATA_VALUE_RESET_VALUE ( 0xDEADBEAF )


#define UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA_OFFSET ( 0x00000014 )

#define UBUS_UBUS_MASTER_0_BRDG_REG_REPLY_DATA_ADDRESS   	( UBUS_UBUS_MASTER_0_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA_OFFSET )
#define UBUS_UBUS_MASTER_0_BRDG_REG_REPLY_DATA_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_0_BRDG_REG_REPLY_DATA_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_0_BRDG_REG_REPLY_DATA_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_0_BRDG_REG_REPLY_DATA_ADDRESS ), (v) )

#define UBUS_UBUS_MASTER_1_BRDG_REG_REPLY_DATA_ADDRESS   	( UBUS_UBUS_MASTER_1_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA_OFFSET )
#define UBUS_UBUS_MASTER_1_BRDG_REG_REPLY_DATA_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_1_BRDG_REG_REPLY_DATA_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_1_BRDG_REG_REPLY_DATA_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_1_BRDG_REG_REPLY_DATA_ADDRESS ), (v) )

#define UBUS_UBUS_MASTER_2_BRDG_REG_REPLY_DATA_ADDRESS   	( UBUS_UBUS_MASTER_2_BRDG_REG_ADDRESS + UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA_OFFSET )
#define UBUS_UBUS_MASTER_2_BRDG_REG_REPLY_DATA_READ( r ) 	READ_32( ( UBUS_UBUS_MASTER_2_BRDG_REG_REPLY_DATA_ADDRESS ), (r) )
#define UBUS_UBUS_MASTER_2_BRDG_REG_REPLY_DATA_WRITE( v )	WRITE_32( ( UBUS_UBUS_MASTER_2_BRDG_REG_REPLY_DATA_ADDRESS ), (v) )


extern uint32_t UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA_ARRAY [ ] ;

#define UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA_WRITE( i, v )	WRITE_32( UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA_ARRAY [ i ], (v) )
#define UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA_READ( i, r ) 	READ_32( UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* data */
	uint32_t data	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA ;
#else
typedef struct
{	uint32_t data	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA ;
#endif

/*****************************************************************************************/
/* BRDG_EN                                                                               */
/* bridge enable                                                                         */
/*****************************************************************************************/

#define UBUS_UBUS_SLAVE_BRDG_REG_EN_R0_RSRV_VALUE                 ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_EN_R0_RSRV_VALUE_RESET_VALUE     ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_EN_INIT_INIT_0_VALUE             ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_EN_INIT_INIT_0_VALUE_RESET_VALUE ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_EN_INIT_INIT_1_VALUE             ( 0x1 )


#define UBUS_UBUS_SLAVE_BRDG_REG_EN_OFFSET ( 0x00000000 )

#define UBUS_UBUS_SLAVE_BRDG_REG_EN_ADDRESS   	( UBUS_UBUS_SLAVE_BRDG_REG_ADDRESS + UBUS_UBUS_SLAVE_BRDG_REG_EN_OFFSET )
#define UBUS_UBUS_SLAVE_BRDG_REG_EN_READ( r ) 	READ_32( ( UBUS_UBUS_SLAVE_BRDG_REG_EN_ADDRESS ), (r) )
#define UBUS_UBUS_SLAVE_BRDG_REG_EN_WRITE( v )	WRITE_32( ( UBUS_UBUS_SLAVE_BRDG_REG_EN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0  	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* init */
	uint32_t init	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_SLAVE_BRDG_REG_EN ;
#else
typedef struct
{	uint32_t init	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* init */
	uint32_t r0  	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_SLAVE_BRDG_REG_EN ;
#endif

/*****************************************************************************************/
/* RESPONDER_CTRL                                                                        */
/* Responder side contol. These registers are releated to ubus Responder control         */
/*****************************************************************************************/

#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_DEV_TIMEOUT_DEV_TIMEOUT_VALUE             ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_DEV_TIMEOUT_DEV_TIMEOUT_VALUE_RESET_VALUE ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_DEV_TIMEOUT_EN_DISABLE_VALUE              ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_DEV_TIMEOUT_EN_DISABLE_VALUE_RESET_VALUE  ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_DEV_TIMEOUT_EN_ENABLE_VALUE               ( 0x1 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_DEV_ERR_NORMAL_VALUE                      ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_DEV_ERR_NORMAL_VALUE_RESET_VALUE          ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_DEV_ERR_ERR_VALUE                         ( 0x1 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_DEV_CLKEN_DISABLE_VALUE                   ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_DEV_CLKEN_ENABLE_VALUE                    ( 0x1 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_DEV_CLKEN_ENABLE_VALUE_RESET_VALUE        ( 0x1 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_REQOUT_ESWAP_NO_SWAP_VALUE                ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_REQOUT_ESWAP_NO_SWAP_VALUE_RESET_VALUE    ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_REQOUT_ESWAP_SWAP_VALUE                   ( 0x1 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_REPIN_ESWAP_NO_SWAP_VALUE                 ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_REPIN_ESWAP_NO_SWAP_VALUE_RESET_VALUE     ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_REPIN_ESWAP_SWAP_VALUE                    ( 0x1 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_R0_RSRV_VALUE                             ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_R0_RSRV_VALUE_RESET_VALUE                 ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_MASK_ID_MASK_ID_VALUE                     ( 0xFF )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_MASK_ID_MASK_ID_VALUE_RESET_VALUE         ( 0xFF )


#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_OFFSET ( 0x00000004 )

#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_ADDRESS   	( UBUS_UBUS_SLAVE_BRDG_REG_ADDRESS + UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_OFFSET )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_READ( r ) 	READ_32( ( UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_ADDRESS ), (r) )
#define UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_WRITE( v )	WRITE_32( ( UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* dev_timeout */
	uint32_t dev_timeout   	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dev_timeout_en */
	uint32_t dev_timeout_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dev_error */
	uint32_t dev_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dev_clk_en */
	uint32_t dev_clken     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reqout_eswap */
	uint32_t reqout_eswap  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* repin_eswap */
	uint32_t repin_eswap   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r0            	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mask_id */
	uint32_t mask_id       	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL ;
#else
typedef struct
{	uint32_t mask_id       	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mask_id */
	uint32_t r0            	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t repin_eswap   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* repin_eswap */
	uint32_t reqout_eswap  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reqout_eswap */
	uint32_t dev_clken     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dev_clk_en */
	uint32_t dev_err       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dev_error */
	uint32_t dev_timeout_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dev_timeout_en */
	uint32_t dev_timeout   	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* dev_timeout */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL ;
#endif

/*****************************************************************************************/
/* HYST_CTRL                                                                             */
/* control the command / data queue full and empty indications.                          */
/*****************************************************************************************/

#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_R1_RSRV_VALUE                         ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_R1_RSRV_VALUE_RESET_VALUE             ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_SECLEV_EN_DISABLE_VALUE               ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_SECLEV_EN_DISABLE_VALUE_RESET_VALUE   ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_SECLEV_EN_ENABLE_VALUE                ( 0x1 )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_SECLEV_CFG_CFG_0_VALUE                ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_SECLEV_CFG_CFG_0_VALUE_RESET_VALUE    ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_SECLEV_CFG_CFG_1_VALUE                ( 0x1 )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_R0_RSRV_VALUE                         ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_R0_RSRV_VALUE_RESET_VALUE             ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_SECLEV_STRAP_SECLEV_VALUE             ( 0x0 )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_SECLEV_STRAP_SECLEV_VALUE_RESET_VALUE ( 0x0 )


#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_OFFSET ( 0x00000008 )

#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_ADDRESS   	( UBUS_UBUS_SLAVE_BRDG_REG_ADDRESS + UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_OFFSET )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_READ( r ) 	READ_32( ( UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_ADDRESS ), (r) )
#define UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_WRITE( v )	WRITE_32( ( UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1          	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* seclev_en */
	uint32_t seclev_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* seclev_config */
	uint32_t seclev_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r0          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* seclev_strap */
	uint32_t seclev_strap	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL ;
#else
typedef struct
{	uint32_t seclev_strap	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* seclev_strap */
	uint32_t r0          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t seclev_cfg  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* seclev_config */
	uint32_t seclev_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* seclev_en */
	uint32_t r1          	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL ;
#endif

/*****************************************************************************************/
/* GPHY_OUT                                                                              */
/* gphy registers output from CR to GPHY                                                 */
/*****************************************************************************************/

#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_R0_RSRV_VALUE                              ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_R0_RSRV_VALUE_RESET_VALUE                  ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_PHY_TEST_EN_REGULAR_MODE_VALUE             ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_PHY_TEST_EN_REGULAR_MODE_VALUE_RESET_VALUE ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_PHY_TEST_EN_TEST_MODE_VALUE                ( 0x1 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_PHYA_PHYA_VALUE                            ( 0x1 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_PHYA_PHYA_VALUE_RESET_VALUE                ( 0x1 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_GPHY_CK25_DIS_CK_25_DIS_VALUE              ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_GPHY_CK25_DIS_CK_25_DIS_VALUE_RESET_VALUE  ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_IDDQ_BIAS_IDDQ_BIAS_VALUE                  ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_IDDQ_BIAS_IDDQ_BIAS_VALUE_RESET_VALUE      ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_DLL_EN_DLL_EN_VALUE                        ( 0x1 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_DLL_EN_DLL_EN_VALUE_RESET_VALUE            ( 0x1 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_PWRDWN_EXT_PWRDWN_VALUE                    ( 0xF )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_PWRDWN_EXT_PWRDWN_VALUE_RESET_VALUE        ( 0xF )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_R1_GPHY_CK25_DIS_VALUE                     ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_R1_GPHY_CK25_DIS_VALUE_RESET_VALUE         ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_RST_RST_VALUE                              ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_RST_NOT_RST_VALUE                          ( 0x1 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_RST_NOT_RST_VALUE_RESET_VALUE              ( 0x1 )


#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_OFFSET ( 0x00000000 )

#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_ADDRESS   	( UBUS_UBUS_MISC_EGPHY_ADDRESS + UBUS_UBUS_MISC_EGPHY_GPHY_OUT_OFFSET )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_READ( r ) 	READ_32( ( UBUS_UBUS_MISC_EGPHY_GPHY_OUT_ADDRESS ), (r) )
#define UBUS_UBUS_MISC_EGPHY_GPHY_OUT_WRITE( v )	WRITE_32( ( UBUS_UBUS_MISC_EGPHY_GPHY_OUT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0           	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* phy_test_en */
	uint32_t phy_test_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* phya */
	uint32_t phya         	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gphy_ck25_disable */
	uint32_t gphy_ck25_dis	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* i_mac_gphy_cfg_iddq_bias */
	uint32_t iddq_bias    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* i_mac_gphy_cfg_ext_force_dll_en */
	uint32_t dll_en       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* i_mac_gphy_cfg_ext_pwrdown */
	uint32_t pwrdwn       	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r1           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* i_mac_gphy_cfg_reset_b */
	uint32_t rst          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY_GPHY_OUT ;
#else
typedef struct
{	uint32_t rst          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* i_mac_gphy_cfg_reset_b */
	uint32_t r1           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t pwrdwn       	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* i_mac_gphy_cfg_ext_pwrdown */
	uint32_t dll_en       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* i_mac_gphy_cfg_ext_force_dll_en */
	uint32_t iddq_bias    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* i_mac_gphy_cfg_iddq_bias */
	uint32_t gphy_ck25_dis	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gphy_ck25_disable */
	uint32_t phya         	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* phya */
	uint32_t phy_test_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* phy_test_en */
	uint32_t r0           	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY_GPHY_OUT ;
#endif

/*****************************************************************************************/
/* RGMII_OUT                                                                             */
/* RGMII registers output from CR to GPHY                                                */
/*****************************************************************************************/

#define UBUS_UBUS_MISC_EGPHY_RGMII_OUT_R0_RSRV_VALUE                        ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_RGMII_OUT_R0_RSRV_VALUE_RESET_VALUE            ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_RGMII_OUT_ID_MODE_ID_MODE_VALUE                ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_RGMII_OUT_ID_MODE_ID_MODE_VALUE_RESET_VALUE    ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_RGMII_OUT_REF_SEL_REFSEL_VALUE                 ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_RGMII_OUT_REF_SEL_REFSEL_VALUE_RESET_VALUE     ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_RGMII_OUT_PORT_MODE_PORTMODE_VALUE             ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_RGMII_OUT_PORT_MODE_PORTMODE_VALUE_RESET_VALUE ( 0x0 )


#define UBUS_UBUS_MISC_EGPHY_RGMII_OUT_OFFSET ( 0x00000004 )

#define UBUS_UBUS_MISC_EGPHY_RGMII_OUT_ADDRESS   	( UBUS_UBUS_MISC_EGPHY_ADDRESS + UBUS_UBUS_MISC_EGPHY_RGMII_OUT_OFFSET )
#define UBUS_UBUS_MISC_EGPHY_RGMII_OUT_READ( r ) 	READ_32( ( UBUS_UBUS_MISC_EGPHY_RGMII_OUT_ADDRESS ), (r) )
#define UBUS_UBUS_MISC_EGPHY_RGMII_OUT_WRITE( v )	WRITE_32( ( UBUS_UBUS_MISC_EGPHY_RGMII_OUT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0       	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* o_cfg_id_mode_disable */
	uint32_t id_mode  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* o_cfg_rvmii_ref_sel */
	uint32_t ref_sel  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* o_cfg_port_mode */
	uint32_t port_mode	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY_RGMII_OUT ;
#else
typedef struct
{	uint32_t port_mode	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* o_cfg_port_mode */
	uint32_t ref_sel  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* o_cfg_rvmii_ref_sel */
	uint32_t id_mode  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* o_cfg_id_mode_disable */
	uint32_t r0       	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY_RGMII_OUT ;
#endif

/*****************************************************************************************/
/* GPHY_IN                                                                               */
/* gphy inputs from GPHY block                                                           */
/*****************************************************************************************/

#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_LNKSPD_1_LNKSPD_1_VALUE                             ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_LNKSPD_1_LNKSPD_1_VALUE_RESET_VALUE                 ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_LNKSPD_2_LNKSPD_2_VALUE                             ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_LNKSPD_2_LNKSPD_2_VALUE_RESET_VALUE                 ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_LNKSPD_3_LNKSPD_3_VALUE                             ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_LNKSPD_3_LNKSPD_3_VALUE_RESET_VALUE                 ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_LNKSPD_4_LNKSPD_4_VALUE                             ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_LNKSPD_4_LNKSPD_4_VALUE_RESET_VALUE                 ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_FDXLED_N_FDXLED_N_VALUE                             ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_FDXLED_N_FDXLED_N_VALUE_RESET_VALUE                 ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_PAUSE_RES_TX_PAUSE_RES_TX_VALUE                     ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_PAUSE_RES_TX_PAUSE_RES_TX_VALUE_RESET_VALUE         ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_PAUSE_RES_RX_PAUSE_RES_RX_VALUE                     ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_PAUSE_RES_RX_PAUSE_RES_RX_VALUE_RESET_VALUE         ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_LOCK_RCVRY_CLK_LOCK_RCVRY_CLK_VALUE                 ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_LOCK_RCVRY_CLK_LOCK_RCVRY_CLK_VALUE_RESET_VALUE     ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_ENRGY_DET_MASKED_ENRGY_DET_MASKED_VALUE             ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_ENRGY_DET_MASKED_ENRGY_DET_MASKED_VALUE_RESET_VALUE ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_ENRGY_DET_APD_ENRGY_DET_APD_VALUE                   ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_ENRGY_DET_APD_ENRGY_DET_APD_VALUE_RESET_VALUE       ( 0x0 )


#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_OFFSET ( 0x00000008 )

#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_ADDRESS   	( UBUS_UBUS_MISC_EGPHY_ADDRESS + UBUS_UBUS_MISC_EGPHY_GPHY_IN_OFFSET )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_READ( r ) 	READ_32( ( UBUS_UBUS_MISC_EGPHY_GPHY_IN_ADDRESS ), (r) )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN_WRITE( v )	WRITE_32( ( UBUS_UBUS_MISC_EGPHY_GPHY_IN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* linkspd_n1 */
	uint32_t lnkspd_1        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* linkspd_n2 */
	uint32_t lnkspd_2        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* linkspd_n3 */
	uint32_t lnkspd_3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* linkspd_n4 */
	uint32_t lnkspd_4        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fdxled_n */
	uint32_t fdxled_n        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pause_resolution_tx */
	uint32_t pause_res_tx    	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pause_resolution_rx */
	uint32_t pause_res_rx    	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* lock_recovery_clock */
	uint32_t lock_rcvry_clk  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* energy_det_masked */
	uint32_t enrgy_det_masked	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* energy_det_apd */
	uint32_t enrgy_det_apd   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY_GPHY_IN ;
#else
typedef struct
{	uint32_t enrgy_det_apd   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* energy_det_apd */
	uint32_t enrgy_det_masked	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* energy_det_masked */
	uint32_t lock_rcvry_clk  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* lock_recovery_clock */
	uint32_t pause_res_rx    	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pause_resolution_rx */
	uint32_t pause_res_tx    	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pause_resolution_tx */
	uint32_t fdxled_n        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fdxled_n */
	uint32_t lnkspd_4        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* linkspd_n4 */
	uint32_t lnkspd_3        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* linkspd_n3 */
	uint32_t lnkspd_2        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* linkspd_n2 */
	uint32_t lnkspd_1        	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* linkspd_n1 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY_GPHY_IN ;
#endif

/*****************************************************************************************/
/* GPHY_IN_2                                                                             */
/* gphy inputs from GPHY block 2                                                         */
/*****************************************************************************************/

#define UBUS_UBUS_MISC_EGPHY_GPHY_IN2_R0_RSRV_VALUE                       ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN2_R0_RSRV_VALUE_RESET_VALUE           ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN2_PLL_LOCK_PLL_LOCK_VALUE             ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN2_PLL_LOCK_PLL_LOCK_VALUE_RESET_VALUE ( 0x0 )


#define UBUS_UBUS_MISC_EGPHY_GPHY_IN2_OFFSET ( 0x0000000C )

#define UBUS_UBUS_MISC_EGPHY_GPHY_IN2_ADDRESS   	( UBUS_UBUS_MISC_EGPHY_ADDRESS + UBUS_UBUS_MISC_EGPHY_GPHY_IN2_OFFSET )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN2_READ( r ) 	READ_32( ( UBUS_UBUS_MISC_EGPHY_GPHY_IN2_ADDRESS ), (r) )
#define UBUS_UBUS_MISC_EGPHY_GPHY_IN2_WRITE( v )	WRITE_32( ( UBUS_UBUS_MISC_EGPHY_GPHY_IN2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0      	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pll_freq_lock */
	uint32_t pll_lock	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY_GPHY_IN2 ;
#else
typedef struct
{	uint32_t pll_lock	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pll_freq_lock */
	uint32_t r0      	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY_GPHY_IN2 ;
#endif

/*****************************************************************************************/
/* ECO_REG_0_RST                                                                         */
/* ECO registers reset value is 0                                                        */
/*****************************************************************************************/

#define UBUS_UBUS_MISC_EGPHY_ECO_0_ECO_RST_0_PLL_LOCK_VALUE             ( 0x0 )
#define UBUS_UBUS_MISC_EGPHY_ECO_0_ECO_RST_0_PLL_LOCK_VALUE_RESET_VALUE ( 0x0 )


#define UBUS_UBUS_MISC_EGPHY_ECO_0_OFFSET ( 0x00000010 )

#define UBUS_UBUS_MISC_EGPHY_ECO_0_ADDRESS   	( UBUS_UBUS_MISC_EGPHY_ADDRESS + UBUS_UBUS_MISC_EGPHY_ECO_0_OFFSET )
#define UBUS_UBUS_MISC_EGPHY_ECO_0_READ( r ) 	READ_32( ( UBUS_UBUS_MISC_EGPHY_ECO_0_ADDRESS ), (r) )
#define UBUS_UBUS_MISC_EGPHY_ECO_0_WRITE( v )	WRITE_32( ( UBUS_UBUS_MISC_EGPHY_ECO_0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* eco_rst_0 */
	uint32_t eco_rst_0	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY_ECO_0 ;
#else
typedef struct
{	uint32_t eco_rst_0	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eco_rst_0 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY_ECO_0 ;
#endif

/*****************************************************************************************/
/* ECO_REG_1_RST                                                                         */
/* ECO registers reset value is 1                                                        */
/*****************************************************************************************/

#define UBUS_UBUS_MISC_EGPHY_ECO_1_ECO_RST_1_PLL_LOCK_VALUE             ( 0xFFFFFFFF )
#define UBUS_UBUS_MISC_EGPHY_ECO_1_ECO_RST_1_PLL_LOCK_VALUE_RESET_VALUE ( 0xFFFFFFFF )


#define UBUS_UBUS_MISC_EGPHY_ECO_1_OFFSET ( 0x00000014 )

#define UBUS_UBUS_MISC_EGPHY_ECO_1_ADDRESS   	( UBUS_UBUS_MISC_EGPHY_ADDRESS + UBUS_UBUS_MISC_EGPHY_ECO_1_OFFSET )
#define UBUS_UBUS_MISC_EGPHY_ECO_1_READ( r ) 	READ_32( ( UBUS_UBUS_MISC_EGPHY_ECO_1_ADDRESS ), (r) )
#define UBUS_UBUS_MISC_EGPHY_ECO_1_WRITE( v )	WRITE_32( ( UBUS_UBUS_MISC_EGPHY_ECO_1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* eco_regs_rst_1 */
	uint32_t eco_rst_1	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY_ECO_1 ;
#else
typedef struct
{	uint32_t eco_rst_1	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eco_regs_rst_1 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY_ECO_1 ;
#endif

typedef struct
{
	/* BRDG_EN */
	UBUS_UBUS_MASTER_BRDG_REG_EN en __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RQUSTOR_CTRL */
	UBUS_UBUS_MASTER_BRDG_REG_REQ_CNTRL req_cntrl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HYST_CTRL */
	UBUS_UBUS_MASTER_BRDG_REG_HYST_CTRL hyst_ctrl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* High_Priority */
	UBUS_UBUS_MASTER_BRDG_REG_HP hp __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* REPLY_ADDRESS */
	UBUS_UBUS_MASTER_BRDG_REG_REPLY_ADD reply_add __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* REPLY_DATA */
	UBUS_UBUS_MASTER_BRDG_REG_REPLY_DATA reply_data __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER_BRDG_REG ;

typedef struct
{
	/* BRDG_EN */
	UBUS_UBUS_SLAVE_BRDG_REG_EN en __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RESPONDER_CTRL */
	UBUS_UBUS_SLAVE_BRDG_REG_RES_CNTRL res_cntrl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HYST_CTRL */
	UBUS_UBUS_SLAVE_BRDG_REG_HYST_CTRL hyst_ctrl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_SLAVE_BRDG_REG ;

typedef struct
{
	/* GPHY_OUT */
	UBUS_UBUS_MISC_EGPHY_GPHY_OUT gphy_out __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RGMII_OUT */
	UBUS_UBUS_MISC_EGPHY_RGMII_OUT rgmii_out __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPHY_IN */
	UBUS_UBUS_MISC_EGPHY_GPHY_IN gphy_in __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPHY_IN_2 */
	UBUS_UBUS_MISC_EGPHY_GPHY_IN2 gphy_in2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ECO_REG_0_RST */
	UBUS_UBUS_MISC_EGPHY_ECO_0 eco_0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ECO_REG_1_RST */
	UBUS_UBUS_MISC_EGPHY_ECO_1 eco_1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC_EGPHY ;

typedef struct
{
	/* brdg_reg function */
	UBUS_UBUS_MASTER_BRDG_REG brdg_reg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MASTER ;

typedef struct
{
	/* brdg_reg function */
	UBUS_UBUS_SLAVE_BRDG_REG brdg_reg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_SLAVE ;

typedef struct
{
	/* egphy function */
	UBUS_UBUS_MISC_EGPHY egphy __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
UBUS_UBUS_MISC ;

#define UBUS_UBUS_MASTER_NUMBER ( 3 )
typedef struct
{
	/* UBUS_MASTER */
	UBUS_UBUS_MASTER ubus_master [ UBUS_UBUS_MASTER_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 3048 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UBUS_SLAVE */
	UBUS_UBUS_SLAVE ubus_slave __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 1012 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UBUS_MISC */
	UBUS_UBUS_MISC ubus_misc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__ 
UBUS_FOR_ALL ;
#endif /* UBUS_H_INCLUDED */

