/*
   Copyright (c) 2013 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2013:DUAL/GPL:standard

    Unless you and Broadcom execute a separate written software license
    agreement governing use of this software, this software is licensed
    to you under the terms of the GNU General Public License version 2
    (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
    with the following added to such license:
    
       As a special exception, the copyright holders of this software give
       you permission to link this software with independent modules, and
       to copy and distribute the resulting executable under terms of your
       choice, provided that you also meet, for each linked independent
       module, the terms and conditions of the license of that module.
       An independent module is a module which is not derived from this
       software.  The special exception does not apply to any modifications
       of the software.
    
    Not withstanding the above, under no circumstances may you combine
    this software in any way with any other Broadcom software provided
    under a license other than the GPL, without Broadcom's express prior
    written consent.
    
    :> 
*/             

#ifndef __RDP_BBH_H_INCLUDED
#define __RDP_BBH_H_INCLUDED

/*  File automatically generated by Reggae at 15/08/2013  10:54:27   */

#include "access_macros.h"
#include "packing.h"
#include "rdp_map.h"
/*****************************************************************************************/
/* The Broad-Bus Handler (BBH) purpose is to manage the interface between the Peripheral */
/* s (GPON, EPON and SGMII) and between the IH, the Runners, the SRAM/DDR DMA and the SR */
/* AM/DDR BPM in two levels: the physical level and the protocol level.   In the physica */
/* l level the BBH manages the interfaces both for the RX and TX units. It manages a FIF */
/* O based interface with the GPON, EPON or EMAC peripherals and the BB interface with t */
/* he IH, the Runners, the DDR/SRAM DMA and the DDR/SRAM BPM.    In the protocol level t */
/* he BBH manages the RX and TX protocol between the Peripheral and the IH, the Runners, */
/*  the DDR/SRAM DMA and the DDR/SRAM BPM.   On the RX side the BBH reads the data from  */
/* the peripherals FIFO and writes the packet header into the IH. After the IH header p */
/* rocessing it reassembles the incoming data in the DDR or in the SRAM, using their DMA */
/*  and writes a packet descriptor (in the Runner SRAM) for each Packet. It is also resp */
/* onsible of sending wakeup requests to the Runner for every PD it sends. It manages th */
/* e DDR/SRAM buffers, using the BPM  On the TX side it either gets an indication of the */
/*  TX FIFO capacity from the Peripheral (GPON) or gets a request for packet (EPON). The */
/* n it requests a PD from the Runner accordingly. For both EPON and GPON peripherals it */
/*  also manages a round-robin algorithm for the requests of the different queues. Accor */
/* ding to the Runner PD, the BBH will then read the data from the DDR or from the SRAM, */
/*  using their DMA. Upon reading the whole packet from the DDR, the BBH will release th */
/* e DDR/SRAM buffer, using the BPM.                                                     */
/*****************************************************************************************/

/*****************************************************************************************/
/* Blocks offsets                                                                        */
/*****************************************************************************************/
/*****************************************************************************************/
/* Functions offsets and addresses                                                       */
/*****************************************************************************************/
#define BBH_RX_0_GENERAL_CONFIGURATION_OFFSET 	( 0x00000000 )
#define BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS	( BBH_RX_0_OFFSET + BBH_RX_0_GENERAL_CONFIGURATION_OFFSET )

#define BBH_RX_0_PM_COUNTERS_OFFSET 	( 0x00000100 )
#define BBH_RX_0_PM_COUNTERS_ADDRESS	( BBH_RX_0_OFFSET + BBH_RX_0_PM_COUNTERS_OFFSET )

#define BBH_RX_0_DEBUG_OFFSET 	( 0x00000200 )
#define BBH_RX_0_DEBUG_ADDRESS	( BBH_RX_0_OFFSET + BBH_RX_0_DEBUG_OFFSET )

#define BBH_RX_0_PER_FLOW_PM_COUNTERS_OFFSET 	( 0x00000400 )
#define BBH_RX_0_PER_FLOW_PM_COUNTERS_ADDRESS	( BBH_RX_0_OFFSET + BBH_RX_0_PER_FLOW_PM_COUNTERS_OFFSET )

#define BBH_RX_1_GENERAL_CONFIGURATION_OFFSET 	( 0x00000000 )
#define BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS	( BBH_RX_1_OFFSET + BBH_RX_1_GENERAL_CONFIGURATION_OFFSET )

#define BBH_RX_1_PM_COUNTERS_OFFSET 	( 0x00000100 )
#define BBH_RX_1_PM_COUNTERS_ADDRESS	( BBH_RX_1_OFFSET + BBH_RX_1_PM_COUNTERS_OFFSET )

#define BBH_RX_1_DEBUG_OFFSET 	( 0x00000200 )
#define BBH_RX_1_DEBUG_ADDRESS	( BBH_RX_1_OFFSET + BBH_RX_1_DEBUG_OFFSET )

#define BBH_RX_1_PER_FLOW_PM_COUNTERS_OFFSET 	( 0x00000400 )
#define BBH_RX_1_PER_FLOW_PM_COUNTERS_ADDRESS	( BBH_RX_1_OFFSET + BBH_RX_1_PER_FLOW_PM_COUNTERS_OFFSET )

#define BBH_RX_2_GENERAL_CONFIGURATION_OFFSET 	( 0x00000000 )
#define BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS	( BBH_RX_2_OFFSET + BBH_RX_2_GENERAL_CONFIGURATION_OFFSET )

#define BBH_RX_2_PM_COUNTERS_OFFSET 	( 0x00000100 )
#define BBH_RX_2_PM_COUNTERS_ADDRESS	( BBH_RX_2_OFFSET + BBH_RX_2_PM_COUNTERS_OFFSET )

#define BBH_RX_2_DEBUG_OFFSET 	( 0x00000200 )
#define BBH_RX_2_DEBUG_ADDRESS	( BBH_RX_2_OFFSET + BBH_RX_2_DEBUG_OFFSET )

#define BBH_RX_2_PER_FLOW_PM_COUNTERS_OFFSET 	( 0x00000400 )
#define BBH_RX_2_PER_FLOW_PM_COUNTERS_ADDRESS	( BBH_RX_2_OFFSET + BBH_RX_2_PER_FLOW_PM_COUNTERS_OFFSET )

#define BBH_RX_3_GENERAL_CONFIGURATION_OFFSET 	( 0x00000000 )
#define BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS	( BBH_RX_3_OFFSET + BBH_RX_3_GENERAL_CONFIGURATION_OFFSET )

#define BBH_RX_3_PM_COUNTERS_OFFSET 	( 0x00000100 )
#define BBH_RX_3_PM_COUNTERS_ADDRESS	( BBH_RX_3_OFFSET + BBH_RX_3_PM_COUNTERS_OFFSET )

#define BBH_RX_3_DEBUG_OFFSET 	( 0x00000200 )
#define BBH_RX_3_DEBUG_ADDRESS	( BBH_RX_3_OFFSET + BBH_RX_3_DEBUG_OFFSET )

#define BBH_RX_3_PER_FLOW_PM_COUNTERS_OFFSET 	( 0x00000400 )
#define BBH_RX_3_PER_FLOW_PM_COUNTERS_ADDRESS	( BBH_RX_3_OFFSET + BBH_RX_3_PER_FLOW_PM_COUNTERS_OFFSET )

#define BBH_RX_4_GENERAL_CONFIGURATION_OFFSET 	( 0x00000000 )
#define BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS	( BBH_RX_4_OFFSET + BBH_RX_4_GENERAL_CONFIGURATION_OFFSET )

#define BBH_RX_4_PM_COUNTERS_OFFSET 	( 0x00000100 )
#define BBH_RX_4_PM_COUNTERS_ADDRESS	( BBH_RX_4_OFFSET + BBH_RX_4_PM_COUNTERS_OFFSET )

#define BBH_RX_4_DEBUG_OFFSET 	( 0x00000200 )
#define BBH_RX_4_DEBUG_ADDRESS	( BBH_RX_4_OFFSET + BBH_RX_4_DEBUG_OFFSET )

#define BBH_RX_4_PER_FLOW_PM_COUNTERS_OFFSET 	( 0x00000400 )
#define BBH_RX_4_PER_FLOW_PM_COUNTERS_ADDRESS	( BBH_RX_4_OFFSET + BBH_RX_4_PER_FLOW_PM_COUNTERS_OFFSET )

#define BBH_RX_5_GENERAL_CONFIGURATION_OFFSET 	( 0x00000000 )
#define BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS	( BBH_RX_5_OFFSET + BBH_RX_5_GENERAL_CONFIGURATION_OFFSET )

#define BBH_RX_5_PM_COUNTERS_OFFSET 	( 0x00000100 )
#define BBH_RX_5_PM_COUNTERS_ADDRESS	( BBH_RX_5_OFFSET + BBH_RX_5_PM_COUNTERS_OFFSET )

#define BBH_RX_5_DEBUG_OFFSET 	( 0x00000200 )
#define BBH_RX_5_DEBUG_ADDRESS	( BBH_RX_5_OFFSET + BBH_RX_5_DEBUG_OFFSET )

#define BBH_RX_5_PER_FLOW_PM_COUNTERS_OFFSET 	( 0x00000400 )
#define BBH_RX_5_PER_FLOW_PM_COUNTERS_ADDRESS	( BBH_RX_5_OFFSET + BBH_RX_5_PER_FLOW_PM_COUNTERS_OFFSET )

#define BBH_RX_6_GENERAL_CONFIGURATION_OFFSET 	( 0x00000000 )
#define BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS	( BBH_RX_6_OFFSET + BBH_RX_6_GENERAL_CONFIGURATION_OFFSET )

#define BBH_RX_6_PM_COUNTERS_OFFSET 	( 0x00000100 )
#define BBH_RX_6_PM_COUNTERS_ADDRESS	( BBH_RX_6_OFFSET + BBH_RX_6_PM_COUNTERS_OFFSET )

#define BBH_RX_6_DEBUG_OFFSET 	( 0x00000200 )
#define BBH_RX_6_DEBUG_ADDRESS	( BBH_RX_6_OFFSET + BBH_RX_6_DEBUG_OFFSET )

#define BBH_RX_6_PER_FLOW_PM_COUNTERS_OFFSET 	( 0x00000400 )
#define BBH_RX_6_PER_FLOW_PM_COUNTERS_ADDRESS	( BBH_RX_6_OFFSET + BBH_RX_6_PER_FLOW_PM_COUNTERS_OFFSET )

#define BBH_TX_0_CONFIGURATIONS_OFFSET 	( 0x00000000 )
#define BBH_TX_0_CONFIGURATIONS_ADDRESS	( BBH_TX_0_OFFSET + BBH_TX_0_CONFIGURATIONS_OFFSET )

#define BBH_TX_0_DEBUG_OFFSET 	( 0x00000100 )
#define BBH_TX_0_DEBUG_ADDRESS	( BBH_TX_0_OFFSET + BBH_TX_0_DEBUG_OFFSET )

#define BBH_TX_0_PD_FIFO_OFFSET 	( 0x00000200 )
#define BBH_TX_0_PD_FIFO_ADDRESS	( BBH_TX_0_OFFSET + BBH_TX_0_PD_FIFO_OFFSET )

#define BBH_TX_0_CONTEXT_OFFSET 	( 0x00000600 )
#define BBH_TX_0_CONTEXT_ADDRESS	( BBH_TX_0_OFFSET + BBH_TX_0_CONTEXT_OFFSET )

#define BBH_TX_0_EPON_PD_FIFO_OFFSET 	( 0x00000700 )
#define BBH_TX_0_EPON_PD_FIFO_ADDRESS	( BBH_TX_0_OFFSET + BBH_TX_0_EPON_PD_FIFO_OFFSET )

#define BBH_TX_0_EPON_CFG_OFFSET 	( 0x00001000 )
#define BBH_TX_0_EPON_CFG_ADDRESS	( BBH_TX_0_OFFSET + BBH_TX_0_EPON_CFG_OFFSET )

#define BBH_TX_0_EPON_DBG_OFFSET 	( 0x00001100 )
#define BBH_TX_0_EPON_DBG_ADDRESS	( BBH_TX_0_OFFSET + BBH_TX_0_EPON_DBG_OFFSET )

#define BBH_TX_0_EPON_STS_FIFO_OFFSET 	( 0x00001700 )
#define BBH_TX_0_EPON_STS_FIFO_ADDRESS	( BBH_TX_0_OFFSET + BBH_TX_0_EPON_STS_FIFO_OFFSET )

#define BBH_TX_1_CONFIGURATIONS_OFFSET 	( 0x00000000 )
#define BBH_TX_1_CONFIGURATIONS_ADDRESS	( BBH_TX_1_OFFSET + BBH_TX_1_CONFIGURATIONS_OFFSET )

#define BBH_TX_1_DEBUG_OFFSET 	( 0x00000100 )
#define BBH_TX_1_DEBUG_ADDRESS	( BBH_TX_1_OFFSET + BBH_TX_1_DEBUG_OFFSET )

#define BBH_TX_1_PD_FIFO_OFFSET 	( 0x00000200 )
#define BBH_TX_1_PD_FIFO_ADDRESS	( BBH_TX_1_OFFSET + BBH_TX_1_PD_FIFO_OFFSET )

#define BBH_TX_1_CONTEXT_OFFSET 	( 0x00000600 )
#define BBH_TX_1_CONTEXT_ADDRESS	( BBH_TX_1_OFFSET + BBH_TX_1_CONTEXT_OFFSET )

#define BBH_TX_1_EPON_PD_FIFO_OFFSET 	( 0x00000700 )
#define BBH_TX_1_EPON_PD_FIFO_ADDRESS	( BBH_TX_1_OFFSET + BBH_TX_1_EPON_PD_FIFO_OFFSET )

#define BBH_TX_1_EPON_CFG_OFFSET 	( 0x00001000 )
#define BBH_TX_1_EPON_CFG_ADDRESS	( BBH_TX_1_OFFSET + BBH_TX_1_EPON_CFG_OFFSET )

#define BBH_TX_1_EPON_DBG_OFFSET 	( 0x00001100 )
#define BBH_TX_1_EPON_DBG_ADDRESS	( BBH_TX_1_OFFSET + BBH_TX_1_EPON_DBG_OFFSET )

#define BBH_TX_1_EPON_STS_FIFO_OFFSET 	( 0x00001700 )
#define BBH_TX_1_EPON_STS_FIFO_ADDRESS	( BBH_TX_1_OFFSET + BBH_TX_1_EPON_STS_FIFO_OFFSET )

#define BBH_TX_2_CONFIGURATIONS_OFFSET 	( 0x00000000 )
#define BBH_TX_2_CONFIGURATIONS_ADDRESS	( BBH_TX_2_OFFSET + BBH_TX_2_CONFIGURATIONS_OFFSET )

#define BBH_TX_2_DEBUG_OFFSET 	( 0x00000100 )
#define BBH_TX_2_DEBUG_ADDRESS	( BBH_TX_2_OFFSET + BBH_TX_2_DEBUG_OFFSET )

#define BBH_TX_2_PD_FIFO_OFFSET 	( 0x00000200 )
#define BBH_TX_2_PD_FIFO_ADDRESS	( BBH_TX_2_OFFSET + BBH_TX_2_PD_FIFO_OFFSET )

#define BBH_TX_2_CONTEXT_OFFSET 	( 0x00000600 )
#define BBH_TX_2_CONTEXT_ADDRESS	( BBH_TX_2_OFFSET + BBH_TX_2_CONTEXT_OFFSET )

#define BBH_TX_2_EPON_PD_FIFO_OFFSET 	( 0x00000700 )
#define BBH_TX_2_EPON_PD_FIFO_ADDRESS	( BBH_TX_2_OFFSET + BBH_TX_2_EPON_PD_FIFO_OFFSET )

#define BBH_TX_2_EPON_CFG_OFFSET 	( 0x00001000 )
#define BBH_TX_2_EPON_CFG_ADDRESS	( BBH_TX_2_OFFSET + BBH_TX_2_EPON_CFG_OFFSET )

#define BBH_TX_2_EPON_DBG_OFFSET 	( 0x00001100 )
#define BBH_TX_2_EPON_DBG_ADDRESS	( BBH_TX_2_OFFSET + BBH_TX_2_EPON_DBG_OFFSET )

#define BBH_TX_2_EPON_STS_FIFO_OFFSET 	( 0x00001700 )
#define BBH_TX_2_EPON_STS_FIFO_ADDRESS	( BBH_TX_2_OFFSET + BBH_TX_2_EPON_STS_FIFO_OFFSET )

#define BBH_TX_3_CONFIGURATIONS_OFFSET 	( 0x00000000 )
#define BBH_TX_3_CONFIGURATIONS_ADDRESS	( BBH_TX_3_OFFSET + BBH_TX_3_CONFIGURATIONS_OFFSET )

#define BBH_TX_3_DEBUG_OFFSET 	( 0x00000100 )
#define BBH_TX_3_DEBUG_ADDRESS	( BBH_TX_3_OFFSET + BBH_TX_3_DEBUG_OFFSET )

#define BBH_TX_3_PD_FIFO_OFFSET 	( 0x00000200 )
#define BBH_TX_3_PD_FIFO_ADDRESS	( BBH_TX_3_OFFSET + BBH_TX_3_PD_FIFO_OFFSET )

#define BBH_TX_3_CONTEXT_OFFSET 	( 0x00000600 )
#define BBH_TX_3_CONTEXT_ADDRESS	( BBH_TX_3_OFFSET + BBH_TX_3_CONTEXT_OFFSET )

#define BBH_TX_3_EPON_PD_FIFO_OFFSET 	( 0x00000700 )
#define BBH_TX_3_EPON_PD_FIFO_ADDRESS	( BBH_TX_3_OFFSET + BBH_TX_3_EPON_PD_FIFO_OFFSET )

#define BBH_TX_3_EPON_CFG_OFFSET 	( 0x00001000 )
#define BBH_TX_3_EPON_CFG_ADDRESS	( BBH_TX_3_OFFSET + BBH_TX_3_EPON_CFG_OFFSET )

#define BBH_TX_3_EPON_DBG_OFFSET 	( 0x00001100 )
#define BBH_TX_3_EPON_DBG_ADDRESS	( BBH_TX_3_OFFSET + BBH_TX_3_EPON_DBG_OFFSET )

#define BBH_TX_3_EPON_STS_FIFO_OFFSET 	( 0x00001700 )
#define BBH_TX_3_EPON_STS_FIFO_ADDRESS	( BBH_TX_3_OFFSET + BBH_TX_3_EPON_STS_FIFO_OFFSET )

#define BBH_TX_4_CONFIGURATIONS_OFFSET 	( 0x00000000 )
#define BBH_TX_4_CONFIGURATIONS_ADDRESS	( BBH_TX_4_OFFSET + BBH_TX_4_CONFIGURATIONS_OFFSET )

#define BBH_TX_4_DEBUG_OFFSET 	( 0x00000100 )
#define BBH_TX_4_DEBUG_ADDRESS	( BBH_TX_4_OFFSET + BBH_TX_4_DEBUG_OFFSET )

#define BBH_TX_4_PD_FIFO_OFFSET 	( 0x00000200 )
#define BBH_TX_4_PD_FIFO_ADDRESS	( BBH_TX_4_OFFSET + BBH_TX_4_PD_FIFO_OFFSET )

#define BBH_TX_4_CONTEXT_OFFSET 	( 0x00000600 )
#define BBH_TX_4_CONTEXT_ADDRESS	( BBH_TX_4_OFFSET + BBH_TX_4_CONTEXT_OFFSET )

#define BBH_TX_4_EPON_PD_FIFO_OFFSET 	( 0x00000700 )
#define BBH_TX_4_EPON_PD_FIFO_ADDRESS	( BBH_TX_4_OFFSET + BBH_TX_4_EPON_PD_FIFO_OFFSET )

#define BBH_TX_4_EPON_CFG_OFFSET 	( 0x00001000 )
#define BBH_TX_4_EPON_CFG_ADDRESS	( BBH_TX_4_OFFSET + BBH_TX_4_EPON_CFG_OFFSET )

#define BBH_TX_4_EPON_DBG_OFFSET 	( 0x00001100 )
#define BBH_TX_4_EPON_DBG_ADDRESS	( BBH_TX_4_OFFSET + BBH_TX_4_EPON_DBG_OFFSET )

#define BBH_TX_4_EPON_STS_FIFO_OFFSET 	( 0x00001700 )
#define BBH_TX_4_EPON_STS_FIFO_ADDRESS	( BBH_TX_4_OFFSET + BBH_TX_4_EPON_STS_FIFO_OFFSET )

#define BBH_TX_5_CONFIGURATIONS_OFFSET 	( 0x00000000 )
#define BBH_TX_5_CONFIGURATIONS_ADDRESS	( BBH_TX_5_OFFSET + BBH_TX_5_CONFIGURATIONS_OFFSET )

#define BBH_TX_5_DEBUG_OFFSET 	( 0x00000100 )
#define BBH_TX_5_DEBUG_ADDRESS	( BBH_TX_5_OFFSET + BBH_TX_5_DEBUG_OFFSET )

#define BBH_TX_5_PD_FIFO_OFFSET 	( 0x00000200 )
#define BBH_TX_5_PD_FIFO_ADDRESS	( BBH_TX_5_OFFSET + BBH_TX_5_PD_FIFO_OFFSET )

#define BBH_TX_5_CONTEXT_OFFSET 	( 0x00000600 )
#define BBH_TX_5_CONTEXT_ADDRESS	( BBH_TX_5_OFFSET + BBH_TX_5_CONTEXT_OFFSET )

#define BBH_TX_5_EPON_PD_FIFO_OFFSET 	( 0x00000700 )
#define BBH_TX_5_EPON_PD_FIFO_ADDRESS	( BBH_TX_5_OFFSET + BBH_TX_5_EPON_PD_FIFO_OFFSET )

#define BBH_TX_5_EPON_CFG_OFFSET 	( 0x00001000 )
#define BBH_TX_5_EPON_CFG_ADDRESS	( BBH_TX_5_OFFSET + BBH_TX_5_EPON_CFG_OFFSET )

#define BBH_TX_5_EPON_DBG_OFFSET 	( 0x00001100 )
#define BBH_TX_5_EPON_DBG_ADDRESS	( BBH_TX_5_OFFSET + BBH_TX_5_EPON_DBG_OFFSET )

#define BBH_TX_5_EPON_STS_FIFO_OFFSET 	( 0x00001700 )
#define BBH_TX_5_EPON_STS_FIFO_ADDRESS	( BBH_TX_5_OFFSET + BBH_TX_5_EPON_STS_FIFO_OFFSET )

#define BBH_TX_6_CONFIGURATIONS_OFFSET 	( 0x00000000 )
#define BBH_TX_6_CONFIGURATIONS_ADDRESS	( BBH_TX_6_OFFSET + BBH_TX_6_CONFIGURATIONS_OFFSET )

#define BBH_TX_6_DEBUG_OFFSET 	( 0x00000100 )
#define BBH_TX_6_DEBUG_ADDRESS	( BBH_TX_6_OFFSET + BBH_TX_6_DEBUG_OFFSET )

#define BBH_TX_6_PD_FIFO_OFFSET 	( 0x00000200 )
#define BBH_TX_6_PD_FIFO_ADDRESS	( BBH_TX_6_OFFSET + BBH_TX_6_PD_FIFO_OFFSET )

#define BBH_TX_6_CONTEXT_OFFSET 	( 0x00000600 )
#define BBH_TX_6_CONTEXT_ADDRESS	( BBH_TX_6_OFFSET + BBH_TX_6_CONTEXT_OFFSET )

#define BBH_TX_6_EPON_PD_FIFO_OFFSET 	( 0x00000700 )
#define BBH_TX_6_EPON_PD_FIFO_ADDRESS	( BBH_TX_6_OFFSET + BBH_TX_6_EPON_PD_FIFO_OFFSET )

#define BBH_TX_6_EPON_CFG_OFFSET 	( 0x00001000 )
#define BBH_TX_6_EPON_CFG_ADDRESS	( BBH_TX_6_OFFSET + BBH_TX_6_EPON_CFG_OFFSET )

#define BBH_TX_6_EPON_DBG_OFFSET 	( 0x00001100 )
#define BBH_TX_6_EPON_DBG_ADDRESS	( BBH_TX_6_OFFSET + BBH_TX_6_EPON_DBG_OFFSET )

#define BBH_TX_6_EPON_STS_FIFO_OFFSET 	( 0x00001700 )
#define BBH_TX_6_EPON_STS_FIFO_ADDRESS	( BBH_TX_6_OFFSET + BBH_TX_6_EPON_STS_FIFO_OFFSET )

/*   'd' is module index   */
/*   'i' is block index    */
/*   'j' is function index */
/*   'e' is function entry */
/*   'k' is register index */

/*****************************************************************************************/
/* Broad-Bus_configuration                                                               */
/* Each BBH unit has its own position on the BB tree. This position defines the Route ad */
/* dress when approaching the Runner, S/DMA, S/BPM and IH.                               */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_R4_DEFAULT_VALUE                       ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_R4_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_BPMROUTE_DEFAULT_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_BPMROUTE_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_R3_DEFAULT_VALUE                       ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_R3_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_DMAROUTE_DEFAULT_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_DMAROUTE_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_R2_DEFAULT_VALUE                       ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_R2_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_RUNNER1ROUTE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_RUNNER1ROUTE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_R1_DEFAULT_VALUE                       ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_R1_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_RUNNER0ROUTE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_RUNNER0ROUTE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_OFFSET ( 0x00000000 )

#define BBH_RX_0_GENERAL_CONFIGURATION_BBCFG_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_BBCFG_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_BBCFG_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_BBCFG_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_BBCFG_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_BBCFG_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_BBCFG_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_BBCFG_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_BBCFG_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_BBCFG_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_BBCFG_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_BBCFG_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_BBCFG_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_BBCFG_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_BBCFG_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_BBCFG_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_BBCFG_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_BBCFG_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_BBCFG_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_BBCFG_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_BBCFG_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_BBCFG_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_BBCFG_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_BBCFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_route */
	uint32_t bpmroute    	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_route */
	uint32_t dmaroute    	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner1_route */
	uint32_t runner1route	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner0_route */
	uint32_t runner0route	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_BBCFG ;
#else
typedef struct
{	uint32_t runner0route	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner0_route */
	uint32_t r1          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t runner1route	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner1_route */
	uint32_t r2          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t dmaroute    	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_route */
	uint32_t r3          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t bpmroute    	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_route */
	uint32_t r4          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_BBCFG ;
#endif

/*****************************************************************************************/
/* Broad-Bus_configuration                                                               */
/* Each BBH unit has its own position on the BB tree. This position defines the Route ad */
/* dress when approaching the Runner, S/DMA, S/BPM and IH.                               */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_R4_DEFAULT_VALUE                    ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_R4_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_SBPMROUTE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_SBPMROUTE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_R3_DEFAULT_VALUE                    ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_R3_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_SDMAROUTE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_SDMAROUTE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_R2_DEFAULT_VALUE                    ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_R2_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_IHROUTE_DEFAULT_VALUE               ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_IHROUTE_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_R1_DEFAULT_VALUE                    ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_OFFSET ( 0x00000004 )

#define BBH_RX_0_GENERAL_CONFIGURATION_BBCFG1_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG1_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_BBCFG1_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_BBCFG1_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_BBCFG1_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG1_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_BBCFG1_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_BBCFG1_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_BBCFG1_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG1_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_BBCFG1_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_BBCFG1_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_BBCFG1_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG1_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_BBCFG1_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_BBCFG1_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_BBCFG1_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG1_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_BBCFG1_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_BBCFG1_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_BBCFG1_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG1_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_BBCFG1_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_BBCFG1_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_BBCFG1_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG1_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_BBCFG1_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_BBCFG1_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_BBCFG1_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_BBCFG1_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_BBCFG1_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_BBCFG1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_route */
	uint32_t sbpmroute	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA_route */
	uint32_t sdmaroute	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_route */
	uint32_t ihroute  	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1       	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_BBCFG1 ;
#else
typedef struct
{	uint32_t r1       	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t ihroute  	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_route */
	uint32_t r2       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t sdmaroute	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA_route */
	uint32_t r3       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t sbpmroute	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_route */
	uint32_t r4       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_BBCFG1 ;
#endif

/*****************************************************************************************/
/* DDR_configuration                                                                     */
/* The BBH reassembles the incoming data in the DDR. The data is stored in a fixed buffe */
/* rs structure.   This register defines the DDR buffer size and the TM base address in  */
/* the DDR.                                                                              */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_DDRTMBASE_DDRTMBASE_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_DDRTMBASE_DDRTMBASE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_R2_DEFAULT_VALUE                      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_R2_DEFAULT_VALUE_RESET_VALUE          ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_BUFSIZE_BUF2K_VALUE                   ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_BUFSIZE_BUF2K_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_BUFSIZE_BUF4K_VALUE                   ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_BUFSIZE_BUF16K_VALUE                  ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_BUFSIZE_R_VALUE                       ( 0x3 )
#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_BPMMSG_14_BIT_BN_WIDTH_VALUE          ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_BPMMSG_15_BIT_BN_WIDTH_VALUE          ( 0x1 )


#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_OFFSET ( 0x00000008 )

#define BBH_RX_0_GENERAL_CONFIGURATION_DDRCFG_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DDRCFG_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_DDRCFG_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_DDRCFG_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_DDRCFG_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DDRCFG_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_DDRCFG_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_DDRCFG_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_DDRCFG_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DDRCFG_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_DDRCFG_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_DDRCFG_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_DDRCFG_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DDRCFG_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_DDRCFG_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_DDRCFG_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_DDRCFG_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DDRCFG_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_DDRCFG_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_DDRCFG_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_DDRCFG_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DDRCFG_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_DDRCFG_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_DDRCFG_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_DDRCFG_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DDRCFG_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_DDRCFG_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_DDRCFG_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_DDRCFG_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_DDRCFG_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_DDRCFG_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_DDRCFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DDRTMBASE */
	uint32_t ddrtmbase	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	uint32_t bpmmsg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_buffer_size */
	uint32_t bufsize  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_DDRCFG ;
#else
typedef struct
{	uint32_t bufsize  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	uint32_t bpmmsg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	/* DDR_buffer_size */
	uint32_t r2       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t ddrtmbase	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDRTMBASE */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_DDRCFG ;
#endif

/*****************************************************************************************/
/* Runner_PD_base_address                                                                */
/* For every reassembled packet in the DDR the BBH writes a packet descriptor (PD) into  */
/* the Runner. The PDs are arranged in a predefined address space in the Runner SRAM and */
/*  managed in a cyclic FIFO style.   This register defines the base address of this cyc */
/* lic FIFO.                                                                             */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_PDBASE_DIRECT_PDBASE_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PDBASE_DIRECT_PDBASE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PDBASE_NORMAL_PDBASE_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PDBASE_NORMAL_PDBASE_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_PDBASE_OFFSET ( 0x0000000C )

#define BBH_RX_0_GENERAL_CONFIGURATION_PDBASE_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDBASE_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_PDBASE_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_PDBASE_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_PDBASE_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDBASE_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_PDBASE_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_PDBASE_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_PDBASE_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDBASE_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_PDBASE_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_PDBASE_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_PDBASE_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDBASE_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_PDBASE_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_PDBASE_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_PDBASE_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDBASE_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_PDBASE_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_PDBASE_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_PDBASE_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDBASE_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_PDBASE_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_PDBASE_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_PDBASE_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDBASE_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_PDBASE_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_PDBASE_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_PDBASE_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_PDBASE_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_PDBASE_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_PDBASE_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_PDBASE_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PD_base_address_for_direct_queue */
	uint32_t direct	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_base_address_for_normal_queue */
	uint32_t normal	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_PDBASE ;
#else
typedef struct
{	uint32_t normal	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_base_address_for_normal_queue */
	uint32_t direct	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_base_address_for_direct_queue */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_PDBASE ;
#endif

/*****************************************************************************************/
/* Ruuner_PD_size                                                                        */
/* For every reassembled packet in the DDR the BBH writes a packet descriptor (PD) into  */
/* the Runner. The PDs are arranged in a predefined address space in the Runner SRAM and */
/*  managed in a cyclic FIFO style.   This register defines the size of this cyclic FIFO */
/* .                                                                                     */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_R2_DEFAULT_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_R2_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_DIRECT_MIN_VALUE_VALUE           ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_DIRECT_DEFAULT_VALUE             ( 0x20 )
#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_DIRECT_DEFAULT_VALUE_RESET_VALUE ( 0x20 )
#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_DIRECT_MAX_VALUE_VALUE           ( 0x40 )
#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_R1_DEFAULT_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_R1_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_NORMAL_MIN_VALUE_VALUE           ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_NORMAL_DEFAULT_VALUE             ( 0x20 )
#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_NORMAL_DEFAULT_VALUE_RESET_VALUE ( 0x20 )
#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_NORMAL_MAX_VALUE_VALUE           ( 0x40 )


#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_OFFSET ( 0x00000010 )

#define BBH_RX_0_GENERAL_CONFIGURATION_PDSIZE_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDSIZE_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_PDSIZE_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_PDSIZE_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_PDSIZE_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDSIZE_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_PDSIZE_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_PDSIZE_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_PDSIZE_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDSIZE_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_PDSIZE_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_PDSIZE_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_PDSIZE_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDSIZE_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_PDSIZE_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_PDSIZE_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_PDSIZE_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDSIZE_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_PDSIZE_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_PDSIZE_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_PDSIZE_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDSIZE_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_PDSIZE_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_PDSIZE_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_PDSIZE_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDSIZE_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_PDSIZE_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_PDSIZE_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_PDSIZE_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_PDSIZE_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_PDSIZE_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_PDSIZE_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2    	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_Of_PDs_for_direct_queue */
	uint32_t direct	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1    	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_Of_PDs_for_normal_queue */
	uint32_t normal	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_PDSIZE ;
#else
typedef struct
{	uint32_t normal	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_Of_PDs_for_normal_queue */
	uint32_t r1    	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t direct	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_Of_PDs_for_direct_queue */
	uint32_t r2    	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_PDSIZE ;
#endif

/*****************************************************************************************/
/* Runner_task                                                                           */
/* For every reassembled packet in the DDR the BBH writes a packet descriptor (PD) into  */
/* the Runner. The PDs are arranged in a predefined address space in the Runner SRAM and */
/*  managed in a cyclic FIFO style.   For every PD written into the Runner, the BBH wake */
/* s the relevantThread. This register defines the Runner thread number for both Runners */
/*  and both queues (normal or direct).                                                  */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_R4_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_R4_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_DIRECT1_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_DIRECT1_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_R3_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_R3_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_NORMAL1_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_NORMAL1_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_R2_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_R2_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_DIRECT0_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_DIRECT0_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_R1_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_NORMAL0_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_NORMAL0_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_OFFSET ( 0x00000014 )

#define BBH_RX_0_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_RUNNERTASK_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_RUNNERTASK_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_RUNNERTASK_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_RUNNERTASK_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_RUNNERTASK_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_RUNNERTASK_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_RUNNERTASK_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_RUNNERTASK_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_RUNNERTASK_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_RUNNERTASK_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_RUNNERTASK_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_RUNNERTASK_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_RUNNERTASK_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_RUNNERTASK_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Direct_1_thread */
	uint32_t direct1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_1_thread */
	uint32_t normal1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Direct_0_thread */
	uint32_t direct0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_0_thread */
	uint32_t normal0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK ;
#else
typedef struct
{	uint32_t normal0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_0_thread */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t direct0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Direct_0_thread */
	uint32_t r2     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t normal1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Normal_1_thread */
	uint32_t r3     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t direct1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Direct_1_thread */
	uint32_t r4     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK ;
#endif

/*****************************************************************************************/
/* DMA_address_configuration                                                             */
/* The BBH reassembles the incoming data in the DDR. The Data is written into the DDR us */
/* ing the DMA. The data is organized in a configurable number of chunks of 128 bytes.   */
/* The BBH arranges the written data in the DMA in these chunks. It arranges the data in */
/*  a predefined address space in the DMA memory and manages the chunks in a cyclic FIFO */
/*  style.  For every write chunk the BBH writes a write descriptor. The write descripto */
/* rs are arranged in a predefined space in the DMA memory and managed in a cyclic FIFO  */
/* style as well.  This register defines the Data and descriptors base addresses.        */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_DMAADDR_R2_DEFAULT_VALUE                    ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DMAADDR_R2_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DMAADDR_DESCBASE_BASEADDR_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DMAADDR_DESCBASE_BASEADDR_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DMAADDR_R1_DEFAULT_VALUE                    ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DMAADDR_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DMAADDR_DATABASE_BASEADDR_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DMAADDR_DATABASE_BASEADDR_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_DMAADDR_OFFSET ( 0x00000018 )

#define BBH_RX_0_GENERAL_CONFIGURATION_DMAADDR_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMAADDR_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_DMAADDR_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_DMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_DMAADDR_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMAADDR_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_DMAADDR_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_DMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_DMAADDR_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMAADDR_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_DMAADDR_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_DMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_DMAADDR_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMAADDR_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_DMAADDR_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_DMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_DMAADDR_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMAADDR_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_DMAADDR_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_DMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_DMAADDR_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMAADDR_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_DMAADDR_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_DMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_DMAADDR_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMAADDR_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_DMAADDR_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_DMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_DMAADDR_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_DMAADDR_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_DMAADDR_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_DMAADDR_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_DMAADDR_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2      	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Descriptor_base_address */
	uint32_t descbase	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Data_base_address */
	uint32_t database	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_DMAADDR ;
#else
typedef struct
{	uint32_t database	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Data_base_address */
	uint32_t r1      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t descbase	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Descriptor_base_address */
	uint32_t r2      	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_DMAADDR ;
#endif

/*****************************************************************************************/
/* DMA_configuration                                                                     */
/* The BBH reassembles the incoming data in the DDR. The Data is written into the DDR us */
/* ing the DMA. The data is organized in a configurable number of chunks of 128 bytes.   */
/* The BBH arranges the written data in the DMA in these chunks. It arranges the data in */
/*  a predefined address space in the DMA memory and manages the chunks in a cyclic FIFO */
/*  style.  For every write chunk the BBH writes a write descriptor. The write descripto */
/* rs are arranged in a predefined space in the DMA memory and managed in a cyclic FIFO  */
/* style as well.    The BBH handles the congestion over the DMA write chunks according  */
/* to 2 priorities (low + high, exclusive). This field defines the number of occupied wr */
/* ite chunks for dropping normal or high priority packets. If the number of occupied ch */
/* unk is lower than this threshold, then all packets are passed. If the number of occup */
/* ied chunk is equal or higher than this threshold, then only exclusive priority packet */
/* s are passed.    This register defines the Data and descriptors FIFO sizes and the ex */
/* clusive threshold.                                                                    */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_R2_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_R2_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_EXCLTH_MIN_VALUE_VALUE            ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_EXCLTH_DEFAULT_VALUE              ( 0x8 )
#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_EXCLTH_DEFAULT_VALUE_RESET_VALUE  ( 0x8 )
#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_EXCLTH_MAX_VALUE_VALUE            ( 0x40 )
#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_R1_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_NUMOFCD_MIN_VALUE_VALUE           ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_NUMOFCD_DEFAULT_VALUE             ( 0x10 )
#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_NUMOFCD_DEFAULT_VALUE_RESET_VALUE ( 0x10 )
#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_NUMOFCD_MAX_VALUE_VALUE           ( 0x40 )


#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_OFFSET ( 0x0000001C )

#define BBH_RX_0_GENERAL_CONFIGURATION_DMACFG_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMACFG_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_DMACFG_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_DMACFG_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_DMACFG_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMACFG_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_DMACFG_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_DMACFG_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_DMACFG_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMACFG_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_DMACFG_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_DMACFG_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_DMACFG_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMACFG_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_DMACFG_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_DMACFG_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_DMACFG_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMACFG_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_DMACFG_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_DMACFG_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_DMACFG_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMACFG_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_DMACFG_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_DMACFG_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_DMACFG_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMACFG_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_DMACFG_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_DMACFG_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_DMACFG_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_DMACFG_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_DMACFG_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_DMACFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2     	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Exclusive_threshold */
	uint32_t exclth 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_of_Chunk-Descriptors */
	uint32_t numofcd	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_DMACFG ;
#else
typedef struct
{	uint32_t numofcd	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_of_Chunk-Descriptors */
	uint32_t r1     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t exclth 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Exclusive_threshold */
	uint32_t r2     	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_DMACFG ;
#endif

/*****************************************************************************************/
/* SDMA_address_configuration                                                            */
/* The BBH reassembles the incoming data in the SRAM. The Data is written into the SRAM  */
/* using the SDMA. The data is organized in a configurable number of chunks of 128 bytes */
/* .  The BBH arranges the written data in the SDMA in these chunks. It arranges the dat */
/* a in a predefined address space in the SDMA memory and manages the chunks in a cyclic */
/*  FIFO style.  For every write chunk the BBH writes a write descriptor. The write desc */
/* riptors are arranged in a predefined space in the SDMA memory and managed in a cyclic */
/*  FIFO style as well.  This register defines the Data and descriptors base addresses.  */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_R2_DEFAULT_VALUE                    ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_R2_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_DESCBASE_BASEADDR_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_DESCBASE_BASEADDR_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_R1_DEFAULT_VALUE                    ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_DATABASE_BASEADDR_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_DATABASE_BASEADDR_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_OFFSET ( 0x00000020 )

#define BBH_RX_0_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_SDMAADDR_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_SDMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_SDMAADDR_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_SDMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_SDMAADDR_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_SDMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_SDMAADDR_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_SDMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_SDMAADDR_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_SDMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_SDMAADDR_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_SDMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_SDMAADDR_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_SDMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2      	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Descriptor_base_address */
	uint32_t descbase	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Data_base_address */
	uint32_t database	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_SDMAADDR ;
#else
typedef struct
{	uint32_t database	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Data_base_address */
	uint32_t r1      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t descbase	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Descriptor_base_address */
	uint32_t r2      	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_SDMAADDR ;
#endif

/*****************************************************************************************/
/* SDMA_configuration                                                                    */
/* The BBH reassembles the incoming data in the SRAM. The Data is written into the SRAM  */
/* using the SDMA. The data is organized in a configurable number of chunks of 128 bytes */
/* .  The BBH arranges the written data in the SDMA in these chunks. It arranges the dat */
/* a in a predefined address space in the SDMA memory and manages the chunks in a cyclic */
/*  FIFO style.  For every write chunk the BBH writes a write descriptor. The write desc */
/* riptors are arranged in a predefined space in the SDMA memory and managed in a cyclic */
/*  FIFO style as well.    The BBH handles the congestion over the SDMA write chunks acc */
/* ording to 2 priorities (low + high, exclusive). This field defines the number of occu */
/* pied write chunks for dropping normal or high priority packets. If the number of occu */
/* pied chunk is lower than this threshold, then all packets are passed. If the number o */
/* f occupied chunk is equal or higher than this threshold, then only exclusive priority */
/*  packets are passed.    This register defines the Data and descriptors FIFO sizes and */
/*  the exclusive threshold.                                                             */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_R2_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_R2_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_EXCLTH_MIN_VALUE_VALUE            ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_EXCLTH_DEFAULT_VALUE              ( 0x8 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_EXCLTH_DEFAULT_VALUE_RESET_VALUE  ( 0x8 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_EXCLTH_MAX_VALUE_VALUE            ( 0x40 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_R1_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_NUMOFCD_MIN_VALUE_VALUE           ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_NUMOFCD_DEFAULT_VALUE             ( 0x10 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_NUMOFCD_DEFAULT_VALUE_RESET_VALUE ( 0x10 )
#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_NUMOFCD_MAX_VALUE_VALUE           ( 0x40 )


#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_OFFSET ( 0x00000024 )

#define BBH_RX_0_GENERAL_CONFIGURATION_SDMACFG_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMACFG_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_SDMACFG_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_SDMACFG_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_SDMACFG_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMACFG_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_SDMACFG_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_SDMACFG_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_SDMACFG_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMACFG_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_SDMACFG_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_SDMACFG_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_SDMACFG_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMACFG_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_SDMACFG_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_SDMACFG_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_SDMACFG_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMACFG_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_SDMACFG_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_SDMACFG_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_SDMACFG_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMACFG_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_SDMACFG_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_SDMACFG_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_SDMACFG_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMACFG_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_SDMACFG_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_SDMACFG_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_SDMACFG_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_SDMACFG_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_SDMACFG_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_SDMACFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2     	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Exclusive_threshold */
	uint32_t exclth 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_of_Chunk-Descriptors */
	uint32_t numofcd	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_SDMACFG ;
#else
typedef struct
{	uint32_t numofcd	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_of_Chunk-Descriptors */
	uint32_t r1     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t exclth 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Exclusive_threshold */
	uint32_t r2     	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_SDMACFG ;
#endif

/*****************************************************************************************/
/* Minimum_Packet_size                                                                   */
/* There are 4 global configuration for Minimum packet size. Each flow can get one out o */
/* f these 4 global configurations.  Packets shorter than this threshold will be discard */
/* ed.  Min packet size should keep the following restriction:  Min packet size < 128   */
/* SOP offset                                                                            */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_MINPKT3_MINPKT_VALUE             ( 0x40 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_MINPKT3_MINPKT_VALUE_RESET_VALUE ( 0x40 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_MINPKT3_MAX_VALUE_VALUE          ( 0x60 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_MINPKT2_MINPKT_VALUE             ( 0x40 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_MINPKT2_MINPKT_VALUE_RESET_VALUE ( 0x40 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_MINPKT2_MAX_VALUE_VALUE          ( 0x60 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_MINPKT1_MINPKT_VALUE             ( 0x40 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_MINPKT1_MINPKT_VALUE_RESET_VALUE ( 0x40 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_MINPKT1_MAX_VALUE_VALUE          ( 0x60 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_MINPKT0_MINPKT_VALUE             ( 0x40 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_MINPKT0_MINPKT_VALUE_RESET_VALUE ( 0x40 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_MINPKT0_MAX_VALUE_VALUE          ( 0x60 )


#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_OFFSET ( 0x00000028 )

#define BBH_RX_0_GENERAL_CONFIGURATION_MINPKT0_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKT0_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_MINPKT0_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_MINPKT0_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_MINPKT0_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKT0_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_MINPKT0_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_MINPKT0_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_MINPKT0_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKT0_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_MINPKT0_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_MINPKT0_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_MINPKT0_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKT0_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_MINPKT0_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_MINPKT0_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_MINPKT0_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKT0_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_MINPKT0_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_MINPKT0_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_MINPKT0_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKT0_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_MINPKT0_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_MINPKT0_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_MINPKT0_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKT0_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_MINPKT0_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_MINPKT0_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_MINPKT0_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_MINPKT0_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKT0_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_MINPKT0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Minimum_Packet_3 */
	uint32_t minpkt3	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_Packet_2 */
	uint32_t minpkt2	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_Packet_1 */
	uint32_t minpkt1	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_Packet_0 */
	uint32_t minpkt0	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MINPKT0 ;
#else
typedef struct
{	uint32_t minpkt0	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_Packet_0 */
	uint32_t minpkt1	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_Packet_1 */
	uint32_t minpkt2	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_Packet_2 */
	uint32_t minpkt3	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_Packet_3 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MINPKT0 ;
#endif

/*****************************************************************************************/
/* Maximum_Packet_size_0                                                                 */
/* There are 4 global configuration for Maximum packet size. Each flow can get one out o */
/* f these 4 global configurations.  Packets longer than this threshold will be discarde */
/* d.  It should not exceed the DDR buffer size and should keep the following restrictio */
/* n:  Max packet size <= DDR buffer size  SOP offset - reassembly offset*8             */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_R2_DEFAULT_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_R2_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_MAXPKT1_MAXPKT_VALUE             ( 0x600 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_MAXPKT1_MAXPKT_VALUE_RESET_VALUE ( 0x600 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_R1_DEFAULT_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_R1_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_MAXPKT0_MAXPKT_VALUE             ( 0x600 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_MAXPKT0_MAXPKT_VALUE_RESET_VALUE ( 0x600 )


#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_OFFSET ( 0x0000002C )

#define BBH_RX_0_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_MAXPKT0_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_MAXPKT0_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_MAXPKT0_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_MAXPKT0_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_MAXPKT0_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_MAXPKT0_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_MAXPKT0_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_MAXPKT0_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_MAXPKT0_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_MAXPKT0_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_MAXPKT0_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_MAXPKT0_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_MAXPKT0_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_MAXPKT0_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_Packet_1 */
	uint32_t maxpkt1	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_Packet_0 */
	uint32_t maxpkt0	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MAXPKT0 ;
#else
typedef struct
{	uint32_t maxpkt0	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_Packet_0 */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t maxpkt1	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_Packet_1 */
	uint32_t r2     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MAXPKT0 ;
#endif

/*****************************************************************************************/
/* Maximum_Packet_size_1                                                                 */
/* There are 4 global configuration for Maximum packet size. Each flow can get one out o */
/* f these 4 global configurations.  Packets longer than this threshold will be discarde */
/* d.  It should not exceed the DDR buffer size and should keep the following restrictio */
/* n:  Max packet size <= DDR buffer size  SOP offset - reassembly offset*8             */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_R2_DEFAULT_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_R2_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_MAXPKT3_MAXPKT_VALUE             ( 0x600 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_MAXPKT3_MAXPKT_VALUE_RESET_VALUE ( 0x600 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_R1_DEFAULT_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_R1_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_MAXPKT2_MAXPKT_VALUE             ( 0x600 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_MAXPKT2_MAXPKT_VALUE_RESET_VALUE ( 0x600 )


#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_OFFSET ( 0x00000030 )

#define BBH_RX_0_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_MAXPKT1_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_MAXPKT1_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_MAXPKT1_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_MAXPKT1_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_MAXPKT1_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_MAXPKT1_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_MAXPKT1_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_MAXPKT1_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_MAXPKT1_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_MAXPKT1_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_MAXPKT1_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_MAXPKT1_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_MAXPKT1_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_MAXPKT1_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_Packet_3 */
	uint32_t maxpkt3	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_Packet_2 */
	uint32_t maxpkt2	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MAXPKT1 ;
#else
typedef struct
{	uint32_t maxpkt2	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_Packet_2 */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t maxpkt3	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_Packet_3 */
	uint32_t r2     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MAXPKT1 ;
#endif

/*****************************************************************************************/
/* IH_configuration                                                                      */
/* The BBH writes the packets header into the IH. The start of data offset is configurab */
/* le.  The IH has 16 ingress buffer for all ingress ports.    This register defines the */
/*  SOP (start of packet) offset and the ingress buffers which are assigned to the BBH.  */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_IHCFG_R1_DEFAULT_VALUE                    ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_IHCFG_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_IHCFG_SOPOFFSET_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_IHCFG_SOPOFFSET_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_IHCFG_IHBUFEN_DEFAULT_VALUE               ( 0xF )
#define BBH_RX_GENERAL_CONFIGURATION_IHCFG_IHBUFEN_DEFAULT_VALUE_RESET_VALUE   ( 0xF )


#define BBH_RX_GENERAL_CONFIGURATION_IHCFG_OFFSET ( 0x00000034 )

#define BBH_RX_0_GENERAL_CONFIGURATION_IHCFG_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCFG_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_IHCFG_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_IHCFG_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_IHCFG_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCFG_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_IHCFG_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_IHCFG_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_IHCFG_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCFG_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_IHCFG_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_IHCFG_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_IHCFG_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCFG_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_IHCFG_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_IHCFG_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_IHCFG_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCFG_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_IHCFG_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_IHCFG_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_IHCFG_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCFG_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_IHCFG_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_IHCFG_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_IHCFG_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCFG_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_IHCFG_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_IHCFG_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_IHCFG_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_IHCFG_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_IHCFG_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_IHCFG_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_IHCFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1       	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SOP_offset */
	uint32_t sopoffset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_buffer_enable */
	uint32_t ihbufen  	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_IHCFG ;
#else
typedef struct
{	uint32_t ihbufen  	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_buffer_enable */
	uint32_t sopoffset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SOP_offset */
	uint32_t r1       	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_IHCFG ;
#endif

/*****************************************************************************************/
/* Flow_control_configuration                                                            */
/* The BBH manages a flow control indication towards the Ethernet MAC with the following */
/*  considerations:  - 	According to the level of the DDR and/or SRAM allocated buffers  */
/* (status from the BPM).  - 	According to a FW request.    This register defines which  */
/* of the above will be considerred (may consider more than one).                        */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_R2_DEFAULT_VALUE                     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_R2_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_DMADROPEN_DISABLE_VALUE              ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_DMADROPEN_ENABLE_VALUE               ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_DMADROPEN_ENABLE_VALUE_RESET_VALUE   ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_SBPMDROPEN_DISABLE_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_SBPMDROPEN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_SBPMDROPEN_ENABLE_VALUE              ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_BPMDROPEN_DISABLE_VALUE              ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_BPMDROPEN_DISABLE_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_BPMDROPEN_ENABLE_VALUE               ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_R1_DEFAULT_VALUE                     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_R1_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_RUNNEREN_DEFAULT_VALUE               ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_RUNNEREN_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_SBPMEN_DEFAULT_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_SBPMEN_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_BPMEN_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_BPMEN_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_OFFSET ( 0x00000038 )

#define BBH_RX_0_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_FLOWCTRL_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_FLOWCTRL_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_FLOWCTRL_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_FLOWCTRL_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_FLOWCTRL_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_FLOWCTRL_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_FLOWCTRL_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_FLOWCTRL_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_FLOWCTRL_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_FLOWCTRL_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_FLOWCTRL_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_FLOWCTRL_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_FLOWCTRL_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_FLOWCTRL_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2        	: 21 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_drop_enable */
	uint32_t dmadropen 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_drop_enable */
	uint32_t sbpmdropen	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_drop_enable */
	uint32_t bpmdropen 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_enable */
	uint32_t runneren  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_enable */
	uint32_t sbpmen    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_enable */
	uint32_t bpmen     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL ;
#else
typedef struct
{	uint32_t bpmen     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_enable */
	uint32_t sbpmen    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_enable */
	uint32_t runneren  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_enable */
	uint32_t r1        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t bpmdropen 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_drop_enable */
	uint32_t sbpmdropen	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_drop_enable */
	uint32_t dmadropen 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_drop_enable */
	uint32_t r2        	: 21 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL ;
#endif

/*****************************************************************************************/
/* Per_flow_threshold.                                                                   */
/* The DS has 256 flows. There are 4 configuration which are per flow:  1. IH class numb */
/* er (4 bits)   2. IH class override enable (1 bit)  3. Minimum packet size (2 bits).   */
/* 4. Maximum packet size (2 bits).    Flows 0-31 will have full options 9 bit configura */
/* tions.  Flows 32-X will have set 0 configuration (9 global bits).  Flows (X+1)-255 wi */
/* ll have set 1 configurations (additional 9 global bits).  X is configurable.    For E */
/* thernet  flow 0 should be configured.    This register defines the  threshold (x).   */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_R3_DEFAULT_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_R3_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_FLOWTH_DEFAULT_VALUE             ( 0x20 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_FLOWTH_DEFAULT_VALUE_RESET_VALUE ( 0x20 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_FLOWTH_MIN_VALUE_VALUE           ( 0x20 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_FLOWTH_MAX_VALUE_VALUE           ( 0xFF )


#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_OFFSET ( 0x0000003C )

#define BBH_RX_0_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_PERFLOWTH_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_PERFLOWTH_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_PERFLOWTH_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_PERFLOWTH_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_PERFLOWTH_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_PERFLOWTH_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_PERFLOWTH_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_PERFLOWTH_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_PERFLOWTH_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_PERFLOWTH_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_PERFLOWTH_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_PERFLOWTH_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_PERFLOWTH_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_PERFLOWTH_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r3    	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_threshold */
	uint32_t flowth	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH ;
#else
typedef struct
{	uint32_t flowth	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_threshold */
	uint32_t r3    	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH ;
#endif

/*****************************************************************************************/
/* Per_flow_sets.                                                                        */
/* The DS has 256 flows. There are 4 configuration which are per flow:  1. IH class numb */
/* er (4 bits)   2. IH class override enable (1 bit)  3. Minimum packet size (2 bits).   */
/* 4. Maximum packet size (2 bits).    Flows 0-31 will have full options 9 bit configura */
/* tions.  Flows 32-X will have set 0 configuration (9 global bits).  Flows (X+1)-255 wi */
/* ll have set 1 configurations (additional 9 global bits).  X is configurable.    For E */
/* thernet  flow 0 should be configured.    This register defines the 2 sets of the gen */
/* eral configurations.                                                                  */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_R2_DEFAULT_VALUE                        ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_R2_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OVERRIDE1_NO_OVERRIDE_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OVERRIDE1_NO_OVERRIDE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OVERRIDE1_OVERRIDE_VALUE                ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_IHCLASS1_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_IHCLASS1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MAXPKTSEL1_GLOBAL_0_VALUE               ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MAXPKTSEL1_GLOBAL_0_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MAXPKTSEL1_GLOBAL_1_VALUE               ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MAXPKTSEL1_GLOBAL_2_VALUE               ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MAXPKTSEL1_GLOBAL_3_VALUE               ( 0x3 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MINPKTSEL1_GLOBAL_0_VALUE               ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MINPKTSEL1_GLOBAL_0_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MINPKTSEL1_GLOBAL_1_VALUE               ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MINPKTSEL1_GLOBAL_2_VALUE               ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MINPKTSEL1_GLOBAL_3_VALUE               ( 0x3 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_R1_DEFAULT_VALUE                        ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_R1_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OVERRIDE0_NO_OVERRIDE_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OVERRIDE0_NO_OVERRIDE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OVERRIDE0_OVERRIDE_VALUE                ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_IHCLASS0_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_IHCLASS0_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MAXPKTSEL0_GLOBAL_0_VALUE               ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MAXPKTSEL0_GLOBAL_0_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MAXPKTSEL0_GLOBAL_1_VALUE               ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MAXPKTSEL0_GLOBAL_2_VALUE               ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MAXPKTSEL0_GLOBAL_3_VALUE               ( 0x3 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MINPKTSEL0_GLOBAL_0_VALUE               ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MINPKTSEL0_GLOBAL_0_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MINPKTSEL0_GLOBAL_1_VALUE               ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MINPKTSEL0_GLOBAL_2_VALUE               ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_MINPKTSEL0_GLOBAL_3_VALUE               ( 0x3 )


#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OFFSET ( 0x00000040 )

#define BBH_RX_0_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_PERFLOWSETS_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_PERFLOWSETS_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_PERFLOWSETS_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_PERFLOWSETS_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_PERFLOWSETS_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_PERFLOWSETS_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_PERFLOWSETS_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_PERFLOWSETS_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_PERFLOWSETS_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_PERFLOWSETS_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_PERFLOWSETS_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_PERFLOWSETS_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_PERFLOWSETS_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_PERFLOWSETS_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2        	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_override */
	uint32_t override1 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_number */
	uint32_t ihclass1  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_packet_size_select_1 */
	uint32_t maxpktsel1	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_packet_size_select_1 */
	uint32_t minpktsel1	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1        	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_override */
	uint32_t override0 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_number */
	uint32_t ihclass0  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_packet_size_select_0 */
	uint32_t maxpktsel0	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_packet_size_select_0 */
	uint32_t minpktsel0	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS ;
#else
typedef struct
{	uint32_t minpktsel0	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_packet_size_select_0 */
	uint32_t maxpktsel0	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_packet_size_select_0 */
	uint32_t ihclass0  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_number */
	uint32_t override0 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_override */
	uint32_t r1        	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t minpktsel1	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_packet_size_select_1 */
	uint32_t maxpktsel1	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_packet_size_select_1 */
	uint32_t ihclass1  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_number */
	uint32_t override1 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_override */
	uint32_t r2        	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS ;
#endif

/*****************************************************************************************/
/* IH_class_select_0                                                                     */
/* The DS has 256 flows. There are 4 configuration which are per flow:  1. IH class numb */
/* er (4 bits)   2. IH class override enable (1 bit)  3. Minimum packet size (2 bits).   */
/* 4. Maximum packet size (2 bits).    Flows 0-31 will have full options 9 bit configura */
/* tions.  Flows 32-X will have set 0 configuration (9 global bits).  Flows (X+1)-255 wi */
/* ll have set 1 configurations (additional 9 global bits).  X is configurable.    For E */
/* thernet  flow 0 should be configured.    This register defines the IH class for flow */
/*  0-7.                                                                                 */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_IHCLASS_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_IHCLASS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_OFFSET ( 0x00000044 )

#define BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS0_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS0_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS0_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS0_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS0_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS0_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS0_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS0_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS0_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS0_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS0_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS0_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS0_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS0_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_class */
	uint32_t ihclass	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_IHCLASS0 ;
#else
typedef struct
{	uint32_t ihclass	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_IHCLASS0 ;
#endif

/*****************************************************************************************/
/* IH_class_select_1                                                                     */
/* The DS has 256 flows. There are 4 configuration which are per flow:  1. IH class numb */
/* er (4 bits)   2. IH class override enable (1 bit)  3. Minimum packet size (2 bits).   */
/* 4. Maximum packet size (2 bits).    Flows 0-31 will have full options 9 bit configura */
/* tions.  Flows 32-X will have set 0 configuration (9 global bits).  Flows (X+1)-255 wi */
/* ll have set 1 configurations (additional 9 global bits).  X is configurable.    For E */
/* thernet  flow 0 should be configured.    This register defines the IH class for flow */
/*  8-15.                                                                                */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_IHCLASS_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_IHCLASS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_OFFSET ( 0x00000048 )

#define BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS1_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS1_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS1_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS1_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS1_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS1_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS1_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS1_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS1_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS1_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS1_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS1_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS1_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS1_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_class */
	uint32_t ihclass	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_IHCLASS1 ;
#else
typedef struct
{	uint32_t ihclass	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_IHCLASS1 ;
#endif

/*****************************************************************************************/
/* IH_class_select_2                                                                     */
/* The DS has 256 flows. There are 4 configuration which are per flow:  1. IH class numb */
/* er (4 bits)   2. IH class override enable (1 bit)  3. Minimum packet size (2 bits).   */
/* 4. Maximum packet size (2 bits).    Flows 0-31 will have full options 9 bit configura */
/* tions.  Flows 32-X will have set 0 configuration (9 global bits).  Flows (X+1)-255 wi */
/* ll have set 1 configurations (additional 9 global bits).  X is configurable.    For E */
/* thernet  flow 0 should be configured.    This register defines the IH class for flow */
/*  16-23.                                                                               */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_IHCLASS_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_IHCLASS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_OFFSET ( 0x0000004C )

#define BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS2_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS2_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS2_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS2_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS2_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS2_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS2_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS2_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS2_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS2_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS2_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS2_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS2_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS2_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_class */
	uint32_t ihclass	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_IHCLASS2 ;
#else
typedef struct
{	uint32_t ihclass	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_IHCLASS2 ;
#endif

/*****************************************************************************************/
/* IH_class_select_3                                                                     */
/* The DS has 256 flows. There are 4 configuration which are per flow:  1. IH class numb */
/* er (4 bits)   2. IH class override enable (1 bit)  3. Minimum packet size (2 bits).   */
/* 4. Maximum packet size (2 bits).    Flows 0-31 will have full options 9 bit configura */
/* tions.  Flows 32-X will have set 0 configuration (9 global bits).  Flows (X+1)-255 wi */
/* ll have set 1 configurations (additional 9 global bits).  X is configurable.    For E */
/* thernet  flow 0 should be configured.    This register defines the IH class for flow */
/*  24-31.                                                                               */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_IHCLASS_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_IHCLASS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_OFFSET ( 0x00000050 )

#define BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS3_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS3_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS3_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS3_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS3_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS3_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS3_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS3_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS3_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS3_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS3_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS3_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS3_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS3_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_class */
	uint32_t ihclass	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_IHCLASS3 ;
#else
typedef struct
{	uint32_t ihclass	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_IHCLASS3 ;
#endif

/*****************************************************************************************/
/* IH_class_override                                                                     */
/* The DS has 256 flows. There are 4 configuration which are per flow:  1. IH class numb */
/* er (4 bits)   2. IH class override enable (1 bit)  3. Minimum packet size (2 bits).   */
/* 4. Maximum packet size (2 bits).    Flows 0-31 will have full options 9 bit configura */
/* tions.  Flows 32-X will have set 0 configuration (9 global bits).  Flows (X+1)-255 wi */
/* ll have set 1 configurations (additional 9 global bits).  X is configurable.    For E */
/* thernet  flow 0 should be configured.    This register defines the IH class select o */
/* verride for flow 0-31.                                                                */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_IHOVERRIDE_NO_OVERRIDE_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_IHOVERRIDE_NO_OVERRIDE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_IHOVERRIDE_OVERRIDE_VALUE                ( 0x1 )


#define BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_OFFSET ( 0x00000054 )

#define BBH_RX_0_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_IHOVERRIDE_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_IHOVERRIDE_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_IHOVERRIDE_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_IHOVERRIDE_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_IHOVERRIDE_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_IHOVERRIDE_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_IHOVERRIDE_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_IHOVERRIDE_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_IHOVERRIDE_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_IHOVERRIDE_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_IHOVERRIDE_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_IHOVERRIDE_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_IHOVERRIDE_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_IHOVERRIDE_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IH_class_override */
	uint32_t ihoverride	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE ;
#else
typedef struct
{	uint32_t ihoverride	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_override */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE ;
#endif

/*****************************************************************************************/
/* Minimum_packet_select_0                                                               */
/* The DS has 256 flows. There are 4 configuration which are per flow:  1. IH class numb */
/* er (4 bits)   2. IH class override enable (1 bit)  3. Minimum packet size (2 bits).   */
/* 4. Maximum packet size (2 bits).    Flows 0-31 will have full options 9 bit configura */
/* tions.  Flows 32-X will have set 0 configuration (9 global bits).  Flows (X+1)-255 wi */
/* ll have set 1 configurations (additional 9 global bits).  X is configurable.    For E */
/* thernet  flow 0 should be configured.    This register defines the minimum packet si */
/* ze select for flow 0-15.                                                              */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_MINPKTSEL_GLOBAL_0_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_MINPKTSEL_GLOBAL_0_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_MINPKTSEL_GLOBAL_1_VALUE             ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_MINPKTSEL_GLOBAL_2_VALUE             ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_MINPKTSEL_GLOBAL_3_VALUE             ( 0x3 )


#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_OFFSET ( 0x00000058 )

#define BBH_RX_0_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_MINPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_MINPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_MINPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_MINPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_MINPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_MINPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_MINPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_MINPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_MINPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_MINPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_MINPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_MINPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_MINPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_MINPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Mimimum_packet_size_select */
	uint32_t minpktsel	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0 ;
#else
typedef struct
{	uint32_t minpktsel	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Mimimum_packet_size_select */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0 ;
#endif

/*****************************************************************************************/
/* Minimum_packet_select_1                                                               */
/* The DS has 256 flows. There are 4 configuration which are per flow:  1. IH class numb */
/* er (4 bits)   2. IH class override enable (1 bit)  3. Minimum packet size (2 bits).   */
/* 4. Maximum packet size (2 bits).    Flows 0-31 will have full options 9 bit configura */
/* tions.  Flows 32-X will have set 0 configuration (9 global bits).  Flows (X+1)-255 wi */
/* ll have set 1 configurations (additional 9 global bits).  X is configurable.    For E */
/* thernet  flow 0 should be configured.    This register defines the minimum packet si */
/* ze select for flow 16-31.                                                             */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_MINPKTSEL_GLOBAL_0_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_MINPKTSEL_GLOBAL_0_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_MINPKTSEL_GLOBAL_1_VALUE             ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_MINPKTSEL_GLOBAL_2_VALUE             ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_MINPKTSEL_GLOBAL_3_VALUE             ( 0x3 )


#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_OFFSET ( 0x0000005C )

#define BBH_RX_0_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_MINPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_MINPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_MINPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_MINPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_MINPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_MINPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_MINPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_MINPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_MINPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_MINPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_MINPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_MINPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_MINPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_MINPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Mimimum_packet_size_select */
	uint32_t minpktsel	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1 ;
#else
typedef struct
{	uint32_t minpktsel	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Mimimum_packet_size_select */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1 ;
#endif

/*****************************************************************************************/
/* Maximum_packet_select_0                                                               */
/* The DS has 256 flows. There are 4 configuration which are per flow:  1. IH class numb */
/* er (4 bits)   2. IH class override enable (1 bit)  3. Minimum packet size (2 bits).   */
/* 4. Maximum packet size (2 bits).    Flows 0-31 will have full options 9 bit configura */
/* tions.  Flows 32-X will have set 0 configuration (9 global bits).  Flows (X+1)-255 wi */
/* ll have set 1 configurations (additional 9 global bits).  X is configurable.    For E */
/* thernet  flow 0 should be configured.    This register defines the maximum packet si */
/* ze select for flow 0-15.                                                              */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_MAXPKTSEL_GLOBAL_0_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_MAXPKTSEL_GLOBAL_0_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_MAXPKTSEL_GLOBAL_1_VALUE             ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_MAXPKTSEL_GLOBAL_2_VALUE             ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_MAXPKTSEL_GLOBAL_3_VALUE             ( 0x3 )


#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_OFFSET ( 0x00000060 )

#define BBH_RX_0_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_MAXPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_MAXPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_MAXPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_MAXPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_MAXPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_MAXPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_MAXPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_MAXPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_MAXPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_MAXPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_MAXPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_MAXPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_MAXPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_MAXPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Maximum_packet_size_select */
	uint32_t maxpktsel	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0 ;
#else
typedef struct
{	uint32_t maxpktsel	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_packet_size_select */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0 ;
#endif

/*****************************************************************************************/
/* Maximum_packet_select_1                                                               */
/* The DS has 256 flows. There are 4 configuration which are per flow:  1. IH class numb */
/* er (4 bits)   2. IH class override enable (1 bit)  3. Minimum packet size (2 bits).   */
/* 4. Maximum packet size (2 bits).    Flows 0-31 will have full options 9 bit configura */
/* tions.  Flows 32-X will have set 0 configuration (9 global bits).  Flows (X+1)-255 wi */
/* ll have set 1 configurations (additional 9 global bits).  X is configurable.    For E */
/* thernet  flow 0 should be configured.    This register defines the maximum packet si */
/* ze select for flow 16-31.                                                             */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_MAXPKTSEL_GLOBAL_0_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_MAXPKTSEL_GLOBAL_0_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_MAXPKTSEL_GLOBAL_1_VALUE             ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_MAXPKTSEL_GLOBAL_2_VALUE             ( 0x2 )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_MAXPKTSEL_GLOBAL_3_VALUE             ( 0x3 )


#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_OFFSET ( 0x00000064 )

#define BBH_RX_0_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_MAXPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_MAXPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_MAXPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_MAXPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_MAXPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_MAXPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_MAXPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_MAXPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_MAXPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_MAXPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_MAXPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_MAXPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_MAXPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_MAXPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Maximum_packet_size_select */
	uint32_t maxpktsel	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1 ;
#else
typedef struct
{	uint32_t maxpktsel	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_packet_size_select */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1 ;
#endif

/*****************************************************************************************/
/* PLOAM_configurations                                                                  */
/* PLOAM has the following 2 configuration:  1. IH class number (4 bits)   2. IH class o */
/* verride enable (1 bit)                                                                */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_R1_DEFAULT_VALUE                         ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_R1_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_IHOVERRIDE_NO_OVERRIDE_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_IHOVERRIDE_NO_OVERRIDE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_IHOVERRIDE_OVERRIDE_VALUE                ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_IHCLASS_DEFAULT_VALUE                    ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_IHCLASS_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_OFFSET ( 0x00000068 )

#define BBH_RX_0_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_PLOAMCFG_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_PLOAMCFG_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_PLOAMCFG_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_PLOAMCFG_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_PLOAMCFG_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_PLOAMCFG_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_PLOAMCFG_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_PLOAMCFG_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_PLOAMCFG_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_PLOAMCFG_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_PLOAMCFG_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_PLOAMCFG_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_PLOAMCFG_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_PLOAMCFG_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1        	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLOAM_IH_override */
	uint32_t ihoverride	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLOAM_IH_class */
	uint32_t ihclass   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG ;
#else
typedef struct
{	uint32_t ihclass   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLOAM_IH_class */
	uint32_t ihoverride	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLOAM_IH_override */
	uint32_t r1        	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG ;
#endif

/*****************************************************************************************/
/* RX_reset_command                                                                      */
/* This register enable reset of internal units (for WA perposes).                       */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_R_DEFAULT_VALUE                                   ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_R_DEFAULT_VALUE_RESET_VALUE                       ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_RNRRST_RESET_IS_NOT_ACTIVE_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_RNRRST_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_RNRRST_RESET_IS_ACTIVE_VALUE                      ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_SDMARST_RESET_IS_NOT_ACTIVE_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_SDMARST_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_SDMARST_RESET_IS_ACTIVE_VALUE                     ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_DMARST_RESET_IS_NOT_ACTIVE_VALUE                  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_DMARST_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_DMARST_RESET_IS_ACTIVE_VALUE                      ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_CNTXTRST_RESET_IS_NOT_ACTIVE_VALUE                ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_CNTXTRST_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE    ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_CNTXTRST_RESET_IS_ACTIVE_VALUE                    ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_PWUFIFORST_RESET_IS_NOT_ACTIVE_VALUE              ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_PWUFIFORST_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_PWUFIFORST_RESET_IS_ACTIVE_VALUE                  ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_RESFIFORST_RESET_IS_NOT_ACTIVE_VALUE              ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_RESFIFORST_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_RESFIFORST_RESET_IS_ACTIVE_VALUE                  ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_SBPMFIFORST_RESET_IS_NOT_ACTIVE_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_SBPMFIFORST_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_SBPMFIFORST_RESET_IS_ACTIVE_VALUE                 ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_BPMFIFORST_RESET_IS_NOT_ACTIVE_VALUE              ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_BPMFIFORST_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_BPMFIFORST_RESET_IS_ACTIVE_VALUE                  ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_REFIFORST_RESET_IS_NOT_ACTIVE_VALUE               ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_REFIFORST_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_REFIFORST_RESET_IS_ACTIVE_VALUE                   ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_IHBUFEN_RESET_IS_NOT_ACTIVE_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_IHBUFEN_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_IHBUFEN_RESET_IS_ACTIVE_VALUE                     ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_IHCNTXT_RESET_IS_NOT_ACTIVE_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_IHCNTXT_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_IHCNTXT_RESET_IS_ACTIVE_VALUE                     ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_BURSTBUFRST_RESET_IS_NOT_ACTIVE_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_BURSTBUFRST_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_BURSTBUFRST_RESET_IS_ACTIVE_VALUE                 ( 0x1 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_INBUFRST_RESET_IS_NOT_ACTIVE_VALUE                ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_INBUFRST_RESET_IS_NOT_ACTIVE_VALUE_RESET_VALUE    ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_INBUFRST_RESET_IS_ACTIVE_VALUE                    ( 0x1 )


#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_OFFSET ( 0x0000006C )

#define BBH_RX_0_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_RXRSTRST_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_RXRSTRST_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_RXRSTRST_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_RXRSTRST_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_RXRSTRST_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_RXRSTRST_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_RXRSTRST_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_RXRSTRST_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_RXRSTRST_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_RXRSTRST_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_RXRSTRST_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_RXRSTRST_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_RXRSTRST_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_RXRSTRST_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r          	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_write_pointer_reset_command */
	uint32_t rnrrst     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA_write_pointer_reset_command */
	uint32_t sdmarst    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_write_pointer_reset_command */
	uint32_t dmarst     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_reset_command */
	uint32_t cntxtrst   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pre_wakeup_FIFO_reset_command */
	uint32_t pwufiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Response_FIFO_reset_command */
	uint32_t resfiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_FIFO_reset_command */
	uint32_t sbpmfiforst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_FIFO_reset_command */
	uint32_t bpmfiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reassembly_FIFO_reset_command */
	uint32_t refiforst  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_buf_en_reset_command */
	uint32_t ihbufen    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_context_reset_command */
	uint32_t ihcntxt    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Burst_buf_reset_command */
	uint32_t burstbufrst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Input_buf_reset_command */
	uint32_t inbufrst   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_RXRSTRST ;
#else
typedef struct
{	uint32_t inbufrst   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Input_buf_reset_command */
	uint32_t burstbufrst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Burst_buf_reset_command */
	uint32_t ihcntxt    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_context_reset_command */
	uint32_t ihbufen    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_buf_en_reset_command */
	uint32_t refiforst  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reassembly_FIFO_reset_command */
	uint32_t bpmfiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_FIFO_reset_command */
	uint32_t sbpmfiforst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_FIFO_reset_command */
	uint32_t resfiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Response_FIFO_reset_command */
	uint32_t pwufiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pre_wakeup_FIFO_reset_command */
	uint32_t cntxtrst   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_reset_command */
	uint32_t dmarst     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_write_pointer_reset_command */
	uint32_t sdmarst    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA_write_pointer_reset_command */
	uint32_t rnrrst     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_write_pointer_reset_command */
	uint32_t r          	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_RXRSTRST ;
#endif

/*****************************************************************************************/
/* RX_debug_select                                                                       */
/* Selects one out of 10 possible debug vectors                                          */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_R1_RESET_VALUE_VALUE                   ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_R1_RESET_VALUE_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_RXDBGSEL_RESET_VALUE_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_RXDBGSEL_RESET_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_OFFSET ( 0x00000070 )

#define BBH_RX_0_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_RXDBGSEL_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_RXDBGSEL_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_RXDBGSEL_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_RXDBGSEL_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_RXDBGSEL_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_RXDBGSEL_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_RXDBGSEL_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_RXDBGSEL_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_RXDBGSEL_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_RXDBGSEL_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_RXDBGSEL_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_RXDBGSEL_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_RXDBGSEL_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_RXDBGSEL_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_debug_select */
	uint32_t rxdbgsel	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL ;
#else
typedef struct
{	uint32_t rxdbgsel	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_debug_select */
	uint32_t r1      	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL ;
#endif

/*****************************************************************************************/
/* Reassembly_offset                                                                     */
/* The BBH writes the packets header into the IH. If the rest of the packet is written i */
/* nto the DDR, then the address is according to the reassembly offset configurations (t */
/* his configuration is in 8-bytes resolutions):  128 + 8 * <reassembly_offset>          */
/*****************************************************************************************/

#define BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_R1_DEFAULT_VALUE                 ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_R1_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_OFFSET_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_OFFSET_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_OFFSET_MAX_VALUE_VALUE           ( 0x32 )


#define BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_OFFSET ( 0x00000074 )

#define BBH_RX_0_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS   	( BBH_RX_0_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_OFFSET )
#define BBH_RX_0_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_READ( r ) 	READ_32( ( BBH_RX_0_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (r) )
#define BBH_RX_0_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_WRITE( v )	WRITE_32( ( BBH_RX_0_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (v) )

#define BBH_RX_1_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS   	( BBH_RX_1_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_OFFSET )
#define BBH_RX_1_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_READ( r ) 	READ_32( ( BBH_RX_1_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (r) )
#define BBH_RX_1_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_WRITE( v )	WRITE_32( ( BBH_RX_1_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (v) )

#define BBH_RX_2_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS   	( BBH_RX_2_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_OFFSET )
#define BBH_RX_2_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_READ( r ) 	READ_32( ( BBH_RX_2_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (r) )
#define BBH_RX_2_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_WRITE( v )	WRITE_32( ( BBH_RX_2_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (v) )

#define BBH_RX_3_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS   	( BBH_RX_3_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_OFFSET )
#define BBH_RX_3_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_READ( r ) 	READ_32( ( BBH_RX_3_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (r) )
#define BBH_RX_3_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_WRITE( v )	WRITE_32( ( BBH_RX_3_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (v) )

#define BBH_RX_4_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS   	( BBH_RX_4_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_OFFSET )
#define BBH_RX_4_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_READ( r ) 	READ_32( ( BBH_RX_4_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (r) )
#define BBH_RX_4_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_WRITE( v )	WRITE_32( ( BBH_RX_4_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (v) )

#define BBH_RX_5_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS   	( BBH_RX_5_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_OFFSET )
#define BBH_RX_5_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_READ( r ) 	READ_32( ( BBH_RX_5_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (r) )
#define BBH_RX_5_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_WRITE( v )	WRITE_32( ( BBH_RX_5_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (v) )

#define BBH_RX_6_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS   	( BBH_RX_6_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_OFFSET )
#define BBH_RX_6_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_READ( r ) 	READ_32( ( BBH_RX_6_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (r) )
#define BBH_RX_6_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_WRITE( v )	WRITE_32( ( BBH_RX_6_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (v) )


extern uint32_t BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ARRAY [ ] ;

#define BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_WRITE( i, v )	WRITE_32( BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ARRAY [ i ], (v) )
#define BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_READ( i, r ) 	READ_32( BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1    	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reassemly_offset */
	uint32_t offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET ;
#else
typedef struct
{	uint32_t offset	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reassemly_offset */
	uint32_t r1    	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET ;
#endif

/*****************************************************************************************/
/* SOP_after_SOP_error                                                                   */
/* This counter counts the packets drop due to SOP after SOP error.  This counter is cle */
/* ared when read and freezes when reaches the maximum value.                            */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_SOPASOP_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_SOPASOP_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_SOPASOP_OFFSET ( 0x00000000 )

#define BBH_RX_0_PM_COUNTERS_SOPASOP_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_SOPASOP_OFFSET )
#define BBH_RX_0_PM_COUNTERS_SOPASOP_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_SOPASOP_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_SOPASOP_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_SOPASOP_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_SOPASOP_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_SOPASOP_OFFSET )
#define BBH_RX_1_PM_COUNTERS_SOPASOP_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_SOPASOP_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_SOPASOP_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_SOPASOP_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_SOPASOP_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_SOPASOP_OFFSET )
#define BBH_RX_2_PM_COUNTERS_SOPASOP_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_SOPASOP_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_SOPASOP_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_SOPASOP_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_SOPASOP_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_SOPASOP_OFFSET )
#define BBH_RX_3_PM_COUNTERS_SOPASOP_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_SOPASOP_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_SOPASOP_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_SOPASOP_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_SOPASOP_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_SOPASOP_OFFSET )
#define BBH_RX_4_PM_COUNTERS_SOPASOP_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_SOPASOP_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_SOPASOP_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_SOPASOP_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_SOPASOP_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_SOPASOP_OFFSET )
#define BBH_RX_5_PM_COUNTERS_SOPASOP_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_SOPASOP_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_SOPASOP_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_SOPASOP_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_SOPASOP_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_SOPASOP_OFFSET )
#define BBH_RX_6_PM_COUNTERS_SOPASOP_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_SOPASOP_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_SOPASOP_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_SOPASOP_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_SOPASOP_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_SOPASOP_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_SOPASOP_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_SOPASOP_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_SOPASOP_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_SOPASOP ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_SOPASOP ;
#endif

/*****************************************************************************************/
/* Third_flow_error                                                                      */
/* This counter counts the packets drop due to Third flow error.  This counter is cleare */
/* d when read and freezes when reaches the maximum value.                               */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_THIRDFLOW_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_THIRDFLOW_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_THIRDFLOW_OFFSET ( 0x00000004 )

#define BBH_RX_0_PM_COUNTERS_THIRDFLOW_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_THIRDFLOW_OFFSET )
#define BBH_RX_0_PM_COUNTERS_THIRDFLOW_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_THIRDFLOW_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_THIRDFLOW_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_THIRDFLOW_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_THIRDFLOW_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_THIRDFLOW_OFFSET )
#define BBH_RX_1_PM_COUNTERS_THIRDFLOW_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_THIRDFLOW_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_THIRDFLOW_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_THIRDFLOW_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_THIRDFLOW_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_THIRDFLOW_OFFSET )
#define BBH_RX_2_PM_COUNTERS_THIRDFLOW_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_THIRDFLOW_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_THIRDFLOW_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_THIRDFLOW_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_THIRDFLOW_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_THIRDFLOW_OFFSET )
#define BBH_RX_3_PM_COUNTERS_THIRDFLOW_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_THIRDFLOW_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_THIRDFLOW_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_THIRDFLOW_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_THIRDFLOW_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_THIRDFLOW_OFFSET )
#define BBH_RX_4_PM_COUNTERS_THIRDFLOW_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_THIRDFLOW_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_THIRDFLOW_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_THIRDFLOW_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_THIRDFLOW_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_THIRDFLOW_OFFSET )
#define BBH_RX_5_PM_COUNTERS_THIRDFLOW_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_THIRDFLOW_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_THIRDFLOW_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_THIRDFLOW_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_THIRDFLOW_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_THIRDFLOW_OFFSET )
#define BBH_RX_6_PM_COUNTERS_THIRDFLOW_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_THIRDFLOW_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_THIRDFLOW_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_THIRDFLOW_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_THIRDFLOW_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_THIRDFLOW_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_THIRDFLOW_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_THIRDFLOW_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_THIRDFLOW_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_THIRDFLOW ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_THIRDFLOW ;
#endif

/*****************************************************************************************/
/* Incoming_packets                                                                      */
/* This counter counts the number of incoming good packets.  It counts the packets from  */
/* all flows together.  This counter is cleared when read and freezes when reaches the m */
/* aximum value.                                                                         */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_INPKT_INPKT_GOOD_PACKETS_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_INPKT_INPKT_GOOD_PACKETS_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_INPKT_OFFSET ( 0x00000008 )

#define BBH_RX_0_PM_COUNTERS_INPKT_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_INPKT_OFFSET )
#define BBH_RX_0_PM_COUNTERS_INPKT_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_INPKT_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_INPKT_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_INPKT_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_INPKT_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_INPKT_OFFSET )
#define BBH_RX_1_PM_COUNTERS_INPKT_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_INPKT_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_INPKT_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_INPKT_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_INPKT_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_INPKT_OFFSET )
#define BBH_RX_2_PM_COUNTERS_INPKT_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_INPKT_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_INPKT_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_INPKT_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_INPKT_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_INPKT_OFFSET )
#define BBH_RX_3_PM_COUNTERS_INPKT_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_INPKT_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_INPKT_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_INPKT_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_INPKT_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_INPKT_OFFSET )
#define BBH_RX_4_PM_COUNTERS_INPKT_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_INPKT_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_INPKT_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_INPKT_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_INPKT_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_INPKT_OFFSET )
#define BBH_RX_5_PM_COUNTERS_INPKT_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_INPKT_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_INPKT_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_INPKT_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_INPKT_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_INPKT_OFFSET )
#define BBH_RX_6_PM_COUNTERS_INPKT_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_INPKT_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_INPKT_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_INPKT_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_INPKT_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_INPKT_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_INPKT_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_INPKT_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_INPKT_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Incoming_packets */
	uint32_t inpkt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_INPKT ;
#else
typedef struct
{	uint32_t inpkt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Incoming_packets */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_INPKT ;
#endif

/*****************************************************************************************/
/* Too_short_error                                                                       */
/* This counter counts the packets drop due to Too short error.  This counter is cleared */
/*  when read and freezes when reaches the maximum value.                                */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_TOOSHORT_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_TOOSHORT_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_TOOSHORT_OFFSET ( 0x0000000C )

#define BBH_RX_0_PM_COUNTERS_TOOSHORT_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOSHORT_OFFSET )
#define BBH_RX_0_PM_COUNTERS_TOOSHORT_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_TOOSHORT_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_TOOSHORT_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_TOOSHORT_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_TOOSHORT_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOSHORT_OFFSET )
#define BBH_RX_1_PM_COUNTERS_TOOSHORT_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_TOOSHORT_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_TOOSHORT_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_TOOSHORT_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_TOOSHORT_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOSHORT_OFFSET )
#define BBH_RX_2_PM_COUNTERS_TOOSHORT_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_TOOSHORT_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_TOOSHORT_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_TOOSHORT_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_TOOSHORT_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOSHORT_OFFSET )
#define BBH_RX_3_PM_COUNTERS_TOOSHORT_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_TOOSHORT_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_TOOSHORT_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_TOOSHORT_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_TOOSHORT_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOSHORT_OFFSET )
#define BBH_RX_4_PM_COUNTERS_TOOSHORT_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_TOOSHORT_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_TOOSHORT_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_TOOSHORT_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_TOOSHORT_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOSHORT_OFFSET )
#define BBH_RX_5_PM_COUNTERS_TOOSHORT_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_TOOSHORT_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_TOOSHORT_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_TOOSHORT_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_TOOSHORT_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOSHORT_OFFSET )
#define BBH_RX_6_PM_COUNTERS_TOOSHORT_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_TOOSHORT_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_TOOSHORT_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_TOOSHORT_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_TOOSHORT_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_TOOSHORT_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_TOOSHORT_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_TOOSHORT_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_TOOSHORT_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_TOOSHORT ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_TOOSHORT ;
#endif

/*****************************************************************************************/
/* Too_long_error                                                                        */
/* This counter counts the packets drop due to Too long error.  This counter is cleared  */
/* when read and freezes when reaches the maximum value.                                 */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_TOOLONG_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_TOOLONG_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_TOOLONG_OFFSET ( 0x00000010 )

#define BBH_RX_0_PM_COUNTERS_TOOLONG_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOLONG_OFFSET )
#define BBH_RX_0_PM_COUNTERS_TOOLONG_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_TOOLONG_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_TOOLONG_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_TOOLONG_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_TOOLONG_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOLONG_OFFSET )
#define BBH_RX_1_PM_COUNTERS_TOOLONG_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_TOOLONG_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_TOOLONG_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_TOOLONG_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_TOOLONG_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOLONG_OFFSET )
#define BBH_RX_2_PM_COUNTERS_TOOLONG_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_TOOLONG_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_TOOLONG_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_TOOLONG_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_TOOLONG_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOLONG_OFFSET )
#define BBH_RX_3_PM_COUNTERS_TOOLONG_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_TOOLONG_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_TOOLONG_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_TOOLONG_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_TOOLONG_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOLONG_OFFSET )
#define BBH_RX_4_PM_COUNTERS_TOOLONG_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_TOOLONG_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_TOOLONG_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_TOOLONG_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_TOOLONG_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOLONG_OFFSET )
#define BBH_RX_5_PM_COUNTERS_TOOLONG_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_TOOLONG_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_TOOLONG_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_TOOLONG_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_TOOLONG_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOLONG_OFFSET )
#define BBH_RX_6_PM_COUNTERS_TOOLONG_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_TOOLONG_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_TOOLONG_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_TOOLONG_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_TOOLONG_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_TOOLONG_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_TOOLONG_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_TOOLONG_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_TOOLONG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_TOOLONG ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_TOOLONG ;
#endif

/*****************************************************************************************/
/* CRC_error                                                                             */
/* This counter counts the packets drop due to CRC error.  This counter is cleared when  */
/* read and freezes when reaches the maximum value.                                      */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_CRCERROR_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_CRCERROR_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_CRCERROR_OFFSET ( 0x00000014 )

#define BBH_RX_0_PM_COUNTERS_CRCERROR_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERROR_OFFSET )
#define BBH_RX_0_PM_COUNTERS_CRCERROR_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_CRCERROR_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_CRCERROR_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_CRCERROR_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_CRCERROR_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERROR_OFFSET )
#define BBH_RX_1_PM_COUNTERS_CRCERROR_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_CRCERROR_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_CRCERROR_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_CRCERROR_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_CRCERROR_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERROR_OFFSET )
#define BBH_RX_2_PM_COUNTERS_CRCERROR_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_CRCERROR_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_CRCERROR_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_CRCERROR_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_CRCERROR_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERROR_OFFSET )
#define BBH_RX_3_PM_COUNTERS_CRCERROR_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_CRCERROR_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_CRCERROR_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_CRCERROR_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_CRCERROR_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERROR_OFFSET )
#define BBH_RX_4_PM_COUNTERS_CRCERROR_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_CRCERROR_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_CRCERROR_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_CRCERROR_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_CRCERROR_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERROR_OFFSET )
#define BBH_RX_5_PM_COUNTERS_CRCERROR_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_CRCERROR_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_CRCERROR_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_CRCERROR_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_CRCERROR_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERROR_OFFSET )
#define BBH_RX_6_PM_COUNTERS_CRCERROR_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_CRCERROR_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_CRCERROR_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_CRCERROR_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_CRCERROR_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_CRCERROR_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_CRCERROR_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_CRCERROR_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_CRCERROR_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_CRCERROR ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_CRCERROR ;
#endif

/*****************************************************************************************/
/* IPTV_error                                                                            */
/* This counter counts the packets drop due to IPTV error.  This counter is cleared when */
/*  read and freezes when reaches the maximum value.                                     */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_IPTV_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_IPTV_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_IPTV_OFFSET ( 0x00000018 )

#define BBH_RX_0_PM_COUNTERS_IPTV_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IPTV_OFFSET )
#define BBH_RX_0_PM_COUNTERS_IPTV_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_IPTV_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_IPTV_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_IPTV_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_IPTV_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IPTV_OFFSET )
#define BBH_RX_1_PM_COUNTERS_IPTV_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_IPTV_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_IPTV_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_IPTV_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_IPTV_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IPTV_OFFSET )
#define BBH_RX_2_PM_COUNTERS_IPTV_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_IPTV_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_IPTV_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_IPTV_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_IPTV_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IPTV_OFFSET )
#define BBH_RX_3_PM_COUNTERS_IPTV_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_IPTV_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_IPTV_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_IPTV_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_IPTV_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IPTV_OFFSET )
#define BBH_RX_4_PM_COUNTERS_IPTV_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_IPTV_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_IPTV_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_IPTV_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_IPTV_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IPTV_OFFSET )
#define BBH_RX_5_PM_COUNTERS_IPTV_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_IPTV_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_IPTV_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_IPTV_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_IPTV_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IPTV_OFFSET )
#define BBH_RX_6_PM_COUNTERS_IPTV_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_IPTV_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_IPTV_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_IPTV_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_IPTV_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_IPTV_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_IPTV_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_IPTV_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_IPTV_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_IPTV ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_IPTV ;
#endif

/*****************************************************************************************/
/* Runner_congestion_error                                                               */
/* This counter counts the packets drop due to Runner congestion error.  This counter is */
/*  cleared when read and freezes when reaches the maximum value.                        */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_RUNNERCONG_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_RUNNERCONG_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_RUNNERCONG_OFFSET ( 0x0000001C )

#define BBH_RX_0_PM_COUNTERS_RUNNERCONG_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_RUNNERCONG_OFFSET )
#define BBH_RX_0_PM_COUNTERS_RUNNERCONG_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_RUNNERCONG_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_RUNNERCONG_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_RUNNERCONG_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_RUNNERCONG_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_RUNNERCONG_OFFSET )
#define BBH_RX_1_PM_COUNTERS_RUNNERCONG_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_RUNNERCONG_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_RUNNERCONG_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_RUNNERCONG_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_RUNNERCONG_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_RUNNERCONG_OFFSET )
#define BBH_RX_2_PM_COUNTERS_RUNNERCONG_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_RUNNERCONG_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_RUNNERCONG_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_RUNNERCONG_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_RUNNERCONG_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_RUNNERCONG_OFFSET )
#define BBH_RX_3_PM_COUNTERS_RUNNERCONG_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_RUNNERCONG_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_RUNNERCONG_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_RUNNERCONG_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_RUNNERCONG_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_RUNNERCONG_OFFSET )
#define BBH_RX_4_PM_COUNTERS_RUNNERCONG_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_RUNNERCONG_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_RUNNERCONG_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_RUNNERCONG_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_RUNNERCONG_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_RUNNERCONG_OFFSET )
#define BBH_RX_5_PM_COUNTERS_RUNNERCONG_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_RUNNERCONG_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_RUNNERCONG_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_RUNNERCONG_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_RUNNERCONG_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_RUNNERCONG_OFFSET )
#define BBH_RX_6_PM_COUNTERS_RUNNERCONG_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_RUNNERCONG_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_RUNNERCONG_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_RUNNERCONG_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_RUNNERCONG_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_RUNNERCONG_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_RUNNERCONG_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_RUNNERCONG_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_RUNNERCONG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_RUNNERCONG ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_RUNNERCONG ;
#endif

/*****************************************************************************************/
/* No_BPM_BN_error                                                                       */
/* This counter counts the packets drop due to No BPM BN error.  This counter is cleared */
/*  when read and freezes when reaches the maximum value.                                */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_NOBPMBN_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_NOBPMBN_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_NOBPMBN_OFFSET ( 0x00000020 )

#define BBH_RX_0_PM_COUNTERS_NOBPMBN_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBN_OFFSET )
#define BBH_RX_0_PM_COUNTERS_NOBPMBN_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_NOBPMBN_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_NOBPMBN_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_NOBPMBN_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_NOBPMBN_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBN_OFFSET )
#define BBH_RX_1_PM_COUNTERS_NOBPMBN_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_NOBPMBN_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_NOBPMBN_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_NOBPMBN_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_NOBPMBN_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBN_OFFSET )
#define BBH_RX_2_PM_COUNTERS_NOBPMBN_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_NOBPMBN_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_NOBPMBN_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_NOBPMBN_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_NOBPMBN_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBN_OFFSET )
#define BBH_RX_3_PM_COUNTERS_NOBPMBN_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_NOBPMBN_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_NOBPMBN_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_NOBPMBN_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_NOBPMBN_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBN_OFFSET )
#define BBH_RX_4_PM_COUNTERS_NOBPMBN_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_NOBPMBN_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_NOBPMBN_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_NOBPMBN_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_NOBPMBN_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBN_OFFSET )
#define BBH_RX_5_PM_COUNTERS_NOBPMBN_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_NOBPMBN_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_NOBPMBN_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_NOBPMBN_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_NOBPMBN_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBN_OFFSET )
#define BBH_RX_6_PM_COUNTERS_NOBPMBN_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_NOBPMBN_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_NOBPMBN_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_NOBPMBN_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_NOBPMBN_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_NOBPMBN_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_NOBPMBN_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_NOBPMBN_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_NOBPMBN_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_NOBPMBN ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_NOBPMBN ;
#endif

/*****************************************************************************************/
/* NO_SBPM_SBN_error                                                                     */
/* This counter counts the packets drop due to NO SBPM SBN error.  This counter is clear */
/* ed when read and freezes when reaches the maximum value.                              */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_NOSBPMSBN_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_NOSBPMSBN_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_NOSBPMSBN_OFFSET ( 0x00000024 )

#define BBH_RX_0_PM_COUNTERS_NOSBPMSBN_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSBPMSBN_OFFSET )
#define BBH_RX_0_PM_COUNTERS_NOSBPMSBN_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_NOSBPMSBN_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_NOSBPMSBN_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSBPMSBN_OFFSET )
#define BBH_RX_1_PM_COUNTERS_NOSBPMSBN_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_NOSBPMSBN_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_NOSBPMSBN_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSBPMSBN_OFFSET )
#define BBH_RX_2_PM_COUNTERS_NOSBPMSBN_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_NOSBPMSBN_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_NOSBPMSBN_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSBPMSBN_OFFSET )
#define BBH_RX_3_PM_COUNTERS_NOSBPMSBN_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_NOSBPMSBN_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_NOSBPMSBN_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSBPMSBN_OFFSET )
#define BBH_RX_4_PM_COUNTERS_NOSBPMSBN_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_NOSBPMSBN_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_NOSBPMSBN_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSBPMSBN_OFFSET )
#define BBH_RX_5_PM_COUNTERS_NOSBPMSBN_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_NOSBPMSBN_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_NOSBPMSBN_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSBPMSBN_OFFSET )
#define BBH_RX_6_PM_COUNTERS_NOSBPMSBN_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_NOSBPMSBN_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_NOSBPMSBN_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_NOSBPMSBN_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_NOSBPMSBN_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_NOSBPMSBN_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_NOSBPMSBN_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_NOSBPMSBN ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_NOSBPMSBN ;
#endif

/*****************************************************************************************/
/* No_DMA_CD_error                                                                       */
/* This counter counts the packets drop due to No DMA CD error.  This counter is cleared */
/*  when read and freezes when reaches the maximum value.                                */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_NODMACD_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_NODMACD_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_NODMACD_OFFSET ( 0x00000028 )

#define BBH_RX_0_PM_COUNTERS_NODMACD_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NODMACD_OFFSET )
#define BBH_RX_0_PM_COUNTERS_NODMACD_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_NODMACD_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_NODMACD_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_NODMACD_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_NODMACD_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NODMACD_OFFSET )
#define BBH_RX_1_PM_COUNTERS_NODMACD_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_NODMACD_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_NODMACD_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_NODMACD_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_NODMACD_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NODMACD_OFFSET )
#define BBH_RX_2_PM_COUNTERS_NODMACD_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_NODMACD_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_NODMACD_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_NODMACD_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_NODMACD_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NODMACD_OFFSET )
#define BBH_RX_3_PM_COUNTERS_NODMACD_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_NODMACD_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_NODMACD_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_NODMACD_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_NODMACD_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NODMACD_OFFSET )
#define BBH_RX_4_PM_COUNTERS_NODMACD_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_NODMACD_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_NODMACD_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_NODMACD_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_NODMACD_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NODMACD_OFFSET )
#define BBH_RX_5_PM_COUNTERS_NODMACD_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_NODMACD_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_NODMACD_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_NODMACD_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_NODMACD_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NODMACD_OFFSET )
#define BBH_RX_6_PM_COUNTERS_NODMACD_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_NODMACD_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_NODMACD_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_NODMACD_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_NODMACD_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_NODMACD_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_NODMACD_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_NODMACD_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_NODMACD_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_NODMACD ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_NODMACD ;
#endif

/*****************************************************************************************/
/* No_SDMA_CD_error                                                                      */
/* This counter counts the packets drop due to No SDMA CD error.  This counter is cleare */
/* d when read and freezes when reaches the maximum value.                               */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_NOSDMACD_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_NOSDMACD_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_NOSDMACD_OFFSET ( 0x0000002C )

#define BBH_RX_0_PM_COUNTERS_NOSDMACD_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSDMACD_OFFSET )
#define BBH_RX_0_PM_COUNTERS_NOSDMACD_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_NOSDMACD_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_NOSDMACD_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_NOSDMACD_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_NOSDMACD_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSDMACD_OFFSET )
#define BBH_RX_1_PM_COUNTERS_NOSDMACD_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_NOSDMACD_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_NOSDMACD_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_NOSDMACD_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_NOSDMACD_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSDMACD_OFFSET )
#define BBH_RX_2_PM_COUNTERS_NOSDMACD_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_NOSDMACD_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_NOSDMACD_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_NOSDMACD_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_NOSDMACD_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSDMACD_OFFSET )
#define BBH_RX_3_PM_COUNTERS_NOSDMACD_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_NOSDMACD_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_NOSDMACD_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_NOSDMACD_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_NOSDMACD_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSDMACD_OFFSET )
#define BBH_RX_4_PM_COUNTERS_NOSDMACD_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_NOSDMACD_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_NOSDMACD_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_NOSDMACD_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_NOSDMACD_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSDMACD_OFFSET )
#define BBH_RX_5_PM_COUNTERS_NOSDMACD_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_NOSDMACD_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_NOSDMACD_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_NOSDMACD_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_NOSDMACD_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSDMACD_OFFSET )
#define BBH_RX_6_PM_COUNTERS_NOSDMACD_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_NOSDMACD_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_NOSDMACD_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_NOSDMACD_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_NOSDMACD_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_NOSDMACD_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_NOSDMACD_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_NOSDMACD_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_NOSDMACD_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_NOSDMACD ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_NOSDMACD ;
#endif

/*****************************************************************************************/
/* IH_drop_ploam_error                                                                   */
/* This counter counts the PLOAMs drop due to Runner congestion or IPTV errors.  This co */
/* unter is cleared when read and freezes when reaches the maximum value.                */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_IHDROPPLOAM_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_IHDROPPLOAM_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_IHDROPPLOAM_OFFSET ( 0x00000030 )

#define BBH_RX_0_PM_COUNTERS_IHDROPPLOAM_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IHDROPPLOAM_OFFSET )
#define BBH_RX_0_PM_COUNTERS_IHDROPPLOAM_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_IHDROPPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_IHDROPPLOAM_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IHDROPPLOAM_OFFSET )
#define BBH_RX_1_PM_COUNTERS_IHDROPPLOAM_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_IHDROPPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_IHDROPPLOAM_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IHDROPPLOAM_OFFSET )
#define BBH_RX_2_PM_COUNTERS_IHDROPPLOAM_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_IHDROPPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_IHDROPPLOAM_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IHDROPPLOAM_OFFSET )
#define BBH_RX_3_PM_COUNTERS_IHDROPPLOAM_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_IHDROPPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_IHDROPPLOAM_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IHDROPPLOAM_OFFSET )
#define BBH_RX_4_PM_COUNTERS_IHDROPPLOAM_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_IHDROPPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_IHDROPPLOAM_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IHDROPPLOAM_OFFSET )
#define BBH_RX_5_PM_COUNTERS_IHDROPPLOAM_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_IHDROPPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_IHDROPPLOAM_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IHDROPPLOAM_OFFSET )
#define BBH_RX_6_PM_COUNTERS_IHDROPPLOAM_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_IHDROPPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_IHDROPPLOAM_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_IHDROPPLOAM_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_IHDROPPLOAM_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_IHDROPPLOAM_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_IHDROPPLOAM_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_IHDROPPLOAM ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_IHDROPPLOAM ;
#endif

/*****************************************************************************************/
/* No_BPM_BN_PLOAM_error                                                                 */
/* This counter counts the PLOAMs drop due to No BPM BN error.  This counter is cleared  */
/* when read and freezes when reaches the maximum value.                                 */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_OFFSET ( 0x00000034 )

#define BBH_RX_0_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_OFFSET )
#define BBH_RX_0_PM_COUNTERS_NOBPMBNPLOAM_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_NOBPMBNPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_OFFSET )
#define BBH_RX_1_PM_COUNTERS_NOBPMBNPLOAM_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_NOBPMBNPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_OFFSET )
#define BBH_RX_2_PM_COUNTERS_NOBPMBNPLOAM_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_NOBPMBNPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_OFFSET )
#define BBH_RX_3_PM_COUNTERS_NOBPMBNPLOAM_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_NOBPMBNPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_OFFSET )
#define BBH_RX_4_PM_COUNTERS_NOBPMBNPLOAM_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_NOBPMBNPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_OFFSET )
#define BBH_RX_5_PM_COUNTERS_NOBPMBNPLOAM_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_NOBPMBNPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_OFFSET )
#define BBH_RX_6_PM_COUNTERS_NOBPMBNPLOAM_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_NOBPMBNPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_NOBPMBNPLOAM ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_NOBPMBNPLOAM ;
#endif

/*****************************************************************************************/
/* CRC_PLOAM_error                                                                       */
/* This counter counts the PLOAMs drop due to CRC error.  This counter is cleared when r */
/* ead and freezes when reaches the maximum value.                                       */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_CRCERRORPLOAM_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_CRCERRORPLOAM_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_CRCERRORPLOAM_OFFSET ( 0x00000038 )

#define BBH_RX_0_PM_COUNTERS_CRCERRORPLOAM_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERRORPLOAM_OFFSET )
#define BBH_RX_0_PM_COUNTERS_CRCERRORPLOAM_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_CRCERRORPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_CRCERRORPLOAM_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERRORPLOAM_OFFSET )
#define BBH_RX_1_PM_COUNTERS_CRCERRORPLOAM_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_CRCERRORPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_CRCERRORPLOAM_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERRORPLOAM_OFFSET )
#define BBH_RX_2_PM_COUNTERS_CRCERRORPLOAM_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_CRCERRORPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_CRCERRORPLOAM_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERRORPLOAM_OFFSET )
#define BBH_RX_3_PM_COUNTERS_CRCERRORPLOAM_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_CRCERRORPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_CRCERRORPLOAM_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERRORPLOAM_OFFSET )
#define BBH_RX_4_PM_COUNTERS_CRCERRORPLOAM_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_CRCERRORPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_CRCERRORPLOAM_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERRORPLOAM_OFFSET )
#define BBH_RX_5_PM_COUNTERS_CRCERRORPLOAM_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_CRCERRORPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_CRCERRORPLOAM_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERRORPLOAM_OFFSET )
#define BBH_RX_6_PM_COUNTERS_CRCERRORPLOAM_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_CRCERRORPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_CRCERRORPLOAM_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_CRCERRORPLOAM_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_CRCERRORPLOAM_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_CRCERRORPLOAM_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_CRCERRORPLOAM_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_CRCERRORPLOAM ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_CRCERRORPLOAM ;
#endif

/*****************************************************************************************/
/* Epon_sync_fifo_overrun                                                                */
/* This counter counts the events of EPON sync FIFO overrun.  This counter is cleared wh */
/* en read and freezes when reaches the maximum value.                                   */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_EPNFIFOVERUN_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_EPNFIFOVERUN_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_EPNFIFOVERUN_OFFSET ( 0x0000003C )

#define BBH_RX_0_PM_COUNTERS_EPNFIFOVERUN_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVERUN_OFFSET )
#define BBH_RX_0_PM_COUNTERS_EPNFIFOVERUN_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_EPNFIFOVERUN_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_EPNFIFOVERUN_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVERUN_OFFSET )
#define BBH_RX_1_PM_COUNTERS_EPNFIFOVERUN_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_EPNFIFOVERUN_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_EPNFIFOVERUN_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVERUN_OFFSET )
#define BBH_RX_2_PM_COUNTERS_EPNFIFOVERUN_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_EPNFIFOVERUN_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_EPNFIFOVERUN_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVERUN_OFFSET )
#define BBH_RX_3_PM_COUNTERS_EPNFIFOVERUN_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_EPNFIFOVERUN_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_EPNFIFOVERUN_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVERUN_OFFSET )
#define BBH_RX_4_PM_COUNTERS_EPNFIFOVERUN_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_EPNFIFOVERUN_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_EPNFIFOVERUN_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVERUN_OFFSET )
#define BBH_RX_5_PM_COUNTERS_EPNFIFOVERUN_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_EPNFIFOVERUN_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_EPNFIFOVERUN_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVERUN_OFFSET )
#define BBH_RX_6_PM_COUNTERS_EPNFIFOVERUN_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_EPNFIFOVERUN_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_EPNFIFOVERUN_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_EPNFIFOVERUN_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_EPNFIFOVERUN_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_EPNFIFOVERUN_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_EPNFIFOVERUN_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_EPNFIFOVERUN ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_EPNFIFOVERUN ;
#endif

/*****************************************************************************************/
/* Epon_sync_fifo_overrun_hdr                                                            */
/* This counter counts the events of EPON sync FIFO overrun when header arrives.  This c */
/* ounter is cleared when read and freezes when reaches the maximum value.               */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_OFFSET ( 0x00000040 )

#define BBH_RX_0_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_OFFSET )
#define BBH_RX_0_PM_COUNTERS_EPNFIFOVRNHDR_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_EPNFIFOVRNHDR_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_OFFSET )
#define BBH_RX_1_PM_COUNTERS_EPNFIFOVRNHDR_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_EPNFIFOVRNHDR_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_OFFSET )
#define BBH_RX_2_PM_COUNTERS_EPNFIFOVRNHDR_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_EPNFIFOVRNHDR_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_OFFSET )
#define BBH_RX_3_PM_COUNTERS_EPNFIFOVRNHDR_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_EPNFIFOVRNHDR_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_OFFSET )
#define BBH_RX_4_PM_COUNTERS_EPNFIFOVRNHDR_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_EPNFIFOVRNHDR_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_OFFSET )
#define BBH_RX_5_PM_COUNTERS_EPNFIFOVRNHDR_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_EPNFIFOVRNHDR_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_OFFSET )
#define BBH_RX_6_PM_COUNTERS_EPNFIFOVRNHDR_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_EPNFIFOVRNHDR_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_EPNFIFOVRNHDR_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR ;
#endif

/*****************************************************************************************/
/* Epon_type_error                                                                       */
/* This counter counts the events of EPON type sequence which is wrong, meaning no sop a */
/* fter header, or sop/header in the middle of packet (before eop).  This counter is cle */
/* ared when read and freezes when reaches the maximum value.                            */
/*****************************************************************************************/

#define BBH_RX_PM_COUNTERS_EPONTYPERROR_PMVALUE_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PM_COUNTERS_EPONTYPERROR_PMVALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PM_COUNTERS_EPONTYPERROR_OFFSET ( 0x00000044 )

#define BBH_RX_0_PM_COUNTERS_EPONTYPERROR_ADDRESS   	( BBH_RX_0_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPONTYPERROR_OFFSET )
#define BBH_RX_0_PM_COUNTERS_EPONTYPERROR_READ( r ) 	READ_32( ( BBH_RX_0_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (r) )
#define BBH_RX_0_PM_COUNTERS_EPONTYPERROR_WRITE( v )	WRITE_32( ( BBH_RX_0_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (v) )

#define BBH_RX_1_PM_COUNTERS_EPONTYPERROR_ADDRESS   	( BBH_RX_1_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPONTYPERROR_OFFSET )
#define BBH_RX_1_PM_COUNTERS_EPONTYPERROR_READ( r ) 	READ_32( ( BBH_RX_1_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (r) )
#define BBH_RX_1_PM_COUNTERS_EPONTYPERROR_WRITE( v )	WRITE_32( ( BBH_RX_1_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (v) )

#define BBH_RX_2_PM_COUNTERS_EPONTYPERROR_ADDRESS   	( BBH_RX_2_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPONTYPERROR_OFFSET )
#define BBH_RX_2_PM_COUNTERS_EPONTYPERROR_READ( r ) 	READ_32( ( BBH_RX_2_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (r) )
#define BBH_RX_2_PM_COUNTERS_EPONTYPERROR_WRITE( v )	WRITE_32( ( BBH_RX_2_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (v) )

#define BBH_RX_3_PM_COUNTERS_EPONTYPERROR_ADDRESS   	( BBH_RX_3_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPONTYPERROR_OFFSET )
#define BBH_RX_3_PM_COUNTERS_EPONTYPERROR_READ( r ) 	READ_32( ( BBH_RX_3_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (r) )
#define BBH_RX_3_PM_COUNTERS_EPONTYPERROR_WRITE( v )	WRITE_32( ( BBH_RX_3_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (v) )

#define BBH_RX_4_PM_COUNTERS_EPONTYPERROR_ADDRESS   	( BBH_RX_4_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPONTYPERROR_OFFSET )
#define BBH_RX_4_PM_COUNTERS_EPONTYPERROR_READ( r ) 	READ_32( ( BBH_RX_4_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (r) )
#define BBH_RX_4_PM_COUNTERS_EPONTYPERROR_WRITE( v )	WRITE_32( ( BBH_RX_4_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (v) )

#define BBH_RX_5_PM_COUNTERS_EPONTYPERROR_ADDRESS   	( BBH_RX_5_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPONTYPERROR_OFFSET )
#define BBH_RX_5_PM_COUNTERS_EPONTYPERROR_READ( r ) 	READ_32( ( BBH_RX_5_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (r) )
#define BBH_RX_5_PM_COUNTERS_EPONTYPERROR_WRITE( v )	WRITE_32( ( BBH_RX_5_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (v) )

#define BBH_RX_6_PM_COUNTERS_EPONTYPERROR_ADDRESS   	( BBH_RX_6_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPONTYPERROR_OFFSET )
#define BBH_RX_6_PM_COUNTERS_EPONTYPERROR_READ( r ) 	READ_32( ( BBH_RX_6_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (r) )
#define BBH_RX_6_PM_COUNTERS_EPONTYPERROR_WRITE( v )	WRITE_32( ( BBH_RX_6_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (v) )


extern uint32_t BBH_RX_PM_COUNTERS_EPONTYPERROR_ARRAY [ ] ;

#define BBH_RX_PM_COUNTERS_EPONTYPERROR_WRITE( i, v )	WRITE_32( BBH_RX_PM_COUNTERS_EPONTYPERROR_ARRAY [ i ], (v) )
#define BBH_RX_PM_COUNTERS_EPONTYPERROR_READ( i, r ) 	READ_32( BBH_RX_PM_COUNTERS_EPONTYPERROR_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PM_counter_value */
	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_EPONTYPERROR ;
#else
typedef struct
{	uint32_t pmvalue	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PM_counter_value */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS_EPONTYPERROR ;
#endif

/*****************************************************************************************/
/* Context_0_LSB                                                                         */
/* In the case of GPON peripheral, DS flows may arrive interleaved. The BBH supports par */
/* allel reassembly of up to two interleaved flows (out of 256). For the reassembly proc */
/* ess the BBH stores a double flow context.                                             */
/*****************************************************************************************/

#define BBH_RX_DEBUG_CNTXTX0LSB_R2_DEFAULT_VALUE                            ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0LSB_R2_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0LSB_CUROFFSET_CURRENT_OFFSET_VALUE              ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0LSB_CUROFFSET_CURRENT_OFFSET_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0LSB_FLOWID_FLOW_ID_VALUE                        ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0LSB_FLOWID_FLOW_ID_VALUE_RESET_VALUE            ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0LSB_R1_DEFAULT_VALUE                            ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0LSB_R1_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0LSB_INREASS_NOT_IN_REASSEMBLY_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0LSB_INREASS_NOT_IN_REASSEMBLY_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0LSB_INREASS_IN_REASSEMBLY_VALUE                 ( 0x1 )


#define BBH_RX_DEBUG_CNTXTX0LSB_OFFSET ( 0x00000000 )

#define BBH_RX_0_DEBUG_CNTXTX0LSB_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0LSB_OFFSET )
#define BBH_RX_0_DEBUG_CNTXTX0LSB_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_CNTXTX0LSB_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_CNTXTX0LSB_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_CNTXTX0LSB_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_CNTXTX0LSB_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0LSB_OFFSET )
#define BBH_RX_1_DEBUG_CNTXTX0LSB_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_CNTXTX0LSB_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_CNTXTX0LSB_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_CNTXTX0LSB_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_CNTXTX0LSB_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0LSB_OFFSET )
#define BBH_RX_2_DEBUG_CNTXTX0LSB_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_CNTXTX0LSB_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_CNTXTX0LSB_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_CNTXTX0LSB_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_CNTXTX0LSB_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0LSB_OFFSET )
#define BBH_RX_3_DEBUG_CNTXTX0LSB_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_CNTXTX0LSB_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_CNTXTX0LSB_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_CNTXTX0LSB_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_CNTXTX0LSB_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0LSB_OFFSET )
#define BBH_RX_4_DEBUG_CNTXTX0LSB_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_CNTXTX0LSB_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_CNTXTX0LSB_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_CNTXTX0LSB_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_CNTXTX0LSB_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0LSB_OFFSET )
#define BBH_RX_5_DEBUG_CNTXTX0LSB_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_CNTXTX0LSB_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_CNTXTX0LSB_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_CNTXTX0LSB_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_CNTXTX0LSB_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0LSB_OFFSET )
#define BBH_RX_6_DEBUG_CNTXTX0LSB_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_CNTXTX0LSB_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_CNTXTX0LSB_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_CNTXTX0LSB_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_CNTXTX0LSB_ARRAY [ ] ;

#define BBH_RX_DEBUG_CNTXTX0LSB_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_CNTXTX0LSB_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_CNTXTX0LSB_READ( i, r ) 	READ_32( BBH_RX_DEBUG_CNTXTX0LSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_offset */
	uint32_t curoffset	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_ID */
	uint32_t flowid   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1       	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* In_reassembly */
	uint32_t inreass  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_CNTXTX0LSB ;
#else
typedef struct
{	uint32_t inreass  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* In_reassembly */
	uint32_t r1       	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t flowid   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_ID */
	uint32_t curoffset	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_offset */
	uint32_t r2       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_CNTXTX0LSB ;
#endif

/*****************************************************************************************/
/* Context_0_MSB                                                                         */
/* In the case of GPON peripheral, DS flows may arrive interleaved. The BBH supports par */
/* allel reassembly of up to two interleaved flows (out of 256). For the reassembly proc */
/* ess the BBH stores a double flow context.                                             */
/*****************************************************************************************/

#define BBH_RX_DEBUG_CNTXTX0MSB_R2_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0MSB_R2_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0MSB_FIRSTBN_BN_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0MSB_FIRSTBN_BN_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0MSB_R1_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0MSB_R1_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0MSB_CURBN_BN_VALUE               ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX0MSB_CURBN_BN_VALUE_RESET_VALUE   ( 0x0 )


#define BBH_RX_DEBUG_CNTXTX0MSB_OFFSET ( 0x00000004 )

#define BBH_RX_0_DEBUG_CNTXTX0MSB_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0MSB_OFFSET )
#define BBH_RX_0_DEBUG_CNTXTX0MSB_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_CNTXTX0MSB_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_CNTXTX0MSB_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_CNTXTX0MSB_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_CNTXTX0MSB_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0MSB_OFFSET )
#define BBH_RX_1_DEBUG_CNTXTX0MSB_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_CNTXTX0MSB_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_CNTXTX0MSB_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_CNTXTX0MSB_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_CNTXTX0MSB_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0MSB_OFFSET )
#define BBH_RX_2_DEBUG_CNTXTX0MSB_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_CNTXTX0MSB_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_CNTXTX0MSB_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_CNTXTX0MSB_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_CNTXTX0MSB_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0MSB_OFFSET )
#define BBH_RX_3_DEBUG_CNTXTX0MSB_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_CNTXTX0MSB_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_CNTXTX0MSB_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_CNTXTX0MSB_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_CNTXTX0MSB_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0MSB_OFFSET )
#define BBH_RX_4_DEBUG_CNTXTX0MSB_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_CNTXTX0MSB_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_CNTXTX0MSB_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_CNTXTX0MSB_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_CNTXTX0MSB_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0MSB_OFFSET )
#define BBH_RX_5_DEBUG_CNTXTX0MSB_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_CNTXTX0MSB_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_CNTXTX0MSB_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_CNTXTX0MSB_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_CNTXTX0MSB_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0MSB_OFFSET )
#define BBH_RX_6_DEBUG_CNTXTX0MSB_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_CNTXTX0MSB_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_CNTXTX0MSB_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_CNTXTX0MSB_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_CNTXTX0MSB_ARRAY [ ] ;

#define BBH_RX_DEBUG_CNTXTX0MSB_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_CNTXTX0MSB_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_CNTXTX0MSB_READ( i, r ) 	READ_32( BBH_RX_DEBUG_CNTXTX0MSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* First_BN */
	uint32_t firstbn	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_BN */
	uint32_t curbn  	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_CNTXTX0MSB ;
#else
typedef struct
{	uint32_t curbn  	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_BN */
	uint32_t r1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t firstbn	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* First_BN */
	uint32_t r2     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_CNTXTX0MSB ;
#endif

/*****************************************************************************************/
/* Context_1_LSB                                                                         */
/* In the case of GPON peripheral, DS flows may arrive interleaved. The BBH supports par */
/* allel reassembly of up to two interleaved flows (out of 256). For the reassembly proc */
/* ess the BBH stores a double flow context.                                             */
/*****************************************************************************************/

#define BBH_RX_DEBUG_CNTXTX1LSB_R2_DEFAULT_VALUE                            ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1LSB_R2_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1LSB_CUROFFSET_CURRENT_OFFSET_VALUE              ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1LSB_CUROFFSET_CURRENT_OFFSET_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1LSB_FLOWID_FLOW_ID_VALUE                        ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1LSB_FLOWID_FLOW_ID_VALUE_RESET_VALUE            ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1LSB_R1_DEFAULT_VALUE                            ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1LSB_R1_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1LSB_INREASS_NOT_IN_REASSEMBLY_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1LSB_INREASS_NOT_IN_REASSEMBLY_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1LSB_INREASS_IN_REASSEMBLY_VALUE                 ( 0x1 )


#define BBH_RX_DEBUG_CNTXTX1LSB_OFFSET ( 0x00000008 )

#define BBH_RX_0_DEBUG_CNTXTX1LSB_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1LSB_OFFSET )
#define BBH_RX_0_DEBUG_CNTXTX1LSB_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_CNTXTX1LSB_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_CNTXTX1LSB_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_CNTXTX1LSB_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_CNTXTX1LSB_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1LSB_OFFSET )
#define BBH_RX_1_DEBUG_CNTXTX1LSB_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_CNTXTX1LSB_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_CNTXTX1LSB_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_CNTXTX1LSB_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_CNTXTX1LSB_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1LSB_OFFSET )
#define BBH_RX_2_DEBUG_CNTXTX1LSB_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_CNTXTX1LSB_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_CNTXTX1LSB_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_CNTXTX1LSB_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_CNTXTX1LSB_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1LSB_OFFSET )
#define BBH_RX_3_DEBUG_CNTXTX1LSB_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_CNTXTX1LSB_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_CNTXTX1LSB_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_CNTXTX1LSB_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_CNTXTX1LSB_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1LSB_OFFSET )
#define BBH_RX_4_DEBUG_CNTXTX1LSB_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_CNTXTX1LSB_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_CNTXTX1LSB_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_CNTXTX1LSB_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_CNTXTX1LSB_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1LSB_OFFSET )
#define BBH_RX_5_DEBUG_CNTXTX1LSB_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_CNTXTX1LSB_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_CNTXTX1LSB_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_CNTXTX1LSB_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_CNTXTX1LSB_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1LSB_OFFSET )
#define BBH_RX_6_DEBUG_CNTXTX1LSB_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_CNTXTX1LSB_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_CNTXTX1LSB_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_CNTXTX1LSB_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_CNTXTX1LSB_ARRAY [ ] ;

#define BBH_RX_DEBUG_CNTXTX1LSB_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_CNTXTX1LSB_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_CNTXTX1LSB_READ( i, r ) 	READ_32( BBH_RX_DEBUG_CNTXTX1LSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_offset */
	uint32_t curoffset	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_ID */
	uint32_t flowid   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1       	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* In_reassembly */
	uint32_t inreass  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_CNTXTX1LSB ;
#else
typedef struct
{	uint32_t inreass  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* In_reassembly */
	uint32_t r1       	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t flowid   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_ID */
	uint32_t curoffset	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_offset */
	uint32_t r2       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_CNTXTX1LSB ;
#endif

/*****************************************************************************************/
/* Context_1_MSB                                                                         */
/* In the case of GPON peripheral, DS flows may arrive interleaved. The BBH supports par */
/* allel reassembly of up to two interleaved flows (out of 256). For the reassembly proc */
/* ess the BBH stores a double flow context.                                             */
/*****************************************************************************************/

#define BBH_RX_DEBUG_CNTXTX1MSB_R2_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1MSB_R2_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1MSB_FIRSTBN_BN_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1MSB_FIRSTBN_BN_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1MSB_R1_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1MSB_R1_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1MSB_CURBN_BN_VALUE               ( 0x0 )
#define BBH_RX_DEBUG_CNTXTX1MSB_CURBN_BN_VALUE_RESET_VALUE   ( 0x0 )


#define BBH_RX_DEBUG_CNTXTX1MSB_OFFSET ( 0x0000000C )

#define BBH_RX_0_DEBUG_CNTXTX1MSB_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1MSB_OFFSET )
#define BBH_RX_0_DEBUG_CNTXTX1MSB_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_CNTXTX1MSB_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_CNTXTX1MSB_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_CNTXTX1MSB_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_CNTXTX1MSB_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1MSB_OFFSET )
#define BBH_RX_1_DEBUG_CNTXTX1MSB_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_CNTXTX1MSB_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_CNTXTX1MSB_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_CNTXTX1MSB_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_CNTXTX1MSB_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1MSB_OFFSET )
#define BBH_RX_2_DEBUG_CNTXTX1MSB_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_CNTXTX1MSB_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_CNTXTX1MSB_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_CNTXTX1MSB_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_CNTXTX1MSB_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1MSB_OFFSET )
#define BBH_RX_3_DEBUG_CNTXTX1MSB_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_CNTXTX1MSB_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_CNTXTX1MSB_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_CNTXTX1MSB_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_CNTXTX1MSB_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1MSB_OFFSET )
#define BBH_RX_4_DEBUG_CNTXTX1MSB_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_CNTXTX1MSB_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_CNTXTX1MSB_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_CNTXTX1MSB_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_CNTXTX1MSB_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1MSB_OFFSET )
#define BBH_RX_5_DEBUG_CNTXTX1MSB_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_CNTXTX1MSB_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_CNTXTX1MSB_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_CNTXTX1MSB_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_CNTXTX1MSB_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1MSB_OFFSET )
#define BBH_RX_6_DEBUG_CNTXTX1MSB_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_CNTXTX1MSB_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_CNTXTX1MSB_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_CNTXTX1MSB_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_CNTXTX1MSB_ARRAY [ ] ;

#define BBH_RX_DEBUG_CNTXTX1MSB_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_CNTXTX1MSB_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_CNTXTX1MSB_READ( i, r ) 	READ_32( BBH_RX_DEBUG_CNTXTX1MSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* First_BN */
	uint32_t firstbn	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_BN */
	uint32_t curbn  	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_CNTXTX1MSB ;
#else
typedef struct
{	uint32_t curbn  	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_BN */
	uint32_t r1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t firstbn	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* First_BN */
	uint32_t r2     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_CNTXTX1MSB ;
#endif

/*****************************************************************************************/
/* IH_context_0                                                                          */
/* In the case of GPON peripheral, DS flows may arrive interleaved. The BBH supports par */
/* allel reassembly of up to two interleaved flows (out of 256). For the reassembly proc */
/* ess the BBH stores a double flow context.                                             */
/*****************************************************************************************/

#define BBH_RX_DEBUG_IHCNTXT0_R2_DEFAULT_VALUE                             ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_R2_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_CUROFFSET_CURRENT_OFFSET_VALUE               ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_CUROFFSET_CURRENT_OFFSET_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_FLOWID_FLOW_ID_VALUE                         ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_FLOWID_FLOW_ID_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_BUFNUM_BUFFER_NUMBER_VALUE                   ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_BUFNUM_BUFFER_NUMBER_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_R1_DEFAULT_VALUE                             ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_R1_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_BUFVALID_NOT_IN_REASSEMBLY_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_BUFVALID_NOT_IN_REASSEMBLY_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_BUFVALID_IN_REASSEMBLY_VALUE                 ( 0x1 )
#define BBH_RX_DEBUG_IHCNTXT0_INREASS_NOT_IN_REASSEMBLY_VALUE              ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_INREASS_NOT_IN_REASSEMBLY_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT0_INREASS_IN_REASSEMBLY_VALUE                  ( 0x1 )


#define BBH_RX_DEBUG_IHCNTXT0_OFFSET ( 0x00000010 )

#define BBH_RX_0_DEBUG_IHCNTXT0_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT0_OFFSET )
#define BBH_RX_0_DEBUG_IHCNTXT0_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_IHCNTXT0_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_IHCNTXT0_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_IHCNTXT0_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_IHCNTXT0_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT0_OFFSET )
#define BBH_RX_1_DEBUG_IHCNTXT0_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_IHCNTXT0_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_IHCNTXT0_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_IHCNTXT0_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_IHCNTXT0_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT0_OFFSET )
#define BBH_RX_2_DEBUG_IHCNTXT0_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_IHCNTXT0_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_IHCNTXT0_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_IHCNTXT0_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_IHCNTXT0_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT0_OFFSET )
#define BBH_RX_3_DEBUG_IHCNTXT0_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_IHCNTXT0_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_IHCNTXT0_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_IHCNTXT0_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_IHCNTXT0_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT0_OFFSET )
#define BBH_RX_4_DEBUG_IHCNTXT0_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_IHCNTXT0_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_IHCNTXT0_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_IHCNTXT0_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_IHCNTXT0_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT0_OFFSET )
#define BBH_RX_5_DEBUG_IHCNTXT0_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_IHCNTXT0_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_IHCNTXT0_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_IHCNTXT0_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_IHCNTXT0_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT0_OFFSET )
#define BBH_RX_6_DEBUG_IHCNTXT0_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_IHCNTXT0_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_IHCNTXT0_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_IHCNTXT0_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_IHCNTXT0_ARRAY [ ] ;

#define BBH_RX_DEBUG_IHCNTXT0_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_IHCNTXT0_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_IHCNTXT0_READ( i, r ) 	READ_32( BBH_RX_DEBUG_IHCNTXT0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_offset */
	uint32_t curoffset	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_ID */
	uint32_t flowid   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_number */
	uint32_t bufnum   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_valid */
	uint32_t bufvalid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* In_reassembly */
	uint32_t inreass  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_IHCNTXT0 ;
#else
typedef struct
{	uint32_t inreass  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* In_reassembly */
	uint32_t bufvalid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_valid */
	uint32_t r1       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t bufnum   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_number */
	uint32_t flowid   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_ID */
	uint32_t curoffset	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_offset */
	uint32_t r2       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_IHCNTXT0 ;
#endif

/*****************************************************************************************/
/* IH_context_1                                                                          */
/* In the case of GPON peripheral, DS flows may arrive interleaved. The BBH supports par */
/* allel reassembly of up to two interleaved flows (out of 256). For the reassembly proc */
/* ess the BBH stores a double flow context.                                             */
/*****************************************************************************************/

#define BBH_RX_DEBUG_IHCNTXT1_R2_DEFAULT_VALUE                             ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_R2_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_CUROFFSET_CURRENT_OFFSET_VALUE               ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_CUROFFSET_CURRENT_OFFSET_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_FLOWID_FLOW_ID_VALUE                         ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_FLOWID_FLOW_ID_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_BUFNUM_BUFFER_NUMBER_VALUE                   ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_BUFNUM_BUFFER_NUMBER_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_R1_DEFAULT_VALUE                             ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_R1_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_BUFVALID_NOT_IN_REASSEMBLY_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_BUFVALID_NOT_IN_REASSEMBLY_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_BUFVALID_IN_REASSEMBLY_VALUE                 ( 0x1 )
#define BBH_RX_DEBUG_IHCNTXT1_INREASS_NOT_IN_REASSEMBLY_VALUE              ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_INREASS_NOT_IN_REASSEMBLY_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXT1_INREASS_IN_REASSEMBLY_VALUE                  ( 0x1 )


#define BBH_RX_DEBUG_IHCNTXT1_OFFSET ( 0x00000014 )

#define BBH_RX_0_DEBUG_IHCNTXT1_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT1_OFFSET )
#define BBH_RX_0_DEBUG_IHCNTXT1_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_IHCNTXT1_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_IHCNTXT1_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_IHCNTXT1_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_IHCNTXT1_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT1_OFFSET )
#define BBH_RX_1_DEBUG_IHCNTXT1_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_IHCNTXT1_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_IHCNTXT1_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_IHCNTXT1_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_IHCNTXT1_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT1_OFFSET )
#define BBH_RX_2_DEBUG_IHCNTXT1_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_IHCNTXT1_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_IHCNTXT1_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_IHCNTXT1_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_IHCNTXT1_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT1_OFFSET )
#define BBH_RX_3_DEBUG_IHCNTXT1_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_IHCNTXT1_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_IHCNTXT1_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_IHCNTXT1_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_IHCNTXT1_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT1_OFFSET )
#define BBH_RX_4_DEBUG_IHCNTXT1_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_IHCNTXT1_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_IHCNTXT1_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_IHCNTXT1_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_IHCNTXT1_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT1_OFFSET )
#define BBH_RX_5_DEBUG_IHCNTXT1_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_IHCNTXT1_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_IHCNTXT1_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_IHCNTXT1_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_IHCNTXT1_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT1_OFFSET )
#define BBH_RX_6_DEBUG_IHCNTXT1_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_IHCNTXT1_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_IHCNTXT1_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_IHCNTXT1_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_IHCNTXT1_ARRAY [ ] ;

#define BBH_RX_DEBUG_IHCNTXT1_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_IHCNTXT1_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_IHCNTXT1_READ( i, r ) 	READ_32( BBH_RX_DEBUG_IHCNTXT1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_offset */
	uint32_t curoffset	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_ID */
	uint32_t flowid   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_number */
	uint32_t bufnum   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_valid */
	uint32_t bufvalid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* In_reassembly */
	uint32_t inreass  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_IHCNTXT1 ;
#else
typedef struct
{	uint32_t inreass  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* In_reassembly */
	uint32_t bufvalid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_valid */
	uint32_t r1       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t bufnum   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_number */
	uint32_t flowid   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_ID */
	uint32_t curoffset	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_offset */
	uint32_t r2       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_IHCNTXT1 ;
#endif

/*****************************************************************************************/
/* IH_context_PLOAM                                                                      */
/* In the case of GPON peripheral, DS flows may arrive interleaved. The BBH supports par */
/* allel reassembly of up to two interleaved flows (out of 256). For the reassembly proc */
/* ess the BBH stores a double flow context.                                             */
/*****************************************************************************************/

#define BBH_RX_DEBUG_IHCNTXTP_R2_DEFAULT_VALUE                             ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_R2_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_CUROFFSET_CURRENT_OFFSET_VALUE               ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_CUROFFSET_CURRENT_OFFSET_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_FLOWID_FLOW_ID_VALUE                         ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_FLOWID_FLOW_ID_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_BUFNUM_BUFFER_NUMBER_VALUE                   ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_BUFNUM_BUFFER_NUMBER_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_R1_DEFAULT_VALUE                             ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_R1_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_BUFVALID_NOT_IN_REASSEMBLY_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_BUFVALID_NOT_IN_REASSEMBLY_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_BUFVALID_IN_REASSEMBLY_VALUE                 ( 0x1 )
#define BBH_RX_DEBUG_IHCNTXTP_INREASS_NOT_IN_REASSEMBLY_VALUE              ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_INREASS_NOT_IN_REASSEMBLY_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_DEBUG_IHCNTXTP_INREASS_IN_REASSEMBLY_VALUE                  ( 0x1 )


#define BBH_RX_DEBUG_IHCNTXTP_OFFSET ( 0x00000018 )

#define BBH_RX_0_DEBUG_IHCNTXTP_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXTP_OFFSET )
#define BBH_RX_0_DEBUG_IHCNTXTP_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_IHCNTXTP_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_IHCNTXTP_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_IHCNTXTP_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_IHCNTXTP_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXTP_OFFSET )
#define BBH_RX_1_DEBUG_IHCNTXTP_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_IHCNTXTP_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_IHCNTXTP_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_IHCNTXTP_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_IHCNTXTP_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXTP_OFFSET )
#define BBH_RX_2_DEBUG_IHCNTXTP_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_IHCNTXTP_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_IHCNTXTP_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_IHCNTXTP_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_IHCNTXTP_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXTP_OFFSET )
#define BBH_RX_3_DEBUG_IHCNTXTP_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_IHCNTXTP_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_IHCNTXTP_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_IHCNTXTP_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_IHCNTXTP_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXTP_OFFSET )
#define BBH_RX_4_DEBUG_IHCNTXTP_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_IHCNTXTP_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_IHCNTXTP_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_IHCNTXTP_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_IHCNTXTP_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXTP_OFFSET )
#define BBH_RX_5_DEBUG_IHCNTXTP_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_IHCNTXTP_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_IHCNTXTP_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_IHCNTXTP_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_IHCNTXTP_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXTP_OFFSET )
#define BBH_RX_6_DEBUG_IHCNTXTP_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_IHCNTXTP_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_IHCNTXTP_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_IHCNTXTP_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_IHCNTXTP_ARRAY [ ] ;

#define BBH_RX_DEBUG_IHCNTXTP_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_IHCNTXTP_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_IHCNTXTP_READ( i, r ) 	READ_32( BBH_RX_DEBUG_IHCNTXTP_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_offset */
	uint32_t curoffset	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_ID */
	uint32_t flowid   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_number */
	uint32_t bufnum   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_valid */
	uint32_t bufvalid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* In_reassembly */
	uint32_t inreass  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_IHCNTXTP ;
#else
typedef struct
{	uint32_t inreass  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* In_reassembly */
	uint32_t bufvalid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_valid */
	uint32_t r1       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t bufnum   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_number */
	uint32_t flowid   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_ID */
	uint32_t curoffset	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Current_offset */
	uint32_t r2       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_IHCNTXTP ;
#endif

/*****************************************************************************************/
/* IH_free_buffer                                                                        */
/* This array describes the status of the 16 IH buffers - free = 1, occupied = 0.        */
/*****************************************************************************************/

#define BBH_RX_DEBUG_IHFREEBUF_R1_RESET_VALUE_VALUE                ( 0x0 )
#define BBH_RX_DEBUG_IHFREEBUF_R1_RESET_VALUE_VALUE_RESET_VALUE    ( 0x0 )
#define BBH_RX_DEBUG_IHFREEBUF_IHFREEBUF_BUFFREE_VALUE             ( 0xFFFF )
#define BBH_RX_DEBUG_IHFREEBUF_IHFREEBUF_BUFFREE_VALUE_RESET_VALUE ( 0xFFFF )


#define BBH_RX_DEBUG_IHFREEBUF_OFFSET ( 0x0000001C )

#define BBH_RX_0_DEBUG_IHFREEBUF_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_IHFREEBUF_OFFSET )
#define BBH_RX_0_DEBUG_IHFREEBUF_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_IHFREEBUF_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_IHFREEBUF_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_IHFREEBUF_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_IHFREEBUF_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_IHFREEBUF_OFFSET )
#define BBH_RX_1_DEBUG_IHFREEBUF_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_IHFREEBUF_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_IHFREEBUF_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_IHFREEBUF_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_IHFREEBUF_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_IHFREEBUF_OFFSET )
#define BBH_RX_2_DEBUG_IHFREEBUF_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_IHFREEBUF_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_IHFREEBUF_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_IHFREEBUF_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_IHFREEBUF_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_IHFREEBUF_OFFSET )
#define BBH_RX_3_DEBUG_IHFREEBUF_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_IHFREEBUF_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_IHFREEBUF_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_IHFREEBUF_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_IHFREEBUF_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_IHFREEBUF_OFFSET )
#define BBH_RX_4_DEBUG_IHFREEBUF_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_IHFREEBUF_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_IHFREEBUF_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_IHFREEBUF_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_IHFREEBUF_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_IHFREEBUF_OFFSET )
#define BBH_RX_5_DEBUG_IHFREEBUF_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_IHFREEBUF_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_IHFREEBUF_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_IHFREEBUF_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_IHFREEBUF_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_IHFREEBUF_OFFSET )
#define BBH_RX_6_DEBUG_IHFREEBUF_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_IHFREEBUF_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_IHFREEBUF_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_IHFREEBUF_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_IHFREEBUF_ARRAY [ ] ;

#define BBH_RX_DEBUG_IHFREEBUF_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_IHFREEBUF_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_IHFREEBUF_READ( i, r ) 	READ_32( BBH_RX_DEBUG_IHFREEBUF_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1       	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_free_buffer */
	uint32_t ihfreebuf	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_IHFREEBUF ;
#else
typedef struct
{	uint32_t ihfreebuf	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_free_buffer */
	uint32_t r1       	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_IHFREEBUF ;
#endif

/*****************************************************************************************/
/* Pre_wakeup_fifo_used_words                                                            */
/* Pre wakeup FIFO used words                                                            */
/*****************************************************************************************/

#define BBH_RX_DEBUG_PWUW_R1_RESET_VALUE_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_PWUW_R1_RESET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_PWUW_UW_RESET_VALUE_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_PWUW_UW_RESET_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_DEBUG_PWUW_OFFSET ( 0x00000020 )

#define BBH_RX_0_DEBUG_PWUW_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_PWUW_OFFSET )
#define BBH_RX_0_DEBUG_PWUW_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_PWUW_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_PWUW_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_PWUW_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_PWUW_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_PWUW_OFFSET )
#define BBH_RX_1_DEBUG_PWUW_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_PWUW_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_PWUW_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_PWUW_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_PWUW_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_PWUW_OFFSET )
#define BBH_RX_2_DEBUG_PWUW_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_PWUW_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_PWUW_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_PWUW_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_PWUW_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_PWUW_OFFSET )
#define BBH_RX_3_DEBUG_PWUW_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_PWUW_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_PWUW_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_PWUW_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_PWUW_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_PWUW_OFFSET )
#define BBH_RX_4_DEBUG_PWUW_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_PWUW_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_PWUW_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_PWUW_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_PWUW_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_PWUW_OFFSET )
#define BBH_RX_5_DEBUG_PWUW_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_PWUW_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_PWUW_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_PWUW_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_PWUW_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_PWUW_OFFSET )
#define BBH_RX_6_DEBUG_PWUW_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_PWUW_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_PWUW_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_PWUW_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_PWUW_ARRAY [ ] ;

#define BBH_RX_DEBUG_PWUW_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_PWUW_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_PWUW_READ( i, r ) 	READ_32( BBH_RX_DEBUG_PWUW_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Used_words */
	uint32_t uw	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_PWUW ;
#else
typedef struct
{	uint32_t uw	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Used_words */
	uint32_t r1	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_PWUW ;
#endif

/*****************************************************************************************/
/* ACK_counters                                                                          */
/* The register reflects 3 ACK counters:  DMA  SDMA  CONNECT                             */
/*****************************************************************************************/

#define BBH_RX_DEBUG_ACKCNT_R1_RESET_VALUE_VALUE                  ( 0x0 )
#define BBH_RX_DEBUG_ACKCNT_R1_RESET_VALUE_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_DEBUG_ACKCNT_CONNECT_RESET_VALUE_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_ACKCNT_CONNECT_RESET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_ACKCNT_SDMA_RESET_VALUE_VALUE                ( 0x0 )
#define BBH_RX_DEBUG_ACKCNT_SDMA_RESET_VALUE_VALUE_RESET_VALUE    ( 0x0 )
#define BBH_RX_DEBUG_ACKCNT_DMA_RESET_VALUE_VALUE                 ( 0x0 )
#define BBH_RX_DEBUG_ACKCNT_DMA_RESET_VALUE_VALUE_RESET_VALUE     ( 0x0 )


#define BBH_RX_DEBUG_ACKCNT_OFFSET ( 0x00000024 )

#define BBH_RX_0_DEBUG_ACKCNT_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_ACKCNT_OFFSET )
#define BBH_RX_0_DEBUG_ACKCNT_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_ACKCNT_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_ACKCNT_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_ACKCNT_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_ACKCNT_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_ACKCNT_OFFSET )
#define BBH_RX_1_DEBUG_ACKCNT_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_ACKCNT_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_ACKCNT_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_ACKCNT_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_ACKCNT_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_ACKCNT_OFFSET )
#define BBH_RX_2_DEBUG_ACKCNT_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_ACKCNT_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_ACKCNT_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_ACKCNT_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_ACKCNT_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_ACKCNT_OFFSET )
#define BBH_RX_3_DEBUG_ACKCNT_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_ACKCNT_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_ACKCNT_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_ACKCNT_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_ACKCNT_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_ACKCNT_OFFSET )
#define BBH_RX_4_DEBUG_ACKCNT_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_ACKCNT_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_ACKCNT_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_ACKCNT_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_ACKCNT_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_ACKCNT_OFFSET )
#define BBH_RX_5_DEBUG_ACKCNT_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_ACKCNT_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_ACKCNT_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_ACKCNT_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_ACKCNT_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_ACKCNT_OFFSET )
#define BBH_RX_6_DEBUG_ACKCNT_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_ACKCNT_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_ACKCNT_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_ACKCNT_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_ACKCNT_ARRAY [ ] ;

#define BBH_RX_DEBUG_ACKCNT_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_ACKCNT_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_ACKCNT_READ( i, r ) 	READ_32( BBH_RX_DEBUG_ACKCNT_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1     	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Connect */
	uint32_t connect	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA */
	uint32_t sdma   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA */
	uint32_t dma    	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_ACKCNT ;
#else
typedef struct
{	uint32_t dma    	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA */
	uint32_t sdma   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA */
	uint32_t connect	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Connect */
	uint32_t r1     	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_ACKCNT ;
#endif

/*****************************************************************************************/
/* Runner_counters                                                                       */
/* The register reflects 4 Runner pending descriptors counters:  Runner 0 normal  Runner */
/*  0 direct  Runner 1 normal  Runner 1 direct                                           */
/*****************************************************************************************/

#define BBH_RX_DEBUG_RNRCNT_R4_RESET_VALUE_VALUE              ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R4_RESET_VALUE_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R1D_RESET_VALUE_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R1D_RESET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R3_RESET_VALUE_VALUE              ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R3_RESET_VALUE_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R1N_RESET_VALUE_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R1N_RESET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R2_RESET_VALUE_VALUE              ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R2_RESET_VALUE_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R0D_RESET_VALUE_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R0D_RESET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R1_RESET_VALUE_VALUE              ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R1_RESET_VALUE_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R0N_RESET_VALUE_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_RNRCNT_R0N_RESET_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_DEBUG_RNRCNT_OFFSET ( 0x00000028 )

#define BBH_RX_0_DEBUG_RNRCNT_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_RNRCNT_OFFSET )
#define BBH_RX_0_DEBUG_RNRCNT_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_RNRCNT_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_RNRCNT_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_RNRCNT_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_RNRCNT_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_RNRCNT_OFFSET )
#define BBH_RX_1_DEBUG_RNRCNT_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_RNRCNT_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_RNRCNT_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_RNRCNT_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_RNRCNT_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_RNRCNT_OFFSET )
#define BBH_RX_2_DEBUG_RNRCNT_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_RNRCNT_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_RNRCNT_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_RNRCNT_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_RNRCNT_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_RNRCNT_OFFSET )
#define BBH_RX_3_DEBUG_RNRCNT_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_RNRCNT_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_RNRCNT_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_RNRCNT_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_RNRCNT_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_RNRCNT_OFFSET )
#define BBH_RX_4_DEBUG_RNRCNT_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_RNRCNT_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_RNRCNT_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_RNRCNT_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_RNRCNT_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_RNRCNT_OFFSET )
#define BBH_RX_5_DEBUG_RNRCNT_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_RNRCNT_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_RNRCNT_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_RNRCNT_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_RNRCNT_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_RNRCNT_OFFSET )
#define BBH_RX_6_DEBUG_RNRCNT_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_RNRCNT_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_RNRCNT_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_RNRCNT_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_RNRCNT_ARRAY [ ] ;

#define BBH_RX_DEBUG_RNRCNT_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_RNRCNT_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_RNRCNT_READ( i, r ) 	READ_32( BBH_RX_DEBUG_RNRCNT_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_1_direct */
	uint32_t r1d	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_1_normal */
	uint32_t r1n	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_0_direct */
	uint32_t r0d	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_0_normal */
	uint32_t r0n	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_RNRCNT ;
#else
typedef struct
{	uint32_t r0n	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_0_normal */
	uint32_t r1 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r0d	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_0_direct */
	uint32_t r2 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1n	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_1_normal */
	uint32_t r3 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1d	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_1_direct */
	uint32_t r4 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_RNRCNT ;
#endif

/*****************************************************************************************/
/* Debug_vector                                                                          */
/* selected debug vector                                                                 */
/*****************************************************************************************/

#define BBH_RX_DEBUG_DBGVEC_R1_RESET_VALUE_VALUE                 ( 0x0 )
#define BBH_RX_DEBUG_DBGVEC_R1_RESET_VALUE_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_RX_DEBUG_DBGVEC_DBGVEC_RESET_VALUE_VALUE             ( 0x11000 )
#define BBH_RX_DEBUG_DBGVEC_DBGVEC_RESET_VALUE_VALUE_RESET_VALUE ( 0x11000 )


#define BBH_RX_DEBUG_DBGVEC_OFFSET ( 0x0000002C )

#define BBH_RX_0_DEBUG_DBGVEC_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_DBGVEC_OFFSET )
#define BBH_RX_0_DEBUG_DBGVEC_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_DBGVEC_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_DBGVEC_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_DBGVEC_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_DBGVEC_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_DBGVEC_OFFSET )
#define BBH_RX_1_DEBUG_DBGVEC_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_DBGVEC_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_DBGVEC_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_DBGVEC_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_DBGVEC_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_DBGVEC_OFFSET )
#define BBH_RX_2_DEBUG_DBGVEC_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_DBGVEC_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_DBGVEC_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_DBGVEC_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_DBGVEC_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_DBGVEC_OFFSET )
#define BBH_RX_3_DEBUG_DBGVEC_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_DBGVEC_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_DBGVEC_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_DBGVEC_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_DBGVEC_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_DBGVEC_OFFSET )
#define BBH_RX_4_DEBUG_DBGVEC_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_DBGVEC_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_DBGVEC_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_DBGVEC_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_DBGVEC_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_DBGVEC_OFFSET )
#define BBH_RX_5_DEBUG_DBGVEC_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_DBGVEC_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_DBGVEC_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_DBGVEC_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_DBGVEC_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_DBGVEC_OFFSET )
#define BBH_RX_6_DEBUG_DBGVEC_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_DBGVEC_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_DBGVEC_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_DBGVEC_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_DBGVEC_ARRAY [ ] ;

#define BBH_RX_DEBUG_DBGVEC_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_DBGVEC_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_DBGVEC_READ( i, r ) 	READ_32( BBH_RX_DEBUG_DBGVEC_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1    	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Debug_vector */
	uint32_t dbgvec	: 21 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_DBGVEC ;
#else
typedef struct
{	uint32_t dbgvec	: 21 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Debug_vector */
	uint32_t r1    	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_DBGVEC ;
#endif

/*****************************************************************************************/
/* DDR_BN_FIFO                                                                           */
/* The BBH RX hold a FIFO with 8 BN.                                                     */
/*****************************************************************************************/

#define BBH_RX_DEBUG_BNFIFO_R2_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_DEBUG_BNFIFO_R2_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_DEBUG_BNFIFO_VALID_NOT_VALID_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_BNFIFO_VALID_NOT_VALID_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_BNFIFO_VALID_VALID_VALUE                 ( 0x1 )
#define BBH_RX_DEBUG_BNFIFO_R1_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_DEBUG_BNFIFO_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_DEBUG_BNFIFO_BNENTRY_BN_VALUE                  ( 0x0 )
#define BBH_RX_DEBUG_BNFIFO_BNENTRY_BN_VALUE_RESET_VALUE      ( 0x0 )


#define BBH_RX_DEBUG_BNFIFO_OFFSET ( 0x00000030 )

#define BBH_RX_0_DEBUG_BNFIFO_ADDRESS        	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_BNFIFO_OFFSET )
#define BBH_RX_0_DEBUG_BNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_0_DEBUG_BNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_0_DEBUG_BNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_0_DEBUG_BNFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_1_DEBUG_BNFIFO_ADDRESS        	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_BNFIFO_OFFSET )
#define BBH_RX_1_DEBUG_BNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_1_DEBUG_BNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_1_DEBUG_BNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_1_DEBUG_BNFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_2_DEBUG_BNFIFO_ADDRESS        	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_BNFIFO_OFFSET )
#define BBH_RX_2_DEBUG_BNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_2_DEBUG_BNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_2_DEBUG_BNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_2_DEBUG_BNFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_3_DEBUG_BNFIFO_ADDRESS        	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_BNFIFO_OFFSET )
#define BBH_RX_3_DEBUG_BNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_3_DEBUG_BNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_3_DEBUG_BNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_3_DEBUG_BNFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_4_DEBUG_BNFIFO_ADDRESS        	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_BNFIFO_OFFSET )
#define BBH_RX_4_DEBUG_BNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_4_DEBUG_BNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_4_DEBUG_BNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_4_DEBUG_BNFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_5_DEBUG_BNFIFO_ADDRESS        	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_BNFIFO_OFFSET )
#define BBH_RX_5_DEBUG_BNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_5_DEBUG_BNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_5_DEBUG_BNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_5_DEBUG_BNFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_6_DEBUG_BNFIFO_ADDRESS        	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_BNFIFO_OFFSET )
#define BBH_RX_6_DEBUG_BNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_6_DEBUG_BNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_6_DEBUG_BNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_6_DEBUG_BNFIFO_ADDRESS ), (i), (v) )


extern uint32_t BBH_RX_DEBUG_BNFIFO_ARRAY [ ] ;

#define BBH_RX_DEBUG_BNFIFO_WRITE( i, k, v )	WRITE_I_32( BBH_RX_DEBUG_BNFIFO_ARRAY [ i ], (k), (v) )
#define BBH_RX_DEBUG_BNFIFO_READ( i, k, r ) 	READ_I_32( BBH_RX_DEBUG_BNFIFO_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2     	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VALID */
	uint32_t valid  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BN_entry */
	uint32_t bnentry	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_BNFIFO ;
#else
typedef struct
{	uint32_t bnentry	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BN_entry */
	uint32_t r1     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t valid  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VALID */
	uint32_t r2     	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_BNFIFO ;
#endif

/*****************************************************************************************/
/* SRAM_BN_FIFO                                                                          */
/* The BBH RX hold a FIFO with 8 BN.                                                     */
/*****************************************************************************************/

#define BBH_RX_DEBUG_SBNFIFO_R2_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_DEBUG_SBNFIFO_R2_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_DEBUG_SBNFIFO_VALID_NOT_VALID_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_SBNFIFO_VALID_NOT_VALID_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_SBNFIFO_VALID_VALID_VALUE                 ( 0x1 )
#define BBH_RX_DEBUG_SBNFIFO_R1_DEFAULT_VALUE                  ( 0x0 )
#define BBH_RX_DEBUG_SBNFIFO_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_RX_DEBUG_SBNFIFO_BNENTRY_BN_VALUE                  ( 0x0 )
#define BBH_RX_DEBUG_SBNFIFO_BNENTRY_BN_VALUE_RESET_VALUE      ( 0x0 )


#define BBH_RX_DEBUG_SBNFIFO_OFFSET ( 0x00000050 )

#define BBH_RX_0_DEBUG_SBNFIFO_ADDRESS        	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_SBNFIFO_OFFSET )
#define BBH_RX_0_DEBUG_SBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_0_DEBUG_SBNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_0_DEBUG_SBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_0_DEBUG_SBNFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_1_DEBUG_SBNFIFO_ADDRESS        	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_SBNFIFO_OFFSET )
#define BBH_RX_1_DEBUG_SBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_1_DEBUG_SBNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_1_DEBUG_SBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_1_DEBUG_SBNFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_2_DEBUG_SBNFIFO_ADDRESS        	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_SBNFIFO_OFFSET )
#define BBH_RX_2_DEBUG_SBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_2_DEBUG_SBNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_2_DEBUG_SBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_2_DEBUG_SBNFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_3_DEBUG_SBNFIFO_ADDRESS        	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_SBNFIFO_OFFSET )
#define BBH_RX_3_DEBUG_SBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_3_DEBUG_SBNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_3_DEBUG_SBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_3_DEBUG_SBNFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_4_DEBUG_SBNFIFO_ADDRESS        	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_SBNFIFO_OFFSET )
#define BBH_RX_4_DEBUG_SBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_4_DEBUG_SBNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_4_DEBUG_SBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_4_DEBUG_SBNFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_5_DEBUG_SBNFIFO_ADDRESS        	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_SBNFIFO_OFFSET )
#define BBH_RX_5_DEBUG_SBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_5_DEBUG_SBNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_5_DEBUG_SBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_5_DEBUG_SBNFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_6_DEBUG_SBNFIFO_ADDRESS        	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_SBNFIFO_OFFSET )
#define BBH_RX_6_DEBUG_SBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_6_DEBUG_SBNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_6_DEBUG_SBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_6_DEBUG_SBNFIFO_ADDRESS ), (i), (v) )


extern uint32_t BBH_RX_DEBUG_SBNFIFO_ARRAY [ ] ;

#define BBH_RX_DEBUG_SBNFIFO_WRITE( i, k, v )	WRITE_I_32( BBH_RX_DEBUG_SBNFIFO_ARRAY [ i ], (k), (v) )
#define BBH_RX_DEBUG_SBNFIFO_READ( i, k, r ) 	READ_I_32( BBH_RX_DEBUG_SBNFIFO_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2     	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VALID */
	uint32_t valid  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BN_entry */
	uint32_t bnentry	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_SBNFIFO ;
#else
typedef struct
{	uint32_t bnentry	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BN_entry */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t valid  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VALID */
	uint32_t r2     	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_SBNFIFO ;
#endif

/*****************************************************************************************/
/* IH_response_FIFO                                                                      */
/* The BBH RX hold a FIFO with 16 IH 2nd responses.                                      */
/*****************************************************************************************/

#define BBH_RX_DEBUG_RESFIFO_R2_DEFAULT_VALUE                    ( 0x0 )
#define BBH_RX_DEBUG_RESFIFO_R2_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_RX_DEBUG_RESFIFO_VALID_NOT_VALID_VALUE               ( 0x0 )
#define BBH_RX_DEBUG_RESFIFO_VALID_NOT_VALID_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_RX_DEBUG_RESFIFO_VALID_VALID_VALUE                   ( 0x1 )
#define BBH_RX_DEBUG_RESFIFO_R1_DEFAULT_VALUE                    ( 0x0 )
#define BBH_RX_DEBUG_RESFIFO_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_RX_DEBUG_RESFIFO_RESENTRY_RESPONSE_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_RESFIFO_RESENTRY_RESPONSE_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_DEBUG_RESFIFO_OFFSET ( 0x00000070 )

#define BBH_RX_0_DEBUG_RESFIFO_ADDRESS        	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_RESFIFO_OFFSET )
#define BBH_RX_0_DEBUG_RESFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_0_DEBUG_RESFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_0_DEBUG_RESFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_0_DEBUG_RESFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_1_DEBUG_RESFIFO_ADDRESS        	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_RESFIFO_OFFSET )
#define BBH_RX_1_DEBUG_RESFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_1_DEBUG_RESFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_1_DEBUG_RESFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_1_DEBUG_RESFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_2_DEBUG_RESFIFO_ADDRESS        	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_RESFIFO_OFFSET )
#define BBH_RX_2_DEBUG_RESFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_2_DEBUG_RESFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_2_DEBUG_RESFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_2_DEBUG_RESFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_3_DEBUG_RESFIFO_ADDRESS        	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_RESFIFO_OFFSET )
#define BBH_RX_3_DEBUG_RESFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_3_DEBUG_RESFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_3_DEBUG_RESFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_3_DEBUG_RESFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_4_DEBUG_RESFIFO_ADDRESS        	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_RESFIFO_OFFSET )
#define BBH_RX_4_DEBUG_RESFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_4_DEBUG_RESFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_4_DEBUG_RESFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_4_DEBUG_RESFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_5_DEBUG_RESFIFO_ADDRESS        	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_RESFIFO_OFFSET )
#define BBH_RX_5_DEBUG_RESFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_5_DEBUG_RESFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_5_DEBUG_RESFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_5_DEBUG_RESFIFO_ADDRESS ), (i), (v) )

#define BBH_RX_6_DEBUG_RESFIFO_ADDRESS        	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_RESFIFO_OFFSET )
#define BBH_RX_6_DEBUG_RESFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_6_DEBUG_RESFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_6_DEBUG_RESFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_6_DEBUG_RESFIFO_ADDRESS ), (i), (v) )


extern uint32_t BBH_RX_DEBUG_RESFIFO_ARRAY [ ] ;

#define BBH_RX_DEBUG_RESFIFO_WRITE( i, k, v )	WRITE_I_32( BBH_RX_DEBUG_RESFIFO_ARRAY [ i ], (k), (v) )
#define BBH_RX_DEBUG_RESFIFO_READ( i, k, r ) 	READ_I_32( BBH_RX_DEBUG_RESFIFO_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2      	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VALID */
	uint32_t valid   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Response_entry */
	uint32_t resentry	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_RESFIFO ;
#else
typedef struct
{	uint32_t resentry	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Response_entry */
	uint32_t r1      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t valid   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* VALID */
	uint32_t r2      	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_RESFIFO ;
#endif

/*****************************************************************************************/
/* Epon_sync_fifo_used_words                                                             */
/* EPON sync FIFO used words                                                             */
/*****************************************************************************************/

#define BBH_RX_DEBUG_ESUW_R1_RESET_VALUE_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_ESUW_R1_RESET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_RX_DEBUG_ESUW_UW_RESET_VALUE_VALUE             ( 0x0 )
#define BBH_RX_DEBUG_ESUW_UW_RESET_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_DEBUG_ESUW_OFFSET ( 0x000000B0 )

#define BBH_RX_0_DEBUG_ESUW_ADDRESS   	( BBH_RX_0_DEBUG_ADDRESS + BBH_RX_DEBUG_ESUW_OFFSET )
#define BBH_RX_0_DEBUG_ESUW_READ( r ) 	READ_32( ( BBH_RX_0_DEBUG_ESUW_ADDRESS ), (r) )
#define BBH_RX_0_DEBUG_ESUW_WRITE( v )	WRITE_32( ( BBH_RX_0_DEBUG_ESUW_ADDRESS ), (v) )

#define BBH_RX_1_DEBUG_ESUW_ADDRESS   	( BBH_RX_1_DEBUG_ADDRESS + BBH_RX_DEBUG_ESUW_OFFSET )
#define BBH_RX_1_DEBUG_ESUW_READ( r ) 	READ_32( ( BBH_RX_1_DEBUG_ESUW_ADDRESS ), (r) )
#define BBH_RX_1_DEBUG_ESUW_WRITE( v )	WRITE_32( ( BBH_RX_1_DEBUG_ESUW_ADDRESS ), (v) )

#define BBH_RX_2_DEBUG_ESUW_ADDRESS   	( BBH_RX_2_DEBUG_ADDRESS + BBH_RX_DEBUG_ESUW_OFFSET )
#define BBH_RX_2_DEBUG_ESUW_READ( r ) 	READ_32( ( BBH_RX_2_DEBUG_ESUW_ADDRESS ), (r) )
#define BBH_RX_2_DEBUG_ESUW_WRITE( v )	WRITE_32( ( BBH_RX_2_DEBUG_ESUW_ADDRESS ), (v) )

#define BBH_RX_3_DEBUG_ESUW_ADDRESS   	( BBH_RX_3_DEBUG_ADDRESS + BBH_RX_DEBUG_ESUW_OFFSET )
#define BBH_RX_3_DEBUG_ESUW_READ( r ) 	READ_32( ( BBH_RX_3_DEBUG_ESUW_ADDRESS ), (r) )
#define BBH_RX_3_DEBUG_ESUW_WRITE( v )	WRITE_32( ( BBH_RX_3_DEBUG_ESUW_ADDRESS ), (v) )

#define BBH_RX_4_DEBUG_ESUW_ADDRESS   	( BBH_RX_4_DEBUG_ADDRESS + BBH_RX_DEBUG_ESUW_OFFSET )
#define BBH_RX_4_DEBUG_ESUW_READ( r ) 	READ_32( ( BBH_RX_4_DEBUG_ESUW_ADDRESS ), (r) )
#define BBH_RX_4_DEBUG_ESUW_WRITE( v )	WRITE_32( ( BBH_RX_4_DEBUG_ESUW_ADDRESS ), (v) )

#define BBH_RX_5_DEBUG_ESUW_ADDRESS   	( BBH_RX_5_DEBUG_ADDRESS + BBH_RX_DEBUG_ESUW_OFFSET )
#define BBH_RX_5_DEBUG_ESUW_READ( r ) 	READ_32( ( BBH_RX_5_DEBUG_ESUW_ADDRESS ), (r) )
#define BBH_RX_5_DEBUG_ESUW_WRITE( v )	WRITE_32( ( BBH_RX_5_DEBUG_ESUW_ADDRESS ), (v) )

#define BBH_RX_6_DEBUG_ESUW_ADDRESS   	( BBH_RX_6_DEBUG_ADDRESS + BBH_RX_DEBUG_ESUW_OFFSET )
#define BBH_RX_6_DEBUG_ESUW_READ( r ) 	READ_32( ( BBH_RX_6_DEBUG_ESUW_ADDRESS ), (r) )
#define BBH_RX_6_DEBUG_ESUW_WRITE( v )	WRITE_32( ( BBH_RX_6_DEBUG_ESUW_ADDRESS ), (v) )


extern uint32_t BBH_RX_DEBUG_ESUW_ARRAY [ ] ;

#define BBH_RX_DEBUG_ESUW_WRITE( i, v )	WRITE_32( BBH_RX_DEBUG_ESUW_ARRAY [ i ], (v) )
#define BBH_RX_DEBUG_ESUW_READ( i, r ) 	READ_32( BBH_RX_DEBUG_ESUW_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Used_words */
	uint32_t uw	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_ESUW ;
#else
typedef struct
{	uint32_t uw	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Used_words */
	uint32_t r1	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG_ESUW ;
#endif

/*****************************************************************************************/
/* Per_flo_error                                                                         */
/* This set of 256 counters counts the packets dropped by IH per flow.  These counters a */
/* re cleared when read and freeze when reaches the maximum value.  The SW should clear  */
/* these counters in initialization stage by reading each of them.                       */
/*****************************************************************************************/

#define BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_R1_RESERVED_VALUE               ( 0x0 )
#define BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_R1_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_PMCNT_DEFAULT_VALUE             ( 0x0 )
#define BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_PMCNT_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_OFFSET ( 0x00000000 )

#define BBH_RX_0_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS        	( BBH_RX_0_PER_FLOW_PM_COUNTERS_ADDRESS + BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_OFFSET )
#define BBH_RX_0_PER_FLOW_PM_COUNTERS_PERFLOWPM_READ_I( r, i ) 	READ_I_32( ( BBH_RX_0_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (r) )
#define BBH_RX_0_PER_FLOW_PM_COUNTERS_PERFLOWPM_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_0_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (v) )

#define BBH_RX_1_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS        	( BBH_RX_1_PER_FLOW_PM_COUNTERS_ADDRESS + BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_OFFSET )
#define BBH_RX_1_PER_FLOW_PM_COUNTERS_PERFLOWPM_READ_I( r, i ) 	READ_I_32( ( BBH_RX_1_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (r) )
#define BBH_RX_1_PER_FLOW_PM_COUNTERS_PERFLOWPM_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_1_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (v) )

#define BBH_RX_2_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS        	( BBH_RX_2_PER_FLOW_PM_COUNTERS_ADDRESS + BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_OFFSET )
#define BBH_RX_2_PER_FLOW_PM_COUNTERS_PERFLOWPM_READ_I( r, i ) 	READ_I_32( ( BBH_RX_2_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (r) )
#define BBH_RX_2_PER_FLOW_PM_COUNTERS_PERFLOWPM_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_2_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (v) )

#define BBH_RX_3_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS        	( BBH_RX_3_PER_FLOW_PM_COUNTERS_ADDRESS + BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_OFFSET )
#define BBH_RX_3_PER_FLOW_PM_COUNTERS_PERFLOWPM_READ_I( r, i ) 	READ_I_32( ( BBH_RX_3_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (r) )
#define BBH_RX_3_PER_FLOW_PM_COUNTERS_PERFLOWPM_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_3_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (v) )

#define BBH_RX_4_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS        	( BBH_RX_4_PER_FLOW_PM_COUNTERS_ADDRESS + BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_OFFSET )
#define BBH_RX_4_PER_FLOW_PM_COUNTERS_PERFLOWPM_READ_I( r, i ) 	READ_I_32( ( BBH_RX_4_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (r) )
#define BBH_RX_4_PER_FLOW_PM_COUNTERS_PERFLOWPM_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_4_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (v) )

#define BBH_RX_5_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS        	( BBH_RX_5_PER_FLOW_PM_COUNTERS_ADDRESS + BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_OFFSET )
#define BBH_RX_5_PER_FLOW_PM_COUNTERS_PERFLOWPM_READ_I( r, i ) 	READ_I_32( ( BBH_RX_5_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (r) )
#define BBH_RX_5_PER_FLOW_PM_COUNTERS_PERFLOWPM_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_5_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (v) )

#define BBH_RX_6_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS        	( BBH_RX_6_PER_FLOW_PM_COUNTERS_ADDRESS + BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_OFFSET )
#define BBH_RX_6_PER_FLOW_PM_COUNTERS_PERFLOWPM_READ_I( r, i ) 	READ_I_32( ( BBH_RX_6_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (r) )
#define BBH_RX_6_PER_FLOW_PM_COUNTERS_PERFLOWPM_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_6_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (v) )


extern uint32_t BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_ARRAY [ ] ;

#define BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_WRITE( i, k, v )	WRITE_I_32( BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_ARRAY [ i ], (k), (v) )
#define BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_READ( i, k, r ) 	READ_I_32( BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Per_flow_PM */
	uint32_t pmcnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM ;
#else
typedef struct
{	uint32_t pmcnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Per_flow_PM */
	uint32_t r1   	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM ;
#endif

/*****************************************************************************************/
/* BB_Cfg                                                                                */
/* Each BBH unit has its own position on the BB tree. This position defines the Route ad */
/* dress when approaching the Runner, S/DMA or S/BPM.                                    */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_BBCFG_TX_R4_DEFAULT_VALUE                           ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_R4_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_BPMROUTE_BPM_ROUTE_VALUE                   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_BPMROUTE_BPM_ROUTE_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_R3_DEFAULT_VALUE                           ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_R3_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_RUNNERROUTE_RUNNER_ROUTE_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_RUNNERROUTE_RUNNER_ROUTE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_R2_DEFAULT_VALUE                           ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_R2_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_DMAROUTE_DMA_ROUTE_VALUE                   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_DMAROUTE_DMA_ROUTE_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_R1_DEFAULT_VALUE                           ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_R1_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )


#define BBH_TX_CONFIGURATIONS_BBCFG_TX_OFFSET ( 0x00000000 )

#define BBH_TX_0_CONFIGURATIONS_BBCFG_TX_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG_TX_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_BBCFG_TX_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_BBCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_BBCFG_TX_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG_TX_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_BBCFG_TX_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_BBCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_BBCFG_TX_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG_TX_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_BBCFG_TX_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_BBCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_BBCFG_TX_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG_TX_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_BBCFG_TX_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_BBCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_BBCFG_TX_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG_TX_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_BBCFG_TX_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_BBCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_BBCFG_TX_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG_TX_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_BBCFG_TX_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_BBCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_BBCFG_TX_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG_TX_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_BBCFG_TX_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_BBCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_BBCFG_TX_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_BBCFG_TX_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_BBCFG_TX_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_BBCFG_TX_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_BBCFG_TX_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_route_address */
	uint32_t bpmroute   	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_route_address */
	uint32_t runnerroute	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_route_address */
	uint32_t dmaroute   	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1         	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_BBCFG_TX ;
#else
typedef struct
{	uint32_t r1         	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t dmaroute   	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_route_address */
	uint32_t r2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t runnerroute	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_route_address */
	uint32_t r3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t bpmroute   	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_route_address */
	uint32_t r4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_BBCFG_TX ;
#endif

/*****************************************************************************************/
/* BB_Cfg_1                                                                              */
/* Each BBH unit has its own position on the BB tree. This position defines the Route ad */
/* dress when approaching the Runner, S/DMA or S/BPM.  This register is relevalt only fo */
/* r Ethernet.                                                                           */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_R3_DEFAULT_VALUE                            ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_R3_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_RNRSTSROUTE_RNR_STS_ROUTE_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_RNRSTSROUTE_RNR_STS_ROUTE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_R2_DEFAULT_VALUE                            ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_R2_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_SBPMROUTE_BPM_ROUTE_VALUE                   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_SBPMROUTE_BPM_ROUTE_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_R1_DEFAULT_VALUE                            ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_R1_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_SDMAROUTE_DMA_ROUTE_VALUE                   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_SDMAROUTE_DMA_ROUTE_VALUE_RESET_VALUE       ( 0x0 )


#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_OFFSET ( 0x00000004 )

#define BBH_TX_0_CONFIGURATIONS_BBCFG1_TX_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG1_TX_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_BBCFG1_TX_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_BBCFG1_TX_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_BBCFG1_TX_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG1_TX_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_BBCFG1_TX_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_BBCFG1_TX_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_BBCFG1_TX_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG1_TX_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_BBCFG1_TX_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_BBCFG1_TX_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_BBCFG1_TX_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG1_TX_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_BBCFG1_TX_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_BBCFG1_TX_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_BBCFG1_TX_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG1_TX_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_BBCFG1_TX_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_BBCFG1_TX_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_BBCFG1_TX_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG1_TX_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_BBCFG1_TX_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_BBCFG1_TX_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_BBCFG1_TX_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG1_TX_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_BBCFG1_TX_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_BBCFG1_TX_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_BBCFG1_TX_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_BBCFG1_TX_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_BBCFG1_TX_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_BBCFG1_TX_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r3         	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_sts_route_address */
	uint32_t rnrstsroute	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_route_address */
	uint32_t sbpmroute  	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA_route_address */
	uint32_t sdmaroute  	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_BBCFG1_TX ;
#else
typedef struct
{	uint32_t sdmaroute  	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA_route_address */
	uint32_t r1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t sbpmroute  	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_route_address */
	uint32_t r2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t rnrstsroute	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_sts_route_address */
	uint32_t r3         	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_BBCFG1_TX ;
#endif

/*****************************************************************************************/
/* DDR_cfg                                                                               */
/* The BBH reads the packet from the DDR. The Packet is arranged in the DDR in the follo */
/* wing way:  There are four Header Numbers located in a dedicated part of the DDR. Addr */
/* ess of these headers = Base (configurable) + 256 (4 headers) * BN; And a single Heade */
/* r Number located at the buffer. In addition there is a configurable payload start off */
/* set (4 bits). The Hn and Offset are delivered in the PD. In addition there is a confi */
/* gurable offset resolution (1, 2 and 4 bytes) and configurable header size. Order of t */
/* ransmission is: if H0 is required=> Then H0 is transmitted and consecutive to that is */
/*  the packet payload (main stream applications). If Hn is required then Hn is transmit */
/* ted and then packet payload (which will start at the PO).  When transmitting a packet */
/*  with HN=0, the transmission will be as follows:  Start address = Offset* OFFSET_RESO */
/* LUTION + 0 * HEADER_SIZE  Transmission then continues until the packet is over.  When */
/*  transmitting a packet with HN>0, the transmission will be as follows:  Start address */
/*  = <HN BASE> + (HN-1) * 64  HN BASE is a pointer to the first extra buffer in DDR whi */
/* ch is allocated for HN headers. The size of each extra buffer is 256 bytes, fixed. Th */
/* e transmission is HEADER_SIZE bytes long, and then transmission jumps to a new addres */
/* s for the rest of the packet:  Continue address = Offset*OFFSET_RESOLUTION + HEADER_S */
/* IZE                                                                                   */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_R4_DEFAULT_VALUE                     ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_R4_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_TXOFFSET_RST_VALUE_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_TXOFFSET_RST_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_R3_DEFAULT_VALUE                     ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_R3_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_HNSIZE_MIN_VALUE_VALUE               ( 0x4 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_HNSIZE_MAX_VALUE_VALUE               ( 0x40 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_HNSIZE_MAX_VALUE_VALUE_RESET_VALUE   ( 0x40 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_R2_DEFAULT_VALUE                     ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_R2_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_BYTERESUL_RES_1B_VALUE               ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_BYTERESUL_RES_1B_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_BYTERESUL_RES_2B_VALUE               ( 0x1 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_R1_DEFAULT_VALUE                     ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_R1_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_BUFSIZE_BUF_2K_VALUE                 ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_BUFSIZE_BUF_2K_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_BUFSIZE_BUF_4K_VALUE                 ( 0x1 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_BUFSIZE_BUF_16K_VALUE                ( 0x2 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_BUFSIZE_BUF_2_5K_VALUE               ( 0x3 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_BPMMSG_14_BIT_BN_WIDTH_VALUE         ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_BPMMSG_15_BIT_BN_WIDTH_VALUE         ( 0x1 )


#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_OFFSET ( 0x00000008 )

#define BBH_TX_0_CONFIGURATIONS_DDRCFG_TX_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRCFG_TX_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_DDRCFG_TX_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_DDRCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_DDRCFG_TX_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRCFG_TX_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_DDRCFG_TX_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_DDRCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_DDRCFG_TX_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRCFG_TX_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_DDRCFG_TX_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_DDRCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_DDRCFG_TX_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRCFG_TX_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_DDRCFG_TX_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_DDRCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_DDRCFG_TX_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRCFG_TX_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_DDRCFG_TX_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_DDRCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_DDRCFG_TX_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRCFG_TX_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_DDRCFG_TX_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_DDRCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_DDRCFG_TX_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRCFG_TX_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_DDRCFG_TX_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_DDRCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_DDRCFG_TX_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_DDRCFG_TX_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_DDRCFG_TX_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_DDRCFG_TX_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4       	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_offset */
	uint32_t txoffset 	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HN_size */
	uint32_t hnsize   	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2       	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PO_bytes_resulotion */
	uint32_t byteresul	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1       	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	uint32_t bpmmsg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	uint32_t r0       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_buffer_size */
	uint32_t bufsize  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_DDRCFG_TX ;
#else
typedef struct
{	uint32_t bufsize  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_buffer_size */
	uint32_t r0       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	uint32_t bpmmsg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	uint32_t r1       	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t byteresul	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PO_bytes_resulotion */
	uint32_t r2       	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t hnsize   	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HN_size */
	uint32_t r3       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t txoffset 	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_offset */
	uint32_t r4       	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_DDRCFG_TX ;
#endif

/*****************************************************************************************/
/* HN_BASE                                                                               */
/* The BBH reads the packet from the DDR. The Packet is arranged in the DDR in the follo */
/* wing way:  There are seven Header Numbers located in a dedicated part of the DDR. Add */
/* ress of these headers = Base (configurable) + 512 (7 headers) * BN; And a single Head */
/* er Number located at the buffer. In addition there is a configurable payload start of */
/* fset (4 bits). The Hn and Offset are delivered in the PD. In addition there is a conf */
/* igurable offset resolution (1, 2 and 4 bytes) and configurable header size. Order of  */
/* transmission is: if H0 is required=> Then H0 is transmitted and consecutive to that i */
/* s the packet payload (main stream applications). If Hn is required then Hn is transmi */
/* tted and then packet payload (which will start at the PO). (Motivation: In the case o */
/* f Multicast packets with a different VLAN manipulation command per EMAC the main buff */
/* ers are not replicated, but the Runner/CPU created a unique header per copy of the mu */
/* lticast packet).  When transmitting a packet with HN=0, the transmission will be as f */
/* ollows:  Start address = Offset* OFFSET_RESOLUTION + 0 * HEADER_SIZE  Transmission th */
/* en continues until the packet is over.  When transmitting a packet with HN>0, the tra */
/* nsmission will be as follows:  Start address = <HN BASE> + (HN-1) * 64  HN BASE is a  */
/* pointer to the first extra buffer in DDR which is allocated for HN headers. The size  */
/* of each extra buffer is 512 bytes, fixed. The transmission is HEADER_SIZE bytes long, */
/*  and then transmission jumps to a new address for the rest of the packet:  Continue a */
/* ddress = Offset*OFFSET_RESOLUTION + HEADER_SIZE                                       */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_HNBASE_HNBASE_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_HNBASE_HNBASE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_CONFIGURATIONS_HNBASE_OFFSET ( 0x0000000C )

#define BBH_TX_0_CONFIGURATIONS_HNBASE_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_HNBASE_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_HNBASE_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_HNBASE_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_HNBASE_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_HNBASE_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_HNBASE_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_HNBASE_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_HNBASE_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_HNBASE_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_HNBASE_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_HNBASE_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_HNBASE_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_HNBASE_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_HNBASE_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_HNBASE_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_HNBASE_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_HNBASE_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_HNBASE_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_HNBASE_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_HNBASE_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_HNBASE_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_HNBASE_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_HNBASE_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_HNBASE_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_HNBASE_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_HNBASE_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_HNBASE_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_HNBASE_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_HNBASE_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_HNBASE_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_HNBASE_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_HNBASE_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_HNBASE_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_HNBASE_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_HNBASE_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_HNBASE_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_HNBASE_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_HNBASE_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_HNBASE_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_HNBASE_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_HNBASE_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_HNBASE_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_HNBASE_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_HNBASE_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_HNBASE_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_HNBASE_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* HN_base */
	uint32_t hnbase	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_HNBASE ;
#else
typedef struct
{	uint32_t hnbase	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HN_base */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_HNBASE ;
#endif

/*****************************************************************************************/
/* Task_numbers_LSB                                                                      */
/* The BBH manages 40 queues for GPON or 32 queues for EPON.  Each of the first 8 Queues */
/*  may have a unique Runner task number.  Queues 8-39 have all the same configurable ta */
/* sk number.  This register defines the tasks for Queues 0-3.  For Ethernet queue 0 sho */
/* uld be configured.                                                                    */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_TASKLSB_R4_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_R4_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_TASK3_TASK_NUMBER_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_TASK3_TASK_NUMBER_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_R3_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_R3_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_TASK2_TASK_NUMBER_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_TASK2_TASK_NUMBER_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_R2_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_R2_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_TASK1_TASK_NUMBER_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_TASK1_TASK_NUMBER_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_R1_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_TASK0_TASK_NUMBER_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKLSB_TASK0_TASK_NUMBER_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_CONFIGURATIONS_TASKLSB_OFFSET ( 0x00000010 )

#define BBH_TX_0_CONFIGURATIONS_TASKLSB_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKLSB_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_TASKLSB_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_TASKLSB_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKLSB_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_TASKLSB_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_TASKLSB_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKLSB_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_TASKLSB_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_TASKLSB_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKLSB_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_TASKLSB_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_TASKLSB_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKLSB_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_TASKLSB_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_TASKLSB_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKLSB_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_TASKLSB_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_TASKLSB_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKLSB_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_TASKLSB_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_TASKLSB_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_TASKLSB_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_TASKLSB_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_TASKLSB_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_TASKLSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_3 */
	uint32_t task3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_2 */
	uint32_t task2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_1 */
	uint32_t task1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_0 */
	uint32_t task0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_TASKLSB ;
#else
typedef struct
{	uint32_t task0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_0 */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t task1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_1 */
	uint32_t r2   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t task2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_2 */
	uint32_t r3   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t task3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_3 */
	uint32_t r4   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_TASKLSB ;
#endif

/*****************************************************************************************/
/* Task_numbers_MSB                                                                      */
/* The BBH manages 40 queues for GPON or 32 queues for EPON.  Each of the first 8 Queues */
/*  may have a unique Runner task number.  Queues 8-39 have all the same configurable ta */
/* sk number.  This register defines the tasks for Queues 4-7.  For Ethernet queue 0 sho */
/* uld be configured.                                                                    */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_TASKMSB_R4_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_R4_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_TASK7_TASK_NUMBER_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_TASK7_TASK_NUMBER_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_R3_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_R3_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_TASK6_TASK_NUMBER_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_TASK6_TASK_NUMBER_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_R2_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_R2_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_TASK5_TASK_NUMBER_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_TASK5_TASK_NUMBER_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_R1_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_TASK4_TASK_NUMBER_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASKMSB_TASK4_TASK_NUMBER_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_CONFIGURATIONS_TASKMSB_OFFSET ( 0x00000014 )

#define BBH_TX_0_CONFIGURATIONS_TASKMSB_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKMSB_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_TASKMSB_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_TASKMSB_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKMSB_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_TASKMSB_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_TASKMSB_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKMSB_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_TASKMSB_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_TASKMSB_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKMSB_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_TASKMSB_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_TASKMSB_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKMSB_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_TASKMSB_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_TASKMSB_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKMSB_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_TASKMSB_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_TASKMSB_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKMSB_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_TASKMSB_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_TASKMSB_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_TASKMSB_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_TASKMSB_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_TASKMSB_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_TASKMSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_7 */
	uint32_t task7	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_6 */
	uint32_t task6	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_5 */
	uint32_t task5	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_4 */
	uint32_t task4	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_TASKMSB ;
#else
typedef struct
{	uint32_t task4	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_4 */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t task5	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_5 */
	uint32_t r2   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t task6	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_6 */
	uint32_t r3   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t task7	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_7 */
	uint32_t r4   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_TASKMSB ;
#endif

/*****************************************************************************************/
/* Task_numbers_8-39                                                                     */
/* The BBH manages 40 queues for GPON or 32 queues for EPON.  Each of the first 8 Queues */
/*  may have a unique Runner task number.  Queues 8-39 have all the same configurable ta */
/* sk number.  This register defines the tasks for Queues 8-39.  For Ethernet queue 0 sh */
/* ould be configured.                                                                   */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_TASK8_39_R1_DEFAULT_VALUE                       ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASK8_39_R1_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASK8_39_TASK8_39_TASK_NUMBER_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TASK8_39_TASK8_39_TASK_NUMBER_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_CONFIGURATIONS_TASK8_39_OFFSET ( 0x00000018 )

#define BBH_TX_0_CONFIGURATIONS_TASK8_39_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASK8_39_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_TASK8_39_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_TASK8_39_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASK8_39_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_TASK8_39_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_TASK8_39_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASK8_39_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_TASK8_39_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_TASK8_39_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASK8_39_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_TASK8_39_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_TASK8_39_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASK8_39_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_TASK8_39_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_TASK8_39_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASK8_39_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_TASK8_39_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_TASK8_39_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASK8_39_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_TASK8_39_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_TASK8_39_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_TASK8_39_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_TASK8_39_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_TASK8_39_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_TASK8_39_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_8-39 */
	uint32_t task8_39	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_TASK8_39 ;
#else
typedef struct
{	uint32_t task8_39	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_8-39 */
	uint32_t r1      	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_TASK8_39 ;
#endif

/*****************************************************************************************/
/* PD_FIFO_size_0_7                                                                      */
/* The BBH manages 40 queues for GPON and 32 queues for EPON (FIFO per TCONT/LLID). For  */
/* each queue it manages a PD FIFO.   A total of 128 PDs (GPON) or 256 PDs (EPON) are av */
/* ailable for all queues.   For each Queue the SW configures the base and the size with */
/* in these 128/256 PDs.  This register defines the PD FIFO size for queues 0-7.  For Et */
/* hernet queue 0 should be configured.                                                  */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE7_MAX_GPON_VALUE                 ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE7_DEFAULT_GPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE7_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE7_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE7_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE7_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE6_MAX_GPON_VALUE                 ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE6_DEFAULT_GPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE6_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE6_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE6_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE6_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE5_MAX_GPON_VALUE                 ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE5_DEFAULT_GPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE5_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE5_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE5_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE5_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE4_MAX_GPON_VALUE                 ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE4_DEFAULT_GPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE4_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE4_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE4_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE4_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE3_MAX_GPON_VALUE                 ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE3_DEFAULT_GPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE3_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE3_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE3_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE3_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE2_MAX_GPON_VALUE                 ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE2_DEFAULT_GPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE2_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE2_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE2_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE2_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE1_MAX_GPON_VALUE                 ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE1_DEFAULT_GPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE1_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE1_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE1_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE1_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE0_MAX_GPON_VALUE                 ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE0_DEFAULT_GPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE0_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE0_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE0_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_FIFOSIZE0_MAX_EPON_VALUE                 ( 0xF )


#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_OFFSET ( 0x0000001C )

#define BBH_TX_0_CONFIGURATIONS_PDSIZE0_7_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE0_7_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_PDSIZE0_7_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_PDSIZE0_7_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_PDSIZE0_7_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE0_7_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_PDSIZE0_7_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_PDSIZE0_7_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_PDSIZE0_7_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE0_7_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_PDSIZE0_7_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_PDSIZE0_7_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_PDSIZE0_7_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE0_7_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_PDSIZE0_7_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_PDSIZE0_7_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_PDSIZE0_7_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE0_7_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_PDSIZE0_7_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_PDSIZE0_7_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_PDSIZE0_7_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE0_7_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_PDSIZE0_7_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_PDSIZE0_7_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_PDSIZE0_7_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE0_7_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_PDSIZE0_7_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_PDSIZE0_7_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_PDSIZE0_7_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_PDSIZE0_7_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_PDSIZE0_7_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_PDSIZE0_7_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* FIFO_size_7 */
	uint32_t fifosize7	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_6 */
	uint32_t fifosize6	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_5 */
	uint32_t fifosize5	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_4 */
	uint32_t fifosize4	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_3 */
	uint32_t fifosize3	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_2 */
	uint32_t fifosize2	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_1 */
	uint32_t fifosize1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_0 */
	uint32_t fifosize0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDSIZE0_7 ;
#else
typedef struct
{	uint32_t fifosize0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_0 */
	uint32_t fifosize1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_1 */
	uint32_t fifosize2	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_2 */
	uint32_t fifosize3	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_3 */
	uint32_t fifosize4	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_4 */
	uint32_t fifosize5	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_5 */
	uint32_t fifosize6	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_6 */
	uint32_t fifosize7	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_7 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDSIZE0_7 ;
#endif

/*****************************************************************************************/
/* PD_FIFO_size_8_39                                                                     */
/* The BBH manages 40 queues for GPON and 32 queues for EPON (FIFO per queue). For each  */
/* queue it manages a PD FIFO.   A total of 128 PDs for GPON and 256 PDs for EPON are av */
/* ailable for all queues.   For each Queue the SW configures the base and the size with */
/* in these 128/256 PDs.  This register defines the PD FIFO size for TCONTs 8-39.        */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_R3_DEFAULT_VALUE                             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_R3_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE32_39_MAX_EPON_VALUE                 ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE32_39_DEFAULT_EPON_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE32_39_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE32_39_DEFAULT_GPON_VALUE             ( 0x1 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE32_39_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x1 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE32_39_MAX_GPON_VALUE                 ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE24_31_DEFAULT_GPON_VALUE             ( 0x1 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE24_31_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x1 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE24_31_DEFAULT_EPON_VALUE             ( 0x4 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE24_31_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x4 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE24_31_MAX_GPON_VALUE                 ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE24_31_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE16_23_DEFAULT_GPON_VALUE             ( 0x1 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE16_23_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x1 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE16_23_DEFAULT_EPON_VALUE             ( 0x4 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE16_23_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x4 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE16_23_MAX_GPON_VALUE                 ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE16_23_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE8_15_DEFAULT_GPON_VALUE              ( 0x1 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE8_15_DEFAULT_GPON_VALUE_RESET_VALUE  ( 0x1 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE8_15_DEFAULT_EPON_VALUE              ( 0x4 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE8_15_DEFAULT_EPON_VALUE_RESET_VALUE  ( 0x4 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE8_15_MAX_GPON_VALUE                  ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_FIFOSIZE8_15_MAX_EPON_VALUE                  ( 0xF )


#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_OFFSET ( 0x00000020 )

#define BBH_TX_0_CONFIGURATIONS_PDSIZE8_39_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE8_39_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_PDSIZE8_39_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_PDSIZE8_39_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_PDSIZE8_39_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE8_39_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_PDSIZE8_39_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_PDSIZE8_39_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_PDSIZE8_39_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE8_39_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_PDSIZE8_39_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_PDSIZE8_39_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_PDSIZE8_39_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE8_39_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_PDSIZE8_39_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_PDSIZE8_39_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_PDSIZE8_39_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE8_39_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_PDSIZE8_39_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_PDSIZE8_39_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_PDSIZE8_39_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE8_39_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_PDSIZE8_39_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_PDSIZE8_39_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_PDSIZE8_39_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE8_39_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_PDSIZE8_39_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_PDSIZE8_39_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_PDSIZE8_39_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_PDSIZE8_39_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_PDSIZE8_39_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_PDSIZE8_39_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r3           	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_32_39 */
	uint32_t fifosize32_39	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_24_31 */
	uint32_t fifosize24_31	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_16_23 */
	uint32_t fifosize16_23	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_8_15 */
	uint32_t fifosize8_15 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDSIZE8_39 ;
#else
typedef struct
{	uint32_t fifosize8_15 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_8_15 */
	uint32_t fifosize16_23	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_16_23 */
	uint32_t fifosize24_31	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_24_31 */
	uint32_t fifosize32_39	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_32_39 */
	uint32_t r3           	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDSIZE8_39 ;
#endif

/*****************************************************************************************/
/* PD_FIFO_base_0_3                                                                      */
/* The BBH manages 40 queues for GPON or 32 queus for EPON (1 for each TCONT/LLID). For  */
/* each queue it manages a PD FIFO.   A total of 128 PDs (GPON) or 256 (EPON) are availa */
/* ble for all queues.   For each Queue the SW configures the base and the size within t */
/* hese 128/256 PDs.  This register defines the PD FIFO base for TCONTs 0-3.  This confi */
/* guration is irrelevant for Ethernet.                                                  */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE3_DEFAULT_GPON_VALUE             ( 0x18 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE3_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x18 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE3_DEFAULT_EPON_VALUE             ( 0x30 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE3_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x30 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE3_MAX_GPON_VALUE                 ( 0x7F )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE3_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE2_DEFAULT_GPON_VALUE             ( 0x10 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE2_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x10 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE2_DEFAULT_EPON_VALUE             ( 0x20 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE2_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x20 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE2_MAX_GPON_VALUE                 ( 0x7F )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE2_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE1_DEFAULT_GPON_VALUE             ( 0x8 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE1_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x8 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE1_DEFAULT_EPON_VALUE             ( 0x10 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE1_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x10 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE1_MAX_GPON_VALUE                 ( 0x7F )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE1_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE0_DEFAULT_EPON_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE0_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE0_DEFAULT_GPON_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE0_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE0_MAX_GPON_VALUE                 ( 0x7F )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_FIFOBASE0_MAX_EPON_VALUE                 ( 0xFF )


#define BBH_TX_CONFIGURATIONS_PDBASE0_3_OFFSET ( 0x00000024 )

#define BBH_TX_0_CONFIGURATIONS_PDBASE0_3_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE0_3_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_PDBASE0_3_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE0_3_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_PDBASE0_3_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE0_3_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_PDBASE0_3_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE0_3_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_PDBASE0_3_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE0_3_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_PDBASE0_3_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE0_3_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_PDBASE0_3_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE0_3_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_PDBASE0_3_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_PDBASE0_3_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_PDBASE0_3_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_PDBASE0_3_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_PDBASE0_3_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* FIFO_base_3 */
	uint32_t fifobase3	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_2 */
	uint32_t fifobase2	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_1 */
	uint32_t fifobase1	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_0 */
	uint32_t fifobase0	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDBASE0_3 ;
#else
typedef struct
{	uint32_t fifobase0	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_0 */
	uint32_t fifobase1	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_1 */
	uint32_t fifobase2	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_2 */
	uint32_t fifobase3	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_3 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDBASE0_3 ;
#endif

/*****************************************************************************************/
/* PD_FIFO_base_4_7                                                                      */
/* The BBH manages 40 queues for GPON or 32 queus for EPON (1 for each TCONT/LLID). For  */
/* each queue it manages a PD FIFO.   A total of 128 PDs (GPON) or 256 (EPON) are availa */
/* ble for all queues.   For each Queue the SW configures the base and the size within t */
/* hese 128/256 PDs.  This register defines the PD FIFO base for TCONTs 4-7.  This confi */
/* guration is irrelevant for Ethernet.                                                  */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE7_DEFAULT_GPON_VALUE             ( 0x38 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE7_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x38 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE7_DEFAULT_EPON_VALUE             ( 0x70 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE7_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x70 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE7_MAX_GPON_VALUE                 ( 0x7F )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE7_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE6_DEFAULT_GPON_VALUE             ( 0x30 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE6_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x30 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE6_DEFAULT_EPON_VALUE             ( 0x60 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE6_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x60 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE6_MAX_GPON_VALUE                 ( 0x7F )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE6_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE5_DEFAULT_GPON_VALUE             ( 0x28 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE5_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x28 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE5_DEFAULT_EPON_VALUE             ( 0x50 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE5_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x50 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE5_MAX_GPON_VALUE                 ( 0x7F )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE5_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE4_DEFAULT_GPON_VALUE             ( 0x20 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE4_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x20 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE4_DEFAULT_EPON_VALUE             ( 0x40 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE4_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x40 )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE4_MAX_GPON_VALUE                 ( 0x7F )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_FIFOBASE4_MAX_EPON_VALUE                 ( 0xFF )


#define BBH_TX_CONFIGURATIONS_PDBASE4_7_OFFSET ( 0x00000028 )

#define BBH_TX_0_CONFIGURATIONS_PDBASE4_7_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE4_7_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_PDBASE4_7_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE4_7_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_PDBASE4_7_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE4_7_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_PDBASE4_7_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE4_7_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_PDBASE4_7_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE4_7_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_PDBASE4_7_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE4_7_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_PDBASE4_7_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE4_7_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_PDBASE4_7_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_PDBASE4_7_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_PDBASE4_7_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_PDBASE4_7_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_PDBASE4_7_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* FIFO_base_7 */
	uint32_t fifobase7	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_6 */
	uint32_t fifobase6	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_5 */
	uint32_t fifobase5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_4 */
	uint32_t fifobase4	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDBASE4_7 ;
#else
typedef struct
{	uint32_t fifobase4	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_4 */
	uint32_t fifobase5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_5 */
	uint32_t fifobase6	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_6 */
	uint32_t fifobase7	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_7 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDBASE4_7 ;
#endif

/*****************************************************************************************/
/* PD_FIFO_base_8_39                                                                     */
/* The BBH manages 40 queues (GPON) or 32 queus (EPON). For each queue it manages a PD F */
/* IFO.   A total of 128 PDs (GPON) or 256 PDs (EPON) are available for all queues.   Fo */
/* r each Queue the SW configures the base and the size within these 128/256 PDs.  This  */
/* register defines the PD FIFO base for queues 8-39.  This configuration is irrelevant  */
/* for Ethernet.                                                                         */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE32_39_DEFAULT_EPON_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE32_39_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE32_39_MAX_EPON_VALUE                 ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE32_39_DEFAULT_GPON_VALUE             ( 0x70 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE32_39_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x70 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE32_39_MAX_GPON_VALUE                 ( 0x7F )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE24_31_DEFAULT_GPON_VALUE             ( 0x60 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE24_31_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x60 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE24_31_MAX_GPON_VALUE                 ( 0x7F )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE24_31_DEFAULT_EPON_VALUE             ( 0xD0 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE24_31_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xD0 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE24_31_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE16_23_DEFAULT_GPON_VALUE             ( 0x50 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE16_23_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x50 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE16_23_MAX_GPON_VALUE                 ( 0x7F )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE16_23_DEFAULT_EPON_VALUE             ( 0xA8 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE16_23_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xA8 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE16_23_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE8_15_DEFAULT_GPON_VALUE              ( 0x40 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE8_15_DEFAULT_GPON_VALUE_RESET_VALUE  ( 0x40 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE8_15_MAX_GPON_VALUE                  ( 0x7F )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE8_15_DEFAULT_EPON_VALUE              ( 0x80 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE8_15_DEFAULT_EPON_VALUE_RESET_VALUE  ( 0x80 )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_FIFOBASE8_15_MAX_EPON_VALUE                  ( 0xFF )


#define BBH_TX_CONFIGURATIONS_PDBASE8_39_OFFSET ( 0x0000002C )

#define BBH_TX_0_CONFIGURATIONS_PDBASE8_39_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE8_39_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_PDBASE8_39_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE8_39_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_PDBASE8_39_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE8_39_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_PDBASE8_39_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE8_39_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_PDBASE8_39_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE8_39_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_PDBASE8_39_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE8_39_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_PDBASE8_39_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE8_39_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_PDBASE8_39_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_PDBASE8_39_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_PDBASE8_39_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_PDBASE8_39_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_PDBASE8_39_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* FIFO_base_32_39 */
	uint32_t fifobase32_39	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_24_31 */
	uint32_t fifobase24_31	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_16_23 */
	uint32_t fifobase16_23	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_8_15 */
	uint32_t fifobase8_15 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDBASE8_39 ;
#else
typedef struct
{	uint32_t fifobase8_15 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_8_15 */
	uint32_t fifobase16_23	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_16_23 */
	uint32_t fifobase24_31	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_24_31 */
	uint32_t fifobase32_39	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_32_39 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDBASE8_39 ;
#endif

/*****************************************************************************************/
/* PD_bytes_threshold_EN                                                                 */
/* The BBH requests PDs from the Runner and maintains a pre-fetch PDs FIFO.  The PDs pre */
/*  fetch is limited either by the PD FIFO configurable size or according to the total n */
/* umber of bytes (deducting bytes already requested/transmitted) for preventing HOL. Fu */
/* ll configuration for the first 8 TCONT and one configuration per group of 8 TCONTs fo */
/* r the rest.                                                                           */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_RESERVED1_DEFAULT_VALUE                      ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_RESERVED1_DEFAULT_VALUE_RESET_VALUE          ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_PDLIMITEN_PD_LIMIT_DISABLE_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_PDLIMITEN_PD_LIMIT_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_PDLIMITEN_PD_LIMIT_ENABLE_VALUE              ( 0x1 )


#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_OFFSET ( 0x00000030 )

#define BBH_TX_0_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_limit_enable */
	uint32_t pdlimiten	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN ;
#else
typedef struct
{	uint32_t pdlimiten	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_limit_enable */
	uint32_t reserved1	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN ;
#endif

/*****************************************************************************************/
/* PD_bytes_threshold                                                                    */
/* The BBH requests PDs from the Runner and maintains a pre-fetch PDs FIFO.  The PDs pre */
/*  fetch is limited either by the PD FIFO configurable size or according to the total n */
/* umber of bytes (deducting bytes already requested/transmitted) for preventing HOL. Fu */
/* ll configuration for the first 8 TCONT and one configuration for the rest (TCONTs 8-3 */
/* 9).  Registers 0-3 define the configuration for the first 8 TCONT and register 4 defi */
/* nes the configuration for TCONTs 8-39 (in the even field).                            */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_R2_RESET_VALUE_VALUE                  ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_R2_RESET_VALUE_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_PDLIMITEVEN_DEFAULT_VALUE             ( 0x180 )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_PDLIMITEVEN_DEFAULT_VALUE_RESET_VALUE ( 0x180 )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_R1_RESET_VALUE_VALUE                  ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_R1_RESET_VALUE_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_PDLIMITODD_DEFAULT_VALUE              ( 0x180 )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_PDLIMITODD_DEFAULT_VALUE_RESET_VALUE  ( 0x180 )


#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_OFFSET ( 0x00000034 )

#define BBH_TX_0_CONFIGURATIONS_PD_BYTE_TH_ADDRESS        	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_0_CONFIGURATIONS_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (v) )

#define BBH_TX_1_CONFIGURATIONS_PD_BYTE_TH_ADDRESS        	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_1_CONFIGURATIONS_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (v) )

#define BBH_TX_2_CONFIGURATIONS_PD_BYTE_TH_ADDRESS        	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_2_CONFIGURATIONS_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (v) )

#define BBH_TX_3_CONFIGURATIONS_PD_BYTE_TH_ADDRESS        	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_3_CONFIGURATIONS_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (v) )

#define BBH_TX_4_CONFIGURATIONS_PD_BYTE_TH_ADDRESS        	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_4_CONFIGURATIONS_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (v) )

#define BBH_TX_5_CONFIGURATIONS_PD_BYTE_TH_ADDRESS        	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_5_CONFIGURATIONS_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (v) )

#define BBH_TX_6_CONFIGURATIONS_PD_BYTE_TH_ADDRESS        	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_6_CONFIGURATIONS_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_PD_BYTE_TH_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_WRITE( i, k, v )	WRITE_I_32( BBH_TX_CONFIGURATIONS_PD_BYTE_TH_ARRAY [ i ], (k), (v) )
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_READ( i, k, r ) 	READ_I_32( BBH_TX_CONFIGURATIONS_PD_BYTE_TH_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2         	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_limit_even */
	uint32_t pdlimiteven	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1         	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_limit_odd */
	uint32_t pdlimitodd 	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PD_BYTE_TH ;
#else
typedef struct
{	uint32_t pdlimitodd 	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_limit_odd */
	uint32_t r1         	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t pdlimiteven	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_limit_even */
	uint32_t r2         	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PD_BYTE_TH ;
#endif

/*****************************************************************************************/
/* DMA_configurations                                                                    */
/* The BBH reads the packet data from the DDR in chunks (with a maximal size of 128 byte */
/* s).  For each chunk the BBH writes a read request (descriptor) into the DMA memory sp */
/* ace. The read descriptors are arranged in a predefined space in the DMA memory and ma */
/* naged in a cyclic FIFO style.   A special configuration limits the maximum number of  */
/* read requests.                                                                        */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_DMACFG_TX_R4_DEFAULT_VALUE                     ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_R4_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_EPNURGNT_NORMAL_VALUE                ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_EPNURGNT_NORMAL_VALUE_RESET_VALUE    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_EPNURGNT_URGENT_VALUE                ( 0x1 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_R3_DEFAULT_VALUE                     ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_R3_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_MAXREQ_MIN_VALUE_VALUE               ( 0x1 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_MAXREQ_MAX_VALUE_VALUE               ( 0x8 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_MAXREQ_MAX_VALUE_VALUE_RESET_VALUE   ( 0x8 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_R2_DEFAULT_VALUE                     ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_R2_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_DESCBASE_DESC_BASE_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_DESCBASE_DESC_BASE_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_CONFIGURATIONS_DMACFG_TX_OFFSET ( 0x0000004C )

#define BBH_TX_0_CONFIGURATIONS_DMACFG_TX_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DMACFG_TX_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_DMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_DMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_DMACFG_TX_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DMACFG_TX_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_DMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_DMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_DMACFG_TX_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DMACFG_TX_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_DMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_DMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_DMACFG_TX_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DMACFG_TX_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_DMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_DMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_DMACFG_TX_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DMACFG_TX_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_DMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_DMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_DMACFG_TX_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DMACFG_TX_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_DMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_DMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_DMACFG_TX_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DMACFG_TX_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_DMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_DMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_DMACFG_TX_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_DMACFG_TX_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_DMACFG_TX_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_DMACFG_TX_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_DMACFG_TX_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4      	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Epon_read_urgent */
	uint32_t epnurgnt	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_number_of_requests */
	uint32_t maxreq  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2      	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Descriptor_FIFO_base */
	uint32_t descbase	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_DMACFG_TX ;
#else
typedef struct
{	uint32_t descbase	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Descriptor_FIFO_base */
	uint32_t r2      	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t maxreq  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_number_of_requests */
	uint32_t r3      	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t epnurgnt	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Epon_read_urgent */
	uint32_t r4      	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_DMACFG_TX ;
#endif

/*****************************************************************************************/
/* SDMA_configurations                                                                   */
/* The BBH reads the packet data from the SRAM in a fixed size chunks (128 bytes).  For  */
/* each chunk the BBH writes a read request (descriptor) into the SDMA memory space. The */
/*  read descriptors are arranged in a predefined space in the SDMA memory and managed i */
/* n a cyclic FIFO style.   A special configuration limits the maximum number of read re */
/* quests.  This register is relevalt only for Ethernet.                                 */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_SDMACFG_TX_R2_DEFAULT_VALUE                     ( 0x0 )
#define BBH_TX_CONFIGURATIONS_SDMACFG_TX_R2_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_TX_CONFIGURATIONS_SDMACFG_TX_MAXREQ_MIN_VALUE_VALUE               ( 0x1 )
#define BBH_TX_CONFIGURATIONS_SDMACFG_TX_MAXREQ_MAX_VALUE_VALUE               ( 0x4 )
#define BBH_TX_CONFIGURATIONS_SDMACFG_TX_MAXREQ_MAX_VALUE_VALUE_RESET_VALUE   ( 0x4 )
#define BBH_TX_CONFIGURATIONS_SDMACFG_TX_R1_DEFAULT_VALUE                     ( 0x0 )
#define BBH_TX_CONFIGURATIONS_SDMACFG_TX_R1_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_TX_CONFIGURATIONS_SDMACFG_TX_DESCBASE_DESC_BASE_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_SDMACFG_TX_DESCBASE_DESC_BASE_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_CONFIGURATIONS_SDMACFG_TX_OFFSET ( 0x00000050 )

#define BBH_TX_0_CONFIGURATIONS_SDMACFG_TX_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SDMACFG_TX_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_SDMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_SDMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_SDMACFG_TX_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SDMACFG_TX_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_SDMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_SDMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_SDMACFG_TX_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SDMACFG_TX_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_SDMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_SDMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_SDMACFG_TX_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SDMACFG_TX_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_SDMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_SDMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_SDMACFG_TX_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SDMACFG_TX_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_SDMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_SDMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_SDMACFG_TX_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SDMACFG_TX_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_SDMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_SDMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_SDMACFG_TX_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SDMACFG_TX_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_SDMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_SDMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_SDMACFG_TX_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_SDMACFG_TX_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_SDMACFG_TX_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_SDMACFG_TX_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_SDMACFG_TX_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2      	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_number_of_requests */
	uint32_t maxreq  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1      	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Descriptor_FIFO_base */
	uint32_t descbase	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_SDMACFG_TX ;
#else
typedef struct
{	uint32_t descbase	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Descriptor_FIFO_base */
	uint32_t r1      	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t maxreq  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_number_of_requests */
	uint32_t r2      	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_SDMACFG_TX ;
#endif

/*****************************************************************************************/
/* Runner_configurations                                                                 */
/* TCONT address:  The BBH requests a Packet descriptor from the Runner. The BBH sends a */
/*  wake-up request to the Runner (for a new PD). The wake-up request is written to addr */
/* ess 0x8000 in the Runner.    In the case of GPON peripheral the BBH writes the TCONT  */
/* number in a predefined address at the Runner SRAM and then sends a wake-up request to */
/*  the Runner.   This register defines the TCONT address within the Runner address spac */
/* e.  SKB address:  When the packet is transmitted from absolute address, then, instead */
/*  of releasing the BN, the BBH writes a 6 bits read counter into the Runner SRAM. It w */
/* rites it into a pre-defined address + TCONT_NUM (for Ethernet TCONT_NUM = 0).  This r */
/* egister defines the SKB free base address within the Runner address                   */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_RUNNERCFG_SKBADDR_SKB_ADDRESS_VALUE                 ( 0x0 )
#define BBH_TX_CONFIGURATIONS_RUNNERCFG_SKBADDR_SKB_ADDRESS_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_TX_CONFIGURATIONS_RUNNERCFG_TCONTADDR_TCONT_ADDRESS_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_RUNNERCFG_TCONTADDR_TCONT_ADDRESS_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_CONFIGURATIONS_RUNNERCFG_OFFSET ( 0x00000054 )

#define BBH_TX_0_CONFIGURATIONS_RUNNERCFG_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_RUNNERCFG_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_RUNNERCFG_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_RUNNERCFG_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_RUNNERCFG_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_RUNNERCFG_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_RUNNERCFG_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_RUNNERCFG_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_RUNNERCFG_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_RUNNERCFG_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_RUNNERCFG_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_RUNNERCFG_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_RUNNERCFG_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_RUNNERCFG_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_RUNNERCFG_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_RUNNERCFG_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_RUNNERCFG_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_RUNNERCFG_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_RUNNERCFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* SKB_address */
	uint32_t skbaddr  	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCONT_address */
	uint32_t tcontaddr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_RUNNERCFG ;
#else
typedef struct
{	uint32_t tcontaddr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCONT_address */
	uint32_t skbaddr  	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SKB_address */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_RUNNERCFG ;
#endif

/*****************************************************************************************/
/* MDU_CFG                                                                               */
/* The BBH supports a special configurable mode to enable a faster packet bridging (for  */
/* EMAC and EPON only):  -There will be a special configurable mode for transferring the */
/*  PD from the Runner into the BBH TX (for downstream only).   -The Runner wont ACK the */
/*  BBH; therefore the BBH wont wake the TX task.   -The Runner will push the PDs into t */
/* he BBH (without any wakeup from the BBH).   -Each time that the BBH reads a PD from t */
/* he PD FIFO, it will write the read pointer into a pre-defined address in the Runner ( */
/* enable by configuration). The pointer is 6 bits width (one bit larger than needed to  */
/* distinguish between full and empty).  -The Runner should manage the congestion over t */
/* he PD FIFO (in the BBH) by reading the BBH read pointer prior to each PD write.   -PD */
/*  drop should be done by the Runner only. The BBH will drop PD when the FIFO is full a */
/* nd will count each drop. The BBH wont release the BN in this case.  FOR EMAC BBH, a p */
/* re PD FIFO of 32 entries is added (no change of the first BN FIFO).    For EPON BBH,  */
/* there will be a full threshold, which can be smaller than the actual size of the FIFO */
/* . When the BBH will move from full to not full state, the BBH will wakeup the Runner. */
/*                                                                                       */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_MDUMODE_PTRADDR_RESET_VALUE_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_MDUMODE_PTRADDR_RESET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_MDUMODE_R1_RESET_VALUE_VALUE                  ( 0x0 )
#define BBH_TX_CONFIGURATIONS_MDUMODE_R1_RESET_VALUE_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_TX_CONFIGURATIONS_MDUMODE_MDUEN_DIS_VALUE                       ( 0x0 )
#define BBH_TX_CONFIGURATIONS_MDUMODE_MDUEN_DIS_VALUE_RESET_VALUE           ( 0x0 )
#define BBH_TX_CONFIGURATIONS_MDUMODE_MDUEN_EN_VALUE                        ( 0x1 )


#define BBH_TX_CONFIGURATIONS_MDUMODE_OFFSET ( 0x00000058 )

#define BBH_TX_0_CONFIGURATIONS_MDUMODE_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MDUMODE_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_MDUMODE_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_MDUMODE_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MDUMODE_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_MDUMODE_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_MDUMODE_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MDUMODE_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_MDUMODE_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_MDUMODE_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MDUMODE_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_MDUMODE_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_MDUMODE_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MDUMODE_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_MDUMODE_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_MDUMODE_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MDUMODE_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_MDUMODE_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_MDUMODE_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MDUMODE_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_MDUMODE_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_MDUMODE_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_MDUMODE_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_MDUMODE_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_MDUMODE_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_MDUMODE_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PTRADDR */
	uint32_t ptraddr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MDU_EN */
	uint32_t mduen  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_MDUMODE ;
#else
typedef struct
{	uint32_t mduen  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MDU_EN */
	uint32_t r1     	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t ptraddr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PTRADDR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_MDUMODE ;
#endif

/*****************************************************************************************/
/* DDR_TM_BASE                                                                           */
/* The BBH calculate the DDR physical address according to the Buffer number and buffer  */
/* size and then adds the DDR TM base.  The value of this register should match the rele */
/* vant registers value in the BBH RX and in the Runner.                                 */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_DDRTMBASE_DDRTMBASE_DDR_TM_BASE_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DDRTMBASE_DDRTMBASE_DDR_TM_BASE_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_CONFIGURATIONS_DDRTMBASE_OFFSET ( 0x0000005C )

#define BBH_TX_0_CONFIGURATIONS_DDRTMBASE_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRTMBASE_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_DDRTMBASE_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_DDRTMBASE_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_DDRTMBASE_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRTMBASE_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_DDRTMBASE_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_DDRTMBASE_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_DDRTMBASE_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRTMBASE_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_DDRTMBASE_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_DDRTMBASE_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_DDRTMBASE_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRTMBASE_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_DDRTMBASE_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_DDRTMBASE_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_DDRTMBASE_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRTMBASE_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_DDRTMBASE_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_DDRTMBASE_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_DDRTMBASE_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRTMBASE_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_DDRTMBASE_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_DDRTMBASE_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_DDRTMBASE_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRTMBASE_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_DDRTMBASE_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_DDRTMBASE_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_DDRTMBASE_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_DDRTMBASE_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_DDRTMBASE_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_DDRTMBASE_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_DDRTMBASE_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DDR_TM_BASE */
	uint32_t ddrtmbase	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_DDRTMBASE ;
#else
typedef struct
{	uint32_t ddrtmbase	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_TM_BASE */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_DDRTMBASE ;
#endif

/*****************************************************************************************/
/* Debug_select                                                                          */
/* This register selects 1 of 8 debug vectors.  The selected vector is reflected to DBGO */
/* UTREG.                                                                                */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_DBGSEL_R1_DEFAULT_VALUE                 ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DBGSEL_R1_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DBGSEL_DBGSEL_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_DBGSEL_DBGSEL_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_CONFIGURATIONS_DBGSEL_OFFSET ( 0x00000060 )

#define BBH_TX_0_CONFIGURATIONS_DBGSEL_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DBGSEL_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_DBGSEL_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_DBGSEL_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_DBGSEL_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_DBGSEL_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_DBGSEL_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DBGSEL_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_DBGSEL_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_DBGSEL_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_DBGSEL_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_DBGSEL_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_DBGSEL_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DBGSEL_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_DBGSEL_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_DBGSEL_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_DBGSEL_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_DBGSEL_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_DBGSEL_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DBGSEL_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_DBGSEL_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_DBGSEL_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_DBGSEL_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_DBGSEL_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_DBGSEL_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DBGSEL_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_DBGSEL_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_DBGSEL_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_DBGSEL_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_DBGSEL_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_DBGSEL_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DBGSEL_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_DBGSEL_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_DBGSEL_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_DBGSEL_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_DBGSEL_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_DBGSEL_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DBGSEL_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_DBGSEL_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_DBGSEL_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_DBGSEL_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_DBGSEL_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_DBGSEL_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_DBGSEL_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_DBGSEL_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_DBGSEL_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_DBGSEL_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1    	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* debug_select */
	uint32_t dbgsel	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_DBGSEL ;
#else
typedef struct
{	uint32_t dbgsel	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* debug_select */
	uint32_t r1    	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_DBGSEL ;
#endif

/*****************************************************************************************/
/* TX_reset_command                                                                      */
/* This register enables reset of internal units (for possible WA purposes).             */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_TXRSTCMD_R1_DEFAULT_VALUE                       ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_R1_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_REQFIFORST_NO_RESET_VALUE              ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_REQFIFORST_NO_RESET_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_REQFIFORST_RESET_VALUE                 ( 0x1 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_STSFIFORST_NO_RESET_VALUE              ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_STSFIFORST_NO_RESET_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_STSFIFORST_RESET_VALUE                 ( 0x1 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_SKBPTRRST_NO_RESET_VALUE               ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_SKBPTRRST_NO_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_SKBPTRRST_RESET_VALUE                  ( 0x1 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_SRAMFIFORST_NO_RESET_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_SRAMFIFORST_NO_RESET_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_SRAMFIFORST_RESET_VALUE                ( 0x1 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_DDRFIFORST_NO_RESET_VALUE              ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_DDRFIFORST_NO_RESET_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_DDRFIFORST_RESET_VALUE                 ( 0x1 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_OKFIFORST_NO_RESET_VALUE               ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_OKFIFORST_NO_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_OKFIFORST_RESET_VALUE                  ( 0x1 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_SBPMFIFORST_NO_RESET_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_SBPMFIFORST_NO_RESET_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_SBPMFIFORST_RESET_VALUE                ( 0x1 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_BPMFIFORST_NO_RESET_VALUE              ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_BPMFIFORST_NO_RESET_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_BPMFIFORST_RESET_VALUE                 ( 0x1 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_SDMAPTRRST_NO_RESET_VALUE              ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_SDMAPTRRST_NO_RESET_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_SDMAPTRRST_RESET_VALUE                 ( 0x1 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_DMAPTRRST_NO_RESET_VALUE               ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_DMAPTRRST_NO_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_DMAPTRRST_RESET_VALUE                  ( 0x1 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_PDFIFORST_NO_RESET_VALUE               ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_PDFIFORST_NO_RESET_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_PDFIFORST_RESET_VALUE                  ( 0x1 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_CNTXTRST_NO_RESET_VALUE                ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_CNTXTRST_NO_RESET_VALUE_RESET_VALUE    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_CNTXTRST_RESET_VALUE                   ( 0x1 )


#define BBH_TX_CONFIGURATIONS_TXRSTCMD_OFFSET ( 0x00000064 )

#define BBH_TX_0_CONFIGURATIONS_TXRSTCMD_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TXRSTCMD_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_TXRSTCMD_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_TXRSTCMD_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_TXRSTCMD_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TXRSTCMD_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_TXRSTCMD_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_TXRSTCMD_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_TXRSTCMD_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TXRSTCMD_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_TXRSTCMD_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_TXRSTCMD_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_TXRSTCMD_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TXRSTCMD_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_TXRSTCMD_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_TXRSTCMD_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_TXRSTCMD_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TXRSTCMD_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_TXRSTCMD_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_TXRSTCMD_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_TXRSTCMD_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TXRSTCMD_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_TXRSTCMD_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_TXRSTCMD_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_TXRSTCMD_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TXRSTCMD_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_TXRSTCMD_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_TXRSTCMD_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_TXRSTCMD_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_TXRSTCMD_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_TXRSTCMD_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_TXRSTCMD_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_TXRSTCMD_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1         	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* REQ_FIFO_reset */
	uint32_t reqfiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* STS_FIFOs_reset */
	uint32_t stsfiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SKB_PTR_reset */
	uint32_t skbptrrst  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SRAM_FIFO_reset */
	uint32_t sramfiforst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_FIFO_reset */
	uint32_t ddrfiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Order_Keeper_FIFO_reset */
	uint32_t okfiforst  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_FIFO_reset */
	uint32_t sbpmfiforst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_FIFO_reset */
	uint32_t bpmfiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA_write_pointer_reset */
	uint32_t sdmaptrrst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_write_pointer_reset */
	uint32_t dmaptrrst  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PDs_FIFOs_reset */
	uint32_t pdfiforst  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_reset */
	uint32_t cntxtrst   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_TXRSTCMD ;
#else
typedef struct
{	uint32_t cntxtrst   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_reset */
	uint32_t pdfiforst  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PDs_FIFOs_reset */
	uint32_t dmaptrrst  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_write_pointer_reset */
	uint32_t sdmaptrrst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA_write_pointer_reset */
	uint32_t bpmfiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_FIFO_reset */
	uint32_t sbpmfiforst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_FIFO_reset */
	uint32_t okfiforst  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Order_Keeper_FIFO_reset */
	uint32_t ddrfiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_FIFO_reset */
	uint32_t sramfiforst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SRAM_FIFO_reset */
	uint32_t skbptrrst  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SKB_PTR_reset */
	uint32_t stsfiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* STS_FIFOs_reset */
	uint32_t reqfiforst 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* REQ_FIFO_reset */
	uint32_t r1         	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_TXRSTCMD ;
#endif

/*****************************************************************************************/
/* EMAC1588                                                                              */
/* EMAC configuration for 1588. An option to force the BBH to wait till the EMAC FIFO is */
/*  empty before issuing a DMA read command (of a 1588 packet only).  This register is r */
/* elevant for Ethernet only.                                                            */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_EMAC1588_R1_RESERVED_VALUE                        ( 0x0 )
#define BBH_TX_CONFIGURATIONS_EMAC1588_R1_RESERVED_VALUE_RESET_VALUE            ( 0x0 )
#define BBH_TX_CONFIGURATIONS_EMAC1588_EMAC1588_DONTWAITEMPTY_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_EMAC1588_EMAC1588_DONTWAITEMPTY_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_EMAC1588_EMAC1588_WAITEMPTY_VALUE                 ( 0x1 )


#define BBH_TX_CONFIGURATIONS_EMAC1588_OFFSET ( 0x00000068 )

#define BBH_TX_0_CONFIGURATIONS_EMAC1588_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_EMAC1588_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_EMAC1588_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_EMAC1588_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_EMAC1588_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_EMAC1588_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_EMAC1588_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_EMAC1588_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_EMAC1588_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_EMAC1588_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_EMAC1588_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_EMAC1588_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_EMAC1588_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_EMAC1588_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_EMAC1588_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_EMAC1588_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_EMAC1588_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_EMAC1588_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_EMAC1588_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_EMAC1588_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_EMAC1588_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_EMAC1588_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_EMAC1588_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_EMAC1588_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_EMAC1588_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_EMAC1588_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_EMAC1588_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_EMAC1588_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_EMAC1588_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_EMAC1588_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_EMAC1588_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_EMAC1588_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_EMAC1588_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_EMAC1588_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_EMAC1588_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_EMAC1588_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_EMAC1588_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_EMAC1588_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_EMAC1588_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_EMAC1588_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_EMAC1588_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_EMAC1588_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_EMAC1588_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_EMAC1588_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_EMAC1588_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_EMAC1588_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_EMAC1588_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC1588 */
	uint32_t emac1588	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_EMAC1588 ;
#else
typedef struct
{	uint32_t emac1588	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC1588 */
	uint32_t r1      	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_EMAC1588 ;
#endif

/*****************************************************************************************/
/* SBPM_configurations                                                                   */
/* When packet transmission is done, the BBH releases the SBPM buffers.  This register d */
/* efines which release command is used:  1. Normal free with context  2. Special free w */
/* ith context  3. free without context                                                  */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_SBPMCFG_R1_RESERVED_VALUE                          ( 0x0 )
#define BBH_TX_CONFIGURATIONS_SBPMCFG_R1_RESERVED_VALUE_RESET_VALUE              ( 0x0 )
#define BBH_TX_CONFIGURATIONS_SBPMCFG_SPECIALFREE_NORMAL_VALUE                   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_SBPMCFG_SPECIALFREE_SPECIAL_VALUE                  ( 0x1 )
#define BBH_TX_CONFIGURATIONS_SBPMCFG_SPECIALFREE_SPECIAL_VALUE_RESET_VALUE      ( 0x1 )
#define BBH_TX_CONFIGURATIONS_SBPMCFG_FREENOCNTXT_WITH_CONTEXT_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_SBPMCFG_FREENOCNTXT_WITH_CONTEXT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_SBPMCFG_FREENOCNTXT_WITHOUT_CONTEXT_VALUE          ( 0x1 )


#define BBH_TX_CONFIGURATIONS_SBPMCFG_OFFSET ( 0x0000006C )

#define BBH_TX_0_CONFIGURATIONS_SBPMCFG_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SBPMCFG_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_SBPMCFG_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_SBPMCFG_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_SBPMCFG_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_SBPMCFG_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_SBPMCFG_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SBPMCFG_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_SBPMCFG_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_SBPMCFG_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_SBPMCFG_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_SBPMCFG_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_SBPMCFG_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SBPMCFG_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_SBPMCFG_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_SBPMCFG_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_SBPMCFG_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_SBPMCFG_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_SBPMCFG_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SBPMCFG_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_SBPMCFG_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_SBPMCFG_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_SBPMCFG_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_SBPMCFG_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_SBPMCFG_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SBPMCFG_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_SBPMCFG_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_SBPMCFG_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_SBPMCFG_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_SBPMCFG_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_SBPMCFG_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SBPMCFG_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_SBPMCFG_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_SBPMCFG_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_SBPMCFG_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_SBPMCFG_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_SBPMCFG_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SBPMCFG_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_SBPMCFG_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_SBPMCFG_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_SBPMCFG_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_SBPMCFG_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_SBPMCFG_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_SBPMCFG_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_SBPMCFG_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_SBPMCFG_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_SBPMCFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1         	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Special_free_with_context_en */
	uint32_t specialfree	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Free_without_context_en */
	uint32_t freenocntxt	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_SBPMCFG ;
#else
typedef struct
{	uint32_t freenocntxt	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Free_without_context_en */
	uint32_t specialfree	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Special_free_with_context_en */
	uint32_t r1         	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_SBPMCFG ;
#endif

/*****************************************************************************************/
/* PD_WKUP_THRESH_0_7                                                                    */
/* The BBH manages 32 queues for EPON (FIFO per LLID). For each queue it manages a PD FI */
/* FO.   When a FIFO occupancy is above this wakeup threshold, the BBH will not wake-up  */
/* the Runner for sending a new PD. This threshold does not represent the actual size of */
/*  the FIFO. If a PD will arrive from the Runner when the FIFO is above the threshold,  */
/* it will not be dropped unless the FIFO is actually full.  Relevant only for EPON BBH. */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH7_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH7_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH7_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH6_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH6_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH6_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH5_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH5_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH5_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH4_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH4_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH4_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH3_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH3_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH3_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH2_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH2_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH2_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH1_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH1_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH1_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH0_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH0_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WKUPTHRESH0_MAX_EPON_VALUE                 ( 0xF )


#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_OFFSET ( 0x00000070 )

#define BBH_TX_0_CONFIGURATIONS_PDWKUPH0_7_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH0_7_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_PDWKUPH0_7_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_PDWKUPH0_7_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_PDWKUPH0_7_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH0_7_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_PDWKUPH0_7_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_PDWKUPH0_7_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_PDWKUPH0_7_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH0_7_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_PDWKUPH0_7_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_PDWKUPH0_7_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_PDWKUPH0_7_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH0_7_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_PDWKUPH0_7_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_PDWKUPH0_7_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_PDWKUPH0_7_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH0_7_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_PDWKUPH0_7_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_PDWKUPH0_7_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_PDWKUPH0_7_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH0_7_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_PDWKUPH0_7_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_PDWKUPH0_7_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_PDWKUPH0_7_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH0_7_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_PDWKUPH0_7_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_PDWKUPH0_7_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_PDWKUPH0_7_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_PDWKUPH0_7_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_PDWKUPH0_7_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_PDWKUPH0_7_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* FIFO_wake_up_threshold_7 */
	uint32_t wkupthresh7	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_6 */
	uint32_t wkupthresh6	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_5 */
	uint32_t wkupthresh5	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_4 */
	uint32_t wkupthresh4	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_3 */
	uint32_t wkupthresh3	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_2 */
	uint32_t wkupthresh2	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_1 */
	uint32_t wkupthresh1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_0 */
	uint32_t wkupthresh0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDWKUPH0_7 ;
#else
typedef struct
{	uint32_t wkupthresh0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_0 */
	uint32_t wkupthresh1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_1 */
	uint32_t wkupthresh2	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_2 */
	uint32_t wkupthresh3	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_3 */
	uint32_t wkupthresh4	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_4 */
	uint32_t wkupthresh5	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_5 */
	uint32_t wkupthresh6	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_6 */
	uint32_t wkupthresh7	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_7 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDWKUPH0_7 ;
#endif

/*****************************************************************************************/
/* PD_WKUP_THRESH_8_31                                                                   */
/* The BBH manages 32 queues for EPON (FIFO per LLID). For each queue it manages a PD FI */
/* FO.   When a FIFO occupancy is above this wakeup threshold, the BBH will not wake-up  */
/* the Runner for sending a new PD. This threshold does not represent the actual size of */
/*  the FIFO. If a PD will arrive from the Runner when the FIFO is above the threshold,  */
/* it will not be dropped unless the FIFO is actually full.  For queues 8-31, this confi */
/* guration is per octet.  Relevant only for EPON BBH.                                   */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_R2_DEFAULT_VALUE                               ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_R2_DEFAULT_VALUE_RESET_VALUE                   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_WKUPTHRESH24_31_DEFAULT_EPON_VALUE             ( 0x2 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_WKUPTHRESH24_31_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x2 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_WKUPTHRESH24_31_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_R1_DEFAULT_VALUE                               ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_R1_DEFAULT_VALUE_RESET_VALUE                   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_WKUPTHRESH16_23_DEFAULT_EPON_VALUE             ( 0x2 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_WKUPTHRESH16_23_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x2 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_WKUPTHRESH16_23_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_R0_DEFAULT_VALUE                               ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_R0_DEFAULT_VALUE_RESET_VALUE                   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_WKUPTHRESH8_15_DEFAULT_EPON_VALUE              ( 0x2 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_WKUPTHRESH8_15_DEFAULT_EPON_VALUE_RESET_VALUE  ( 0x2 )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_WKUPTHRESH8_15_MAX_EPON_VALUE                  ( 0xF )


#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_OFFSET ( 0x00000074 )

#define BBH_TX_0_CONFIGURATIONS_PDWKUPH8_31_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH8_31_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_PDWKUPH8_31_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH8_31_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_PDWKUPH8_31_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH8_31_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_PDWKUPH8_31_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH8_31_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_PDWKUPH8_31_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH8_31_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_PDWKUPH8_31_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH8_31_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_PDWKUPH8_31_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH8_31_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_PDWKUPH8_31_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_PDWKUPH8_31_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_PDWKUPH8_31_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_PDWKUPH8_31_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2             	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_24_31 */
	uint32_t wkupthresh24_31	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1             	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_16_23 */
	uint32_t wkupthresh16_23	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r0             	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_8_15 */
	uint32_t wkupthresh8_15 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDWKUPH8_31 ;
#else
typedef struct
{	uint32_t wkupthresh8_15 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_8_15 */
	uint32_t r0             	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t wkupthresh16_23	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_16_23 */
	uint32_t r1             	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t wkupthresh24_31	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_24_31 */
	uint32_t r2             	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDWKUPH8_31 ;
#endif

/*****************************************************************************************/
/* PD_EMPTY_THRESHOLD                                                                    */
/* The BBH manages 32 queues for EPON (FIFO per LLID). For each queue it manages a PD FI */
/* FO. Usually, the BBH orders PDs from the Runner in RR between all queues. In EPON BBH */
/* , if a FIFO occupancy is below this threshold, the queue will have higher priority in */
/*  PD ordering arbitration (with RR between all the empty queues).  This configuration  */
/* is global for all queues.  Relevant only for EPON BBH.                                */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_PDEMPTY_R1_DEFAULT_VALUE                ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDEMPTY_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDEMPTY_EMPTY_MIN_VALUE                 ( 0x0 )
#define BBH_TX_CONFIGURATIONS_PDEMPTY_EMPTY_DEFAULT_VALUE             ( 0x1 )
#define BBH_TX_CONFIGURATIONS_PDEMPTY_EMPTY_DEFAULT_VALUE_RESET_VALUE ( 0x1 )
#define BBH_TX_CONFIGURATIONS_PDEMPTY_EMPTY_MAX_VALUE                 ( 0xF )


#define BBH_TX_CONFIGURATIONS_PDEMPTY_OFFSET ( 0x00000078 )

#define BBH_TX_0_CONFIGURATIONS_PDEMPTY_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDEMPTY_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_PDEMPTY_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_PDEMPTY_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDEMPTY_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_PDEMPTY_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_PDEMPTY_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDEMPTY_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_PDEMPTY_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_PDEMPTY_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDEMPTY_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_PDEMPTY_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_PDEMPTY_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDEMPTY_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_PDEMPTY_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_PDEMPTY_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDEMPTY_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_PDEMPTY_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_PDEMPTY_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDEMPTY_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_PDEMPTY_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_PDEMPTY_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_PDEMPTY_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_PDEMPTY_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_PDEMPTY_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_PDEMPTY_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Empty_thershold */
	uint32_t empty	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDEMPTY ;
#else
typedef struct
{	uint32_t empty	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Empty_thershold */
	uint32_t r1   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_PDEMPTY ;
#endif

/*****************************************************************************************/
/* ETH_TRANSMIT_TH                                                                       */
/* This register contains the Transmit threshold configurations for both DDR/PSRAM packe */
/* ts; packet is transmitted only if the amount of bytes in the TX FIFO is higher or equ */
/* al to the transmit threshold or if the whole packet is in the TX FIFO                 */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_ETHTT_R3_DEFAULT_VALUE                   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_ETHTT_R3_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_TX_CONFIGURATIONS_ETHTT_URGENTEN_DISABLE_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_ETHTT_URGENTEN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONFIGURATIONS_ETHTT_URGENTEN_ENABLE_VALUE              ( 0x1 )
#define BBH_TX_CONFIGURATIONS_ETHTT_ACCEN_DISABLE_VALUE                ( 0x0 )
#define BBH_TX_CONFIGURATIONS_ETHTT_ACCEN_DISABLE_VALUE_RESET_VALUE    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_ETHTT_ACCEN_ENABLE_VALUE                 ( 0x1 )
#define BBH_TX_CONFIGURATIONS_ETHTT_R1_DEFAULT_VALUE                   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_ETHTT_R1_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_TX_CONFIGURATIONS_ETHTT_SRAMTT_DEFAULT_VALUE               ( 0x20 )
#define BBH_TX_CONFIGURATIONS_ETHTT_SRAMTT_DEFAULT_VALUE_RESET_VALUE   ( 0x20 )
#define BBH_TX_CONFIGURATIONS_ETHTT_R2_DEFAULT_VALUE                   ( 0x0 )
#define BBH_TX_CONFIGURATIONS_ETHTT_R2_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_TX_CONFIGURATIONS_ETHTT_DDRTT_DEFAULT_VALUE                ( 0x1C0 )
#define BBH_TX_CONFIGURATIONS_ETHTT_DDRTT_DEFAULT_VALUE_RESET_VALUE    ( 0x1C0 )


#define BBH_TX_CONFIGURATIONS_ETHTT_OFFSET ( 0x0000007C )

#define BBH_TX_0_CONFIGURATIONS_ETHTT_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_ETHTT_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_ETHTT_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_ETHTT_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_ETHTT_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_ETHTT_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_ETHTT_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_ETHTT_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_ETHTT_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_ETHTT_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_ETHTT_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_ETHTT_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_ETHTT_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_ETHTT_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_ETHTT_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_ETHTT_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_ETHTT_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_ETHTT_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_ETHTT_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_ETHTT_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_ETHTT_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_ETHTT_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_ETHTT_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_ETHTT_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_ETHTT_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_ETHTT_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_ETHTT_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_ETHTT_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_ETHTT_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_ETHTT_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_ETHTT_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_ETHTT_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_ETHTT_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_ETHTT_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_ETHTT_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_ETHTT_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_ETHTT_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_ETHTT_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_ETHTT_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_ETHTT_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_ETHTT_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_ETHTT_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_ETHTT_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_ETHTT_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_ETHTT_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_ETHTT_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_ETHTT_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r3      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* URGENT_EN */
	uint32_t urgenten	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ACCURATE_REQ_EN */
	uint32_t accen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1      	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SRAM_TRANSMIT_TH */
	uint32_t sramtt  	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2      	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_TRANSMIT_TH */
	uint32_t ddrtt   	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_ETHTT ;
#else
typedef struct
{	uint32_t ddrtt   	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_TRANSMIT_TH */
	uint32_t r2      	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t sramtt  	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SRAM_TRANSMIT_TH */
	uint32_t r1      	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t accen   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ACCURATE_REQ_EN */
	uint32_t urgenten	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* URGENT_EN */
	uint32_t r3      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_ETHTT ;
#endif

/*****************************************************************************************/
/* DSL_MAXWLEN                                                                           */
/* VDSL max word len    relevant only for VDSL BBH                                       */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_MAXWLEN_R1_DEFAULT_VALUE                  ( 0x0 )
#define BBH_TX_CONFIGURATIONS_MAXWLEN_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_TX_CONFIGURATIONS_MAXWLEN_MAXWLEN_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_MAXWLEN_MAXWLEN_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_CONFIGURATIONS_MAXWLEN_OFFSET ( 0x00000080 )

#define BBH_TX_0_CONFIGURATIONS_MAXWLEN_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MAXWLEN_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_MAXWLEN_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_MAXWLEN_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_MAXWLEN_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_MAXWLEN_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_MAXWLEN_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MAXWLEN_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_MAXWLEN_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_MAXWLEN_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_MAXWLEN_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_MAXWLEN_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_MAXWLEN_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MAXWLEN_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_MAXWLEN_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_MAXWLEN_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_MAXWLEN_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_MAXWLEN_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_MAXWLEN_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MAXWLEN_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_MAXWLEN_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_MAXWLEN_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_MAXWLEN_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_MAXWLEN_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_MAXWLEN_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MAXWLEN_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_MAXWLEN_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_MAXWLEN_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_MAXWLEN_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_MAXWLEN_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_MAXWLEN_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MAXWLEN_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_MAXWLEN_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_MAXWLEN_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_MAXWLEN_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_MAXWLEN_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_MAXWLEN_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MAXWLEN_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_MAXWLEN_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_MAXWLEN_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_MAXWLEN_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_MAXWLEN_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_MAXWLEN_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_MAXWLEN_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_MAXWLEN_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_MAXWLEN_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_MAXWLEN_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1     	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_word_len */
	uint32_t maxwlen	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_MAXWLEN ;
#else
typedef struct
{	uint32_t maxwlen	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_word_len */
	uint32_t r1     	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_MAXWLEN ;
#endif

/*****************************************************************************************/
/* DSL_FLUSH                                                                             */
/* VDSL Flush indication    relevant only for VDSL BBH                                   */
/*****************************************************************************************/

#define BBH_TX_CONFIGURATIONS_FLUSH_R1_DEFAULT_VALUE                ( 0x0 )
#define BBH_TX_CONFIGURATIONS_FLUSH_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define BBH_TX_CONFIGURATIONS_FLUSH_FLUSH_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_CONFIGURATIONS_FLUSH_FLUSH_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_CONFIGURATIONS_FLUSH_OFFSET ( 0x00000084 )

#define BBH_TX_0_CONFIGURATIONS_FLUSH_ADDRESS   	( BBH_TX_0_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_FLUSH_OFFSET )
#define BBH_TX_0_CONFIGURATIONS_FLUSH_READ( r ) 	READ_32( ( BBH_TX_0_CONFIGURATIONS_FLUSH_ADDRESS ), (r) )
#define BBH_TX_0_CONFIGURATIONS_FLUSH_WRITE( v )	WRITE_32( ( BBH_TX_0_CONFIGURATIONS_FLUSH_ADDRESS ), (v) )

#define BBH_TX_1_CONFIGURATIONS_FLUSH_ADDRESS   	( BBH_TX_1_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_FLUSH_OFFSET )
#define BBH_TX_1_CONFIGURATIONS_FLUSH_READ( r ) 	READ_32( ( BBH_TX_1_CONFIGURATIONS_FLUSH_ADDRESS ), (r) )
#define BBH_TX_1_CONFIGURATIONS_FLUSH_WRITE( v )	WRITE_32( ( BBH_TX_1_CONFIGURATIONS_FLUSH_ADDRESS ), (v) )

#define BBH_TX_2_CONFIGURATIONS_FLUSH_ADDRESS   	( BBH_TX_2_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_FLUSH_OFFSET )
#define BBH_TX_2_CONFIGURATIONS_FLUSH_READ( r ) 	READ_32( ( BBH_TX_2_CONFIGURATIONS_FLUSH_ADDRESS ), (r) )
#define BBH_TX_2_CONFIGURATIONS_FLUSH_WRITE( v )	WRITE_32( ( BBH_TX_2_CONFIGURATIONS_FLUSH_ADDRESS ), (v) )

#define BBH_TX_3_CONFIGURATIONS_FLUSH_ADDRESS   	( BBH_TX_3_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_FLUSH_OFFSET )
#define BBH_TX_3_CONFIGURATIONS_FLUSH_READ( r ) 	READ_32( ( BBH_TX_3_CONFIGURATIONS_FLUSH_ADDRESS ), (r) )
#define BBH_TX_3_CONFIGURATIONS_FLUSH_WRITE( v )	WRITE_32( ( BBH_TX_3_CONFIGURATIONS_FLUSH_ADDRESS ), (v) )

#define BBH_TX_4_CONFIGURATIONS_FLUSH_ADDRESS   	( BBH_TX_4_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_FLUSH_OFFSET )
#define BBH_TX_4_CONFIGURATIONS_FLUSH_READ( r ) 	READ_32( ( BBH_TX_4_CONFIGURATIONS_FLUSH_ADDRESS ), (r) )
#define BBH_TX_4_CONFIGURATIONS_FLUSH_WRITE( v )	WRITE_32( ( BBH_TX_4_CONFIGURATIONS_FLUSH_ADDRESS ), (v) )

#define BBH_TX_5_CONFIGURATIONS_FLUSH_ADDRESS   	( BBH_TX_5_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_FLUSH_OFFSET )
#define BBH_TX_5_CONFIGURATIONS_FLUSH_READ( r ) 	READ_32( ( BBH_TX_5_CONFIGURATIONS_FLUSH_ADDRESS ), (r) )
#define BBH_TX_5_CONFIGURATIONS_FLUSH_WRITE( v )	WRITE_32( ( BBH_TX_5_CONFIGURATIONS_FLUSH_ADDRESS ), (v) )

#define BBH_TX_6_CONFIGURATIONS_FLUSH_ADDRESS   	( BBH_TX_6_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_FLUSH_OFFSET )
#define BBH_TX_6_CONFIGURATIONS_FLUSH_READ( r ) 	READ_32( ( BBH_TX_6_CONFIGURATIONS_FLUSH_ADDRESS ), (r) )
#define BBH_TX_6_CONFIGURATIONS_FLUSH_WRITE( v )	WRITE_32( ( BBH_TX_6_CONFIGURATIONS_FLUSH_ADDRESS ), (v) )


extern uint32_t BBH_TX_CONFIGURATIONS_FLUSH_ARRAY [ ] ;

#define BBH_TX_CONFIGURATIONS_FLUSH_WRITE( i, v )	WRITE_32( BBH_TX_CONFIGURATIONS_FLUSH_ARRAY [ i ], (v) )
#define BBH_TX_CONFIGURATIONS_FLUSH_READ( i, r ) 	READ_32( BBH_TX_CONFIGURATIONS_FLUSH_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1   	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* flush */
	uint32_t flush	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_FLUSH ;
#else
typedef struct
{	uint32_t flush	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* flush */
	uint32_t r1   	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS_FLUSH ;
#endif

/*****************************************************************************************/
/* SRAM_PD_counter                                                                       */
/* This counter counts the number of packets which were transmitted from the SRAM.  It c */
/* ounts the packets for all TCONTs together.  This counter is cleared when read and fre */
/* ezes when maximum value is reached.  This counter is relevant for Ethernet only.      */
/*****************************************************************************************/

#define BBH_TX_DEBUG_SRAMPD_SRAMPD_SRAM_PD_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_SRAMPD_SRAMPD_SRAM_PD_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_DEBUG_SRAMPD_OFFSET ( 0x00000000 )

#define BBH_TX_0_DEBUG_SRAMPD_ADDRESS   	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_SRAMPD_OFFSET )
#define BBH_TX_0_DEBUG_SRAMPD_READ( r ) 	READ_32( ( BBH_TX_0_DEBUG_SRAMPD_ADDRESS ), (r) )
#define BBH_TX_0_DEBUG_SRAMPD_WRITE( v )	WRITE_32( ( BBH_TX_0_DEBUG_SRAMPD_ADDRESS ), (v) )

#define BBH_TX_1_DEBUG_SRAMPD_ADDRESS   	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_SRAMPD_OFFSET )
#define BBH_TX_1_DEBUG_SRAMPD_READ( r ) 	READ_32( ( BBH_TX_1_DEBUG_SRAMPD_ADDRESS ), (r) )
#define BBH_TX_1_DEBUG_SRAMPD_WRITE( v )	WRITE_32( ( BBH_TX_1_DEBUG_SRAMPD_ADDRESS ), (v) )

#define BBH_TX_2_DEBUG_SRAMPD_ADDRESS   	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_SRAMPD_OFFSET )
#define BBH_TX_2_DEBUG_SRAMPD_READ( r ) 	READ_32( ( BBH_TX_2_DEBUG_SRAMPD_ADDRESS ), (r) )
#define BBH_TX_2_DEBUG_SRAMPD_WRITE( v )	WRITE_32( ( BBH_TX_2_DEBUG_SRAMPD_ADDRESS ), (v) )

#define BBH_TX_3_DEBUG_SRAMPD_ADDRESS   	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_SRAMPD_OFFSET )
#define BBH_TX_3_DEBUG_SRAMPD_READ( r ) 	READ_32( ( BBH_TX_3_DEBUG_SRAMPD_ADDRESS ), (r) )
#define BBH_TX_3_DEBUG_SRAMPD_WRITE( v )	WRITE_32( ( BBH_TX_3_DEBUG_SRAMPD_ADDRESS ), (v) )

#define BBH_TX_4_DEBUG_SRAMPD_ADDRESS   	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_SRAMPD_OFFSET )
#define BBH_TX_4_DEBUG_SRAMPD_READ( r ) 	READ_32( ( BBH_TX_4_DEBUG_SRAMPD_ADDRESS ), (r) )
#define BBH_TX_4_DEBUG_SRAMPD_WRITE( v )	WRITE_32( ( BBH_TX_4_DEBUG_SRAMPD_ADDRESS ), (v) )

#define BBH_TX_5_DEBUG_SRAMPD_ADDRESS   	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_SRAMPD_OFFSET )
#define BBH_TX_5_DEBUG_SRAMPD_READ( r ) 	READ_32( ( BBH_TX_5_DEBUG_SRAMPD_ADDRESS ), (r) )
#define BBH_TX_5_DEBUG_SRAMPD_WRITE( v )	WRITE_32( ( BBH_TX_5_DEBUG_SRAMPD_ADDRESS ), (v) )

#define BBH_TX_6_DEBUG_SRAMPD_ADDRESS   	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_SRAMPD_OFFSET )
#define BBH_TX_6_DEBUG_SRAMPD_READ( r ) 	READ_32( ( BBH_TX_6_DEBUG_SRAMPD_ADDRESS ), (r) )
#define BBH_TX_6_DEBUG_SRAMPD_WRITE( v )	WRITE_32( ( BBH_TX_6_DEBUG_SRAMPD_ADDRESS ), (v) )


extern uint32_t BBH_TX_DEBUG_SRAMPD_ARRAY [ ] ;

#define BBH_TX_DEBUG_SRAMPD_WRITE( i, v )	WRITE_32( BBH_TX_DEBUG_SRAMPD_ARRAY [ i ], (v) )
#define BBH_TX_DEBUG_SRAMPD_READ( i, r ) 	READ_32( BBH_TX_DEBUG_SRAMPD_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* SRAM_PD */
	uint32_t srampd	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_SRAMPD ;
#else
typedef struct
{	uint32_t srampd	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SRAM_PD */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_SRAMPD ;
#endif

/*****************************************************************************************/
/* DDR_PD_counter                                                                        */
/* This counter counts the number of packets which were transmitted from the DDR.  It co */
/* unts the packets for all TCONTs together.  This counter is cleared when read and free */
/* zes when maximum value is reached.                                                    */
/*****************************************************************************************/

#define BBH_TX_DEBUG_DDRPD_DDRPD_DDR_PD_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_DDRPD_DDRPD_DDR_PD_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_DEBUG_DDRPD_OFFSET ( 0x00000004 )

#define BBH_TX_0_DEBUG_DDRPD_ADDRESS   	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_DDRPD_OFFSET )
#define BBH_TX_0_DEBUG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_0_DEBUG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_0_DEBUG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_0_DEBUG_DDRPD_ADDRESS ), (v) )

#define BBH_TX_1_DEBUG_DDRPD_ADDRESS   	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_DDRPD_OFFSET )
#define BBH_TX_1_DEBUG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_1_DEBUG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_1_DEBUG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_1_DEBUG_DDRPD_ADDRESS ), (v) )

#define BBH_TX_2_DEBUG_DDRPD_ADDRESS   	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_DDRPD_OFFSET )
#define BBH_TX_2_DEBUG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_2_DEBUG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_2_DEBUG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_2_DEBUG_DDRPD_ADDRESS ), (v) )

#define BBH_TX_3_DEBUG_DDRPD_ADDRESS   	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_DDRPD_OFFSET )
#define BBH_TX_3_DEBUG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_3_DEBUG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_3_DEBUG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_3_DEBUG_DDRPD_ADDRESS ), (v) )

#define BBH_TX_4_DEBUG_DDRPD_ADDRESS   	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_DDRPD_OFFSET )
#define BBH_TX_4_DEBUG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_4_DEBUG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_4_DEBUG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_4_DEBUG_DDRPD_ADDRESS ), (v) )

#define BBH_TX_5_DEBUG_DDRPD_ADDRESS   	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_DDRPD_OFFSET )
#define BBH_TX_5_DEBUG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_5_DEBUG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_5_DEBUG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_5_DEBUG_DDRPD_ADDRESS ), (v) )

#define BBH_TX_6_DEBUG_DDRPD_ADDRESS   	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_DDRPD_OFFSET )
#define BBH_TX_6_DEBUG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_6_DEBUG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_6_DEBUG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_6_DEBUG_DDRPD_ADDRESS ), (v) )


extern uint32_t BBH_TX_DEBUG_DDRPD_ARRAY [ ] ;

#define BBH_TX_DEBUG_DDRPD_WRITE( i, v )	WRITE_32( BBH_TX_DEBUG_DDRPD_ARRAY [ i ], (v) )
#define BBH_TX_DEBUG_DDRPD_READ( i, r ) 	READ_32( BBH_TX_DEBUG_DDRPD_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DDR_PD */
	uint32_t ddrpd	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_DDRPD ;
#else
typedef struct
{	uint32_t ddrpd	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_PD */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_DDRPD ;
#endif

/*****************************************************************************************/
/* PD_DROP_counter                                                                       */
/* This counter counts the number of PDs which were dropped due to PD FIFO full.  It cou */
/* nts the packets for all TCONTs together.  This counter is cleared when read and freez */
/* es when maximum value is reached.  This counter is relevant for Ethernet only.        */
/*****************************************************************************************/

#define BBH_TX_DEBUG_PDDROP_R1_RESERVED_VALUE               ( 0x0 )
#define BBH_TX_DEBUG_PDDROP_R1_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_TX_DEBUG_PDDROP_PDDROP_PDDROP_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_PDDROP_PDDROP_PDDROP_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_DEBUG_PDDROP_OFFSET ( 0x00000008 )

#define BBH_TX_0_DEBUG_PDDROP_ADDRESS   	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_PDDROP_OFFSET )
#define BBH_TX_0_DEBUG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_0_DEBUG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_0_DEBUG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_0_DEBUG_PDDROP_ADDRESS ), (v) )

#define BBH_TX_1_DEBUG_PDDROP_ADDRESS   	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_PDDROP_OFFSET )
#define BBH_TX_1_DEBUG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_1_DEBUG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_1_DEBUG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_1_DEBUG_PDDROP_ADDRESS ), (v) )

#define BBH_TX_2_DEBUG_PDDROP_ADDRESS   	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_PDDROP_OFFSET )
#define BBH_TX_2_DEBUG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_2_DEBUG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_2_DEBUG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_2_DEBUG_PDDROP_ADDRESS ), (v) )

#define BBH_TX_3_DEBUG_PDDROP_ADDRESS   	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_PDDROP_OFFSET )
#define BBH_TX_3_DEBUG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_3_DEBUG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_3_DEBUG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_3_DEBUG_PDDROP_ADDRESS ), (v) )

#define BBH_TX_4_DEBUG_PDDROP_ADDRESS   	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_PDDROP_OFFSET )
#define BBH_TX_4_DEBUG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_4_DEBUG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_4_DEBUG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_4_DEBUG_PDDROP_ADDRESS ), (v) )

#define BBH_TX_5_DEBUG_PDDROP_ADDRESS   	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_PDDROP_OFFSET )
#define BBH_TX_5_DEBUG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_5_DEBUG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_5_DEBUG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_5_DEBUG_PDDROP_ADDRESS ), (v) )

#define BBH_TX_6_DEBUG_PDDROP_ADDRESS   	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_PDDROP_OFFSET )
#define BBH_TX_6_DEBUG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_6_DEBUG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_6_DEBUG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_6_DEBUG_PDDROP_ADDRESS ), (v) )


extern uint32_t BBH_TX_DEBUG_PDDROP_ARRAY [ ] ;

#define BBH_TX_DEBUG_PDDROP_WRITE( i, v )	WRITE_32( BBH_TX_DEBUG_PDDROP_ARRAY [ i ], (v) )
#define BBH_TX_DEBUG_PDDROP_READ( i, r ) 	READ_32( BBH_TX_DEBUG_PDDROP_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1    	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_DROP */
	uint32_t pddrop	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDDROP ;
#else
typedef struct
{	uint32_t pddrop	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_DROP */
	uint32_t r1    	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDDROP ;
#endif

/*****************************************************************************************/
/* PD_equal_0_counter                                                                    */
/* This counter counts the number of PDs with packet length equal zero.  It counts the p */
/* ackets for all TCONTs together.  This counter is cleared when read and freezes when m */
/* aximum value is reached.                                                              */
/*****************************************************************************************/

#define BBH_TX_DEBUG_PDEQ0_R1_RESERVED_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_PDEQ0_R1_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_DEBUG_PDEQ0_PDEQ0_PDEQ0_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_PDEQ0_PDEQ0_PDEQ0_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_DEBUG_PDEQ0_OFFSET ( 0x0000000C )

#define BBH_TX_0_DEBUG_PDEQ0_ADDRESS   	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEQ0_OFFSET )
#define BBH_TX_0_DEBUG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_0_DEBUG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_0_DEBUG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_0_DEBUG_PDEQ0_ADDRESS ), (v) )

#define BBH_TX_1_DEBUG_PDEQ0_ADDRESS   	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEQ0_OFFSET )
#define BBH_TX_1_DEBUG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_1_DEBUG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_1_DEBUG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_1_DEBUG_PDEQ0_ADDRESS ), (v) )

#define BBH_TX_2_DEBUG_PDEQ0_ADDRESS   	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEQ0_OFFSET )
#define BBH_TX_2_DEBUG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_2_DEBUG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_2_DEBUG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_2_DEBUG_PDEQ0_ADDRESS ), (v) )

#define BBH_TX_3_DEBUG_PDEQ0_ADDRESS   	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEQ0_OFFSET )
#define BBH_TX_3_DEBUG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_3_DEBUG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_3_DEBUG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_3_DEBUG_PDEQ0_ADDRESS ), (v) )

#define BBH_TX_4_DEBUG_PDEQ0_ADDRESS   	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEQ0_OFFSET )
#define BBH_TX_4_DEBUG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_4_DEBUG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_4_DEBUG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_4_DEBUG_PDEQ0_ADDRESS ), (v) )

#define BBH_TX_5_DEBUG_PDEQ0_ADDRESS   	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEQ0_OFFSET )
#define BBH_TX_5_DEBUG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_5_DEBUG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_5_DEBUG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_5_DEBUG_PDEQ0_ADDRESS ), (v) )

#define BBH_TX_6_DEBUG_PDEQ0_ADDRESS   	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEQ0_OFFSET )
#define BBH_TX_6_DEBUG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_6_DEBUG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_6_DEBUG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_6_DEBUG_PDEQ0_ADDRESS ), (v) )


extern uint32_t BBH_TX_DEBUG_PDEQ0_ARRAY [ ] ;

#define BBH_TX_DEBUG_PDEQ0_WRITE( i, v )	WRITE_32( BBH_TX_DEBUG_PDEQ0_ARRAY [ i ], (v) )
#define BBH_TX_DEBUG_PDEQ0_READ( i, r ) 	READ_32( BBH_TX_DEBUG_PDEQ0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_equal_0 */
	uint32_t pdeq0	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDEQ0 ;
#else
typedef struct
{	uint32_t pdeq0	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_equal_0 */
	uint32_t r1   	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDEQ0 ;
#endif

/*****************************************************************************************/
/* Get_next_is_null_counter                                                              */
/* This counter counts the number Get next responses with a null BN.  It counts the pack */
/* ets for all TCONTs together.  This counter is cleared when read and freezes when maxi */
/* mum value is reached.  This counter is relevant for Ethernet only.                    */
/*****************************************************************************************/

#define BBH_TX_DEBUG_GETNEXTNULL_R1_RESERVED_VALUE                         ( 0x0 )
#define BBH_TX_DEBUG_GETNEXTNULL_R1_RESERVED_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_GETNEXTNULL_GETNEXTNULL_GETNEXTNULL_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_GETNEXTNULL_GETNEXTNULL_GETNEXTNULL_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_DEBUG_GETNEXTNULL_OFFSET ( 0x00000010 )

#define BBH_TX_0_DEBUG_GETNEXTNULL_ADDRESS   	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTNULL_OFFSET )
#define BBH_TX_0_DEBUG_GETNEXTNULL_READ( r ) 	READ_32( ( BBH_TX_0_DEBUG_GETNEXTNULL_ADDRESS ), (r) )
#define BBH_TX_0_DEBUG_GETNEXTNULL_WRITE( v )	WRITE_32( ( BBH_TX_0_DEBUG_GETNEXTNULL_ADDRESS ), (v) )

#define BBH_TX_1_DEBUG_GETNEXTNULL_ADDRESS   	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTNULL_OFFSET )
#define BBH_TX_1_DEBUG_GETNEXTNULL_READ( r ) 	READ_32( ( BBH_TX_1_DEBUG_GETNEXTNULL_ADDRESS ), (r) )
#define BBH_TX_1_DEBUG_GETNEXTNULL_WRITE( v )	WRITE_32( ( BBH_TX_1_DEBUG_GETNEXTNULL_ADDRESS ), (v) )

#define BBH_TX_2_DEBUG_GETNEXTNULL_ADDRESS   	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTNULL_OFFSET )
#define BBH_TX_2_DEBUG_GETNEXTNULL_READ( r ) 	READ_32( ( BBH_TX_2_DEBUG_GETNEXTNULL_ADDRESS ), (r) )
#define BBH_TX_2_DEBUG_GETNEXTNULL_WRITE( v )	WRITE_32( ( BBH_TX_2_DEBUG_GETNEXTNULL_ADDRESS ), (v) )

#define BBH_TX_3_DEBUG_GETNEXTNULL_ADDRESS   	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTNULL_OFFSET )
#define BBH_TX_3_DEBUG_GETNEXTNULL_READ( r ) 	READ_32( ( BBH_TX_3_DEBUG_GETNEXTNULL_ADDRESS ), (r) )
#define BBH_TX_3_DEBUG_GETNEXTNULL_WRITE( v )	WRITE_32( ( BBH_TX_3_DEBUG_GETNEXTNULL_ADDRESS ), (v) )

#define BBH_TX_4_DEBUG_GETNEXTNULL_ADDRESS   	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTNULL_OFFSET )
#define BBH_TX_4_DEBUG_GETNEXTNULL_READ( r ) 	READ_32( ( BBH_TX_4_DEBUG_GETNEXTNULL_ADDRESS ), (r) )
#define BBH_TX_4_DEBUG_GETNEXTNULL_WRITE( v )	WRITE_32( ( BBH_TX_4_DEBUG_GETNEXTNULL_ADDRESS ), (v) )

#define BBH_TX_5_DEBUG_GETNEXTNULL_ADDRESS   	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTNULL_OFFSET )
#define BBH_TX_5_DEBUG_GETNEXTNULL_READ( r ) 	READ_32( ( BBH_TX_5_DEBUG_GETNEXTNULL_ADDRESS ), (r) )
#define BBH_TX_5_DEBUG_GETNEXTNULL_WRITE( v )	WRITE_32( ( BBH_TX_5_DEBUG_GETNEXTNULL_ADDRESS ), (v) )

#define BBH_TX_6_DEBUG_GETNEXTNULL_ADDRESS   	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTNULL_OFFSET )
#define BBH_TX_6_DEBUG_GETNEXTNULL_READ( r ) 	READ_32( ( BBH_TX_6_DEBUG_GETNEXTNULL_ADDRESS ), (r) )
#define BBH_TX_6_DEBUG_GETNEXTNULL_WRITE( v )	WRITE_32( ( BBH_TX_6_DEBUG_GETNEXTNULL_ADDRESS ), (v) )


extern uint32_t BBH_TX_DEBUG_GETNEXTNULL_ARRAY [ ] ;

#define BBH_TX_DEBUG_GETNEXTNULL_WRITE( i, v )	WRITE_32( BBH_TX_DEBUG_GETNEXTNULL_ARRAY [ i ], (v) )
#define BBH_TX_DEBUG_GETNEXTNULL_READ( i, r ) 	READ_32( BBH_TX_DEBUG_GETNEXTNULL_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1         	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Get_next_is_null */
	uint32_t getnextnull	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_GETNEXTNULL ;
#else
typedef struct
{	uint32_t getnextnull	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Get_next_is_null */
	uint32_t r1         	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_GETNEXTNULL ;
#endif

/*****************************************************************************************/
/* PD_Full_LSB                                                                           */
/* Full indication of the PD FIFOs.                                                      */
/*****************************************************************************************/

#define BBH_TX_DEBUG_PDFULLLSB_PDFULL_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_PDFULLLSB_PDFULL_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_DEBUG_PDFULLLSB_OFFSET ( 0x00000020 )

#define BBH_TX_0_DEBUG_PDFULLLSB_ADDRESS   	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLLSB_OFFSET )
#define BBH_TX_0_DEBUG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_0_DEBUG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_0_DEBUG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_0_DEBUG_PDFULLLSB_ADDRESS ), (v) )

#define BBH_TX_1_DEBUG_PDFULLLSB_ADDRESS   	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLLSB_OFFSET )
#define BBH_TX_1_DEBUG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_1_DEBUG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_1_DEBUG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_1_DEBUG_PDFULLLSB_ADDRESS ), (v) )

#define BBH_TX_2_DEBUG_PDFULLLSB_ADDRESS   	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLLSB_OFFSET )
#define BBH_TX_2_DEBUG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_2_DEBUG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_2_DEBUG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_2_DEBUG_PDFULLLSB_ADDRESS ), (v) )

#define BBH_TX_3_DEBUG_PDFULLLSB_ADDRESS   	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLLSB_OFFSET )
#define BBH_TX_3_DEBUG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_3_DEBUG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_3_DEBUG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_3_DEBUG_PDFULLLSB_ADDRESS ), (v) )

#define BBH_TX_4_DEBUG_PDFULLLSB_ADDRESS   	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLLSB_OFFSET )
#define BBH_TX_4_DEBUG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_4_DEBUG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_4_DEBUG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_4_DEBUG_PDFULLLSB_ADDRESS ), (v) )

#define BBH_TX_5_DEBUG_PDFULLLSB_ADDRESS   	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLLSB_OFFSET )
#define BBH_TX_5_DEBUG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_5_DEBUG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_5_DEBUG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_5_DEBUG_PDFULLLSB_ADDRESS ), (v) )

#define BBH_TX_6_DEBUG_PDFULLLSB_ADDRESS   	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLLSB_OFFSET )
#define BBH_TX_6_DEBUG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_6_DEBUG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_6_DEBUG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_6_DEBUG_PDFULLLSB_ADDRESS ), (v) )


extern uint32_t BBH_TX_DEBUG_PDFULLLSB_ARRAY [ ] ;

#define BBH_TX_DEBUG_PDFULLLSB_WRITE( i, v )	WRITE_32( BBH_TX_DEBUG_PDFULLLSB_ARRAY [ i ], (v) )
#define BBH_TX_DEBUG_PDFULLLSB_READ( i, r ) 	READ_32( BBH_TX_DEBUG_PDFULLLSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PD_full */
	uint32_t pdfull	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDFULLLSB ;
#else
typedef struct
{	uint32_t pdfull	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_full */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDFULLLSB ;
#endif

/*****************************************************************************************/
/* PD_Full_MSB                                                                           */
/* Full indication of the PD FIFOs.                                                      */
/*****************************************************************************************/

#define BBH_TX_DEBUG_PDFULLMSB_R1_DEFAULT_VALUE                 ( 0x0 )
#define BBH_TX_DEBUG_PDFULLMSB_R1_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_TX_DEBUG_PDFULLMSB_PDFULL_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_PDFULLMSB_PDFULL_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_DEBUG_PDFULLMSB_OFFSET ( 0x00000024 )

#define BBH_TX_0_DEBUG_PDFULLMSB_ADDRESS   	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLMSB_OFFSET )
#define BBH_TX_0_DEBUG_PDFULLMSB_READ( r ) 	READ_32( ( BBH_TX_0_DEBUG_PDFULLMSB_ADDRESS ), (r) )
#define BBH_TX_0_DEBUG_PDFULLMSB_WRITE( v )	WRITE_32( ( BBH_TX_0_DEBUG_PDFULLMSB_ADDRESS ), (v) )

#define BBH_TX_1_DEBUG_PDFULLMSB_ADDRESS   	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLMSB_OFFSET )
#define BBH_TX_1_DEBUG_PDFULLMSB_READ( r ) 	READ_32( ( BBH_TX_1_DEBUG_PDFULLMSB_ADDRESS ), (r) )
#define BBH_TX_1_DEBUG_PDFULLMSB_WRITE( v )	WRITE_32( ( BBH_TX_1_DEBUG_PDFULLMSB_ADDRESS ), (v) )

#define BBH_TX_2_DEBUG_PDFULLMSB_ADDRESS   	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLMSB_OFFSET )
#define BBH_TX_2_DEBUG_PDFULLMSB_READ( r ) 	READ_32( ( BBH_TX_2_DEBUG_PDFULLMSB_ADDRESS ), (r) )
#define BBH_TX_2_DEBUG_PDFULLMSB_WRITE( v )	WRITE_32( ( BBH_TX_2_DEBUG_PDFULLMSB_ADDRESS ), (v) )

#define BBH_TX_3_DEBUG_PDFULLMSB_ADDRESS   	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLMSB_OFFSET )
#define BBH_TX_3_DEBUG_PDFULLMSB_READ( r ) 	READ_32( ( BBH_TX_3_DEBUG_PDFULLMSB_ADDRESS ), (r) )
#define BBH_TX_3_DEBUG_PDFULLMSB_WRITE( v )	WRITE_32( ( BBH_TX_3_DEBUG_PDFULLMSB_ADDRESS ), (v) )

#define BBH_TX_4_DEBUG_PDFULLMSB_ADDRESS   	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLMSB_OFFSET )
#define BBH_TX_4_DEBUG_PDFULLMSB_READ( r ) 	READ_32( ( BBH_TX_4_DEBUG_PDFULLMSB_ADDRESS ), (r) )
#define BBH_TX_4_DEBUG_PDFULLMSB_WRITE( v )	WRITE_32( ( BBH_TX_4_DEBUG_PDFULLMSB_ADDRESS ), (v) )

#define BBH_TX_5_DEBUG_PDFULLMSB_ADDRESS   	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLMSB_OFFSET )
#define BBH_TX_5_DEBUG_PDFULLMSB_READ( r ) 	READ_32( ( BBH_TX_5_DEBUG_PDFULLMSB_ADDRESS ), (r) )
#define BBH_TX_5_DEBUG_PDFULLMSB_WRITE( v )	WRITE_32( ( BBH_TX_5_DEBUG_PDFULLMSB_ADDRESS ), (v) )

#define BBH_TX_6_DEBUG_PDFULLMSB_ADDRESS   	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLMSB_OFFSET )
#define BBH_TX_6_DEBUG_PDFULLMSB_READ( r ) 	READ_32( ( BBH_TX_6_DEBUG_PDFULLMSB_ADDRESS ), (r) )
#define BBH_TX_6_DEBUG_PDFULLMSB_WRITE( v )	WRITE_32( ( BBH_TX_6_DEBUG_PDFULLMSB_ADDRESS ), (v) )


extern uint32_t BBH_TX_DEBUG_PDFULLMSB_ARRAY [ ] ;

#define BBH_TX_DEBUG_PDFULLMSB_WRITE( i, v )	WRITE_32( BBH_TX_DEBUG_PDFULLMSB_ARRAY [ i ], (v) )
#define BBH_TX_DEBUG_PDFULLMSB_READ( i, r ) 	READ_32( BBH_TX_DEBUG_PDFULLMSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1    	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_full */
	uint32_t pdfull	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDFULLMSB ;
#else
typedef struct
{	uint32_t pdfull	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_full */
	uint32_t r1    	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDFULLMSB ;
#endif

/*****************************************************************************************/
/* PD_empty_LSB                                                                          */
/* Empty indication of the PD FIFOs.                                                     */
/*****************************************************************************************/

#define BBH_TX_DEBUG_PDEMPTYLSB_PDEMPTY_DEFAULT_VALUE             ( 0xFFFFFFFF )
#define BBH_TX_DEBUG_PDEMPTYLSB_PDEMPTY_DEFAULT_VALUE_RESET_VALUE ( 0xFFFFFFFF )


#define BBH_TX_DEBUG_PDEMPTYLSB_OFFSET ( 0x00000028 )

#define BBH_TX_0_DEBUG_PDEMPTYLSB_ADDRESS   	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYLSB_OFFSET )
#define BBH_TX_0_DEBUG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_0_DEBUG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_0_DEBUG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_0_DEBUG_PDEMPTYLSB_ADDRESS ), (v) )

#define BBH_TX_1_DEBUG_PDEMPTYLSB_ADDRESS   	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYLSB_OFFSET )
#define BBH_TX_1_DEBUG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_1_DEBUG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_1_DEBUG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_1_DEBUG_PDEMPTYLSB_ADDRESS ), (v) )

#define BBH_TX_2_DEBUG_PDEMPTYLSB_ADDRESS   	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYLSB_OFFSET )
#define BBH_TX_2_DEBUG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_2_DEBUG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_2_DEBUG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_2_DEBUG_PDEMPTYLSB_ADDRESS ), (v) )

#define BBH_TX_3_DEBUG_PDEMPTYLSB_ADDRESS   	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYLSB_OFFSET )
#define BBH_TX_3_DEBUG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_3_DEBUG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_3_DEBUG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_3_DEBUG_PDEMPTYLSB_ADDRESS ), (v) )

#define BBH_TX_4_DEBUG_PDEMPTYLSB_ADDRESS   	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYLSB_OFFSET )
#define BBH_TX_4_DEBUG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_4_DEBUG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_4_DEBUG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_4_DEBUG_PDEMPTYLSB_ADDRESS ), (v) )

#define BBH_TX_5_DEBUG_PDEMPTYLSB_ADDRESS   	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYLSB_OFFSET )
#define BBH_TX_5_DEBUG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_5_DEBUG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_5_DEBUG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_5_DEBUG_PDEMPTYLSB_ADDRESS ), (v) )

#define BBH_TX_6_DEBUG_PDEMPTYLSB_ADDRESS   	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYLSB_OFFSET )
#define BBH_TX_6_DEBUG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_6_DEBUG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_6_DEBUG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_6_DEBUG_PDEMPTYLSB_ADDRESS ), (v) )


extern uint32_t BBH_TX_DEBUG_PDEMPTYLSB_ARRAY [ ] ;

#define BBH_TX_DEBUG_PDEMPTYLSB_WRITE( i, v )	WRITE_32( BBH_TX_DEBUG_PDEMPTYLSB_ARRAY [ i ], (v) )
#define BBH_TX_DEBUG_PDEMPTYLSB_READ( i, r ) 	READ_32( BBH_TX_DEBUG_PDEMPTYLSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PD_empty */
	uint32_t pdempty	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDEMPTYLSB ;
#else
typedef struct
{	uint32_t pdempty	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_empty */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDEMPTYLSB ;
#endif

/*****************************************************************************************/
/* PD_empty_MSB                                                                          */
/* Empty indication of the PD FIFOs.                                                     */
/*****************************************************************************************/

#define BBH_TX_DEBUG_PDEMPTYMSB_R1_DEFAULT_VALUE                  ( 0x0 )
#define BBH_TX_DEBUG_PDEMPTYMSB_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_TX_DEBUG_PDEMPTYMSB_PDEMPTY_DEFAULT_VALUE             ( 0xFF )
#define BBH_TX_DEBUG_PDEMPTYMSB_PDEMPTY_DEFAULT_VALUE_RESET_VALUE ( 0xFF )


#define BBH_TX_DEBUG_PDEMPTYMSB_OFFSET ( 0x0000002C )

#define BBH_TX_0_DEBUG_PDEMPTYMSB_ADDRESS   	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYMSB_OFFSET )
#define BBH_TX_0_DEBUG_PDEMPTYMSB_READ( r ) 	READ_32( ( BBH_TX_0_DEBUG_PDEMPTYMSB_ADDRESS ), (r) )
#define BBH_TX_0_DEBUG_PDEMPTYMSB_WRITE( v )	WRITE_32( ( BBH_TX_0_DEBUG_PDEMPTYMSB_ADDRESS ), (v) )

#define BBH_TX_1_DEBUG_PDEMPTYMSB_ADDRESS   	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYMSB_OFFSET )
#define BBH_TX_1_DEBUG_PDEMPTYMSB_READ( r ) 	READ_32( ( BBH_TX_1_DEBUG_PDEMPTYMSB_ADDRESS ), (r) )
#define BBH_TX_1_DEBUG_PDEMPTYMSB_WRITE( v )	WRITE_32( ( BBH_TX_1_DEBUG_PDEMPTYMSB_ADDRESS ), (v) )

#define BBH_TX_2_DEBUG_PDEMPTYMSB_ADDRESS   	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYMSB_OFFSET )
#define BBH_TX_2_DEBUG_PDEMPTYMSB_READ( r ) 	READ_32( ( BBH_TX_2_DEBUG_PDEMPTYMSB_ADDRESS ), (r) )
#define BBH_TX_2_DEBUG_PDEMPTYMSB_WRITE( v )	WRITE_32( ( BBH_TX_2_DEBUG_PDEMPTYMSB_ADDRESS ), (v) )

#define BBH_TX_3_DEBUG_PDEMPTYMSB_ADDRESS   	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYMSB_OFFSET )
#define BBH_TX_3_DEBUG_PDEMPTYMSB_READ( r ) 	READ_32( ( BBH_TX_3_DEBUG_PDEMPTYMSB_ADDRESS ), (r) )
#define BBH_TX_3_DEBUG_PDEMPTYMSB_WRITE( v )	WRITE_32( ( BBH_TX_3_DEBUG_PDEMPTYMSB_ADDRESS ), (v) )

#define BBH_TX_4_DEBUG_PDEMPTYMSB_ADDRESS   	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYMSB_OFFSET )
#define BBH_TX_4_DEBUG_PDEMPTYMSB_READ( r ) 	READ_32( ( BBH_TX_4_DEBUG_PDEMPTYMSB_ADDRESS ), (r) )
#define BBH_TX_4_DEBUG_PDEMPTYMSB_WRITE( v )	WRITE_32( ( BBH_TX_4_DEBUG_PDEMPTYMSB_ADDRESS ), (v) )

#define BBH_TX_5_DEBUG_PDEMPTYMSB_ADDRESS   	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYMSB_OFFSET )
#define BBH_TX_5_DEBUG_PDEMPTYMSB_READ( r ) 	READ_32( ( BBH_TX_5_DEBUG_PDEMPTYMSB_ADDRESS ), (r) )
#define BBH_TX_5_DEBUG_PDEMPTYMSB_WRITE( v )	WRITE_32( ( BBH_TX_5_DEBUG_PDEMPTYMSB_ADDRESS ), (v) )

#define BBH_TX_6_DEBUG_PDEMPTYMSB_ADDRESS   	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYMSB_OFFSET )
#define BBH_TX_6_DEBUG_PDEMPTYMSB_READ( r ) 	READ_32( ( BBH_TX_6_DEBUG_PDEMPTYMSB_ADDRESS ), (r) )
#define BBH_TX_6_DEBUG_PDEMPTYMSB_WRITE( v )	WRITE_32( ( BBH_TX_6_DEBUG_PDEMPTYMSB_ADDRESS ), (v) )


extern uint32_t BBH_TX_DEBUG_PDEMPTYMSB_ARRAY [ ] ;

#define BBH_TX_DEBUG_PDEMPTYMSB_WRITE( i, v )	WRITE_32( BBH_TX_DEBUG_PDEMPTYMSB_ARRAY [ i ], (v) )
#define BBH_TX_DEBUG_PDEMPTYMSB_READ( i, r ) 	READ_32( BBH_TX_DEBUG_PDEMPTYMSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1     	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_empty */
	uint32_t pdempty	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDEMPTYMSB ;
#else
typedef struct
{	uint32_t pdempty	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_empty */
	uint32_t r1     	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDEMPTYMSB ;
#endif

/*****************************************************************************************/
/* PD_VALID                                                                              */
/* The BBH manages 40 queues (1 for each TCONT). For each queue it manages a PD FIFO.    */
/* A total of 128 PDs are available for all queue.  The SW may read these PDs.  The PD v */
/* alid register indicates whether the relevant PD is valid.  The first register refers  */
/* to PDs 0-31.  The second register refers to PDs 32-63.  The third register refers to  */
/* PDs 64-95.  The fourth register refers to PDs 96-127.    This register is irrelevant  */
/* for Ethernet. For Ethernet, the valid indication is part of the PD.    This register  */
/* is also irrelevant for EPON. For EPON PD FIDOs validinformation, refer to EPON_PD_VAL */
/* ID registers in this section.                                                         */
/*****************************************************************************************/

#define BBH_TX_DEBUG_PDVALID_VALID_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_PDVALID_VALID_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_DEBUG_PDVALID_OFFSET ( 0x00000030 )

#define BBH_TX_0_DEBUG_PDVALID_ADDRESS        	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_PDVALID_OFFSET )
#define BBH_TX_0_DEBUG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_DEBUG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_0_DEBUG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_DEBUG_PDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_1_DEBUG_PDVALID_ADDRESS        	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_PDVALID_OFFSET )
#define BBH_TX_1_DEBUG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_DEBUG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_1_DEBUG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_DEBUG_PDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_2_DEBUG_PDVALID_ADDRESS        	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_PDVALID_OFFSET )
#define BBH_TX_2_DEBUG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_DEBUG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_2_DEBUG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_DEBUG_PDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_3_DEBUG_PDVALID_ADDRESS        	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_PDVALID_OFFSET )
#define BBH_TX_3_DEBUG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_DEBUG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_3_DEBUG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_DEBUG_PDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_4_DEBUG_PDVALID_ADDRESS        	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_PDVALID_OFFSET )
#define BBH_TX_4_DEBUG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_DEBUG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_4_DEBUG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_DEBUG_PDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_5_DEBUG_PDVALID_ADDRESS        	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_PDVALID_OFFSET )
#define BBH_TX_5_DEBUG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_DEBUG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_5_DEBUG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_DEBUG_PDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_6_DEBUG_PDVALID_ADDRESS        	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_PDVALID_OFFSET )
#define BBH_TX_6_DEBUG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_DEBUG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_6_DEBUG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_DEBUG_PDVALID_ADDRESS ), (i), (v) )


extern uint32_t BBH_TX_DEBUG_PDVALID_ARRAY [ ] ;

#define BBH_TX_DEBUG_PDVALID_WRITE( i, k, v )	WRITE_I_32( BBH_TX_DEBUG_PDVALID_ARRAY [ i ], (k), (v) )
#define BBH_TX_DEBUG_PDVALID_READ( i, k, r ) 	READ_I_32( BBH_TX_DEBUG_PDVALID_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* valid */
	uint32_t valid	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDVALID ;
#else
typedef struct
{	uint32_t valid	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* valid */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_PDVALID ;
#endif

/*****************************************************************************************/
/* BPM_FIFO                                                                              */
/* After reading a whole packet from the DDR, the BBH clears the BPM pointer. For that r */
/* eason it keeps a FIFO (of 8 entries) with the pointers to be cleared.                 */
/*****************************************************************************************/

#define BBH_TX_DEBUG_BPMFIFO_R4_DEFAULT_VALUE                      ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_R4_DEFAULT_VALUE_RESET_VALUE          ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_VALID_NOT_VALID_VALUE                 ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_VALID_NOT_VALID_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_VALID_VALID_VALUE                     ( 0x1 )
#define BBH_TX_DEBUG_BPMFIFO_R3_DEFAULT_VALUE                      ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_R3_DEFAULT_VALUE_RESET_VALUE          ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_P1588_NOT_1588_VALUE                  ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_P1588_NOT_1588_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_P1588_IS1588_VALUE                    ( 0x1 )
#define BBH_TX_DEBUG_BPMFIFO_ABS_NOT_ABSOLUTE_VALUE                ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_ABS_NOT_ABSOLUTE_VALUE_RESET_VALUE    ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_ABS_ABSOLUTE_VALUE                    ( 0x1 )
#define BBH_TX_DEBUG_BPMFIFO_R2_DEFAULT_VALUE                      ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_R2_DEFAULT_VALUE_RESET_VALUE          ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_SRCPORT_SOURCE_PORT_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_SRCPORT_SOURCE_PORT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_R1_DEFAULT_VALUE                      ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_R1_DEFAULT_VALUE_RESET_VALUE          ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_BN_BN_VALUE                           ( 0x0 )
#define BBH_TX_DEBUG_BPMFIFO_BN_BN_VALUE_RESET_VALUE               ( 0x0 )


#define BBH_TX_DEBUG_BPMFIFO_OFFSET ( 0x00000040 )

#define BBH_TX_0_DEBUG_BPMFIFO_ADDRESS        	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_BPMFIFO_OFFSET )
#define BBH_TX_0_DEBUG_BPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_DEBUG_BPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_0_DEBUG_BPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_DEBUG_BPMFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_1_DEBUG_BPMFIFO_ADDRESS        	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_BPMFIFO_OFFSET )
#define BBH_TX_1_DEBUG_BPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_DEBUG_BPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_1_DEBUG_BPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_DEBUG_BPMFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_2_DEBUG_BPMFIFO_ADDRESS        	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_BPMFIFO_OFFSET )
#define BBH_TX_2_DEBUG_BPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_DEBUG_BPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_2_DEBUG_BPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_DEBUG_BPMFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_3_DEBUG_BPMFIFO_ADDRESS        	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_BPMFIFO_OFFSET )
#define BBH_TX_3_DEBUG_BPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_DEBUG_BPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_3_DEBUG_BPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_DEBUG_BPMFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_4_DEBUG_BPMFIFO_ADDRESS        	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_BPMFIFO_OFFSET )
#define BBH_TX_4_DEBUG_BPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_DEBUG_BPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_4_DEBUG_BPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_DEBUG_BPMFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_5_DEBUG_BPMFIFO_ADDRESS        	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_BPMFIFO_OFFSET )
#define BBH_TX_5_DEBUG_BPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_DEBUG_BPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_5_DEBUG_BPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_DEBUG_BPMFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_6_DEBUG_BPMFIFO_ADDRESS        	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_BPMFIFO_OFFSET )
#define BBH_TX_6_DEBUG_BPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_DEBUG_BPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_6_DEBUG_BPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_DEBUG_BPMFIFO_ADDRESS ), (i), (v) )


extern uint32_t BBH_TX_DEBUG_BPMFIFO_ARRAY [ ] ;

#define BBH_TX_DEBUG_BPMFIFO_WRITE( i, k, v )	WRITE_I_32( BBH_TX_DEBUG_BPMFIFO_ARRAY [ i ], (k), (v) )
#define BBH_TX_DEBUG_BPMFIFO_READ( i, k, r ) 	READ_I_32( BBH_TX_DEBUG_BPMFIFO_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Valid */
	uint32_t valid  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* P1588 */
	uint32_t p1588  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Absolute */
	uint32_t abs    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Source_port */
	uint32_t srcport	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BN */
	uint32_t bn     	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_BPMFIFO ;
#else
typedef struct
{	uint32_t bn     	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BN */
	uint32_t r1     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t srcport	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Source_port */
	uint32_t r2     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t abs    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Absolute */
	uint32_t p1588  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* P1588 */
	uint32_t r3     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t valid  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Valid */
	uint32_t r4     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_BPMFIFO ;
#endif

/*****************************************************************************************/
/* SBPM_FIFO                                                                             */
/* After reading a whole packet from the SRAM, the BBH clears the SBPM pointer. For that */
/*  reason it keeps a FIFO (of 4 entries) with the pointers to be cleared.  Relevant onl */
/* y for Ethernet.                                                                       */
/*****************************************************************************************/

#define BBH_TX_DEBUG_SBPMFIFO_VALID_NOT_VALID_VALUE                 ( 0x0 )
#define BBH_TX_DEBUG_SBPMFIFO_VALID_NOT_VALID_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_TX_DEBUG_SBPMFIFO_VALID_VALID_VALUE                     ( 0x1 )
#define BBH_TX_DEBUG_SBPMFIFO_LASTBN_BN_VALUE                       ( 0x0 )
#define BBH_TX_DEBUG_SBPMFIFO_LASTBN_BN_VALUE_RESET_VALUE           ( 0x0 )
#define BBH_TX_DEBUG_SBPMFIFO_SRCPORT_SOURCE_PORT_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_SBPMFIFO_SRCPORT_SOURCE_PORT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_DEBUG_SBPMFIFO_HEADBN_BN_VALUE                       ( 0x0 )
#define BBH_TX_DEBUG_SBPMFIFO_HEADBN_BN_VALUE_RESET_VALUE           ( 0x0 )


#define BBH_TX_DEBUG_SBPMFIFO_OFFSET ( 0x00000060 )

#define BBH_TX_0_DEBUG_SBPMFIFO_ADDRESS        	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_SBPMFIFO_OFFSET )
#define BBH_TX_0_DEBUG_SBPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_DEBUG_SBPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_0_DEBUG_SBPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_DEBUG_SBPMFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_1_DEBUG_SBPMFIFO_ADDRESS        	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_SBPMFIFO_OFFSET )
#define BBH_TX_1_DEBUG_SBPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_DEBUG_SBPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_1_DEBUG_SBPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_DEBUG_SBPMFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_2_DEBUG_SBPMFIFO_ADDRESS        	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_SBPMFIFO_OFFSET )
#define BBH_TX_2_DEBUG_SBPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_DEBUG_SBPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_2_DEBUG_SBPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_DEBUG_SBPMFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_3_DEBUG_SBPMFIFO_ADDRESS        	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_SBPMFIFO_OFFSET )
#define BBH_TX_3_DEBUG_SBPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_DEBUG_SBPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_3_DEBUG_SBPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_DEBUG_SBPMFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_4_DEBUG_SBPMFIFO_ADDRESS        	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_SBPMFIFO_OFFSET )
#define BBH_TX_4_DEBUG_SBPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_DEBUG_SBPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_4_DEBUG_SBPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_DEBUG_SBPMFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_5_DEBUG_SBPMFIFO_ADDRESS        	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_SBPMFIFO_OFFSET )
#define BBH_TX_5_DEBUG_SBPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_DEBUG_SBPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_5_DEBUG_SBPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_DEBUG_SBPMFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_6_DEBUG_SBPMFIFO_ADDRESS        	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_SBPMFIFO_OFFSET )
#define BBH_TX_6_DEBUG_SBPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_DEBUG_SBPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_6_DEBUG_SBPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_DEBUG_SBPMFIFO_ADDRESS ), (i), (v) )


extern uint32_t BBH_TX_DEBUG_SBPMFIFO_ARRAY [ ] ;

#define BBH_TX_DEBUG_SBPMFIFO_WRITE( i, k, v )	WRITE_I_32( BBH_TX_DEBUG_SBPMFIFO_ARRAY [ i ], (k), (v) )
#define BBH_TX_DEBUG_SBPMFIFO_READ( i, k, r ) 	READ_I_32( BBH_TX_DEBUG_SBPMFIFO_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Valid */
	uint32_t valid  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Last_BN */
	uint32_t lastbn 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Source_port */
	uint32_t srcport	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HEAD_BN */
	uint32_t headbn 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_SBPMFIFO ;
#else
typedef struct
{	uint32_t headbn 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HEAD_BN */
	uint32_t srcport	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Source_port */
	uint32_t lastbn 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Last_BN */
	uint32_t valid  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Valid */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_SBPMFIFO ;
#endif

/*****************************************************************************************/
/* First_BN_FIFO                                                                         */
/* The SBPM Get next unit will maintain a first BN FIFO (8 entries). Each PD, which ar */
/* rives from the Runner, is checked and if it describes a SRAM packet which exceeds 128 */
/*  bytes (including the SOP offset and multicast transmission) it is written into firs */
/* t BN FIFO.   Relevant only for Ethernet.                                             */
/*****************************************************************************************/

#define BBH_TX_DEBUG_FIRSTBNFIFO_R3_DEFAULT_VALUE                   ( 0x0 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_R3_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_VALID_NOT_VALID_VALUE              ( 0x0 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_VALID_NOT_VALID_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_VALID_VALID_VALUE                  ( 0x1 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_R2_DEFAULT_VALUE                   ( 0x0 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_R2_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_NUMOFSBN_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_NUMOFSBN_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_R1_DEFAULT_VALUE                   ( 0x0 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_R1_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_HEADBN_BN_VALUE                    ( 0x0 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_HEADBN_BN_VALUE_RESET_VALUE        ( 0x0 )


#define BBH_TX_DEBUG_FIRSTBNFIFO_OFFSET ( 0x00000080 )

#define BBH_TX_0_DEBUG_FIRSTBNFIFO_ADDRESS        	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_FIRSTBNFIFO_OFFSET )
#define BBH_TX_0_DEBUG_FIRSTBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_0_DEBUG_FIRSTBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_1_DEBUG_FIRSTBNFIFO_ADDRESS        	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_FIRSTBNFIFO_OFFSET )
#define BBH_TX_1_DEBUG_FIRSTBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_1_DEBUG_FIRSTBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_2_DEBUG_FIRSTBNFIFO_ADDRESS        	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_FIRSTBNFIFO_OFFSET )
#define BBH_TX_2_DEBUG_FIRSTBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_2_DEBUG_FIRSTBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_3_DEBUG_FIRSTBNFIFO_ADDRESS        	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_FIRSTBNFIFO_OFFSET )
#define BBH_TX_3_DEBUG_FIRSTBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_3_DEBUG_FIRSTBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_4_DEBUG_FIRSTBNFIFO_ADDRESS        	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_FIRSTBNFIFO_OFFSET )
#define BBH_TX_4_DEBUG_FIRSTBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_4_DEBUG_FIRSTBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_5_DEBUG_FIRSTBNFIFO_ADDRESS        	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_FIRSTBNFIFO_OFFSET )
#define BBH_TX_5_DEBUG_FIRSTBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_5_DEBUG_FIRSTBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_6_DEBUG_FIRSTBNFIFO_ADDRESS        	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_FIRSTBNFIFO_OFFSET )
#define BBH_TX_6_DEBUG_FIRSTBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_6_DEBUG_FIRSTBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (v) )


extern uint32_t BBH_TX_DEBUG_FIRSTBNFIFO_ARRAY [ ] ;

#define BBH_TX_DEBUG_FIRSTBNFIFO_WRITE( i, k, v )	WRITE_I_32( BBH_TX_DEBUG_FIRSTBNFIFO_ARRAY [ i ], (k), (v) )
#define BBH_TX_DEBUG_FIRSTBNFIFO_READ( i, k, r ) 	READ_I_32( BBH_TX_DEBUG_FIRSTBNFIFO_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r3      	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Valid */
	uint32_t valid   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_of_SBN */
	uint32_t numofsbn	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HEAD_BN */
	uint32_t headbn  	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_FIRSTBNFIFO ;
#else
typedef struct
{	uint32_t headbn  	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HEAD_BN */
	uint32_t r1      	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t numofsbn	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Number_of_SBN */
	uint32_t r2      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t valid   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Valid */
	uint32_t r3      	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_FIRSTBNFIFO ;
#endif

/*****************************************************************************************/
/* Get_next_FIFO                                                                         */
/* When reading a packet from the SRAM, the BBH should request the next buffer in the pa */
/* ckets linked list. Doing it during the packet transmission might damage the performa */
/* nce; therefore the BBH maintains a pre-fetch of next buffers FIFO.  Relevant only f */
/* or Ethernet.                                                                          */
/*****************************************************************************************/

#define BBH_TX_DEBUG_GETNEXTFIFO_R2_DEFAULT_VALUE                  ( 0x0 )
#define BBH_TX_DEBUG_GETNEXTFIFO_R2_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_TX_DEBUG_GETNEXTFIFO_VALID_NOT_VALID_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_GETNEXTFIFO_VALID_NOT_VALID_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_DEBUG_GETNEXTFIFO_VALID_VALID_VALUE                 ( 0x1 )
#define BBH_TX_DEBUG_GETNEXTFIFO_R1_DEFAULT_VALUE                  ( 0x0 )
#define BBH_TX_DEBUG_GETNEXTFIFO_R1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_TX_DEBUG_GETNEXTFIFO_HEADBN_BN_VALUE                   ( 0x0 )
#define BBH_TX_DEBUG_GETNEXTFIFO_HEADBN_BN_VALUE_RESET_VALUE       ( 0x0 )


#define BBH_TX_DEBUG_GETNEXTFIFO_OFFSET ( 0x000000A0 )

#define BBH_TX_0_DEBUG_GETNEXTFIFO_ADDRESS        	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTFIFO_OFFSET )
#define BBH_TX_0_DEBUG_GETNEXTFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_0_DEBUG_GETNEXTFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_1_DEBUG_GETNEXTFIFO_ADDRESS        	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTFIFO_OFFSET )
#define BBH_TX_1_DEBUG_GETNEXTFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_1_DEBUG_GETNEXTFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_2_DEBUG_GETNEXTFIFO_ADDRESS        	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTFIFO_OFFSET )
#define BBH_TX_2_DEBUG_GETNEXTFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_2_DEBUG_GETNEXTFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_3_DEBUG_GETNEXTFIFO_ADDRESS        	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTFIFO_OFFSET )
#define BBH_TX_3_DEBUG_GETNEXTFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_3_DEBUG_GETNEXTFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_4_DEBUG_GETNEXTFIFO_ADDRESS        	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTFIFO_OFFSET )
#define BBH_TX_4_DEBUG_GETNEXTFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_4_DEBUG_GETNEXTFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_5_DEBUG_GETNEXTFIFO_ADDRESS        	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTFIFO_OFFSET )
#define BBH_TX_5_DEBUG_GETNEXTFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_5_DEBUG_GETNEXTFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_6_DEBUG_GETNEXTFIFO_ADDRESS        	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTFIFO_OFFSET )
#define BBH_TX_6_DEBUG_GETNEXTFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_6_DEBUG_GETNEXTFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (v) )


extern uint32_t BBH_TX_DEBUG_GETNEXTFIFO_ARRAY [ ] ;

#define BBH_TX_DEBUG_GETNEXTFIFO_WRITE( i, k, v )	WRITE_I_32( BBH_TX_DEBUG_GETNEXTFIFO_ARRAY [ i ], (k), (v) )
#define BBH_TX_DEBUG_GETNEXTFIFO_READ( i, k, r ) 	READ_I_32( BBH_TX_DEBUG_GETNEXTFIFO_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2    	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Valid */
	uint32_t valid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1    	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HEAD_BN */
	uint32_t headbn	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_GETNEXTFIFO ;
#else
typedef struct
{	uint32_t headbn	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HEAD_BN */
	uint32_t r1    	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t valid 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Valid */
	uint32_t r2    	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_GETNEXTFIFO ;
#endif

/*****************************************************************************************/
/* Debug_out_reg                                                                         */
/* Holds the selected debug vector (1 of 8) according to DBGSEL                          */
/*****************************************************************************************/

#define BBH_TX_DEBUG_DBGOUTREG_R1_DEFAULT_VALUE                 ( 0x0 )
#define BBH_TX_DEBUG_DBGOUTREG_R1_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_TX_DEBUG_DBGOUTREG_DBGVEC_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_DBGOUTREG_DBGVEC_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_DEBUG_DBGOUTREG_OFFSET ( 0x000000C0 )

#define BBH_TX_0_DEBUG_DBGOUTREG_ADDRESS   	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_DBGOUTREG_OFFSET )
#define BBH_TX_0_DEBUG_DBGOUTREG_READ( r ) 	READ_32( ( BBH_TX_0_DEBUG_DBGOUTREG_ADDRESS ), (r) )
#define BBH_TX_0_DEBUG_DBGOUTREG_WRITE( v )	WRITE_32( ( BBH_TX_0_DEBUG_DBGOUTREG_ADDRESS ), (v) )

#define BBH_TX_1_DEBUG_DBGOUTREG_ADDRESS   	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_DBGOUTREG_OFFSET )
#define BBH_TX_1_DEBUG_DBGOUTREG_READ( r ) 	READ_32( ( BBH_TX_1_DEBUG_DBGOUTREG_ADDRESS ), (r) )
#define BBH_TX_1_DEBUG_DBGOUTREG_WRITE( v )	WRITE_32( ( BBH_TX_1_DEBUG_DBGOUTREG_ADDRESS ), (v) )

#define BBH_TX_2_DEBUG_DBGOUTREG_ADDRESS   	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_DBGOUTREG_OFFSET )
#define BBH_TX_2_DEBUG_DBGOUTREG_READ( r ) 	READ_32( ( BBH_TX_2_DEBUG_DBGOUTREG_ADDRESS ), (r) )
#define BBH_TX_2_DEBUG_DBGOUTREG_WRITE( v )	WRITE_32( ( BBH_TX_2_DEBUG_DBGOUTREG_ADDRESS ), (v) )

#define BBH_TX_3_DEBUG_DBGOUTREG_ADDRESS   	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_DBGOUTREG_OFFSET )
#define BBH_TX_3_DEBUG_DBGOUTREG_READ( r ) 	READ_32( ( BBH_TX_3_DEBUG_DBGOUTREG_ADDRESS ), (r) )
#define BBH_TX_3_DEBUG_DBGOUTREG_WRITE( v )	WRITE_32( ( BBH_TX_3_DEBUG_DBGOUTREG_ADDRESS ), (v) )

#define BBH_TX_4_DEBUG_DBGOUTREG_ADDRESS   	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_DBGOUTREG_OFFSET )
#define BBH_TX_4_DEBUG_DBGOUTREG_READ( r ) 	READ_32( ( BBH_TX_4_DEBUG_DBGOUTREG_ADDRESS ), (r) )
#define BBH_TX_4_DEBUG_DBGOUTREG_WRITE( v )	WRITE_32( ( BBH_TX_4_DEBUG_DBGOUTREG_ADDRESS ), (v) )

#define BBH_TX_5_DEBUG_DBGOUTREG_ADDRESS   	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_DBGOUTREG_OFFSET )
#define BBH_TX_5_DEBUG_DBGOUTREG_READ( r ) 	READ_32( ( BBH_TX_5_DEBUG_DBGOUTREG_ADDRESS ), (r) )
#define BBH_TX_5_DEBUG_DBGOUTREG_WRITE( v )	WRITE_32( ( BBH_TX_5_DEBUG_DBGOUTREG_ADDRESS ), (v) )

#define BBH_TX_6_DEBUG_DBGOUTREG_ADDRESS   	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_DBGOUTREG_OFFSET )
#define BBH_TX_6_DEBUG_DBGOUTREG_READ( r ) 	READ_32( ( BBH_TX_6_DEBUG_DBGOUTREG_ADDRESS ), (r) )
#define BBH_TX_6_DEBUG_DBGOUTREG_WRITE( v )	WRITE_32( ( BBH_TX_6_DEBUG_DBGOUTREG_ADDRESS ), (v) )


extern uint32_t BBH_TX_DEBUG_DBGOUTREG_ARRAY [ ] ;

#define BBH_TX_DEBUG_DBGOUTREG_WRITE( i, v )	WRITE_32( BBH_TX_DEBUG_DBGOUTREG_ARRAY [ i ], (v) )
#define BBH_TX_DEBUG_DBGOUTREG_READ( i, r ) 	READ_32( BBH_TX_DEBUG_DBGOUTREG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1    	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Debug_vector */
	uint32_t dbgvec	: 21 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_DBGOUTREG ;
#else
typedef struct
{	uint32_t dbgvec	: 21 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Debug_vector */
	uint32_t r1    	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_DBGOUTREG ;
#endif

/*****************************************************************************************/
/* EPON_PD_VALID                                                                         */
/* The BBH manages 32 queues. For each queue it manages a PD FIFO.   A total of 256 PDs  */
/* are available for all queue.  The SW may read these PDs.  The PD valid register indic */
/* ates whether the relevant PD is valid.  The first register refers to PDs 0-31.  The s */
/* econd register refers to PDs 32-63 and so on.                                         */
/*****************************************************************************************/

#define BBH_TX_DEBUG_EPNPDVALID_VALID_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_DEBUG_EPNPDVALID_VALID_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_DEBUG_EPNPDVALID_OFFSET ( 0x000000D0 )

#define BBH_TX_0_DEBUG_EPNPDVALID_ADDRESS        	( BBH_TX_0_DEBUG_ADDRESS + BBH_TX_DEBUG_EPNPDVALID_OFFSET )
#define BBH_TX_0_DEBUG_EPNPDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_DEBUG_EPNPDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_0_DEBUG_EPNPDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_DEBUG_EPNPDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_1_DEBUG_EPNPDVALID_ADDRESS        	( BBH_TX_1_DEBUG_ADDRESS + BBH_TX_DEBUG_EPNPDVALID_OFFSET )
#define BBH_TX_1_DEBUG_EPNPDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_DEBUG_EPNPDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_1_DEBUG_EPNPDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_DEBUG_EPNPDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_2_DEBUG_EPNPDVALID_ADDRESS        	( BBH_TX_2_DEBUG_ADDRESS + BBH_TX_DEBUG_EPNPDVALID_OFFSET )
#define BBH_TX_2_DEBUG_EPNPDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_DEBUG_EPNPDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_2_DEBUG_EPNPDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_DEBUG_EPNPDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_3_DEBUG_EPNPDVALID_ADDRESS        	( BBH_TX_3_DEBUG_ADDRESS + BBH_TX_DEBUG_EPNPDVALID_OFFSET )
#define BBH_TX_3_DEBUG_EPNPDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_DEBUG_EPNPDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_3_DEBUG_EPNPDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_DEBUG_EPNPDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_4_DEBUG_EPNPDVALID_ADDRESS        	( BBH_TX_4_DEBUG_ADDRESS + BBH_TX_DEBUG_EPNPDVALID_OFFSET )
#define BBH_TX_4_DEBUG_EPNPDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_DEBUG_EPNPDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_4_DEBUG_EPNPDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_DEBUG_EPNPDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_5_DEBUG_EPNPDVALID_ADDRESS        	( BBH_TX_5_DEBUG_ADDRESS + BBH_TX_DEBUG_EPNPDVALID_OFFSET )
#define BBH_TX_5_DEBUG_EPNPDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_DEBUG_EPNPDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_5_DEBUG_EPNPDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_DEBUG_EPNPDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_6_DEBUG_EPNPDVALID_ADDRESS        	( BBH_TX_6_DEBUG_ADDRESS + BBH_TX_DEBUG_EPNPDVALID_OFFSET )
#define BBH_TX_6_DEBUG_EPNPDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_DEBUG_EPNPDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_6_DEBUG_EPNPDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_DEBUG_EPNPDVALID_ADDRESS ), (i), (v) )


extern uint32_t BBH_TX_DEBUG_EPNPDVALID_ARRAY [ ] ;

#define BBH_TX_DEBUG_EPNPDVALID_WRITE( i, k, v )	WRITE_I_32( BBH_TX_DEBUG_EPNPDVALID_ARRAY [ i ], (k), (v) )
#define BBH_TX_DEBUG_EPNPDVALID_READ( i, k, r ) 	READ_I_32( BBH_TX_DEBUG_EPNPDVALID_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* valid */
	uint32_t valid	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_EPNPDVALID ;
#else
typedef struct
{	uint32_t valid	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* valid */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG_EPNPDVALID ;
#endif

/*****************************************************************************************/
/* PD_FIFO                                                                               */
/* The SW may read the PD RAM.  This RAM includes a total of 128 PDs.  A special registe */
/* r marks the valid PDs.  Each PD occupies 2 addresses of 32 bits - the odd address ref */
/* ers to the LSB word of the entry.  Please refer to BBH LLD for the context of the PD. */
/*****************************************************************************************/

#define BBH_TX_PD_FIFO_PDFIFO_PDENTRY_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_PD_FIFO_PDFIFO_PDENTRY_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_PD_FIFO_PDFIFO_OFFSET ( 0x00000000 )

#define BBH_TX_0_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_0_PD_FIFO_ADDRESS + BBH_TX_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_0_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_0_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_1_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_1_PD_FIFO_ADDRESS + BBH_TX_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_1_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_1_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_2_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_2_PD_FIFO_ADDRESS + BBH_TX_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_2_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_2_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_3_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_3_PD_FIFO_ADDRESS + BBH_TX_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_3_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_3_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_4_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_4_PD_FIFO_ADDRESS + BBH_TX_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_4_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_4_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_5_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_5_PD_FIFO_ADDRESS + BBH_TX_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_5_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_5_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_6_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_6_PD_FIFO_ADDRESS + BBH_TX_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_6_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_6_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )


extern uint32_t BBH_TX_PD_FIFO_PDFIFO_ARRAY [ ] ;

#define BBH_TX_PD_FIFO_PDFIFO_WRITE( i, k, v )	WRITE_I_32( BBH_TX_PD_FIFO_PDFIFO_ARRAY [ i ], (k), (v) )
#define BBH_TX_PD_FIFO_PDFIFO_READ( i, k, r ) 	READ_I_32( BBH_TX_PD_FIFO_PDFIFO_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PD_entry */
	uint32_t pdentry	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_PD_FIFO_PDFIFO ;
#else
typedef struct
{	uint32_t pdentry	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_entry */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_PD_FIFO_PDFIFO ;
#endif

/*****************************************************************************************/
/* Segmentation_context                                                                  */
/* Segmentation context                                                                  */
/*****************************************************************************************/

#define BBH_TX_CONTEXT_SEGCNTXT_RMNCHUNK_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_CONTEXT_SEGCNTXT_RMNCHUNK_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONTEXT_SEGCNTXT_BN_DEFAULT_VALUE                   ( 0x0 )
#define BBH_TX_CONTEXT_SEGCNTXT_BN_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define BBH_TX_CONTEXT_SEGCNTXT_SRCPORT_DEFAULT_VALUE              ( 0x0 )
#define BBH_TX_CONTEXT_SEGCNTXT_SRCPORT_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_TX_CONTEXT_SEGCNTXT_PENDREQ_DEFAULT_VALUE              ( 0x0 )
#define BBH_TX_CONTEXT_SEGCNTXT_PENDREQ_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )
#define BBH_TX_CONTEXT_SEGCNTXT_ABS_NOT_ABSOLUTE_VALUE             ( 0x0 )
#define BBH_TX_CONTEXT_SEGCNTXT_ABS_NOT_ABSOLUTE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONTEXT_SEGCNTXT_ABS_ABSOLUTE_VALUE                 ( 0x1 )
#define BBH_TX_CONTEXT_SEGCNTXT_INSEG_NOT_IN_SEG_VALUE             ( 0x0 )
#define BBH_TX_CONTEXT_SEGCNTXT_INSEG_NOT_IN_SEG_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_CONTEXT_SEGCNTXT_INSEG_IN_SEG_VALUE                 ( 0x1 )


#define BBH_TX_CONTEXT_SEGCNTXT_OFFSET ( 0x00000000 )

#define BBH_TX_0_CONTEXT_SEGCNTXT_ADDRESS        	( BBH_TX_0_CONTEXT_ADDRESS + BBH_TX_CONTEXT_SEGCNTXT_OFFSET )
#define BBH_TX_0_CONTEXT_SEGCNTXT_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_CONTEXT_SEGCNTXT_ADDRESS ), (i), (r) )
#define BBH_TX_0_CONTEXT_SEGCNTXT_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_CONTEXT_SEGCNTXT_ADDRESS ), (i), (v) )

#define BBH_TX_1_CONTEXT_SEGCNTXT_ADDRESS        	( BBH_TX_1_CONTEXT_ADDRESS + BBH_TX_CONTEXT_SEGCNTXT_OFFSET )
#define BBH_TX_1_CONTEXT_SEGCNTXT_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_CONTEXT_SEGCNTXT_ADDRESS ), (i), (r) )
#define BBH_TX_1_CONTEXT_SEGCNTXT_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_CONTEXT_SEGCNTXT_ADDRESS ), (i), (v) )

#define BBH_TX_2_CONTEXT_SEGCNTXT_ADDRESS        	( BBH_TX_2_CONTEXT_ADDRESS + BBH_TX_CONTEXT_SEGCNTXT_OFFSET )
#define BBH_TX_2_CONTEXT_SEGCNTXT_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_CONTEXT_SEGCNTXT_ADDRESS ), (i), (r) )
#define BBH_TX_2_CONTEXT_SEGCNTXT_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_CONTEXT_SEGCNTXT_ADDRESS ), (i), (v) )

#define BBH_TX_3_CONTEXT_SEGCNTXT_ADDRESS        	( BBH_TX_3_CONTEXT_ADDRESS + BBH_TX_CONTEXT_SEGCNTXT_OFFSET )
#define BBH_TX_3_CONTEXT_SEGCNTXT_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_CONTEXT_SEGCNTXT_ADDRESS ), (i), (r) )
#define BBH_TX_3_CONTEXT_SEGCNTXT_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_CONTEXT_SEGCNTXT_ADDRESS ), (i), (v) )

#define BBH_TX_4_CONTEXT_SEGCNTXT_ADDRESS        	( BBH_TX_4_CONTEXT_ADDRESS + BBH_TX_CONTEXT_SEGCNTXT_OFFSET )
#define BBH_TX_4_CONTEXT_SEGCNTXT_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_CONTEXT_SEGCNTXT_ADDRESS ), (i), (r) )
#define BBH_TX_4_CONTEXT_SEGCNTXT_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_CONTEXT_SEGCNTXT_ADDRESS ), (i), (v) )

#define BBH_TX_5_CONTEXT_SEGCNTXT_ADDRESS        	( BBH_TX_5_CONTEXT_ADDRESS + BBH_TX_CONTEXT_SEGCNTXT_OFFSET )
#define BBH_TX_5_CONTEXT_SEGCNTXT_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_CONTEXT_SEGCNTXT_ADDRESS ), (i), (r) )
#define BBH_TX_5_CONTEXT_SEGCNTXT_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_CONTEXT_SEGCNTXT_ADDRESS ), (i), (v) )

#define BBH_TX_6_CONTEXT_SEGCNTXT_ADDRESS        	( BBH_TX_6_CONTEXT_ADDRESS + BBH_TX_CONTEXT_SEGCNTXT_OFFSET )
#define BBH_TX_6_CONTEXT_SEGCNTXT_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_CONTEXT_SEGCNTXT_ADDRESS ), (i), (r) )
#define BBH_TX_6_CONTEXT_SEGCNTXT_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_CONTEXT_SEGCNTXT_ADDRESS ), (i), (v) )


extern uint32_t BBH_TX_CONTEXT_SEGCNTXT_ARRAY [ ] ;

#define BBH_TX_CONTEXT_SEGCNTXT_WRITE( i, k, v )	WRITE_I_32( BBH_TX_CONTEXT_SEGCNTXT_ARRAY [ i ], (k), (v) )
#define BBH_TX_CONTEXT_SEGCNTXT_READ( i, k, r ) 	READ_I_32( BBH_TX_CONTEXT_SEGCNTXT_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Remaining_chunks */
	uint32_t rmnchunk	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_Number */
	uint32_t bn      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Source_port */
	uint32_t srcport 	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pending_requests */
	uint32_t pendreq 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Absolute */
	uint32_t abs     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* In_segmentation */
	uint32_t inseg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONTEXT_SEGCNTXT ;
#else
typedef struct
{	uint32_t inseg   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* In_segmentation */
	uint32_t abs     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Absolute */
	uint32_t pendreq 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pending_requests */
	uint32_t srcport 	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Source_port */
	uint32_t bn      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_Number */
	uint32_t rmnchunk	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Remaining_chunks */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONTEXT_SEGCNTXT ;
#endif

/*****************************************************************************************/
/* PD_FIFO                                                                               */
/* The SW may read the PD RAM.  This RAM includes a total of 256 PDs.  A special registe */
/* r marks the valid PDs.  Each PD occupies 2 addresses of 32 bits - the odd address ref */
/* ers to the LSB word of the entry.  Please refer to BBH LLD for the context of the PD. */
/*****************************************************************************************/

#define BBH_TX_EPON_PD_FIFO_PDFIFO_PDENTRY_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_EPON_PD_FIFO_PDFIFO_PDENTRY_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_EPON_PD_FIFO_PDFIFO_OFFSET ( 0x00000000 )

#define BBH_TX_0_EPON_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_0_EPON_PD_FIFO_ADDRESS + BBH_TX_EPON_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_0_EPON_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_0_EPON_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_1_EPON_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_1_EPON_PD_FIFO_ADDRESS + BBH_TX_EPON_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_1_EPON_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_1_EPON_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_2_EPON_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_2_EPON_PD_FIFO_ADDRESS + BBH_TX_EPON_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_2_EPON_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_2_EPON_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_3_EPON_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_3_EPON_PD_FIFO_ADDRESS + BBH_TX_EPON_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_3_EPON_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_3_EPON_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_4_EPON_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_4_EPON_PD_FIFO_ADDRESS + BBH_TX_EPON_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_4_EPON_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_4_EPON_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_5_EPON_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_5_EPON_PD_FIFO_ADDRESS + BBH_TX_EPON_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_5_EPON_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_5_EPON_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_6_EPON_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_6_EPON_PD_FIFO_ADDRESS + BBH_TX_EPON_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_6_EPON_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_6_EPON_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )


extern uint32_t BBH_TX_EPON_PD_FIFO_PDFIFO_ARRAY [ ] ;

#define BBH_TX_EPON_PD_FIFO_PDFIFO_WRITE( i, k, v )	WRITE_I_32( BBH_TX_EPON_PD_FIFO_PDFIFO_ARRAY [ i ], (k), (v) )
#define BBH_TX_EPON_PD_FIFO_PDFIFO_READ( i, k, r ) 	READ_I_32( BBH_TX_EPON_PD_FIFO_PDFIFO_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PD_entry */
	uint32_t pdentry	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_PD_FIFO_PDFIFO ;
#else
typedef struct
{	uint32_t pdentry	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_entry */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_PD_FIFO_PDFIFO ;
#endif

/*****************************************************************************************/
/* Task_numbers_LSB                                                                      */
/* The BBH manages 40 queues for GPON or 32 queues for EPON.  Each of the first 8 Queues */
/*  may have a unique Runner task number.  Queues 8-39 have all the same configurable ta */
/* sk number.  This register defines the tasks for Queues 0-3.  For Ethernet queue 0 sho */
/* uld be configured.                                                                    */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_TASKLSB_R4_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_EPON_CFG_TASKLSB_R4_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_EPON_CFG_TASKLSB_TASK3_TASK_NUMBER_VALUE             ( 0x6 )
#define BBH_TX_EPON_CFG_TASKLSB_TASK3_TASK_NUMBER_VALUE_RESET_VALUE ( 0x6 )
#define BBH_TX_EPON_CFG_TASKLSB_R3_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_EPON_CFG_TASKLSB_R3_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_EPON_CFG_TASKLSB_TASK2_TASK_NUMBER_VALUE             ( 0x6 )
#define BBH_TX_EPON_CFG_TASKLSB_TASK2_TASK_NUMBER_VALUE_RESET_VALUE ( 0x6 )
#define BBH_TX_EPON_CFG_TASKLSB_R2_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_EPON_CFG_TASKLSB_R2_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_EPON_CFG_TASKLSB_TASK1_TASK_NUMBER_VALUE             ( 0x6 )
#define BBH_TX_EPON_CFG_TASKLSB_TASK1_TASK_NUMBER_VALUE_RESET_VALUE ( 0x6 )
#define BBH_TX_EPON_CFG_TASKLSB_R1_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_EPON_CFG_TASKLSB_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_EPON_CFG_TASKLSB_TASK0_TASK_NUMBER_VALUE             ( 0x6 )
#define BBH_TX_EPON_CFG_TASKLSB_TASK0_TASK_NUMBER_VALUE_RESET_VALUE ( 0x6 )


#define BBH_TX_EPON_CFG_TASKLSB_OFFSET ( 0x00000000 )

#define BBH_TX_0_EPON_CFG_TASKLSB_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKLSB_OFFSET )
#define BBH_TX_0_EPON_CFG_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_TASKLSB_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_TASKLSB_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKLSB_OFFSET )
#define BBH_TX_1_EPON_CFG_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_TASKLSB_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_TASKLSB_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKLSB_OFFSET )
#define BBH_TX_2_EPON_CFG_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_TASKLSB_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_TASKLSB_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKLSB_OFFSET )
#define BBH_TX_3_EPON_CFG_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_TASKLSB_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_TASKLSB_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKLSB_OFFSET )
#define BBH_TX_4_EPON_CFG_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_TASKLSB_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_TASKLSB_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKLSB_OFFSET )
#define BBH_TX_5_EPON_CFG_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_TASKLSB_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_TASKLSB_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKLSB_OFFSET )
#define BBH_TX_6_EPON_CFG_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_TASKLSB_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_TASKLSB_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_TASKLSB_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_TASKLSB_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_TASKLSB_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_TASKLSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_3 */
	uint32_t task3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_2 */
	uint32_t task2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_1 */
	uint32_t task1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_0 */
	uint32_t task0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_TASKLSB ;
#else
typedef struct
{	uint32_t task0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_0 */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t task1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_1 */
	uint32_t r2   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t task2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_2 */
	uint32_t r3   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t task3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_3 */
	uint32_t r4   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_TASKLSB ;
#endif

/*****************************************************************************************/
/* Task_numbers_MSB                                                                      */
/* The BBH manages 40 queues for GPON or 32 queues for EPON.  Each of the first 8 Queues */
/*  may have a unique Runner task number.  Queues 8-39 have all the same configurable ta */
/* sk number.  This register defines the tasks for Queues 4-7.  For Ethernet queue 0 sho */
/* uld be configured.                                                                    */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_TASKMSB_R4_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_EPON_CFG_TASKMSB_R4_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_EPON_CFG_TASKMSB_TASK7_TASK_NUMBER_VALUE             ( 0x6 )
#define BBH_TX_EPON_CFG_TASKMSB_TASK7_TASK_NUMBER_VALUE_RESET_VALUE ( 0x6 )
#define BBH_TX_EPON_CFG_TASKMSB_R3_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_EPON_CFG_TASKMSB_R3_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_EPON_CFG_TASKMSB_TASK6_TASK_NUMBER_VALUE             ( 0x6 )
#define BBH_TX_EPON_CFG_TASKMSB_TASK6_TASK_NUMBER_VALUE_RESET_VALUE ( 0x6 )
#define BBH_TX_EPON_CFG_TASKMSB_R2_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_EPON_CFG_TASKMSB_R2_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_EPON_CFG_TASKMSB_TASK5_TASK_NUMBER_VALUE             ( 0x6 )
#define BBH_TX_EPON_CFG_TASKMSB_TASK5_TASK_NUMBER_VALUE_RESET_VALUE ( 0x6 )
#define BBH_TX_EPON_CFG_TASKMSB_R1_DEFAULT_VALUE                    ( 0x0 )
#define BBH_TX_EPON_CFG_TASKMSB_R1_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define BBH_TX_EPON_CFG_TASKMSB_TASK4_TASK_NUMBER_VALUE             ( 0x6 )
#define BBH_TX_EPON_CFG_TASKMSB_TASK4_TASK_NUMBER_VALUE_RESET_VALUE ( 0x6 )


#define BBH_TX_EPON_CFG_TASKMSB_OFFSET ( 0x00000004 )

#define BBH_TX_0_EPON_CFG_TASKMSB_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKMSB_OFFSET )
#define BBH_TX_0_EPON_CFG_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_TASKMSB_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_TASKMSB_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKMSB_OFFSET )
#define BBH_TX_1_EPON_CFG_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_TASKMSB_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_TASKMSB_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKMSB_OFFSET )
#define BBH_TX_2_EPON_CFG_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_TASKMSB_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_TASKMSB_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKMSB_OFFSET )
#define BBH_TX_3_EPON_CFG_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_TASKMSB_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_TASKMSB_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKMSB_OFFSET )
#define BBH_TX_4_EPON_CFG_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_TASKMSB_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_TASKMSB_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKMSB_OFFSET )
#define BBH_TX_5_EPON_CFG_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_TASKMSB_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_TASKMSB_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKMSB_OFFSET )
#define BBH_TX_6_EPON_CFG_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_TASKMSB_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_TASKMSB_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_TASKMSB_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_TASKMSB_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_TASKMSB_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_TASKMSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_7 */
	uint32_t task7	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_6 */
	uint32_t task6	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_5 */
	uint32_t task5	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_4 */
	uint32_t task4	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_TASKMSB ;
#else
typedef struct
{	uint32_t task4	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_4 */
	uint32_t r1   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t task5	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_5 */
	uint32_t r2   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t task6	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_6 */
	uint32_t r3   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t task7	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_7 */
	uint32_t r4   	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_TASKMSB ;
#endif

/*****************************************************************************************/
/* Task_numbers_8-39                                                                     */
/* The BBH manages 40 queues for GPON or 32 queues for EPON.  Each of the first 8 Queues */
/*  may have a unique Runner task number.  Queues 8-39 have all the same configurable ta */
/* sk number.  This register defines the tasks for Queues 8-39.  For Ethernet queue 0 sh */
/* ould be configured.                                                                   */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_TASK8_39_R1_DEFAULT_VALUE                       ( 0x0 )
#define BBH_TX_EPON_CFG_TASK8_39_R1_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define BBH_TX_EPON_CFG_TASK8_39_TASK8_39_TASK_NUMBER_VALUE             ( 0x6 )
#define BBH_TX_EPON_CFG_TASK8_39_TASK8_39_TASK_NUMBER_VALUE_RESET_VALUE ( 0x6 )


#define BBH_TX_EPON_CFG_TASK8_39_OFFSET ( 0x00000008 )

#define BBH_TX_0_EPON_CFG_TASK8_39_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASK8_39_OFFSET )
#define BBH_TX_0_EPON_CFG_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_TASK8_39_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_TASK8_39_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASK8_39_OFFSET )
#define BBH_TX_1_EPON_CFG_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_TASK8_39_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_TASK8_39_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASK8_39_OFFSET )
#define BBH_TX_2_EPON_CFG_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_TASK8_39_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_TASK8_39_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASK8_39_OFFSET )
#define BBH_TX_3_EPON_CFG_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_TASK8_39_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_TASK8_39_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASK8_39_OFFSET )
#define BBH_TX_4_EPON_CFG_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_TASK8_39_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_TASK8_39_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASK8_39_OFFSET )
#define BBH_TX_5_EPON_CFG_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_TASK8_39_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_TASK8_39_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASK8_39_OFFSET )
#define BBH_TX_6_EPON_CFG_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_TASK8_39_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_TASK8_39_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_TASK8_39_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_TASK8_39_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_TASK8_39_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_TASK8_39_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_8-39 */
	uint32_t task8_39	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_TASK8_39 ;
#else
typedef struct
{	uint32_t task8_39	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_8-39 */
	uint32_t r1      	: 26 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_TASK8_39 ;
#endif

/*****************************************************************************************/
/* PD_FIFO_size_0_3                                                                      */
/* The BBH manages 40 queues for GPON and 32 queues for EPON (FIFO per TCONT/LLID). For  */
/* each queue it manages a PD FIFO.   A total of 128 PDs (GPON) or 256 PDs (EPON) are av */
/* ailable for all queues.   For each Queue the SW configures the base and the size with */
/* in these 128/256 PDs.  This register defines the PD FIFO size for queues 0-3.         */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_PDSIZE0_3_R4_DEFAULT_VALUE                         ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE0_3_R4_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE0_3_FIFOSIZE3_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE0_3_FIFOSIZE3_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE0_3_FIFOSIZE3_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE0_3_R3_DEFAULT_VALUE                         ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE0_3_R3_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE0_3_FIFOSIZE2_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE0_3_FIFOSIZE2_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE0_3_FIFOSIZE2_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE0_3_R2_DEFAULT_VALUE                         ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE0_3_R2_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE0_3_FIFOSIZE1_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE0_3_FIFOSIZE1_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE0_3_FIFOSIZE1_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE0_3_R1_DEFAULT_VALUE                         ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE0_3_R1_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE0_3_FIFOSIZE0_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE0_3_FIFOSIZE0_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE0_3_FIFOSIZE0_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )


#define BBH_TX_EPON_CFG_PDSIZE0_3_OFFSET ( 0x0000000C )

#define BBH_TX_0_EPON_CFG_PDSIZE0_3_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE0_3_OFFSET )
#define BBH_TX_0_EPON_CFG_PDSIZE0_3_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_PDSIZE0_3_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_PDSIZE0_3_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_PDSIZE0_3_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_PDSIZE0_3_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE0_3_OFFSET )
#define BBH_TX_1_EPON_CFG_PDSIZE0_3_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_PDSIZE0_3_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_PDSIZE0_3_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_PDSIZE0_3_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_PDSIZE0_3_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE0_3_OFFSET )
#define BBH_TX_2_EPON_CFG_PDSIZE0_3_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_PDSIZE0_3_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_PDSIZE0_3_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_PDSIZE0_3_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_PDSIZE0_3_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE0_3_OFFSET )
#define BBH_TX_3_EPON_CFG_PDSIZE0_3_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_PDSIZE0_3_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_PDSIZE0_3_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_PDSIZE0_3_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_PDSIZE0_3_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE0_3_OFFSET )
#define BBH_TX_4_EPON_CFG_PDSIZE0_3_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_PDSIZE0_3_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_PDSIZE0_3_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_PDSIZE0_3_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_PDSIZE0_3_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE0_3_OFFSET )
#define BBH_TX_5_EPON_CFG_PDSIZE0_3_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_PDSIZE0_3_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_PDSIZE0_3_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_PDSIZE0_3_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_PDSIZE0_3_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE0_3_OFFSET )
#define BBH_TX_6_EPON_CFG_PDSIZE0_3_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_PDSIZE0_3_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_PDSIZE0_3_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_PDSIZE0_3_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_PDSIZE0_3_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_PDSIZE0_3_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_PDSIZE0_3_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_PDSIZE0_3_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_PDSIZE0_3_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_3 */
	uint32_t fifosize3	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_2 */
	uint32_t fifosize2	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_1 */
	uint32_t fifosize1	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_0 */
	uint32_t fifosize0	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDSIZE0_3 ;
#else
typedef struct
{	uint32_t fifosize0	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_0 */
	uint32_t r1       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t fifosize1	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_1 */
	uint32_t r2       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t fifosize2	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_2 */
	uint32_t r3       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t fifosize3	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_3 */
	uint32_t r4       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDSIZE0_3 ;
#endif

/*****************************************************************************************/
/* PD_FIFO_size_4_7                                                                      */
/* The BBH manages 40 queues for GPON and 32 queues for EPON (FIFO per TCONT/LLID). For  */
/* each queue it manages a PD FIFO.   A total of 128 PDs (GPON) or 256 PDs (EPON) are av */
/* ailable for all queues.   For each Queue the SW configures the base and the size with */
/* in these 128/256 PDs.  This register defines the PD FIFO size for queues 4-7.         */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_PDSIZE4_7_R4_DEFAULT_VALUE                         ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE4_7_R4_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE4_7_FIFOSIZE7_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE4_7_FIFOSIZE7_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE4_7_FIFOSIZE7_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE4_7_R3_DEFAULT_VALUE                         ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE4_7_R3_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE4_7_FIFOSIZE6_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE4_7_FIFOSIZE6_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE4_7_FIFOSIZE6_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE4_7_R2_DEFAULT_VALUE                         ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE4_7_R2_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE4_7_FIFOSIZE5_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE4_7_FIFOSIZE5_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE4_7_FIFOSIZE5_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE4_7_R1_DEFAULT_VALUE                         ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE4_7_R1_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE4_7_FIFOSIZE4_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE4_7_FIFOSIZE4_DEFAULT_EPON_VALUE             ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE4_7_FIFOSIZE4_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xF )


#define BBH_TX_EPON_CFG_PDSIZE4_7_OFFSET ( 0x00000010 )

#define BBH_TX_0_EPON_CFG_PDSIZE4_7_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE4_7_OFFSET )
#define BBH_TX_0_EPON_CFG_PDSIZE4_7_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_PDSIZE4_7_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_PDSIZE4_7_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_PDSIZE4_7_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_PDSIZE4_7_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE4_7_OFFSET )
#define BBH_TX_1_EPON_CFG_PDSIZE4_7_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_PDSIZE4_7_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_PDSIZE4_7_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_PDSIZE4_7_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_PDSIZE4_7_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE4_7_OFFSET )
#define BBH_TX_2_EPON_CFG_PDSIZE4_7_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_PDSIZE4_7_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_PDSIZE4_7_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_PDSIZE4_7_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_PDSIZE4_7_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE4_7_OFFSET )
#define BBH_TX_3_EPON_CFG_PDSIZE4_7_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_PDSIZE4_7_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_PDSIZE4_7_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_PDSIZE4_7_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_PDSIZE4_7_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE4_7_OFFSET )
#define BBH_TX_4_EPON_CFG_PDSIZE4_7_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_PDSIZE4_7_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_PDSIZE4_7_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_PDSIZE4_7_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_PDSIZE4_7_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE4_7_OFFSET )
#define BBH_TX_5_EPON_CFG_PDSIZE4_7_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_PDSIZE4_7_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_PDSIZE4_7_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_PDSIZE4_7_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_PDSIZE4_7_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE4_7_OFFSET )
#define BBH_TX_6_EPON_CFG_PDSIZE4_7_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_PDSIZE4_7_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_PDSIZE4_7_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_PDSIZE4_7_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_PDSIZE4_7_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_PDSIZE4_7_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_PDSIZE4_7_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_PDSIZE4_7_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_PDSIZE4_7_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_7 */
	uint32_t fifosize7	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_6 */
	uint32_t fifosize6	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_5 */
	uint32_t fifosize5	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_4 */
	uint32_t fifosize4	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDSIZE4_7 ;
#else
typedef struct
{	uint32_t fifosize4	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_4 */
	uint32_t r1       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t fifosize5	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_5 */
	uint32_t r2       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t fifosize6	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_6 */
	uint32_t r3       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t fifosize7	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_7 */
	uint32_t r4       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDSIZE4_7 ;
#endif

/*****************************************************************************************/
/* PD_FIFO_size_8_31                                                                     */
/* The BBH manages 40 queues for GPON and 32 queues for EPON (FIFO per queue). For each  */
/* queue it manages a PD FIFO.   A total of 128 PDs for GPON and 256 PDs for EPON are av */
/* ailable for all queues.   For each Queue the SW configures the base and the size with */
/* in these 128/256 PDs.  This register defines the PD FIFO size for TCONTs 8-31.        */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_PDSIZE8_31_R3_DEFAULT_VALUE                             ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE8_31_R3_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE8_31_FIFOSIZE24_31_DEFAULT_EPON_VALUE             ( 0x4 )
#define BBH_TX_EPON_CFG_PDSIZE8_31_FIFOSIZE24_31_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x4 )
#define BBH_TX_EPON_CFG_PDSIZE8_31_FIFOSIZE24_31_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE8_31_R2_DEFAULT_VALUE                             ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE8_31_R2_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE8_31_FIFOSIZE16_23_DEFAULT_EPON_VALUE             ( 0x4 )
#define BBH_TX_EPON_CFG_PDSIZE8_31_FIFOSIZE16_23_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x4 )
#define BBH_TX_EPON_CFG_PDSIZE8_31_FIFOSIZE16_23_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDSIZE8_31_R1_DEFAULT_VALUE                             ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE8_31_R1_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define BBH_TX_EPON_CFG_PDSIZE8_31_FIFOSIZE8_15_DEFAULT_EPON_VALUE              ( 0x4 )
#define BBH_TX_EPON_CFG_PDSIZE8_31_FIFOSIZE8_15_DEFAULT_EPON_VALUE_RESET_VALUE  ( 0x4 )
#define BBH_TX_EPON_CFG_PDSIZE8_31_FIFOSIZE8_15_MAX_EPON_VALUE                  ( 0xF )


#define BBH_TX_EPON_CFG_PDSIZE8_31_OFFSET ( 0x00000014 )

#define BBH_TX_0_EPON_CFG_PDSIZE8_31_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE8_31_OFFSET )
#define BBH_TX_0_EPON_CFG_PDSIZE8_31_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_PDSIZE8_31_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_PDSIZE8_31_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_PDSIZE8_31_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_PDSIZE8_31_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE8_31_OFFSET )
#define BBH_TX_1_EPON_CFG_PDSIZE8_31_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_PDSIZE8_31_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_PDSIZE8_31_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_PDSIZE8_31_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_PDSIZE8_31_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE8_31_OFFSET )
#define BBH_TX_2_EPON_CFG_PDSIZE8_31_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_PDSIZE8_31_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_PDSIZE8_31_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_PDSIZE8_31_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_PDSIZE8_31_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE8_31_OFFSET )
#define BBH_TX_3_EPON_CFG_PDSIZE8_31_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_PDSIZE8_31_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_PDSIZE8_31_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_PDSIZE8_31_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_PDSIZE8_31_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE8_31_OFFSET )
#define BBH_TX_4_EPON_CFG_PDSIZE8_31_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_PDSIZE8_31_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_PDSIZE8_31_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_PDSIZE8_31_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_PDSIZE8_31_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE8_31_OFFSET )
#define BBH_TX_5_EPON_CFG_PDSIZE8_31_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_PDSIZE8_31_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_PDSIZE8_31_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_PDSIZE8_31_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_PDSIZE8_31_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE8_31_OFFSET )
#define BBH_TX_6_EPON_CFG_PDSIZE8_31_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_PDSIZE8_31_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_PDSIZE8_31_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_PDSIZE8_31_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_PDSIZE8_31_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_PDSIZE8_31_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_PDSIZE8_31_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_PDSIZE8_31_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_PDSIZE8_31_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r3           	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_24_31 */
	uint32_t fifosize24_31	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_16_23 */
	uint32_t fifosize16_23	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_8_15 */
	uint32_t fifosize8_15 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDSIZE8_31 ;
#else
typedef struct
{	uint32_t fifosize8_15 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_8_15 */
	uint32_t r1           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t fifosize16_23	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_16_23 */
	uint32_t r2           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t fifosize24_31	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_size_24_31 */
	uint32_t r3           	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDSIZE8_31 ;
#endif

/*****************************************************************************************/
/* PD_FIFO_base_0_3                                                                      */
/* The BBH manages 40 queues for GPON or 32 queus for EPON (1 for each TCONT/LLID). For  */
/* each queue it manages a PD FIFO.   A total of 128 PDs (GPON) or 256 (EPON) are availa */
/* ble for all queues.   For each Queue the SW configures the base and the size within t */
/* hese 128/256 PDs.  This register defines the PD FIFO base for TCONTs 0-3.  This confi */
/* guration is irrelevant for Ethernet.                                                  */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_PDBASE0_3_FIFOBASE3_DEFAULT_EPON_VALUE             ( 0x30 )
#define BBH_TX_EPON_CFG_PDBASE0_3_FIFOBASE3_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x30 )
#define BBH_TX_EPON_CFG_PDBASE0_3_FIFOBASE3_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_EPON_CFG_PDBASE0_3_FIFOBASE2_DEFAULT_EPON_VALUE             ( 0x20 )
#define BBH_TX_EPON_CFG_PDBASE0_3_FIFOBASE2_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x20 )
#define BBH_TX_EPON_CFG_PDBASE0_3_FIFOBASE2_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_EPON_CFG_PDBASE0_3_FIFOBASE1_DEFAULT_EPON_VALUE             ( 0x10 )
#define BBH_TX_EPON_CFG_PDBASE0_3_FIFOBASE1_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x10 )
#define BBH_TX_EPON_CFG_PDBASE0_3_FIFOBASE1_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_EPON_CFG_PDBASE0_3_FIFOBASE0_DEFAULT_EPON_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_PDBASE0_3_FIFOBASE0_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_EPON_CFG_PDBASE0_3_FIFOBASE0_MAX_EPON_VALUE                 ( 0xFF )


#define BBH_TX_EPON_CFG_PDBASE0_3_OFFSET ( 0x00000018 )

#define BBH_TX_0_EPON_CFG_PDBASE0_3_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE0_3_OFFSET )
#define BBH_TX_0_EPON_CFG_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_PDBASE0_3_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_PDBASE0_3_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE0_3_OFFSET )
#define BBH_TX_1_EPON_CFG_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_PDBASE0_3_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_PDBASE0_3_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE0_3_OFFSET )
#define BBH_TX_2_EPON_CFG_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_PDBASE0_3_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_PDBASE0_3_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE0_3_OFFSET )
#define BBH_TX_3_EPON_CFG_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_PDBASE0_3_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_PDBASE0_3_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE0_3_OFFSET )
#define BBH_TX_4_EPON_CFG_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_PDBASE0_3_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_PDBASE0_3_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE0_3_OFFSET )
#define BBH_TX_5_EPON_CFG_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_PDBASE0_3_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_PDBASE0_3_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE0_3_OFFSET )
#define BBH_TX_6_EPON_CFG_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_PDBASE0_3_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_PDBASE0_3_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_PDBASE0_3_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_PDBASE0_3_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_PDBASE0_3_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_PDBASE0_3_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* FIFO_base_3 */
	uint32_t fifobase3	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_2 */
	uint32_t fifobase2	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_1 */
	uint32_t fifobase1	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_0 */
	uint32_t fifobase0	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDBASE0_3 ;
#else
typedef struct
{	uint32_t fifobase0	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_0 */
	uint32_t fifobase1	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_1 */
	uint32_t fifobase2	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_2 */
	uint32_t fifobase3	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_3 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDBASE0_3 ;
#endif

/*****************************************************************************************/
/* PD_FIFO_base_4_7                                                                      */
/* The BBH manages 40 queues for GPON or 32 queus for EPON (1 for each TCONT/LLID). For  */
/* each queue it manages a PD FIFO.   A total of 128 PDs (GPON) or 256 (EPON) are availa */
/* ble for all queues.   For each Queue the SW configures the base and the size within t */
/* hese 128/256 PDs.  This register defines the PD FIFO base for TCONTs 4-7.  This confi */
/* guration is irrelevant for Ethernet.                                                  */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_PDBASE4_7_FIFOBASE7_DEFAULT_EPON_VALUE             ( 0x70 )
#define BBH_TX_EPON_CFG_PDBASE4_7_FIFOBASE7_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x70 )
#define BBH_TX_EPON_CFG_PDBASE4_7_FIFOBASE7_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_EPON_CFG_PDBASE4_7_FIFOBASE6_DEFAULT_EPON_VALUE             ( 0x60 )
#define BBH_TX_EPON_CFG_PDBASE4_7_FIFOBASE6_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x60 )
#define BBH_TX_EPON_CFG_PDBASE4_7_FIFOBASE6_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_EPON_CFG_PDBASE4_7_FIFOBASE5_DEFAULT_EPON_VALUE             ( 0x50 )
#define BBH_TX_EPON_CFG_PDBASE4_7_FIFOBASE5_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x50 )
#define BBH_TX_EPON_CFG_PDBASE4_7_FIFOBASE5_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_EPON_CFG_PDBASE4_7_FIFOBASE4_DEFAULT_EPON_VALUE             ( 0x40 )
#define BBH_TX_EPON_CFG_PDBASE4_7_FIFOBASE4_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x40 )
#define BBH_TX_EPON_CFG_PDBASE4_7_FIFOBASE4_MAX_EPON_VALUE                 ( 0xFF )


#define BBH_TX_EPON_CFG_PDBASE4_7_OFFSET ( 0x0000001C )

#define BBH_TX_0_EPON_CFG_PDBASE4_7_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE4_7_OFFSET )
#define BBH_TX_0_EPON_CFG_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_PDBASE4_7_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_PDBASE4_7_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE4_7_OFFSET )
#define BBH_TX_1_EPON_CFG_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_PDBASE4_7_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_PDBASE4_7_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE4_7_OFFSET )
#define BBH_TX_2_EPON_CFG_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_PDBASE4_7_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_PDBASE4_7_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE4_7_OFFSET )
#define BBH_TX_3_EPON_CFG_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_PDBASE4_7_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_PDBASE4_7_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE4_7_OFFSET )
#define BBH_TX_4_EPON_CFG_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_PDBASE4_7_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_PDBASE4_7_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE4_7_OFFSET )
#define BBH_TX_5_EPON_CFG_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_PDBASE4_7_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_PDBASE4_7_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE4_7_OFFSET )
#define BBH_TX_6_EPON_CFG_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_PDBASE4_7_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_PDBASE4_7_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_PDBASE4_7_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_PDBASE4_7_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_PDBASE4_7_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_PDBASE4_7_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* FIFO_base_7 */
	uint32_t fifobase7	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_6 */
	uint32_t fifobase6	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_5 */
	uint32_t fifobase5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_4 */
	uint32_t fifobase4	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDBASE4_7 ;
#else
typedef struct
{	uint32_t fifobase4	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_4 */
	uint32_t fifobase5	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_5 */
	uint32_t fifobase6	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_6 */
	uint32_t fifobase7	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_7 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDBASE4_7 ;
#endif

/*****************************************************************************************/
/* PD_FIFO_base_8_39                                                                     */
/* The BBH manages 40 queues (GPON) or 32 queus (EPON). For each queue it manages a PD F */
/* IFO.   A total of 128 PDs (GPON) or 256 PDs (EPON) are available for all queues.   Fo */
/* r each Queue the SW configures the base and the size within these 128/256 PDs.  This  */
/* register defines the PD FIFO base for queues 8-39.  This configuration is irrelevant  */
/* for Ethernet.                                                                         */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_PDBASE8_39_FIFOBASE32_39_MAX_EPON_VALUE                 ( 0x0 )
#define BBH_TX_EPON_CFG_PDBASE8_39_FIFOBASE32_39_DEFAULT_GPON_VALUE             ( 0x70 )
#define BBH_TX_EPON_CFG_PDBASE8_39_FIFOBASE32_39_DEFAULT_GPON_VALUE_RESET_VALUE ( 0x70 )
#define BBH_TX_EPON_CFG_PDBASE8_39_FIFOBASE24_31_DEFAULT_EPON_VALUE             ( 0xD0 )
#define BBH_TX_EPON_CFG_PDBASE8_39_FIFOBASE24_31_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xD0 )
#define BBH_TX_EPON_CFG_PDBASE8_39_FIFOBASE24_31_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_EPON_CFG_PDBASE8_39_FIFOBASE16_23_DEFAULT_EPON_VALUE             ( 0xA8 )
#define BBH_TX_EPON_CFG_PDBASE8_39_FIFOBASE16_23_DEFAULT_EPON_VALUE_RESET_VALUE ( 0xA8 )
#define BBH_TX_EPON_CFG_PDBASE8_39_FIFOBASE16_23_MAX_EPON_VALUE                 ( 0xFF )
#define BBH_TX_EPON_CFG_PDBASE8_39_FIFOBASE8_15_DEFAULT_EPON_VALUE              ( 0x80 )
#define BBH_TX_EPON_CFG_PDBASE8_39_FIFOBASE8_15_DEFAULT_EPON_VALUE_RESET_VALUE  ( 0x80 )
#define BBH_TX_EPON_CFG_PDBASE8_39_FIFOBASE8_15_MAX_EPON_VALUE                  ( 0xFF )


#define BBH_TX_EPON_CFG_PDBASE8_39_OFFSET ( 0x00000020 )

#define BBH_TX_0_EPON_CFG_PDBASE8_39_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE8_39_OFFSET )
#define BBH_TX_0_EPON_CFG_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_PDBASE8_39_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_PDBASE8_39_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE8_39_OFFSET )
#define BBH_TX_1_EPON_CFG_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_PDBASE8_39_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_PDBASE8_39_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE8_39_OFFSET )
#define BBH_TX_2_EPON_CFG_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_PDBASE8_39_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_PDBASE8_39_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE8_39_OFFSET )
#define BBH_TX_3_EPON_CFG_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_PDBASE8_39_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_PDBASE8_39_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE8_39_OFFSET )
#define BBH_TX_4_EPON_CFG_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_PDBASE8_39_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_PDBASE8_39_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE8_39_OFFSET )
#define BBH_TX_5_EPON_CFG_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_PDBASE8_39_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_PDBASE8_39_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE8_39_OFFSET )
#define BBH_TX_6_EPON_CFG_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_PDBASE8_39_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_PDBASE8_39_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_PDBASE8_39_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_PDBASE8_39_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_PDBASE8_39_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_PDBASE8_39_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* FIFO_base_32_39 */
	uint32_t fifobase32_39	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_24_31 */
	uint32_t fifobase24_31	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_16_23 */
	uint32_t fifobase16_23	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_8_15 */
	uint32_t fifobase8_15 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDBASE8_39 ;
#else
typedef struct
{	uint32_t fifobase8_15 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_8_15 */
	uint32_t fifobase16_23	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_16_23 */
	uint32_t fifobase24_31	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_24_31 */
	uint32_t fifobase32_39	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_base_32_39 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDBASE8_39 ;
#endif

/*****************************************************************************************/
/* PD_bytes_threshold_EN                                                                 */
/* The BBH requests PDs from the Runner and maintains a pre-fetch PDs FIFO.  The PDs pre */
/*  fetch is limited either by the PD FIFO configurable size or according to the total n */
/* umber of bytes (deducting bytes already requested/transmitted) for preventing HOL. Fu */
/* ll configuration for the first 8 TCONT and one configuration per group of 8 TCONTs fo */
/* r the rest.                                                                           */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_PD_BYTE_TH_EN_RESERVED1_DEFAULT_VALUE                      ( 0x0 )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_EN_RESERVED1_DEFAULT_VALUE_RESET_VALUE          ( 0x0 )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_EN_PDLIMITEN_PD_LIMIT_DISABLE_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_EN_PDLIMITEN_PD_LIMIT_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_EN_PDLIMITEN_PD_LIMIT_ENABLE_VALUE              ( 0x1 )


#define BBH_TX_EPON_CFG_PD_BYTE_TH_EN_OFFSET ( 0x00000024 )

#define BBH_TX_0_EPON_CFG_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_0_EPON_CFG_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_1_EPON_CFG_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_2_EPON_CFG_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_3_EPON_CFG_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_4_EPON_CFG_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_5_EPON_CFG_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_6_EPON_CFG_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_PD_BYTE_TH_EN_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_PD_BYTE_TH_EN_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_PD_BYTE_TH_EN_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_EN_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_PD_BYTE_TH_EN_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_limit_enable */
	uint32_t pdlimiten	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PD_BYTE_TH_EN ;
#else
typedef struct
{	uint32_t pdlimiten	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_limit_enable */
	uint32_t reserved1	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PD_BYTE_TH_EN ;
#endif

/*****************************************************************************************/
/* PD_bytes_threshold                                                                    */
/* The BBH requests PDs from the Runner and maintains a pre-fetch PDs FIFO.  The PDs pre */
/*  fetch is limited either by the PD FIFO configurable size or according to the total n */
/* umber of bytes (deducting bytes already requested/transmitted) for preventing HOL. Fu */
/* ll configuration for the first 8 TCONT and one configuration for the rest (TCONTs 8-3 */
/* 9).  Registers 0-3 define the configuration for the first 8 TCONT and register 4 defi */
/* nes the configuration for TCONTs 8-39 (in the even field).                            */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_PD_BYTE_TH_R2_RESET_VALUE_VALUE                  ( 0x0 )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_R2_RESET_VALUE_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_PDLIMITEVEN_DEFAULT_VALUE             ( 0x180 )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_PDLIMITEVEN_DEFAULT_VALUE_RESET_VALUE ( 0x180 )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_R1_RESET_VALUE_VALUE                  ( 0x0 )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_R1_RESET_VALUE_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_PDLIMITODD_DEFAULT_VALUE              ( 0x180 )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_PDLIMITODD_DEFAULT_VALUE_RESET_VALUE  ( 0x180 )


#define BBH_TX_EPON_CFG_PD_BYTE_TH_OFFSET ( 0x00000028 )

#define BBH_TX_0_EPON_CFG_PD_BYTE_TH_ADDRESS        	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_OFFSET )
#define BBH_TX_0_EPON_CFG_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_0_EPON_CFG_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (v) )

#define BBH_TX_1_EPON_CFG_PD_BYTE_TH_ADDRESS        	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_OFFSET )
#define BBH_TX_1_EPON_CFG_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_1_EPON_CFG_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (v) )

#define BBH_TX_2_EPON_CFG_PD_BYTE_TH_ADDRESS        	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_OFFSET )
#define BBH_TX_2_EPON_CFG_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_2_EPON_CFG_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (v) )

#define BBH_TX_3_EPON_CFG_PD_BYTE_TH_ADDRESS        	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_OFFSET )
#define BBH_TX_3_EPON_CFG_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_3_EPON_CFG_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (v) )

#define BBH_TX_4_EPON_CFG_PD_BYTE_TH_ADDRESS        	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_OFFSET )
#define BBH_TX_4_EPON_CFG_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_4_EPON_CFG_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (v) )

#define BBH_TX_5_EPON_CFG_PD_BYTE_TH_ADDRESS        	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_OFFSET )
#define BBH_TX_5_EPON_CFG_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_5_EPON_CFG_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (v) )

#define BBH_TX_6_EPON_CFG_PD_BYTE_TH_ADDRESS        	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_OFFSET )
#define BBH_TX_6_EPON_CFG_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_6_EPON_CFG_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (v) )


extern uint32_t BBH_TX_EPON_CFG_PD_BYTE_TH_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_PD_BYTE_TH_WRITE( i, k, v )	WRITE_I_32( BBH_TX_EPON_CFG_PD_BYTE_TH_ARRAY [ i ], (k), (v) )
#define BBH_TX_EPON_CFG_PD_BYTE_TH_READ( i, k, r ) 	READ_I_32( BBH_TX_EPON_CFG_PD_BYTE_TH_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2         	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_limit_even */
	uint32_t pdlimiteven	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1         	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_limit_odd */
	uint32_t pdlimitodd 	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PD_BYTE_TH ;
#else
typedef struct
{	uint32_t pdlimitodd 	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_limit_odd */
	uint32_t r1         	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t pdlimiteven	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_limit_even */
	uint32_t r2         	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PD_BYTE_TH ;
#endif

/*****************************************************************************************/
/* Runner_configurations                                                                 */
/* TCONT/LLID address:  The BBH requests a Packet descriptor from the Runner. The BBH se */
/* nds a wake-up request to the Runner (for a new PD). The wake-up request is written to */
/*  address 0x8000 in the Runner.    In the case of GPON/EPON peripheral the BBH writes  */
/* the TCONT/LLID number in a predefined address at the Runner SRAM and then sends a wak */
/* e-up request to the Runner.   This register defines the TCONT/LLID address within the */
/*  Runner address space.                                                                */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_RUNNERCFG_R0_DEFAULT_VALUE                          ( 0x0 )
#define BBH_TX_EPON_CFG_RUNNERCFG_R0_DEFAULT_VALUE_RESET_VALUE              ( 0x0 )
#define BBH_TX_EPON_CFG_RUNNERCFG_TCONTADDR_TCONT_ADDRESS_VALUE             ( 0x1797 )
#define BBH_TX_EPON_CFG_RUNNERCFG_TCONTADDR_TCONT_ADDRESS_VALUE_RESET_VALUE ( 0x1797 )


#define BBH_TX_EPON_CFG_RUNNERCFG_OFFSET ( 0x0000003C )

#define BBH_TX_0_EPON_CFG_RUNNERCFG_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_RUNNERCFG_OFFSET )
#define BBH_TX_0_EPON_CFG_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_RUNNERCFG_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_RUNNERCFG_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_RUNNERCFG_OFFSET )
#define BBH_TX_1_EPON_CFG_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_RUNNERCFG_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_RUNNERCFG_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_RUNNERCFG_OFFSET )
#define BBH_TX_2_EPON_CFG_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_RUNNERCFG_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_RUNNERCFG_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_RUNNERCFG_OFFSET )
#define BBH_TX_3_EPON_CFG_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_RUNNERCFG_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_RUNNERCFG_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_RUNNERCFG_OFFSET )
#define BBH_TX_4_EPON_CFG_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_RUNNERCFG_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_RUNNERCFG_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_RUNNERCFG_OFFSET )
#define BBH_TX_5_EPON_CFG_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_RUNNERCFG_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_RUNNERCFG_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_RUNNERCFG_OFFSET )
#define BBH_TX_6_EPON_CFG_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_RUNNERCFG_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_RUNNERCFG_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_RUNNERCFG_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_RUNNERCFG_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_RUNNERCFG_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_RUNNERCFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r0       	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCONT_address */
	uint32_t tcontaddr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_RUNNERCFG ;
#else
typedef struct
{	uint32_t tcontaddr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TCONT_address */
	uint32_t r0       	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_RUNNERCFG ;
#endif

/*****************************************************************************************/
/* MDU_CFG                                                                               */
/* The BBH supports a special configurable mode to enable a faster packet bridging:  -Th */
/* ere will be a special configurable mode for transferring the PD from the Runner into  */
/* the BBH TX.    -The Runner wont ACK the BBH; therefore the BBH wont wake the TX task. */
/*    -The Runner will push the PDs into the BBH (without any wakeup from the BBH).   -E */
/* ach time that the BBH reads a PD from the PD FIFO, it will write the read pointer int */
/* o a pre-defined address in the Runner (enable by configuration). The pointer is 6 bit */
/* s width (one bit larger than needed to distinguish between full and empty).  -The Run */
/* ner should manage the congestion over the PD FIFO (in the BBH) by reading the BBH rea */
/* d pointer prior to each PD write.   -PD drop should be done by the Runner only. The B */
/* BH will drop PD when the FIFO is full and will count each drop. The BBH wont release  */
/* the BN in this case.  For EPON BBH, there will be a full threshold, which can be smal */
/* ler than the actual size of the FIFO. When the BBH will move from full to not full st */
/* ate, the BBH will wakeup the Runner.                                                  */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_MDUMODE_PTRADDR_RESET_VALUE_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_MDUMODE_PTRADDR_RESET_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_EPON_CFG_MDUMODE_R1_RESET_VALUE_VALUE                  ( 0x0 )
#define BBH_TX_EPON_CFG_MDUMODE_R1_RESET_VALUE_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_TX_EPON_CFG_MDUMODE_MDUEN_DIS_VALUE                       ( 0x0 )
#define BBH_TX_EPON_CFG_MDUMODE_MDUEN_DIS_VALUE_RESET_VALUE           ( 0x0 )
#define BBH_TX_EPON_CFG_MDUMODE_MDUEN_EN_VALUE                        ( 0x1 )


#define BBH_TX_EPON_CFG_MDUMODE_OFFSET ( 0x00000040 )

#define BBH_TX_0_EPON_CFG_MDUMODE_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_MDUMODE_OFFSET )
#define BBH_TX_0_EPON_CFG_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_MDUMODE_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_MDUMODE_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_MDUMODE_OFFSET )
#define BBH_TX_1_EPON_CFG_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_MDUMODE_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_MDUMODE_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_MDUMODE_OFFSET )
#define BBH_TX_2_EPON_CFG_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_MDUMODE_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_MDUMODE_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_MDUMODE_OFFSET )
#define BBH_TX_3_EPON_CFG_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_MDUMODE_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_MDUMODE_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_MDUMODE_OFFSET )
#define BBH_TX_4_EPON_CFG_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_MDUMODE_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_MDUMODE_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_MDUMODE_OFFSET )
#define BBH_TX_5_EPON_CFG_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_MDUMODE_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_MDUMODE_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_MDUMODE_OFFSET )
#define BBH_TX_6_EPON_CFG_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_MDUMODE_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_MDUMODE_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_MDUMODE_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_MDUMODE_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_MDUMODE_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_MDUMODE_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PTRADDR */
	uint32_t ptraddr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1     	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MDU_EN */
	uint32_t mduen  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_MDUMODE ;
#else
typedef struct
{	uint32_t mduen  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MDU_EN */
	uint32_t r1     	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t ptraddr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PTRADDR */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_MDUMODE ;
#endif

/*****************************************************************************************/
/* REQ_CFG                                                                               */
/* Configurations related to EPON Request interface.                                     */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_REQCFG_R1_DEFAULT_VALUE                     ( 0x0 )
#define BBH_TX_EPON_CFG_REQCFG_R1_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_TX_EPON_CFG_REQCFG_CMP_WIDTH_WIDTH_11_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_REQCFG_CMP_WIDTH_WIDTH_11_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_EPON_CFG_REQCFG_CMP_WIDTH_WIDTH_14_VALUE             ( 0x1 )
#define BBH_TX_EPON_CFG_REQCFG_STPLENERR_CONTINUE_VALUE             ( 0x0 )
#define BBH_TX_EPON_CFG_REQCFG_STPLENERR_CONTINUE_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_EPON_CFG_REQCFG_STPLENERR_STOP_VALUE                 ( 0x1 )


#define BBH_TX_EPON_CFG_REQCFG_OFFSET ( 0x00000044 )

#define BBH_TX_0_EPON_CFG_REQCFG_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_REQCFG_OFFSET )
#define BBH_TX_0_EPON_CFG_REQCFG_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_REQCFG_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_REQCFG_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_REQCFG_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_REQCFG_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_REQCFG_OFFSET )
#define BBH_TX_1_EPON_CFG_REQCFG_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_REQCFG_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_REQCFG_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_REQCFG_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_REQCFG_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_REQCFG_OFFSET )
#define BBH_TX_2_EPON_CFG_REQCFG_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_REQCFG_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_REQCFG_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_REQCFG_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_REQCFG_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_REQCFG_OFFSET )
#define BBH_TX_3_EPON_CFG_REQCFG_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_REQCFG_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_REQCFG_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_REQCFG_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_REQCFG_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_REQCFG_OFFSET )
#define BBH_TX_4_EPON_CFG_REQCFG_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_REQCFG_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_REQCFG_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_REQCFG_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_REQCFG_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_REQCFG_OFFSET )
#define BBH_TX_5_EPON_CFG_REQCFG_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_REQCFG_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_REQCFG_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_REQCFG_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_REQCFG_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_REQCFG_OFFSET )
#define BBH_TX_6_EPON_CFG_REQCFG_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_REQCFG_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_REQCFG_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_REQCFG_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_REQCFG_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_REQCFG_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_REQCFG_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_REQCFG_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_REQCFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1       	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* comp_width */
	uint32_t cmp_width	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Stop_on_len_error */
	uint32_t stplenerr	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_REQCFG ;
#else
typedef struct
{	uint32_t stplenerr	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Stop_on_len_error */
	uint32_t cmp_width	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* comp_width */
	uint32_t r1       	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_REQCFG ;
#endif

/*****************************************************************************************/
/* PD_WKUP_THRESH_0_3                                                                    */
/* The BBH manages 32 queues for EPON (FIFO per LLID). For each queue it manages a PD FI */
/* FO.   When a FIFO occupancy is above this wakeup threshold, the BBH will not wake-up  */
/* the Runner for sending a new PD. This threshold does not represent the actual size of */
/*  the FIFO. If a PD will arrive from the Runner when the FIFO is above the threshold,  */
/* it will not be dropped unless the FIFO is actually full.  Relevant only for EPON BBH. */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_PDWKUPH0_3_R4_DEFAULT_VALUE                           ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_R4_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_WKUPTHRESH3_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_WKUPTHRESH3_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_WKUPTHRESH3_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_R3_DEFAULT_VALUE                           ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_R3_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_WKUPTHRESH2_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_WKUPTHRESH2_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_WKUPTHRESH2_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_R2_DEFAULT_VALUE                           ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_R2_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_WKUPTHRESH1_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_WKUPTHRESH1_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_WKUPTHRESH1_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_R1_DEFAULT_VALUE                           ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_R1_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_WKUPTHRESH0_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_WKUPTHRESH0_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_WKUPTHRESH0_MAX_EPON_VALUE                 ( 0xF )


#define BBH_TX_EPON_CFG_PDWKUPH0_3_OFFSET ( 0x00000048 )

#define BBH_TX_0_EPON_CFG_PDWKUPH0_3_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH0_3_OFFSET )
#define BBH_TX_0_EPON_CFG_PDWKUPH0_3_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_PDWKUPH0_3_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_PDWKUPH0_3_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_PDWKUPH0_3_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_PDWKUPH0_3_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH0_3_OFFSET )
#define BBH_TX_1_EPON_CFG_PDWKUPH0_3_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_PDWKUPH0_3_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_PDWKUPH0_3_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_PDWKUPH0_3_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_PDWKUPH0_3_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH0_3_OFFSET )
#define BBH_TX_2_EPON_CFG_PDWKUPH0_3_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_PDWKUPH0_3_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_PDWKUPH0_3_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_PDWKUPH0_3_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_PDWKUPH0_3_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH0_3_OFFSET )
#define BBH_TX_3_EPON_CFG_PDWKUPH0_3_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_PDWKUPH0_3_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_PDWKUPH0_3_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_PDWKUPH0_3_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_PDWKUPH0_3_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH0_3_OFFSET )
#define BBH_TX_4_EPON_CFG_PDWKUPH0_3_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_PDWKUPH0_3_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_PDWKUPH0_3_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_PDWKUPH0_3_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_PDWKUPH0_3_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH0_3_OFFSET )
#define BBH_TX_5_EPON_CFG_PDWKUPH0_3_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_PDWKUPH0_3_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_PDWKUPH0_3_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_PDWKUPH0_3_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_PDWKUPH0_3_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH0_3_OFFSET )
#define BBH_TX_6_EPON_CFG_PDWKUPH0_3_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_PDWKUPH0_3_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_PDWKUPH0_3_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_PDWKUPH0_3_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_PDWKUPH0_3_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_PDWKUPH0_3_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_PDWKUPH0_3_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_PDWKUPH0_3_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_PDWKUPH0_3_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_3 */
	uint32_t wkupthresh3	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_2 */
	uint32_t wkupthresh2	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_1 */
	uint32_t wkupthresh1	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_0 */
	uint32_t wkupthresh0	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDWKUPH0_3 ;
#else
typedef struct
{	uint32_t wkupthresh0	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_0 */
	uint32_t r1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t wkupthresh1	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_1 */
	uint32_t r2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t wkupthresh2	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_2 */
	uint32_t r3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t wkupthresh3	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_3 */
	uint32_t r4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDWKUPH0_3 ;
#endif

/*****************************************************************************************/
/* PD_WKUP_THRESH_4_7                                                                    */
/* The BBH manages 32 queues for EPON (FIFO per LLID). For each queue it manages a PD FI */
/* FO.   When a FIFO occupancy is above this wakeup threshold, the BBH will not wake-up  */
/* the Runner for sending a new PD. This threshold does not represent the actual size of */
/*  the FIFO. If a PD will arrive from the Runner when the FIFO is above the threshold,  */
/* it will not be dropped unless the FIFO is actually full.  Relevant only for EPON BBH. */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_PDWKUPH4_7_R4_DEFAULT_VALUE                           ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_R4_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_WKUPTHRESH7_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_WKUPTHRESH7_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_WKUPTHRESH7_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_R3_DEFAULT_VALUE                           ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_R3_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_WKUPTHRESH6_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_WKUPTHRESH6_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_WKUPTHRESH6_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_R2_DEFAULT_VALUE                           ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_R2_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_WKUPTHRESH5_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_WKUPTHRESH5_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_WKUPTHRESH5_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_R1_DEFAULT_VALUE                           ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_R1_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_WKUPTHRESH4_DEFAULT_EPON_VALUE             ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_WKUPTHRESH4_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x7 )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_WKUPTHRESH4_MAX_EPON_VALUE                 ( 0xF )


#define BBH_TX_EPON_CFG_PDWKUPH4_7_OFFSET ( 0x0000004C )

#define BBH_TX_0_EPON_CFG_PDWKUPH4_7_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH4_7_OFFSET )
#define BBH_TX_0_EPON_CFG_PDWKUPH4_7_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_PDWKUPH4_7_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_PDWKUPH4_7_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_PDWKUPH4_7_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_PDWKUPH4_7_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH4_7_OFFSET )
#define BBH_TX_1_EPON_CFG_PDWKUPH4_7_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_PDWKUPH4_7_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_PDWKUPH4_7_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_PDWKUPH4_7_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_PDWKUPH4_7_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH4_7_OFFSET )
#define BBH_TX_2_EPON_CFG_PDWKUPH4_7_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_PDWKUPH4_7_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_PDWKUPH4_7_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_PDWKUPH4_7_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_PDWKUPH4_7_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH4_7_OFFSET )
#define BBH_TX_3_EPON_CFG_PDWKUPH4_7_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_PDWKUPH4_7_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_PDWKUPH4_7_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_PDWKUPH4_7_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_PDWKUPH4_7_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH4_7_OFFSET )
#define BBH_TX_4_EPON_CFG_PDWKUPH4_7_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_PDWKUPH4_7_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_PDWKUPH4_7_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_PDWKUPH4_7_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_PDWKUPH4_7_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH4_7_OFFSET )
#define BBH_TX_5_EPON_CFG_PDWKUPH4_7_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_PDWKUPH4_7_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_PDWKUPH4_7_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_PDWKUPH4_7_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_PDWKUPH4_7_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH4_7_OFFSET )
#define BBH_TX_6_EPON_CFG_PDWKUPH4_7_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_PDWKUPH4_7_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_PDWKUPH4_7_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_PDWKUPH4_7_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_PDWKUPH4_7_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_PDWKUPH4_7_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_PDWKUPH4_7_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_PDWKUPH4_7_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_PDWKUPH4_7_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_7 */
	uint32_t wkupthresh7	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_6 */
	uint32_t wkupthresh6	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_5 */
	uint32_t wkupthresh5	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_4 */
	uint32_t wkupthresh4	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDWKUPH4_7 ;
#else
typedef struct
{	uint32_t wkupthresh4	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_4 */
	uint32_t r1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t wkupthresh5	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_5 */
	uint32_t r2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t wkupthresh6	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_6 */
	uint32_t r3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t wkupthresh7	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_7 */
	uint32_t r4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDWKUPH4_7 ;
#endif

/*****************************************************************************************/
/* PD_WKUP_THRESH_8_31                                                                   */
/* The BBH manages 32 queues for EPON (FIFO per LLID). For each queue it manages a PD FI */
/* FO.   When a FIFO occupancy is above this wakeup threshold, the BBH will not wake-up  */
/* the Runner for sending a new PD. This threshold does not represent the actual size of */
/*  the FIFO. If a PD will arrive from the Runner when the FIFO is above the threshold,  */
/* it will not be dropped unless the FIFO is actually full.  For queues 8-31, this confi */
/* guration is per octet.  Relevant only for EPON BBH.                                   */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_PDWKUPH8_31_R2_DEFAULT_VALUE                               ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_R2_DEFAULT_VALUE_RESET_VALUE                   ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_WKUPTHRESH24_31_DEFAULT_EPON_VALUE             ( 0x2 )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_WKUPTHRESH24_31_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x2 )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_WKUPTHRESH24_31_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_R1_DEFAULT_VALUE                               ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_R1_DEFAULT_VALUE_RESET_VALUE                   ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_WKUPTHRESH16_23_DEFAULT_EPON_VALUE             ( 0x2 )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_WKUPTHRESH16_23_DEFAULT_EPON_VALUE_RESET_VALUE ( 0x2 )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_WKUPTHRESH16_23_MAX_EPON_VALUE                 ( 0xF )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_R0_DEFAULT_VALUE                               ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_R0_DEFAULT_VALUE_RESET_VALUE                   ( 0x0 )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_WKUPTHRESH8_15_DEFAULT_EPON_VALUE              ( 0x2 )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_WKUPTHRESH8_15_DEFAULT_EPON_VALUE_RESET_VALUE  ( 0x2 )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_WKUPTHRESH8_15_MAX_EPON_VALUE                  ( 0xF )


#define BBH_TX_EPON_CFG_PDWKUPH8_31_OFFSET ( 0x00000050 )

#define BBH_TX_0_EPON_CFG_PDWKUPH8_31_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH8_31_OFFSET )
#define BBH_TX_0_EPON_CFG_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_PDWKUPH8_31_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_PDWKUPH8_31_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH8_31_OFFSET )
#define BBH_TX_1_EPON_CFG_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_PDWKUPH8_31_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_PDWKUPH8_31_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH8_31_OFFSET )
#define BBH_TX_2_EPON_CFG_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_PDWKUPH8_31_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_PDWKUPH8_31_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH8_31_OFFSET )
#define BBH_TX_3_EPON_CFG_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_PDWKUPH8_31_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_PDWKUPH8_31_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH8_31_OFFSET )
#define BBH_TX_4_EPON_CFG_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_PDWKUPH8_31_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_PDWKUPH8_31_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH8_31_OFFSET )
#define BBH_TX_5_EPON_CFG_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_PDWKUPH8_31_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_PDWKUPH8_31_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH8_31_OFFSET )
#define BBH_TX_6_EPON_CFG_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_PDWKUPH8_31_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_PDWKUPH8_31_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_PDWKUPH8_31_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_PDWKUPH8_31_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_PDWKUPH8_31_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_PDWKUPH8_31_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r2             	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_24_31 */
	uint32_t wkupthresh24_31	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_16_23 */
	uint32_t wkupthresh16_23	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r0             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_8_15 */
	uint32_t wkupthresh8_15 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDWKUPH8_31 ;
#else
typedef struct
{	uint32_t wkupthresh8_15 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_8_15 */
	uint32_t r0             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t wkupthresh16_23	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_16_23 */
	uint32_t r1             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t wkupthresh24_31	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FIFO_wake_up_threshold_24_31 */
	uint32_t r2             	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDWKUPH8_31 ;
#endif

/*****************************************************************************************/
/* PD_EMPTY_THRESHOLD                                                                    */
/* The BBH manages 32 queues for EPON (FIFO per LLID). For each queue it manages a PD FI */
/* FO. Usually, the BBH orders PDs from the Runner in RR between all queues. In EPON BBH */
/* , if a FIFO occupancy is below this threshold, the queue will have higher priority in */
/*  PD ordering arbitration (with RR between all the empty queues).  This configuration  */
/* is global for all queues.  Relevant only for EPON BBH.                                */
/*****************************************************************************************/

#define BBH_TX_EPON_CFG_PDEMPTY_R1_DEFAULT_VALUE                ( 0x0 )
#define BBH_TX_EPON_CFG_PDEMPTY_R1_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define BBH_TX_EPON_CFG_PDEMPTY_EMPTY_MIN_VALUE                 ( 0x0 )
#define BBH_TX_EPON_CFG_PDEMPTY_EMPTY_DEFAULT_VALUE             ( 0x1 )
#define BBH_TX_EPON_CFG_PDEMPTY_EMPTY_DEFAULT_VALUE_RESET_VALUE ( 0x1 )
#define BBH_TX_EPON_CFG_PDEMPTY_EMPTY_MAX_VALUE                 ( 0xF )


#define BBH_TX_EPON_CFG_PDEMPTY_OFFSET ( 0x00000054 )

#define BBH_TX_0_EPON_CFG_PDEMPTY_ADDRESS   	( BBH_TX_0_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDEMPTY_OFFSET )
#define BBH_TX_0_EPON_CFG_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_0_EPON_CFG_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_0_EPON_CFG_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_CFG_PDEMPTY_ADDRESS ), (v) )

#define BBH_TX_1_EPON_CFG_PDEMPTY_ADDRESS   	( BBH_TX_1_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDEMPTY_OFFSET )
#define BBH_TX_1_EPON_CFG_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_1_EPON_CFG_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_1_EPON_CFG_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_CFG_PDEMPTY_ADDRESS ), (v) )

#define BBH_TX_2_EPON_CFG_PDEMPTY_ADDRESS   	( BBH_TX_2_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDEMPTY_OFFSET )
#define BBH_TX_2_EPON_CFG_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_2_EPON_CFG_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_2_EPON_CFG_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_CFG_PDEMPTY_ADDRESS ), (v) )

#define BBH_TX_3_EPON_CFG_PDEMPTY_ADDRESS   	( BBH_TX_3_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDEMPTY_OFFSET )
#define BBH_TX_3_EPON_CFG_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_3_EPON_CFG_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_3_EPON_CFG_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_CFG_PDEMPTY_ADDRESS ), (v) )

#define BBH_TX_4_EPON_CFG_PDEMPTY_ADDRESS   	( BBH_TX_4_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDEMPTY_OFFSET )
#define BBH_TX_4_EPON_CFG_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_4_EPON_CFG_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_4_EPON_CFG_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_CFG_PDEMPTY_ADDRESS ), (v) )

#define BBH_TX_5_EPON_CFG_PDEMPTY_ADDRESS   	( BBH_TX_5_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDEMPTY_OFFSET )
#define BBH_TX_5_EPON_CFG_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_5_EPON_CFG_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_5_EPON_CFG_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_CFG_PDEMPTY_ADDRESS ), (v) )

#define BBH_TX_6_EPON_CFG_PDEMPTY_ADDRESS   	( BBH_TX_6_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDEMPTY_OFFSET )
#define BBH_TX_6_EPON_CFG_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_6_EPON_CFG_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_6_EPON_CFG_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_CFG_PDEMPTY_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_CFG_PDEMPTY_ARRAY [ ] ;

#define BBH_TX_EPON_CFG_PDEMPTY_WRITE( i, v )	WRITE_32( BBH_TX_EPON_CFG_PDEMPTY_ARRAY [ i ], (v) )
#define BBH_TX_EPON_CFG_PDEMPTY_READ( i, r ) 	READ_32( BBH_TX_EPON_CFG_PDEMPTY_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Empty_thershold */
	uint32_t empty	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDEMPTY ;
#else
typedef struct
{	uint32_t empty	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Empty_thershold */
	uint32_t r1   	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG_PDEMPTY ;
#endif

/*****************************************************************************************/
/* DDR_PD_counter                                                                        */
/* This counter counts the number of packets which were transmitted from the DDR.  It co */
/* unts the packets for all TCONTs together.  This counter is cleared when read and free */
/* zes when maximum value is reached.                                                    */
/*****************************************************************************************/

#define BBH_TX_EPON_DBG_DDRPD_DDRPD_DDR_PD_VALUE             ( 0x0 )
#define BBH_TX_EPON_DBG_DDRPD_DDRPD_DDR_PD_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_EPON_DBG_DDRPD_OFFSET ( 0x00000004 )

#define BBH_TX_0_EPON_DBG_DDRPD_ADDRESS   	( BBH_TX_0_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_DDRPD_OFFSET )
#define BBH_TX_0_EPON_DBG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_0_EPON_DBG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_0_EPON_DBG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_DBG_DDRPD_ADDRESS ), (v) )

#define BBH_TX_1_EPON_DBG_DDRPD_ADDRESS   	( BBH_TX_1_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_DDRPD_OFFSET )
#define BBH_TX_1_EPON_DBG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_1_EPON_DBG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_1_EPON_DBG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_DBG_DDRPD_ADDRESS ), (v) )

#define BBH_TX_2_EPON_DBG_DDRPD_ADDRESS   	( BBH_TX_2_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_DDRPD_OFFSET )
#define BBH_TX_2_EPON_DBG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_2_EPON_DBG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_2_EPON_DBG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_DBG_DDRPD_ADDRESS ), (v) )

#define BBH_TX_3_EPON_DBG_DDRPD_ADDRESS   	( BBH_TX_3_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_DDRPD_OFFSET )
#define BBH_TX_3_EPON_DBG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_3_EPON_DBG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_3_EPON_DBG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_DBG_DDRPD_ADDRESS ), (v) )

#define BBH_TX_4_EPON_DBG_DDRPD_ADDRESS   	( BBH_TX_4_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_DDRPD_OFFSET )
#define BBH_TX_4_EPON_DBG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_4_EPON_DBG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_4_EPON_DBG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_DBG_DDRPD_ADDRESS ), (v) )

#define BBH_TX_5_EPON_DBG_DDRPD_ADDRESS   	( BBH_TX_5_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_DDRPD_OFFSET )
#define BBH_TX_5_EPON_DBG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_5_EPON_DBG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_5_EPON_DBG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_DBG_DDRPD_ADDRESS ), (v) )

#define BBH_TX_6_EPON_DBG_DDRPD_ADDRESS   	( BBH_TX_6_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_DDRPD_OFFSET )
#define BBH_TX_6_EPON_DBG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_6_EPON_DBG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_6_EPON_DBG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_DBG_DDRPD_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_DBG_DDRPD_ARRAY [ ] ;

#define BBH_TX_EPON_DBG_DDRPD_WRITE( i, v )	WRITE_32( BBH_TX_EPON_DBG_DDRPD_ARRAY [ i ], (v) )
#define BBH_TX_EPON_DBG_DDRPD_READ( i, r ) 	READ_32( BBH_TX_EPON_DBG_DDRPD_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* DDR_PD */
	uint32_t ddrpd	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_DDRPD ;
#else
typedef struct
{	uint32_t ddrpd	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_PD */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_DDRPD ;
#endif

/*****************************************************************************************/
/* PD_DROP_counter                                                                       */
/* This counter counts the number of PDs which were dropped due to PD FIFO full.  It cou */
/* nts the packets for all TCONTs together.  This counter is cleared when read and freez */
/* es when maximum value is reached.  This counter is relevant for Ethernet only.        */
/*****************************************************************************************/

#define BBH_TX_EPON_DBG_PDDROP_R1_RESERVED_VALUE               ( 0x0 )
#define BBH_TX_EPON_DBG_PDDROP_R1_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_TX_EPON_DBG_PDDROP_PDDROP_PDDROP_VALUE             ( 0x0 )
#define BBH_TX_EPON_DBG_PDDROP_PDDROP_PDDROP_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_EPON_DBG_PDDROP_OFFSET ( 0x00000008 )

#define BBH_TX_0_EPON_DBG_PDDROP_ADDRESS   	( BBH_TX_0_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDDROP_OFFSET )
#define BBH_TX_0_EPON_DBG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_0_EPON_DBG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_0_EPON_DBG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_DBG_PDDROP_ADDRESS ), (v) )

#define BBH_TX_1_EPON_DBG_PDDROP_ADDRESS   	( BBH_TX_1_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDDROP_OFFSET )
#define BBH_TX_1_EPON_DBG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_1_EPON_DBG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_1_EPON_DBG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_DBG_PDDROP_ADDRESS ), (v) )

#define BBH_TX_2_EPON_DBG_PDDROP_ADDRESS   	( BBH_TX_2_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDDROP_OFFSET )
#define BBH_TX_2_EPON_DBG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_2_EPON_DBG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_2_EPON_DBG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_DBG_PDDROP_ADDRESS ), (v) )

#define BBH_TX_3_EPON_DBG_PDDROP_ADDRESS   	( BBH_TX_3_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDDROP_OFFSET )
#define BBH_TX_3_EPON_DBG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_3_EPON_DBG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_3_EPON_DBG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_DBG_PDDROP_ADDRESS ), (v) )

#define BBH_TX_4_EPON_DBG_PDDROP_ADDRESS   	( BBH_TX_4_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDDROP_OFFSET )
#define BBH_TX_4_EPON_DBG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_4_EPON_DBG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_4_EPON_DBG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_DBG_PDDROP_ADDRESS ), (v) )

#define BBH_TX_5_EPON_DBG_PDDROP_ADDRESS   	( BBH_TX_5_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDDROP_OFFSET )
#define BBH_TX_5_EPON_DBG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_5_EPON_DBG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_5_EPON_DBG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_DBG_PDDROP_ADDRESS ), (v) )

#define BBH_TX_6_EPON_DBG_PDDROP_ADDRESS   	( BBH_TX_6_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDDROP_OFFSET )
#define BBH_TX_6_EPON_DBG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_6_EPON_DBG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_6_EPON_DBG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_DBG_PDDROP_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_DBG_PDDROP_ARRAY [ ] ;

#define BBH_TX_EPON_DBG_PDDROP_WRITE( i, v )	WRITE_32( BBH_TX_EPON_DBG_PDDROP_ARRAY [ i ], (v) )
#define BBH_TX_EPON_DBG_PDDROP_READ( i, r ) 	READ_32( BBH_TX_EPON_DBG_PDDROP_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1    	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_DROP */
	uint32_t pddrop	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_PDDROP ;
#else
typedef struct
{	uint32_t pddrop	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_DROP */
	uint32_t r1    	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_PDDROP ;
#endif

/*****************************************************************************************/
/* PD_equal_0_counter                                                                    */
/* This counter counts the number of PDs with packet length equal zero.  It counts the p */
/* ackets for all TCONTs together.  This counter is cleared when read and freezes when m */
/* aximum value is reached.                                                              */
/*****************************************************************************************/

#define BBH_TX_EPON_DBG_PDEQ0_R1_RESERVED_VALUE             ( 0x0 )
#define BBH_TX_EPON_DBG_PDEQ0_R1_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_EPON_DBG_PDEQ0_PDEQ0_PDEQ0_VALUE             ( 0x0 )
#define BBH_TX_EPON_DBG_PDEQ0_PDEQ0_PDEQ0_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_EPON_DBG_PDEQ0_OFFSET ( 0x0000000C )

#define BBH_TX_0_EPON_DBG_PDEQ0_ADDRESS   	( BBH_TX_0_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEQ0_OFFSET )
#define BBH_TX_0_EPON_DBG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_0_EPON_DBG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_0_EPON_DBG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_DBG_PDEQ0_ADDRESS ), (v) )

#define BBH_TX_1_EPON_DBG_PDEQ0_ADDRESS   	( BBH_TX_1_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEQ0_OFFSET )
#define BBH_TX_1_EPON_DBG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_1_EPON_DBG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_1_EPON_DBG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_DBG_PDEQ0_ADDRESS ), (v) )

#define BBH_TX_2_EPON_DBG_PDEQ0_ADDRESS   	( BBH_TX_2_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEQ0_OFFSET )
#define BBH_TX_2_EPON_DBG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_2_EPON_DBG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_2_EPON_DBG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_DBG_PDEQ0_ADDRESS ), (v) )

#define BBH_TX_3_EPON_DBG_PDEQ0_ADDRESS   	( BBH_TX_3_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEQ0_OFFSET )
#define BBH_TX_3_EPON_DBG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_3_EPON_DBG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_3_EPON_DBG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_DBG_PDEQ0_ADDRESS ), (v) )

#define BBH_TX_4_EPON_DBG_PDEQ0_ADDRESS   	( BBH_TX_4_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEQ0_OFFSET )
#define BBH_TX_4_EPON_DBG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_4_EPON_DBG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_4_EPON_DBG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_DBG_PDEQ0_ADDRESS ), (v) )

#define BBH_TX_5_EPON_DBG_PDEQ0_ADDRESS   	( BBH_TX_5_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEQ0_OFFSET )
#define BBH_TX_5_EPON_DBG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_5_EPON_DBG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_5_EPON_DBG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_DBG_PDEQ0_ADDRESS ), (v) )

#define BBH_TX_6_EPON_DBG_PDEQ0_ADDRESS   	( BBH_TX_6_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEQ0_OFFSET )
#define BBH_TX_6_EPON_DBG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_6_EPON_DBG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_6_EPON_DBG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_DBG_PDEQ0_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_DBG_PDEQ0_ARRAY [ ] ;

#define BBH_TX_EPON_DBG_PDEQ0_WRITE( i, v )	WRITE_32( BBH_TX_EPON_DBG_PDEQ0_ARRAY [ i ], (v) )
#define BBH_TX_EPON_DBG_PDEQ0_READ( i, r ) 	READ_32( BBH_TX_EPON_DBG_PDEQ0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_equal_0 */
	uint32_t pdeq0	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_PDEQ0 ;
#else
typedef struct
{	uint32_t pdeq0	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_equal_0 */
	uint32_t r1   	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_PDEQ0 ;
#endif

/*****************************************************************************************/
/* PD_Full_LSB                                                                           */
/* Full indication of the PD FIFOs.                                                      */
/*****************************************************************************************/

#define BBH_TX_EPON_DBG_PDFULLLSB_PDFULL_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_EPON_DBG_PDFULLLSB_PDFULL_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_EPON_DBG_PDFULLLSB_OFFSET ( 0x00000020 )

#define BBH_TX_0_EPON_DBG_PDFULLLSB_ADDRESS   	( BBH_TX_0_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDFULLLSB_OFFSET )
#define BBH_TX_0_EPON_DBG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_0_EPON_DBG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_0_EPON_DBG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_DBG_PDFULLLSB_ADDRESS ), (v) )

#define BBH_TX_1_EPON_DBG_PDFULLLSB_ADDRESS   	( BBH_TX_1_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDFULLLSB_OFFSET )
#define BBH_TX_1_EPON_DBG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_1_EPON_DBG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_1_EPON_DBG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_DBG_PDFULLLSB_ADDRESS ), (v) )

#define BBH_TX_2_EPON_DBG_PDFULLLSB_ADDRESS   	( BBH_TX_2_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDFULLLSB_OFFSET )
#define BBH_TX_2_EPON_DBG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_2_EPON_DBG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_2_EPON_DBG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_DBG_PDFULLLSB_ADDRESS ), (v) )

#define BBH_TX_3_EPON_DBG_PDFULLLSB_ADDRESS   	( BBH_TX_3_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDFULLLSB_OFFSET )
#define BBH_TX_3_EPON_DBG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_3_EPON_DBG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_3_EPON_DBG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_DBG_PDFULLLSB_ADDRESS ), (v) )

#define BBH_TX_4_EPON_DBG_PDFULLLSB_ADDRESS   	( BBH_TX_4_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDFULLLSB_OFFSET )
#define BBH_TX_4_EPON_DBG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_4_EPON_DBG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_4_EPON_DBG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_DBG_PDFULLLSB_ADDRESS ), (v) )

#define BBH_TX_5_EPON_DBG_PDFULLLSB_ADDRESS   	( BBH_TX_5_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDFULLLSB_OFFSET )
#define BBH_TX_5_EPON_DBG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_5_EPON_DBG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_5_EPON_DBG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_DBG_PDFULLLSB_ADDRESS ), (v) )

#define BBH_TX_6_EPON_DBG_PDFULLLSB_ADDRESS   	( BBH_TX_6_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDFULLLSB_OFFSET )
#define BBH_TX_6_EPON_DBG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_6_EPON_DBG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_6_EPON_DBG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_DBG_PDFULLLSB_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_DBG_PDFULLLSB_ARRAY [ ] ;

#define BBH_TX_EPON_DBG_PDFULLLSB_WRITE( i, v )	WRITE_32( BBH_TX_EPON_DBG_PDFULLLSB_ARRAY [ i ], (v) )
#define BBH_TX_EPON_DBG_PDFULLLSB_READ( i, r ) 	READ_32( BBH_TX_EPON_DBG_PDFULLLSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PD_full */
	uint32_t pdfull	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_PDFULLLSB ;
#else
typedef struct
{	uint32_t pdfull	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_full */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_PDFULLLSB ;
#endif

/*****************************************************************************************/
/* PD_empty_LSB                                                                          */
/* Empty indication of the PD FIFOs.                                                     */
/*****************************************************************************************/

#define BBH_TX_EPON_DBG_PDEMPTYLSB_PDEMPTY_DEFAULT_VALUE             ( 0xFFFFFFFF )
#define BBH_TX_EPON_DBG_PDEMPTYLSB_PDEMPTY_DEFAULT_VALUE_RESET_VALUE ( 0xFFFFFFFF )


#define BBH_TX_EPON_DBG_PDEMPTYLSB_OFFSET ( 0x00000028 )

#define BBH_TX_0_EPON_DBG_PDEMPTYLSB_ADDRESS   	( BBH_TX_0_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEMPTYLSB_OFFSET )
#define BBH_TX_0_EPON_DBG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_0_EPON_DBG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_0_EPON_DBG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_DBG_PDEMPTYLSB_ADDRESS ), (v) )

#define BBH_TX_1_EPON_DBG_PDEMPTYLSB_ADDRESS   	( BBH_TX_1_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEMPTYLSB_OFFSET )
#define BBH_TX_1_EPON_DBG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_1_EPON_DBG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_1_EPON_DBG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_DBG_PDEMPTYLSB_ADDRESS ), (v) )

#define BBH_TX_2_EPON_DBG_PDEMPTYLSB_ADDRESS   	( BBH_TX_2_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEMPTYLSB_OFFSET )
#define BBH_TX_2_EPON_DBG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_2_EPON_DBG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_2_EPON_DBG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_DBG_PDEMPTYLSB_ADDRESS ), (v) )

#define BBH_TX_3_EPON_DBG_PDEMPTYLSB_ADDRESS   	( BBH_TX_3_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEMPTYLSB_OFFSET )
#define BBH_TX_3_EPON_DBG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_3_EPON_DBG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_3_EPON_DBG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_DBG_PDEMPTYLSB_ADDRESS ), (v) )

#define BBH_TX_4_EPON_DBG_PDEMPTYLSB_ADDRESS   	( BBH_TX_4_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEMPTYLSB_OFFSET )
#define BBH_TX_4_EPON_DBG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_4_EPON_DBG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_4_EPON_DBG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_DBG_PDEMPTYLSB_ADDRESS ), (v) )

#define BBH_TX_5_EPON_DBG_PDEMPTYLSB_ADDRESS   	( BBH_TX_5_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEMPTYLSB_OFFSET )
#define BBH_TX_5_EPON_DBG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_5_EPON_DBG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_5_EPON_DBG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_DBG_PDEMPTYLSB_ADDRESS ), (v) )

#define BBH_TX_6_EPON_DBG_PDEMPTYLSB_ADDRESS   	( BBH_TX_6_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEMPTYLSB_OFFSET )
#define BBH_TX_6_EPON_DBG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_6_EPON_DBG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_6_EPON_DBG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_DBG_PDEMPTYLSB_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_DBG_PDEMPTYLSB_ARRAY [ ] ;

#define BBH_TX_EPON_DBG_PDEMPTYLSB_WRITE( i, v )	WRITE_32( BBH_TX_EPON_DBG_PDEMPTYLSB_ARRAY [ i ], (v) )
#define BBH_TX_EPON_DBG_PDEMPTYLSB_READ( i, r ) 	READ_32( BBH_TX_EPON_DBG_PDEMPTYLSB_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PD_empty */
	uint32_t pdempty	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_PDEMPTYLSB ;
#else
typedef struct
{	uint32_t pdempty	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_empty */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_PDEMPTYLSB ;
#endif

/*****************************************************************************************/
/* EPON_PD_VALID                                                                         */
/* The BBH manages 32 queues. For each queue it manages a PD FIFO.   A total of 256 PDs  */
/* are available for all queue.  The SW may read these PDs.  The PD valid register indic */
/* ates whether the relevant PD is valid.  The first register refers to PDs 0-31.  The s */
/* econd register refers to PDs 32-63 and so on.                                         */
/*****************************************************************************************/

#define BBH_TX_EPON_DBG_PDVALID_VALID_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_EPON_DBG_PDVALID_VALID_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_EPON_DBG_PDVALID_OFFSET ( 0x000000D0 )

#define BBH_TX_0_EPON_DBG_PDVALID_ADDRESS        	( BBH_TX_0_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDVALID_OFFSET )
#define BBH_TX_0_EPON_DBG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_EPON_DBG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_0_EPON_DBG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_EPON_DBG_PDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_1_EPON_DBG_PDVALID_ADDRESS        	( BBH_TX_1_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDVALID_OFFSET )
#define BBH_TX_1_EPON_DBG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_EPON_DBG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_1_EPON_DBG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_EPON_DBG_PDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_2_EPON_DBG_PDVALID_ADDRESS        	( BBH_TX_2_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDVALID_OFFSET )
#define BBH_TX_2_EPON_DBG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_EPON_DBG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_2_EPON_DBG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_EPON_DBG_PDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_3_EPON_DBG_PDVALID_ADDRESS        	( BBH_TX_3_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDVALID_OFFSET )
#define BBH_TX_3_EPON_DBG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_EPON_DBG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_3_EPON_DBG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_EPON_DBG_PDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_4_EPON_DBG_PDVALID_ADDRESS        	( BBH_TX_4_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDVALID_OFFSET )
#define BBH_TX_4_EPON_DBG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_EPON_DBG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_4_EPON_DBG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_EPON_DBG_PDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_5_EPON_DBG_PDVALID_ADDRESS        	( BBH_TX_5_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDVALID_OFFSET )
#define BBH_TX_5_EPON_DBG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_EPON_DBG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_5_EPON_DBG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_EPON_DBG_PDVALID_ADDRESS ), (i), (v) )

#define BBH_TX_6_EPON_DBG_PDVALID_ADDRESS        	( BBH_TX_6_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDVALID_OFFSET )
#define BBH_TX_6_EPON_DBG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_EPON_DBG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_6_EPON_DBG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_EPON_DBG_PDVALID_ADDRESS ), (i), (v) )


extern uint32_t BBH_TX_EPON_DBG_PDVALID_ARRAY [ ] ;

#define BBH_TX_EPON_DBG_PDVALID_WRITE( i, k, v )	WRITE_I_32( BBH_TX_EPON_DBG_PDVALID_ARRAY [ i ], (k), (v) )
#define BBH_TX_EPON_DBG_PDVALID_READ( i, k, r ) 	READ_I_32( BBH_TX_EPON_DBG_PDVALID_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* valid */
	uint32_t valid	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_PDVALID ;
#else
typedef struct
{	uint32_t valid	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* valid */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_PDVALID ;
#endif

/*****************************************************************************************/
/* REQ_length_error_counter                                                              */
/* This counter counts the number of times a length error (mismatch between a request fr */
/* om the MAC and a PD from the Runner) occured.  This counter is cleared when read and  */
/* freezes when maximum value is reached.                                                */
/*****************************************************************************************/

#define BBH_TX_EPON_DBG_LENERR_R1_DEFAULT_VALUE                 ( 0x0 )
#define BBH_TX_EPON_DBG_LENERR_R1_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define BBH_TX_EPON_DBG_LENERR_LENERR_LEN_ERR_VALUE             ( 0x0 )
#define BBH_TX_EPON_DBG_LENERR_LENERR_LEN_ERR_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_EPON_DBG_LENERR_OFFSET ( 0x000000F0 )

#define BBH_TX_0_EPON_DBG_LENERR_ADDRESS   	( BBH_TX_0_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_LENERR_OFFSET )
#define BBH_TX_0_EPON_DBG_LENERR_READ( r ) 	READ_32( ( BBH_TX_0_EPON_DBG_LENERR_ADDRESS ), (r) )
#define BBH_TX_0_EPON_DBG_LENERR_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_DBG_LENERR_ADDRESS ), (v) )

#define BBH_TX_1_EPON_DBG_LENERR_ADDRESS   	( BBH_TX_1_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_LENERR_OFFSET )
#define BBH_TX_1_EPON_DBG_LENERR_READ( r ) 	READ_32( ( BBH_TX_1_EPON_DBG_LENERR_ADDRESS ), (r) )
#define BBH_TX_1_EPON_DBG_LENERR_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_DBG_LENERR_ADDRESS ), (v) )

#define BBH_TX_2_EPON_DBG_LENERR_ADDRESS   	( BBH_TX_2_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_LENERR_OFFSET )
#define BBH_TX_2_EPON_DBG_LENERR_READ( r ) 	READ_32( ( BBH_TX_2_EPON_DBG_LENERR_ADDRESS ), (r) )
#define BBH_TX_2_EPON_DBG_LENERR_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_DBG_LENERR_ADDRESS ), (v) )

#define BBH_TX_3_EPON_DBG_LENERR_ADDRESS   	( BBH_TX_3_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_LENERR_OFFSET )
#define BBH_TX_3_EPON_DBG_LENERR_READ( r ) 	READ_32( ( BBH_TX_3_EPON_DBG_LENERR_ADDRESS ), (r) )
#define BBH_TX_3_EPON_DBG_LENERR_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_DBG_LENERR_ADDRESS ), (v) )

#define BBH_TX_4_EPON_DBG_LENERR_ADDRESS   	( BBH_TX_4_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_LENERR_OFFSET )
#define BBH_TX_4_EPON_DBG_LENERR_READ( r ) 	READ_32( ( BBH_TX_4_EPON_DBG_LENERR_ADDRESS ), (r) )
#define BBH_TX_4_EPON_DBG_LENERR_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_DBG_LENERR_ADDRESS ), (v) )

#define BBH_TX_5_EPON_DBG_LENERR_ADDRESS   	( BBH_TX_5_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_LENERR_OFFSET )
#define BBH_TX_5_EPON_DBG_LENERR_READ( r ) 	READ_32( ( BBH_TX_5_EPON_DBG_LENERR_ADDRESS ), (r) )
#define BBH_TX_5_EPON_DBG_LENERR_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_DBG_LENERR_ADDRESS ), (v) )

#define BBH_TX_6_EPON_DBG_LENERR_ADDRESS   	( BBH_TX_6_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_LENERR_OFFSET )
#define BBH_TX_6_EPON_DBG_LENERR_READ( r ) 	READ_32( ( BBH_TX_6_EPON_DBG_LENERR_ADDRESS ), (r) )
#define BBH_TX_6_EPON_DBG_LENERR_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_DBG_LENERR_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_DBG_LENERR_ARRAY [ ] ;

#define BBH_TX_EPON_DBG_LENERR_WRITE( i, v )	WRITE_32( BBH_TX_EPON_DBG_LENERR_ARRAY [ i ], (v) )
#define BBH_TX_EPON_DBG_LENERR_READ( i, r ) 	READ_32( BBH_TX_EPON_DBG_LENERR_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1    	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LEN_ERR */
	uint32_t lenerr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_LENERR ;
#else
typedef struct
{	uint32_t lenerr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LEN_ERR */
	uint32_t r1    	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_LENERR ;
#endif

/*****************************************************************************************/
/* Flushed_packets_counter                                                               */
/* This counter counts the number of packets that were flushed (bn was released without  */
/* sending the data to the EPON MAC) due to flush request.  The counter is global for al */
/* l queues.  The counter is read clear.                                                 */
/*****************************************************************************************/

#define BBH_TX_EPON_DBG_FLUSHPKTS_R1_DEFAULT_VALUE                     ( 0x0 )
#define BBH_TX_EPON_DBG_FLUSHPKTS_R1_DEFAULT_VALUE_RESET_VALUE         ( 0x0 )
#define BBH_TX_EPON_DBG_FLUSHPKTS_FLSHPKTS_FLSH_PKTS_VALUE             ( 0x0 )
#define BBH_TX_EPON_DBG_FLUSHPKTS_FLSHPKTS_FLSH_PKTS_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_EPON_DBG_FLUSHPKTS_OFFSET ( 0x000000F4 )

#define BBH_TX_0_EPON_DBG_FLUSHPKTS_ADDRESS   	( BBH_TX_0_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_FLUSHPKTS_OFFSET )
#define BBH_TX_0_EPON_DBG_FLUSHPKTS_READ( r ) 	READ_32( ( BBH_TX_0_EPON_DBG_FLUSHPKTS_ADDRESS ), (r) )
#define BBH_TX_0_EPON_DBG_FLUSHPKTS_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_DBG_FLUSHPKTS_ADDRESS ), (v) )

#define BBH_TX_1_EPON_DBG_FLUSHPKTS_ADDRESS   	( BBH_TX_1_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_FLUSHPKTS_OFFSET )
#define BBH_TX_1_EPON_DBG_FLUSHPKTS_READ( r ) 	READ_32( ( BBH_TX_1_EPON_DBG_FLUSHPKTS_ADDRESS ), (r) )
#define BBH_TX_1_EPON_DBG_FLUSHPKTS_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_DBG_FLUSHPKTS_ADDRESS ), (v) )

#define BBH_TX_2_EPON_DBG_FLUSHPKTS_ADDRESS   	( BBH_TX_2_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_FLUSHPKTS_OFFSET )
#define BBH_TX_2_EPON_DBG_FLUSHPKTS_READ( r ) 	READ_32( ( BBH_TX_2_EPON_DBG_FLUSHPKTS_ADDRESS ), (r) )
#define BBH_TX_2_EPON_DBG_FLUSHPKTS_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_DBG_FLUSHPKTS_ADDRESS ), (v) )

#define BBH_TX_3_EPON_DBG_FLUSHPKTS_ADDRESS   	( BBH_TX_3_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_FLUSHPKTS_OFFSET )
#define BBH_TX_3_EPON_DBG_FLUSHPKTS_READ( r ) 	READ_32( ( BBH_TX_3_EPON_DBG_FLUSHPKTS_ADDRESS ), (r) )
#define BBH_TX_3_EPON_DBG_FLUSHPKTS_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_DBG_FLUSHPKTS_ADDRESS ), (v) )

#define BBH_TX_4_EPON_DBG_FLUSHPKTS_ADDRESS   	( BBH_TX_4_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_FLUSHPKTS_OFFSET )
#define BBH_TX_4_EPON_DBG_FLUSHPKTS_READ( r ) 	READ_32( ( BBH_TX_4_EPON_DBG_FLUSHPKTS_ADDRESS ), (r) )
#define BBH_TX_4_EPON_DBG_FLUSHPKTS_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_DBG_FLUSHPKTS_ADDRESS ), (v) )

#define BBH_TX_5_EPON_DBG_FLUSHPKTS_ADDRESS   	( BBH_TX_5_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_FLUSHPKTS_OFFSET )
#define BBH_TX_5_EPON_DBG_FLUSHPKTS_READ( r ) 	READ_32( ( BBH_TX_5_EPON_DBG_FLUSHPKTS_ADDRESS ), (r) )
#define BBH_TX_5_EPON_DBG_FLUSHPKTS_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_DBG_FLUSHPKTS_ADDRESS ), (v) )

#define BBH_TX_6_EPON_DBG_FLUSHPKTS_ADDRESS   	( BBH_TX_6_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_FLUSHPKTS_OFFSET )
#define BBH_TX_6_EPON_DBG_FLUSHPKTS_READ( r ) 	READ_32( ( BBH_TX_6_EPON_DBG_FLUSHPKTS_ADDRESS ), (r) )
#define BBH_TX_6_EPON_DBG_FLUSHPKTS_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_DBG_FLUSHPKTS_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_DBG_FLUSHPKTS_ARRAY [ ] ;

#define BBH_TX_EPON_DBG_FLUSHPKTS_WRITE( i, v )	WRITE_32( BBH_TX_EPON_DBG_FLUSHPKTS_ARRAY [ i ], (v) )
#define BBH_TX_EPON_DBG_FLUSHPKTS_READ( i, r ) 	READ_32( BBH_TX_EPON_DBG_FLUSHPKTS_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1      	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FLSH_PKTS */
	uint32_t flshpkts	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_FLUSHPKTS ;
#else
typedef struct
{	uint32_t flshpkts	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FLSH_PKTS */
	uint32_t r1      	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_FLUSHPKTS ;
#endif

/*****************************************************************************************/
/* REQ_FIFO_address                                                                      */
/* Address in REQ FIFO for SW read. Total number of entries in the FIFO is 8.            */
/*****************************************************************************************/

#define BBH_TX_EPON_DBG_REQFIFOADD_R1_DEFAULT_VALUE               ( 0x0 )
#define BBH_TX_EPON_DBG_REQFIFOADD_R1_DEFAULT_VALUE_RESET_VALUE   ( 0x0 )
#define BBH_TX_EPON_DBG_REQFIFOADD_ADRS_ADDRESS_VALUE             ( 0x0 )
#define BBH_TX_EPON_DBG_REQFIFOADD_ADRS_ADDRESS_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_EPON_DBG_REQFIFOADD_OFFSET ( 0x00000100 )

#define BBH_TX_0_EPON_DBG_REQFIFOADD_ADDRESS   	( BBH_TX_0_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFOADD_OFFSET )
#define BBH_TX_0_EPON_DBG_REQFIFOADD_READ( r ) 	READ_32( ( BBH_TX_0_EPON_DBG_REQFIFOADD_ADDRESS ), (r) )
#define BBH_TX_0_EPON_DBG_REQFIFOADD_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_DBG_REQFIFOADD_ADDRESS ), (v) )

#define BBH_TX_1_EPON_DBG_REQFIFOADD_ADDRESS   	( BBH_TX_1_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFOADD_OFFSET )
#define BBH_TX_1_EPON_DBG_REQFIFOADD_READ( r ) 	READ_32( ( BBH_TX_1_EPON_DBG_REQFIFOADD_ADDRESS ), (r) )
#define BBH_TX_1_EPON_DBG_REQFIFOADD_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_DBG_REQFIFOADD_ADDRESS ), (v) )

#define BBH_TX_2_EPON_DBG_REQFIFOADD_ADDRESS   	( BBH_TX_2_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFOADD_OFFSET )
#define BBH_TX_2_EPON_DBG_REQFIFOADD_READ( r ) 	READ_32( ( BBH_TX_2_EPON_DBG_REQFIFOADD_ADDRESS ), (r) )
#define BBH_TX_2_EPON_DBG_REQFIFOADD_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_DBG_REQFIFOADD_ADDRESS ), (v) )

#define BBH_TX_3_EPON_DBG_REQFIFOADD_ADDRESS   	( BBH_TX_3_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFOADD_OFFSET )
#define BBH_TX_3_EPON_DBG_REQFIFOADD_READ( r ) 	READ_32( ( BBH_TX_3_EPON_DBG_REQFIFOADD_ADDRESS ), (r) )
#define BBH_TX_3_EPON_DBG_REQFIFOADD_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_DBG_REQFIFOADD_ADDRESS ), (v) )

#define BBH_TX_4_EPON_DBG_REQFIFOADD_ADDRESS   	( BBH_TX_4_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFOADD_OFFSET )
#define BBH_TX_4_EPON_DBG_REQFIFOADD_READ( r ) 	READ_32( ( BBH_TX_4_EPON_DBG_REQFIFOADD_ADDRESS ), (r) )
#define BBH_TX_4_EPON_DBG_REQFIFOADD_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_DBG_REQFIFOADD_ADDRESS ), (v) )

#define BBH_TX_5_EPON_DBG_REQFIFOADD_ADDRESS   	( BBH_TX_5_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFOADD_OFFSET )
#define BBH_TX_5_EPON_DBG_REQFIFOADD_READ( r ) 	READ_32( ( BBH_TX_5_EPON_DBG_REQFIFOADD_ADDRESS ), (r) )
#define BBH_TX_5_EPON_DBG_REQFIFOADD_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_DBG_REQFIFOADD_ADDRESS ), (v) )

#define BBH_TX_6_EPON_DBG_REQFIFOADD_ADDRESS   	( BBH_TX_6_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFOADD_OFFSET )
#define BBH_TX_6_EPON_DBG_REQFIFOADD_READ( r ) 	READ_32( ( BBH_TX_6_EPON_DBG_REQFIFOADD_ADDRESS ), (r) )
#define BBH_TX_6_EPON_DBG_REQFIFOADD_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_DBG_REQFIFOADD_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_DBG_REQFIFOADD_ARRAY [ ] ;

#define BBH_TX_EPON_DBG_REQFIFOADD_WRITE( i, v )	WRITE_32( BBH_TX_EPON_DBG_REQFIFOADD_ARRAY [ i ], (v) )
#define BBH_TX_EPON_DBG_REQFIFOADD_READ( i, r ) 	READ_32( BBH_TX_EPON_DBG_REQFIFOADD_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1  	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Address */
	uint32_t adrs	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_REQFIFOADD ;
#else
typedef struct
{	uint32_t adrs	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Address */
	uint32_t r1  	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_REQFIFOADD ;
#endif

/*****************************************************************************************/
/* REQ_FIFO_data                                                                         */
/* Read data from the REQ FIFO                                                           */
/*****************************************************************************************/

#define BBH_TX_EPON_DBG_REQFIFODATA_R1_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_EPON_DBG_REQFIFODATA_R1_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define BBH_TX_EPON_DBG_REQFIFODATA_FLUSH_Q_VALUE                ( 0x0 )
#define BBH_TX_EPON_DBG_REQFIFODATA_FLUSH_Q_VALUE_RESET_VALUE    ( 0x0 )
#define BBH_TX_EPON_DBG_REQFIFODATA_LEN_Q_VALUE                  ( 0x0 )
#define BBH_TX_EPON_DBG_REQFIFODATA_LEN_Q_VALUE_RESET_VALUE      ( 0x0 )
#define BBH_TX_EPON_DBG_REQFIFODATA_Q_Q_VALUE                    ( 0x0 )
#define BBH_TX_EPON_DBG_REQFIFODATA_Q_Q_VALUE_RESET_VALUE        ( 0x0 )


#define BBH_TX_EPON_DBG_REQFIFODATA_OFFSET ( 0x00000104 )

#define BBH_TX_0_EPON_DBG_REQFIFODATA_ADDRESS   	( BBH_TX_0_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFODATA_OFFSET )
#define BBH_TX_0_EPON_DBG_REQFIFODATA_READ( r ) 	READ_32( ( BBH_TX_0_EPON_DBG_REQFIFODATA_ADDRESS ), (r) )
#define BBH_TX_0_EPON_DBG_REQFIFODATA_WRITE( v )	WRITE_32( ( BBH_TX_0_EPON_DBG_REQFIFODATA_ADDRESS ), (v) )

#define BBH_TX_1_EPON_DBG_REQFIFODATA_ADDRESS   	( BBH_TX_1_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFODATA_OFFSET )
#define BBH_TX_1_EPON_DBG_REQFIFODATA_READ( r ) 	READ_32( ( BBH_TX_1_EPON_DBG_REQFIFODATA_ADDRESS ), (r) )
#define BBH_TX_1_EPON_DBG_REQFIFODATA_WRITE( v )	WRITE_32( ( BBH_TX_1_EPON_DBG_REQFIFODATA_ADDRESS ), (v) )

#define BBH_TX_2_EPON_DBG_REQFIFODATA_ADDRESS   	( BBH_TX_2_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFODATA_OFFSET )
#define BBH_TX_2_EPON_DBG_REQFIFODATA_READ( r ) 	READ_32( ( BBH_TX_2_EPON_DBG_REQFIFODATA_ADDRESS ), (r) )
#define BBH_TX_2_EPON_DBG_REQFIFODATA_WRITE( v )	WRITE_32( ( BBH_TX_2_EPON_DBG_REQFIFODATA_ADDRESS ), (v) )

#define BBH_TX_3_EPON_DBG_REQFIFODATA_ADDRESS   	( BBH_TX_3_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFODATA_OFFSET )
#define BBH_TX_3_EPON_DBG_REQFIFODATA_READ( r ) 	READ_32( ( BBH_TX_3_EPON_DBG_REQFIFODATA_ADDRESS ), (r) )
#define BBH_TX_3_EPON_DBG_REQFIFODATA_WRITE( v )	WRITE_32( ( BBH_TX_3_EPON_DBG_REQFIFODATA_ADDRESS ), (v) )

#define BBH_TX_4_EPON_DBG_REQFIFODATA_ADDRESS   	( BBH_TX_4_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFODATA_OFFSET )
#define BBH_TX_4_EPON_DBG_REQFIFODATA_READ( r ) 	READ_32( ( BBH_TX_4_EPON_DBG_REQFIFODATA_ADDRESS ), (r) )
#define BBH_TX_4_EPON_DBG_REQFIFODATA_WRITE( v )	WRITE_32( ( BBH_TX_4_EPON_DBG_REQFIFODATA_ADDRESS ), (v) )

#define BBH_TX_5_EPON_DBG_REQFIFODATA_ADDRESS   	( BBH_TX_5_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFODATA_OFFSET )
#define BBH_TX_5_EPON_DBG_REQFIFODATA_READ( r ) 	READ_32( ( BBH_TX_5_EPON_DBG_REQFIFODATA_ADDRESS ), (r) )
#define BBH_TX_5_EPON_DBG_REQFIFODATA_WRITE( v )	WRITE_32( ( BBH_TX_5_EPON_DBG_REQFIFODATA_ADDRESS ), (v) )

#define BBH_TX_6_EPON_DBG_REQFIFODATA_ADDRESS   	( BBH_TX_6_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFODATA_OFFSET )
#define BBH_TX_6_EPON_DBG_REQFIFODATA_READ( r ) 	READ_32( ( BBH_TX_6_EPON_DBG_REQFIFODATA_ADDRESS ), (r) )
#define BBH_TX_6_EPON_DBG_REQFIFODATA_WRITE( v )	WRITE_32( ( BBH_TX_6_EPON_DBG_REQFIFODATA_ADDRESS ), (v) )


extern uint32_t BBH_TX_EPON_DBG_REQFIFODATA_ARRAY [ ] ;

#define BBH_TX_EPON_DBG_REQFIFODATA_WRITE( i, v )	WRITE_32( BBH_TX_EPON_DBG_REQFIFODATA_ARRAY [ i ], (v) )
#define BBH_TX_EPON_DBG_REQFIFODATA_READ( i, r ) 	READ_32( BBH_TX_EPON_DBG_REQFIFODATA_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Req_flush */
	uint32_t flush	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Req_length */
	uint32_t len  	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Req_Q */
	uint32_t q    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_REQFIFODATA ;
#else
typedef struct
{	uint32_t q    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Req_Q */
	uint32_t len  	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Req_length */
	uint32_t flush	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Req_flush */
	uint32_t r1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG_REQFIFODATA ;
#endif

/*****************************************************************************************/
/* PD_FIFO                                                                               */
/* The SW may read the PD RAM.  This RAM includes a total of 256 PDs.  A special registe */
/* r marks the valid PDs.  Each PD occupies 2 addresses of 32 bits - the odd address ref */
/* ers to the LSB word of the entry.  Please refer to BBH LLD for the context of the PD. */
/*****************************************************************************************/

#define BBH_TX_EPON_STS_FIFO_PDFIFO_PDENTRY_DEFAULT_VALUE             ( 0x0 )
#define BBH_TX_EPON_STS_FIFO_PDFIFO_PDENTRY_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define BBH_TX_EPON_STS_FIFO_PDFIFO_OFFSET ( 0x00000000 )

#define BBH_TX_0_EPON_STS_FIFO_PDFIFO_ADDRESS        	( BBH_TX_0_EPON_STS_FIFO_ADDRESS + BBH_TX_EPON_STS_FIFO_PDFIFO_OFFSET )
#define BBH_TX_0_EPON_STS_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_0_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_0_EPON_STS_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_0_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_1_EPON_STS_FIFO_PDFIFO_ADDRESS        	( BBH_TX_1_EPON_STS_FIFO_ADDRESS + BBH_TX_EPON_STS_FIFO_PDFIFO_OFFSET )
#define BBH_TX_1_EPON_STS_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_1_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_1_EPON_STS_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_1_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_2_EPON_STS_FIFO_PDFIFO_ADDRESS        	( BBH_TX_2_EPON_STS_FIFO_ADDRESS + BBH_TX_EPON_STS_FIFO_PDFIFO_OFFSET )
#define BBH_TX_2_EPON_STS_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_2_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_2_EPON_STS_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_2_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_3_EPON_STS_FIFO_PDFIFO_ADDRESS        	( BBH_TX_3_EPON_STS_FIFO_ADDRESS + BBH_TX_EPON_STS_FIFO_PDFIFO_OFFSET )
#define BBH_TX_3_EPON_STS_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_3_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_3_EPON_STS_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_3_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_4_EPON_STS_FIFO_PDFIFO_ADDRESS        	( BBH_TX_4_EPON_STS_FIFO_ADDRESS + BBH_TX_EPON_STS_FIFO_PDFIFO_OFFSET )
#define BBH_TX_4_EPON_STS_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_4_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_4_EPON_STS_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_4_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_5_EPON_STS_FIFO_PDFIFO_ADDRESS        	( BBH_TX_5_EPON_STS_FIFO_ADDRESS + BBH_TX_EPON_STS_FIFO_PDFIFO_OFFSET )
#define BBH_TX_5_EPON_STS_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_5_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_5_EPON_STS_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_5_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (v) )

#define BBH_TX_6_EPON_STS_FIFO_PDFIFO_ADDRESS        	( BBH_TX_6_EPON_STS_FIFO_ADDRESS + BBH_TX_EPON_STS_FIFO_PDFIFO_OFFSET )
#define BBH_TX_6_EPON_STS_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_6_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_6_EPON_STS_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_6_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (v) )



/* XXX: Temporary added for EPON bring-up manually, should be generated by Reggae automatically */

#define BBH_RX_7_GENERAL_CONFIGURATION_OFFSET 	( 0x00000000 )
#define BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS	( BBH_RX_7_OFFSET + BBH_RX_7_GENERAL_CONFIGURATION_OFFSET )
#define BBH_RX_7_PM_COUNTERS_OFFSET 	( 0x00000100 )
#define BBH_RX_7_PM_COUNTERS_ADDRESS	( BBH_RX_7_OFFSET + BBH_RX_7_PM_COUNTERS_OFFSET )
#define BBH_RX_7_DEBUG_OFFSET 	( 0x00000200 )
#define BBH_RX_7_DEBUG_ADDRESS	( BBH_RX_7_OFFSET + BBH_RX_7_DEBUG_OFFSET )
#define BBH_RX_7_PER_FLOW_PM_COUNTERS_OFFSET 	( 0x00000400 )
#define BBH_RX_7_PER_FLOW_PM_COUNTERS_ADDRESS	( BBH_RX_7_OFFSET + BBH_RX_7_PER_FLOW_PM_COUNTERS_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_OFFSET 	( 0x00000000 )
#define BBH_TX_7_CONFIGURATIONS_ADDRESS	( BBH_TX_7_OFFSET + BBH_TX_7_CONFIGURATIONS_OFFSET )
#define BBH_TX_7_DEBUG_OFFSET 	( 0x00000100 )
#define BBH_TX_7_DEBUG_ADDRESS	( BBH_TX_7_OFFSET + BBH_TX_7_DEBUG_OFFSET )
#define BBH_TX_7_PD_FIFO_OFFSET 	( 0x00000200 )
#define BBH_TX_7_PD_FIFO_ADDRESS	( BBH_TX_7_OFFSET + BBH_TX_7_PD_FIFO_OFFSET )
#define BBH_TX_7_CONTEXT_OFFSET 	( 0x00000600 )
#define BBH_TX_7_CONTEXT_ADDRESS	( BBH_TX_7_OFFSET + BBH_TX_7_CONTEXT_OFFSET )
#define BBH_TX_7_EPON_PD_FIFO_OFFSET 	( 0x00000700 )
#define BBH_TX_7_EPON_PD_FIFO_ADDRESS	( BBH_TX_7_OFFSET + BBH_TX_7_EPON_PD_FIFO_OFFSET )
#define BBH_TX_7_EPON_CFG_OFFSET 	( 0x00001000 )
#define BBH_TX_7_EPON_CFG_ADDRESS	( BBH_TX_7_OFFSET + BBH_TX_7_EPON_CFG_OFFSET )
#define BBH_TX_7_EPON_DBG_OFFSET 	( 0x00001100 )
#define BBH_TX_7_EPON_DBG_ADDRESS	( BBH_TX_7_OFFSET + BBH_TX_7_EPON_DBG_OFFSET )
#define BBH_TX_7_EPON_STS_FIFO_OFFSET 	( 0x00001700 )
#define BBH_TX_7_EPON_STS_FIFO_ADDRESS	( BBH_TX_7_OFFSET + BBH_TX_7_EPON_STS_FIFO_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_BBCFG_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_BBCFG_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_BBCFG_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_BBCFG_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_BBCFG1_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_BBCFG1_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_BBCFG1_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_BBCFG1_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_BBCFG1_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_DDRCFG_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DDRCFG_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_DDRCFG_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_DDRCFG_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_DDRCFG_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_PDBASE_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDBASE_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_PDBASE_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_PDBASE_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_PDBASE_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_PDSIZE_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PDSIZE_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_PDSIZE_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_PDSIZE_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_PDSIZE_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_RUNNERTASK_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_RUNNERTASK_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_RUNNERTASK_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_DMAADDR_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMAADDR_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_DMAADDR_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_DMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_DMAADDR_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_DMACFG_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_DMACFG_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_DMACFG_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_DMACFG_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_DMACFG_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMAADDR_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_SDMAADDR_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_SDMAADDR_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_SDMAADDR_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_SDMACFG_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_SDMACFG_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_SDMACFG_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_SDMACFG_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_SDMACFG_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MINPKT0_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKT0_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_MINPKT0_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MINPKT0_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MINPKT0_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT0_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_MAXPKT0_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MAXPKT0_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MAXPKT0_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKT1_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_MAXPKT1_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MAXPKT1_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MAXPKT1_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCFG_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCFG_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCFG_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCFG_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_IHCFG_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_FLOWCTRL_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_FLOWCTRL_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_FLOWCTRL_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_PERFLOWTH_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_PERFLOWTH_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_PERFLOWTH_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_PERFLOWSETS_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_PERFLOWSETS_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_PERFLOWSETS_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS0_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS0_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS0_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS0_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS1_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS1_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS1_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS1_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS2_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS2_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS2_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS2_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHCLASS3_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS3_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS3_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_IHCLASS3_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHOVERRIDE_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_IHOVERRIDE_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_IHOVERRIDE_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_MINPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MINPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MINPKTSEL0_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_MINPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MINPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MINPKTSEL1_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_MAXPKTSEL0_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MAXPKTSEL0_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MAXPKTSEL0_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_MAXPKTSEL1_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_MAXPKTSEL1_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_MAXPKTSEL1_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_PLOAMCFG_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_PLOAMCFG_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_PLOAMCFG_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXRSTRST_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_RXRSTRST_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_RXRSTRST_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_RXRSTRST_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_RXDBGSEL_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_RXDBGSEL_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_RXDBGSEL_ADDRESS ), (v) )
#define BBH_RX_7_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS   	( BBH_RX_7_GENERAL_CONFIGURATION_ADDRESS + BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_OFFSET )
#define BBH_RX_7_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_READ( r ) 	READ_32( ( BBH_RX_7_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (r) )
#define BBH_RX_7_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_WRITE( v )	WRITE_32( ( BBH_RX_7_GENERAL_CONFIGURATION_REASSEMBLYOFFSET_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_SOPASOP_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_SOPASOP_OFFSET )
#define BBH_RX_7_PM_COUNTERS_SOPASOP_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_SOPASOP_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_SOPASOP_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_SOPASOP_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_THIRDFLOW_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_THIRDFLOW_OFFSET )
#define BBH_RX_7_PM_COUNTERS_THIRDFLOW_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_THIRDFLOW_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_THIRDFLOW_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_THIRDFLOW_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_INPKT_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_INPKT_OFFSET )
#define BBH_RX_7_PM_COUNTERS_INPKT_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_INPKT_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_INPKT_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_INPKT_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_TOOSHORT_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOSHORT_OFFSET )
#define BBH_RX_7_PM_COUNTERS_TOOSHORT_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_TOOSHORT_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_TOOSHORT_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_TOOSHORT_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_TOOLONG_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_TOOLONG_OFFSET )
#define BBH_RX_7_PM_COUNTERS_TOOLONG_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_TOOLONG_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_TOOLONG_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_TOOLONG_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_CRCERROR_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERROR_OFFSET )
#define BBH_RX_7_PM_COUNTERS_CRCERROR_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_CRCERROR_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_CRCERROR_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_CRCERROR_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_IPTV_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IPTV_OFFSET )
#define BBH_RX_7_PM_COUNTERS_IPTV_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_IPTV_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_IPTV_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_IPTV_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_RUNNERCONG_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_RUNNERCONG_OFFSET )
#define BBH_RX_7_PM_COUNTERS_RUNNERCONG_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_RUNNERCONG_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_RUNNERCONG_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_RUNNERCONG_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_NOBPMBN_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBN_OFFSET )
#define BBH_RX_7_PM_COUNTERS_NOBPMBN_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_NOBPMBN_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_NOBPMBN_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_NOBPMBN_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_NOSBPMSBN_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSBPMSBN_OFFSET )
#define BBH_RX_7_PM_COUNTERS_NOSBPMSBN_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_NOSBPMSBN_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_NOSBPMSBN_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_NODMACD_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NODMACD_OFFSET )
#define BBH_RX_7_PM_COUNTERS_NODMACD_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_NODMACD_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_NODMACD_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_NODMACD_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_NOSDMACD_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOSDMACD_OFFSET )
#define BBH_RX_7_PM_COUNTERS_NOSDMACD_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_NOSDMACD_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_NOSDMACD_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_NOSDMACD_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_IHDROPPLOAM_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_IHDROPPLOAM_OFFSET )
#define BBH_RX_7_PM_COUNTERS_IHDROPPLOAM_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_IHDROPPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_IHDROPPLOAM_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_NOBPMBNPLOAM_OFFSET )
#define BBH_RX_7_PM_COUNTERS_NOBPMBNPLOAM_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_NOBPMBNPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_NOBPMBNPLOAM_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_CRCERRORPLOAM_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_CRCERRORPLOAM_OFFSET )
#define BBH_RX_7_PM_COUNTERS_CRCERRORPLOAM_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_CRCERRORPLOAM_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_CRCERRORPLOAM_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_EPNFIFOVERUN_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPNFIFOVERUN_OFFSET )
#define BBH_RX_7_PM_COUNTERS_EPNFIFOVERUN_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_EPNFIFOVERUN_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_EPNFIFOVERUN_ADDRESS ), (v) )
#define BBH_RX_7_PM_COUNTERS_EPONTYPERROR_ADDRESS   	( BBH_RX_7_PM_COUNTERS_ADDRESS + BBH_RX_PM_COUNTERS_EPONTYPERROR_OFFSET )
#define BBH_RX_7_PM_COUNTERS_EPONTYPERROR_READ( r ) 	READ_32( ( BBH_RX_7_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (r) )
#define BBH_RX_7_PM_COUNTERS_EPONTYPERROR_WRITE( v )	WRITE_32( ( BBH_RX_7_PM_COUNTERS_EPONTYPERROR_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_CNTXTX0LSB_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0LSB_OFFSET )
#define BBH_RX_7_DEBUG_CNTXTX0LSB_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_CNTXTX0LSB_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_CNTXTX0LSB_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_CNTXTX0LSB_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_CNTXTX0MSB_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX0MSB_OFFSET )
#define BBH_RX_7_DEBUG_CNTXTX0MSB_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_CNTXTX0MSB_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_CNTXTX0MSB_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_CNTXTX0MSB_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_CNTXTX1LSB_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1LSB_OFFSET )
#define BBH_RX_7_DEBUG_CNTXTX1LSB_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_CNTXTX1LSB_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_CNTXTX1LSB_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_CNTXTX1LSB_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_CNTXTX1MSB_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_CNTXTX1MSB_OFFSET )
#define BBH_RX_7_DEBUG_CNTXTX1MSB_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_CNTXTX1MSB_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_CNTXTX1MSB_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_CNTXTX1MSB_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_IHCNTXT0_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT0_OFFSET )
#define BBH_RX_7_DEBUG_IHCNTXT0_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_IHCNTXT0_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_IHCNTXT0_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_IHCNTXT0_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_IHCNTXT1_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXT1_OFFSET )
#define BBH_RX_7_DEBUG_IHCNTXT1_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_IHCNTXT1_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_IHCNTXT1_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_IHCNTXT1_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_IHCNTXTP_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_IHCNTXTP_OFFSET )
#define BBH_RX_7_DEBUG_IHCNTXTP_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_IHCNTXTP_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_IHCNTXTP_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_IHCNTXTP_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_IHFREEBUF_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_IHFREEBUF_OFFSET )
#define BBH_RX_7_DEBUG_IHFREEBUF_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_IHFREEBUF_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_IHFREEBUF_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_IHFREEBUF_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_PWUW_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_PWUW_OFFSET )
#define BBH_RX_7_DEBUG_PWUW_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_PWUW_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_PWUW_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_PWUW_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_ACKCNT_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_ACKCNT_OFFSET )
#define BBH_RX_7_DEBUG_ACKCNT_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_ACKCNT_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_ACKCNT_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_ACKCNT_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_RNRCNT_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_RNRCNT_OFFSET )
#define BBH_RX_7_DEBUG_RNRCNT_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_RNRCNT_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_RNRCNT_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_RNRCNT_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_DBGVEC_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_DBGVEC_OFFSET )
#define BBH_RX_7_DEBUG_DBGVEC_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_DBGVEC_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_DBGVEC_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_DBGVEC_ADDRESS ), (v) )
#define BBH_RX_7_DEBUG_BNFIFO_ADDRESS        	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_BNFIFO_OFFSET )
#define BBH_RX_7_DEBUG_BNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_7_DEBUG_BNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_7_DEBUG_BNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_7_DEBUG_BNFIFO_ADDRESS ), (i), (v) )
#define BBH_RX_7_DEBUG_SBNFIFO_ADDRESS        	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_SBNFIFO_OFFSET )
#define BBH_RX_7_DEBUG_SBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_7_DEBUG_SBNFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_7_DEBUG_SBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_7_DEBUG_SBNFIFO_ADDRESS ), (i), (v) )
#define BBH_RX_7_DEBUG_RESFIFO_ADDRESS        	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_RESFIFO_OFFSET )
#define BBH_RX_7_DEBUG_RESFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_RX_7_DEBUG_RESFIFO_ADDRESS ), (i), (r) )
#define BBH_RX_7_DEBUG_RESFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_7_DEBUG_RESFIFO_ADDRESS ), (i), (v) )
#define BBH_RX_7_DEBUG_ESUW_ADDRESS   	( BBH_RX_7_DEBUG_ADDRESS + BBH_RX_DEBUG_ESUW_OFFSET )
#define BBH_RX_7_DEBUG_ESUW_READ( r ) 	READ_32( ( BBH_RX_7_DEBUG_ESUW_ADDRESS ), (r) )
#define BBH_RX_7_DEBUG_ESUW_WRITE( v )	WRITE_32( ( BBH_RX_7_DEBUG_ESUW_ADDRESS ), (v) )
#define BBH_RX_7_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS        	( BBH_RX_7_PER_FLOW_PM_COUNTERS_ADDRESS + BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_OFFSET )
#define BBH_RX_7_PER_FLOW_PM_COUNTERS_PERFLOWPM_READ_I( r, i ) 	READ_I_32( ( BBH_RX_7_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (r) )
#define BBH_RX_7_PER_FLOW_PM_COUNTERS_PERFLOWPM_WRITE_I( v, i )	WRITE_I_32( ( BBH_RX_7_PER_FLOW_PM_COUNTERS_PERFLOWPM_ADDRESS ), (i), (v) )
#define BBH_TX_7_CONFIGURATIONS_BBCFG_TX_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG_TX_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_BBCFG_TX_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_BBCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_BBCFG_TX_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_BBCFG1_TX_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_BBCFG1_TX_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_BBCFG1_TX_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_BBCFG1_TX_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_BBCFG1_TX_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_DDRCFG_TX_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRCFG_TX_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_DDRCFG_TX_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_DDRCFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_DDRCFG_TX_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_HNBASE_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_HNBASE_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_HNBASE_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_HNBASE_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_HNBASE_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_HNBASE_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_TASKLSB_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKLSB_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_TASKLSB_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_TASKMSB_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASKMSB_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_TASKMSB_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_TASK8_39_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TASK8_39_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_TASK8_39_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_PDSIZE0_7_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE0_7_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_PDSIZE0_7_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_PDSIZE0_7_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_PDSIZE0_7_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_PDSIZE8_39_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDSIZE8_39_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_PDSIZE8_39_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_PDSIZE8_39_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_PDSIZE8_39_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_PDBASE0_3_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE0_3_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_PDBASE0_3_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_PDBASE4_7_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE4_7_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_PDBASE4_7_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_PDBASE8_39_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDBASE8_39_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_PDBASE8_39_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_PD_BYTE_TH_EN_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_PD_BYTE_TH_ADDRESS        	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PD_BYTE_TH_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_7_CONFIGURATIONS_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_CONFIGURATIONS_PD_BYTE_TH_ADDRESS ), (i), (v) )
#define BBH_TX_7_CONFIGURATIONS_DMACFG_TX_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DMACFG_TX_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_DMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_DMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_DMACFG_TX_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_SDMACFG_TX_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SDMACFG_TX_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_SDMACFG_TX_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_SDMACFG_TX_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_SDMACFG_TX_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_RUNNERCFG_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_RUNNERCFG_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_RUNNERCFG_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_MDUMODE_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MDUMODE_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_MDUMODE_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_DDRTMBASE_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DDRTMBASE_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_DDRTMBASE_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_DDRTMBASE_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_DDRTMBASE_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_DBGSEL_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_DBGSEL_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_DBGSEL_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_DBGSEL_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_DBGSEL_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_DBGSEL_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_TXRSTCMD_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_TXRSTCMD_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_TXRSTCMD_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_TXRSTCMD_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_TXRSTCMD_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_EMAC1588_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_EMAC1588_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_EMAC1588_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_EMAC1588_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_EMAC1588_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_EMAC1588_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_SBPMCFG_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_SBPMCFG_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_SBPMCFG_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_SBPMCFG_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_SBPMCFG_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_SBPMCFG_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_PDWKUPH0_7_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH0_7_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_PDWKUPH0_7_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_PDWKUPH0_7_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_PDWKUPH0_7_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_PDWKUPH8_31_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDWKUPH8_31_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_PDWKUPH8_31_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_PDEMPTY_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_PDEMPTY_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_PDEMPTY_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_ETHTT_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_ETHTT_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_ETHTT_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_ETHTT_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_ETHTT_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_ETHTT_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_MAXWLEN_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_MAXWLEN_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_MAXWLEN_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_MAXWLEN_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_MAXWLEN_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_MAXWLEN_ADDRESS ), (v) )
#define BBH_TX_7_CONFIGURATIONS_FLUSH_ADDRESS   	( BBH_TX_7_CONFIGURATIONS_ADDRESS + BBH_TX_CONFIGURATIONS_FLUSH_OFFSET )
#define BBH_TX_7_CONFIGURATIONS_FLUSH_READ( r ) 	READ_32( ( BBH_TX_7_CONFIGURATIONS_FLUSH_ADDRESS ), (r) )
#define BBH_TX_7_CONFIGURATIONS_FLUSH_WRITE( v )	WRITE_32( ( BBH_TX_7_CONFIGURATIONS_FLUSH_ADDRESS ), (v) )
#define BBH_TX_7_DEBUG_SRAMPD_ADDRESS   	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_SRAMPD_OFFSET )
#define BBH_TX_7_DEBUG_SRAMPD_READ( r ) 	READ_32( ( BBH_TX_7_DEBUG_SRAMPD_ADDRESS ), (r) )
#define BBH_TX_7_DEBUG_SRAMPD_WRITE( v )	WRITE_32( ( BBH_TX_7_DEBUG_SRAMPD_ADDRESS ), (v) )
#define BBH_TX_7_DEBUG_DDRPD_ADDRESS   	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_DDRPD_OFFSET )
#define BBH_TX_7_DEBUG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_7_DEBUG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_7_DEBUG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_7_DEBUG_DDRPD_ADDRESS ), (v) )
#define BBH_TX_7_DEBUG_PDDROP_ADDRESS   	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_PDDROP_OFFSET )
#define BBH_TX_7_DEBUG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_7_DEBUG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_7_DEBUG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_7_DEBUG_PDDROP_ADDRESS ), (v) )
#define BBH_TX_7_DEBUG_PDEQ0_ADDRESS   	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEQ0_OFFSET )
#define BBH_TX_7_DEBUG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_7_DEBUG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_7_DEBUG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_7_DEBUG_PDEQ0_ADDRESS ), (v) )
#define BBH_TX_7_DEBUG_GETNEXTNULL_ADDRESS   	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTNULL_OFFSET )
#define BBH_TX_7_DEBUG_GETNEXTNULL_READ( r ) 	READ_32( ( BBH_TX_7_DEBUG_GETNEXTNULL_ADDRESS ), (r) )
#define BBH_TX_7_DEBUG_GETNEXTNULL_WRITE( v )	WRITE_32( ( BBH_TX_7_DEBUG_GETNEXTNULL_ADDRESS ), (v) )
#define BBH_TX_7_DEBUG_PDFULLLSB_ADDRESS   	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLLSB_OFFSET )
#define BBH_TX_7_DEBUG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_7_DEBUG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_7_DEBUG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_7_DEBUG_PDFULLLSB_ADDRESS ), (v) )
#define BBH_TX_7_DEBUG_PDFULLMSB_ADDRESS   	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_PDFULLMSB_OFFSET )
#define BBH_TX_7_DEBUG_PDFULLMSB_READ( r ) 	READ_32( ( BBH_TX_7_DEBUG_PDFULLMSB_ADDRESS ), (r) )
#define BBH_TX_7_DEBUG_PDFULLMSB_WRITE( v )	WRITE_32( ( BBH_TX_7_DEBUG_PDFULLMSB_ADDRESS ), (v) )
#define BBH_TX_7_DEBUG_PDEMPTYLSB_ADDRESS   	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYLSB_OFFSET )
#define BBH_TX_7_DEBUG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_7_DEBUG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_7_DEBUG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_7_DEBUG_PDEMPTYLSB_ADDRESS ), (v) )
#define BBH_TX_7_DEBUG_PDEMPTYMSB_ADDRESS   	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_PDEMPTYMSB_OFFSET )
#define BBH_TX_7_DEBUG_PDEMPTYMSB_READ( r ) 	READ_32( ( BBH_TX_7_DEBUG_PDEMPTYMSB_ADDRESS ), (r) )
#define BBH_TX_7_DEBUG_PDEMPTYMSB_WRITE( v )	WRITE_32( ( BBH_TX_7_DEBUG_PDEMPTYMSB_ADDRESS ), (v) )
#define BBH_TX_7_DEBUG_PDVALID_ADDRESS        	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_PDVALID_OFFSET )
#define BBH_TX_7_DEBUG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_DEBUG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_7_DEBUG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_DEBUG_PDVALID_ADDRESS ), (i), (v) )
#define BBH_TX_7_DEBUG_BPMFIFO_ADDRESS        	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_BPMFIFO_OFFSET )
#define BBH_TX_7_DEBUG_BPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_DEBUG_BPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_7_DEBUG_BPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_DEBUG_BPMFIFO_ADDRESS ), (i), (v) )
#define BBH_TX_7_DEBUG_SBPMFIFO_ADDRESS        	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_SBPMFIFO_OFFSET )
#define BBH_TX_7_DEBUG_SBPMFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_DEBUG_SBPMFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_7_DEBUG_SBPMFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_DEBUG_SBPMFIFO_ADDRESS ), (i), (v) )
#define BBH_TX_7_DEBUG_FIRSTBNFIFO_ADDRESS        	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_FIRSTBNFIFO_OFFSET )
#define BBH_TX_7_DEBUG_FIRSTBNFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_7_DEBUG_FIRSTBNFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_DEBUG_FIRSTBNFIFO_ADDRESS ), (i), (v) )
#define BBH_TX_7_DEBUG_GETNEXTFIFO_ADDRESS        	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_GETNEXTFIFO_OFFSET )
#define BBH_TX_7_DEBUG_GETNEXTFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_7_DEBUG_GETNEXTFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_DEBUG_GETNEXTFIFO_ADDRESS ), (i), (v) )
#define BBH_TX_7_DEBUG_DBGOUTREG_ADDRESS   	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_DBGOUTREG_OFFSET )
#define BBH_TX_7_DEBUG_DBGOUTREG_READ( r ) 	READ_32( ( BBH_TX_7_DEBUG_DBGOUTREG_ADDRESS ), (r) )
#define BBH_TX_7_DEBUG_DBGOUTREG_WRITE( v )	WRITE_32( ( BBH_TX_7_DEBUG_DBGOUTREG_ADDRESS ), (v) )
#define BBH_TX_7_DEBUG_EPNPDVALID_ADDRESS        	( BBH_TX_7_DEBUG_ADDRESS + BBH_TX_DEBUG_EPNPDVALID_OFFSET )
#define BBH_TX_7_DEBUG_EPNPDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_DEBUG_EPNPDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_7_DEBUG_EPNPDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_DEBUG_EPNPDVALID_ADDRESS ), (i), (v) )
#define BBH_TX_7_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_7_PD_FIFO_ADDRESS + BBH_TX_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_7_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_7_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )
#define BBH_TX_7_CONTEXT_SEGCNTXT_ADDRESS        	( BBH_TX_7_CONTEXT_ADDRESS + BBH_TX_CONTEXT_SEGCNTXT_OFFSET )
#define BBH_TX_7_CONTEXT_SEGCNTXT_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_CONTEXT_SEGCNTXT_ADDRESS ), (i), (r) )
#define BBH_TX_7_CONTEXT_SEGCNTXT_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_CONTEXT_SEGCNTXT_ADDRESS ), (i), (v) )
#define BBH_TX_7_EPON_PD_FIFO_PDFIFO_ADDRESS        	( BBH_TX_7_EPON_PD_FIFO_ADDRESS + BBH_TX_EPON_PD_FIFO_PDFIFO_OFFSET )
#define BBH_TX_7_EPON_PD_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_7_EPON_PD_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_EPON_PD_FIFO_PDFIFO_ADDRESS ), (i), (v) )
#define BBH_TX_7_EPON_CFG_TASKLSB_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKLSB_OFFSET )
#define BBH_TX_7_EPON_CFG_TASKLSB_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_TASKLSB_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_TASKLSB_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_TASKLSB_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_TASKMSB_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASKMSB_OFFSET )
#define BBH_TX_7_EPON_CFG_TASKMSB_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_TASKMSB_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_TASKMSB_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_TASKMSB_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_TASK8_39_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_TASK8_39_OFFSET )
#define BBH_TX_7_EPON_CFG_TASK8_39_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_TASK8_39_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_TASK8_39_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_TASK8_39_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_PDSIZE0_3_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE0_3_OFFSET )
#define BBH_TX_7_EPON_CFG_PDSIZE0_3_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_PDSIZE0_3_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_PDSIZE0_3_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_PDSIZE0_3_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_PDSIZE4_7_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE4_7_OFFSET )
#define BBH_TX_7_EPON_CFG_PDSIZE4_7_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_PDSIZE4_7_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_PDSIZE4_7_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_PDSIZE4_7_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_PDSIZE8_31_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDSIZE8_31_OFFSET )
#define BBH_TX_7_EPON_CFG_PDSIZE8_31_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_PDSIZE8_31_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_PDSIZE8_31_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_PDSIZE8_31_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_PDBASE0_3_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE0_3_OFFSET )
#define BBH_TX_7_EPON_CFG_PDBASE0_3_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_PDBASE0_3_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_PDBASE0_3_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_PDBASE0_3_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_PDBASE4_7_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE4_7_OFFSET )
#define BBH_TX_7_EPON_CFG_PDBASE4_7_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_PDBASE4_7_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_PDBASE4_7_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_PDBASE4_7_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_PDBASE8_39_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDBASE8_39_OFFSET )
#define BBH_TX_7_EPON_CFG_PDBASE8_39_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_PDBASE8_39_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_PDBASE8_39_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_PDBASE8_39_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_PD_BYTE_TH_EN_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_EN_OFFSET )
#define BBH_TX_7_EPON_CFG_PD_BYTE_TH_EN_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_PD_BYTE_TH_EN_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_PD_BYTE_TH_EN_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_PD_BYTE_TH_ADDRESS        	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PD_BYTE_TH_OFFSET )
#define BBH_TX_7_EPON_CFG_PD_BYTE_TH_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (r) )
#define BBH_TX_7_EPON_CFG_PD_BYTE_TH_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_EPON_CFG_PD_BYTE_TH_ADDRESS ), (i), (v) )
#define BBH_TX_7_EPON_CFG_RUNNERCFG_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_RUNNERCFG_OFFSET )
#define BBH_TX_7_EPON_CFG_RUNNERCFG_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_RUNNERCFG_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_RUNNERCFG_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_RUNNERCFG_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_MDUMODE_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_MDUMODE_OFFSET )
#define BBH_TX_7_EPON_CFG_MDUMODE_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_MDUMODE_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_MDUMODE_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_MDUMODE_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_REQCFG_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_REQCFG_OFFSET )
#define BBH_TX_7_EPON_CFG_REQCFG_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_REQCFG_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_REQCFG_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_REQCFG_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_PDWKUPH0_3_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH0_3_OFFSET )
#define BBH_TX_7_EPON_CFG_PDWKUPH0_3_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_PDWKUPH0_3_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_PDWKUPH0_3_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_PDWKUPH0_3_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_PDWKUPH4_7_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH4_7_OFFSET )
#define BBH_TX_7_EPON_CFG_PDWKUPH4_7_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_PDWKUPH4_7_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_PDWKUPH4_7_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_PDWKUPH4_7_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_PDWKUPH8_31_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDWKUPH8_31_OFFSET )
#define BBH_TX_7_EPON_CFG_PDWKUPH8_31_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_PDWKUPH8_31_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_PDWKUPH8_31_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_PDWKUPH8_31_ADDRESS ), (v) )
#define BBH_TX_7_EPON_CFG_PDEMPTY_ADDRESS   	( BBH_TX_7_EPON_CFG_ADDRESS + BBH_TX_EPON_CFG_PDEMPTY_OFFSET )
#define BBH_TX_7_EPON_CFG_PDEMPTY_READ( r ) 	READ_32( ( BBH_TX_7_EPON_CFG_PDEMPTY_ADDRESS ), (r) )
#define BBH_TX_7_EPON_CFG_PDEMPTY_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_CFG_PDEMPTY_ADDRESS ), (v) )
#define BBH_TX_7_EPON_DBG_DDRPD_ADDRESS   	( BBH_TX_7_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_DDRPD_OFFSET )
#define BBH_TX_7_EPON_DBG_DDRPD_READ( r ) 	READ_32( ( BBH_TX_7_EPON_DBG_DDRPD_ADDRESS ), (r) )
#define BBH_TX_7_EPON_DBG_DDRPD_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_DBG_DDRPD_ADDRESS ), (v) )
#define BBH_TX_7_EPON_DBG_PDDROP_ADDRESS   	( BBH_TX_7_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDDROP_OFFSET )
#define BBH_TX_7_EPON_DBG_PDDROP_READ( r ) 	READ_32( ( BBH_TX_7_EPON_DBG_PDDROP_ADDRESS ), (r) )
#define BBH_TX_7_EPON_DBG_PDDROP_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_DBG_PDDROP_ADDRESS ), (v) )
#define BBH_TX_7_EPON_DBG_PDEQ0_ADDRESS   	( BBH_TX_7_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEQ0_OFFSET )
#define BBH_TX_7_EPON_DBG_PDEQ0_READ( r ) 	READ_32( ( BBH_TX_7_EPON_DBG_PDEQ0_ADDRESS ), (r) )
#define BBH_TX_7_EPON_DBG_PDEQ0_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_DBG_PDEQ0_ADDRESS ), (v) )
#define BBH_TX_7_EPON_DBG_PDFULLLSB_ADDRESS   	( BBH_TX_7_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDFULLLSB_OFFSET )
#define BBH_TX_7_EPON_DBG_PDFULLLSB_READ( r ) 	READ_32( ( BBH_TX_7_EPON_DBG_PDFULLLSB_ADDRESS ), (r) )
#define BBH_TX_7_EPON_DBG_PDFULLLSB_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_DBG_PDFULLLSB_ADDRESS ), (v) )
#define BBH_TX_7_EPON_DBG_PDEMPTYLSB_ADDRESS   	( BBH_TX_7_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDEMPTYLSB_OFFSET )
#define BBH_TX_7_EPON_DBG_PDEMPTYLSB_READ( r ) 	READ_32( ( BBH_TX_7_EPON_DBG_PDEMPTYLSB_ADDRESS ), (r) )
#define BBH_TX_7_EPON_DBG_PDEMPTYLSB_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_DBG_PDEMPTYLSB_ADDRESS ), (v) )
#define BBH_TX_7_EPON_DBG_PDVALID_ADDRESS        	( BBH_TX_7_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_PDVALID_OFFSET )
#define BBH_TX_7_EPON_DBG_PDVALID_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_EPON_DBG_PDVALID_ADDRESS ), (i), (r) )
#define BBH_TX_7_EPON_DBG_PDVALID_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_EPON_DBG_PDVALID_ADDRESS ), (i), (v) )
#define BBH_TX_7_EPON_DBG_LENERR_ADDRESS   	( BBH_TX_7_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_LENERR_OFFSET )
#define BBH_TX_7_EPON_DBG_LENERR_READ( r ) 	READ_32( ( BBH_TX_7_EPON_DBG_LENERR_ADDRESS ), (r) )
#define BBH_TX_7_EPON_DBG_LENERR_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_DBG_LENERR_ADDRESS ), (v) )
#define BBH_TX_7_EPON_DBG_FLUSHPKTS_ADDRESS   	( BBH_TX_7_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_FLUSHPKTS_OFFSET )
#define BBH_TX_7_EPON_DBG_FLUSHPKTS_READ( r ) 	READ_32( ( BBH_TX_7_EPON_DBG_FLUSHPKTS_ADDRESS ), (r) )
#define BBH_TX_7_EPON_DBG_FLUSHPKTS_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_DBG_FLUSHPKTS_ADDRESS ), (v) )
#define BBH_TX_7_EPON_DBG_REQFIFOADD_ADDRESS   	( BBH_TX_7_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFOADD_OFFSET )
#define BBH_TX_7_EPON_DBG_REQFIFOADD_READ( r ) 	READ_32( ( BBH_TX_7_EPON_DBG_REQFIFOADD_ADDRESS ), (r) )
#define BBH_TX_7_EPON_DBG_REQFIFOADD_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_DBG_REQFIFOADD_ADDRESS ), (v) )
#define BBH_TX_7_EPON_DBG_REQFIFODATA_ADDRESS   	( BBH_TX_7_EPON_DBG_ADDRESS + BBH_TX_EPON_DBG_REQFIFODATA_OFFSET )
#define BBH_TX_7_EPON_DBG_REQFIFODATA_READ( r ) 	READ_32( ( BBH_TX_7_EPON_DBG_REQFIFODATA_ADDRESS ), (r) )
#define BBH_TX_7_EPON_DBG_REQFIFODATA_WRITE( v )	WRITE_32( ( BBH_TX_7_EPON_DBG_REQFIFODATA_ADDRESS ), (v) )
#define BBH_TX_7_EPON_STS_FIFO_PDFIFO_ADDRESS        	( BBH_TX_7_EPON_STS_FIFO_ADDRESS + BBH_TX_EPON_STS_FIFO_PDFIFO_OFFSET )
#define BBH_TX_7_EPON_STS_FIFO_PDFIFO_READ_I( r, i ) 	READ_I_32( ( BBH_TX_7_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (r) )
#define BBH_TX_7_EPON_STS_FIFO_PDFIFO_WRITE_I( v, i )	WRITE_I_32( ( BBH_TX_7_EPON_STS_FIFO_PDFIFO_ADDRESS ), (i), (v) )



extern uint32_t BBH_TX_EPON_STS_FIFO_PDFIFO_ARRAY [ ] ;

#define BBH_TX_EPON_STS_FIFO_PDFIFO_WRITE( i, k, v )	WRITE_I_32( BBH_TX_EPON_STS_FIFO_PDFIFO_ARRAY [ i ], (k), (v) )
#define BBH_TX_EPON_STS_FIFO_PDFIFO_READ( i, k, r ) 	READ_I_32( BBH_TX_EPON_STS_FIFO_PDFIFO_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* PD_entry */
	uint32_t pdentry	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_STS_FIFO_PDFIFO ;
#else
typedef struct
{	uint32_t pdentry	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_entry */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_STS_FIFO_PDFIFO ;
#endif

typedef struct
{
	/* Broad-Bus_configuration */
	BBH_RX_GENERAL_CONFIGURATION_BBCFG bbcfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Broad-Bus_configuration */
	BBH_RX_GENERAL_CONFIGURATION_BBCFG1 bbcfg1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_configuration */
	BBH_RX_GENERAL_CONFIGURATION_DDRCFG ddrcfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_PD_base_address */
	BBH_RX_GENERAL_CONFIGURATION_PDBASE pdbase __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ruuner_PD_size */
	BBH_RX_GENERAL_CONFIGURATION_PDSIZE pdsize __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_task */
	BBH_RX_GENERAL_CONFIGURATION_RUNNERTASK runnertask __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_address_configuration */
	BBH_RX_GENERAL_CONFIGURATION_DMAADDR dmaaddr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_configuration */
	BBH_RX_GENERAL_CONFIGURATION_DMACFG dmacfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA_address_configuration */
	BBH_RX_GENERAL_CONFIGURATION_SDMAADDR sdmaaddr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA_configuration */
	BBH_RX_GENERAL_CONFIGURATION_SDMACFG sdmacfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_Packet_size */
	BBH_RX_GENERAL_CONFIGURATION_MINPKT0 minpkt0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_Packet_size_0 */
	BBH_RX_GENERAL_CONFIGURATION_MAXPKT0 maxpkt0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_Packet_size_1 */
	BBH_RX_GENERAL_CONFIGURATION_MAXPKT1 maxpkt1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_configuration */
	BBH_RX_GENERAL_CONFIGURATION_IHCFG ihcfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flow_control_configuration */
	BBH_RX_GENERAL_CONFIGURATION_FLOWCTRL flowctrl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Per_flow_threshold. */
	BBH_RX_GENERAL_CONFIGURATION_PERFLOWTH perflowth __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Per_flow_sets. */
	BBH_RX_GENERAL_CONFIGURATION_PERFLOWSETS perflowsets __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_select_0 */
	BBH_RX_GENERAL_CONFIGURATION_IHCLASS0 ihclass0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_select_1 */
	BBH_RX_GENERAL_CONFIGURATION_IHCLASS1 ihclass1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_select_2 */
	BBH_RX_GENERAL_CONFIGURATION_IHCLASS2 ihclass2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_select_3 */
	BBH_RX_GENERAL_CONFIGURATION_IHCLASS3 ihclass3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_class_override */
	BBH_RX_GENERAL_CONFIGURATION_IHOVERRIDE ihoverride __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_packet_select_0 */
	BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL0 minpktsel0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Minimum_packet_select_1 */
	BBH_RX_GENERAL_CONFIGURATION_MINPKTSEL1 minpktsel1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_packet_select_0 */
	BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL0 maxpktsel0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Maximum_packet_select_1 */
	BBH_RX_GENERAL_CONFIGURATION_MAXPKTSEL1 maxpktsel1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PLOAM_configurations */
	BBH_RX_GENERAL_CONFIGURATION_PLOAMCFG ploamcfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_reset_command */
	BBH_RX_GENERAL_CONFIGURATION_RXRSTRST rxrstrst __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_debug_select */
	BBH_RX_GENERAL_CONFIGURATION_RXDBGSEL rxdbgsel __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reassembly_offset */
	BBH_RX_GENERAL_CONFIGURATION_REASSEMBLYOFFSET reassemblyoffset __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_GENERAL_CONFIGURATION ;

typedef struct
{
	/* SOP_after_SOP_error */
	BBH_RX_PM_COUNTERS_SOPASOP sopasop __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Third_flow_error */
	BBH_RX_PM_COUNTERS_THIRDFLOW thirdflow __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Incoming_packets */
	BBH_RX_PM_COUNTERS_INPKT inpkt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Too_short_error */
	BBH_RX_PM_COUNTERS_TOOSHORT tooshort __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Too_long_error */
	BBH_RX_PM_COUNTERS_TOOLONG toolong __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CRC_error */
	BBH_RX_PM_COUNTERS_CRCERROR crcerror __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IPTV_error */
	BBH_RX_PM_COUNTERS_IPTV iptv __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_congestion_error */
	BBH_RX_PM_COUNTERS_RUNNERCONG runnercong __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* No_BPM_BN_error */
	BBH_RX_PM_COUNTERS_NOBPMBN nobpmbn __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NO_SBPM_SBN_error */
	BBH_RX_PM_COUNTERS_NOSBPMSBN nosbpmsbn __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* No_DMA_CD_error */
	BBH_RX_PM_COUNTERS_NODMACD nodmacd __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* No_SDMA_CD_error */
	BBH_RX_PM_COUNTERS_NOSDMACD nosdmacd __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_drop_ploam_error */
	BBH_RX_PM_COUNTERS_IHDROPPLOAM ihdropploam __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* No_BPM_BN_PLOAM_error */
	BBH_RX_PM_COUNTERS_NOBPMBNPLOAM nobpmbnploam __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CRC_PLOAM_error */
	BBH_RX_PM_COUNTERS_CRCERRORPLOAM crcerrorploam __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Epon_sync_fifo_overrun */
	BBH_RX_PM_COUNTERS_EPNFIFOVERUN epnfifoverun __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Epon_sync_fifo_overrun_hdr */
	BBH_RX_PM_COUNTERS_EPNFIFOVRNHDR epnfifovrnhdr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Epon_type_error */
	BBH_RX_PM_COUNTERS_EPONTYPERROR epontyperror __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PM_COUNTERS ;

/*****************************************************************************************/
/* Debug features.                                                                       */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define BBH_RX_DEBUG_BNFIFO_NUMBER ( 8 )
#define BBH_RX_DEBUG_SBNFIFO_NUMBER ( 8 )
#define BBH_RX_DEBUG_RESFIFO_NUMBER ( 16 )
typedef struct
{
	/* Context_0_LSB */
	BBH_RX_DEBUG_CNTXTX0LSB cntxtx0lsb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_0_MSB */
	BBH_RX_DEBUG_CNTXTX0MSB cntxtx0msb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_1_LSB */
	BBH_RX_DEBUG_CNTXTX1LSB cntxtx1lsb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_1_MSB */
	BBH_RX_DEBUG_CNTXTX1MSB cntxtx1msb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_context_0 */
	BBH_RX_DEBUG_IHCNTXT0 ihcntxt0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_context_1 */
	BBH_RX_DEBUG_IHCNTXT1 ihcntxt1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_context_PLOAM */
	BBH_RX_DEBUG_IHCNTXTP ihcntxtp __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_free_buffer */
	BBH_RX_DEBUG_IHFREEBUF ihfreebuf __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pre_wakeup_fifo_used_words */
	BBH_RX_DEBUG_PWUW pwuw __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ACK_counters */
	BBH_RX_DEBUG_ACKCNT ackcnt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_counters */
	BBH_RX_DEBUG_RNRCNT rnrcnt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Debug_vector */
	BBH_RX_DEBUG_DBGVEC dbgvec __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_BN_FIFO */
	BBH_RX_DEBUG_BNFIFO bnfifo [ BBH_RX_DEBUG_BNFIFO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SRAM_BN_FIFO */
	BBH_RX_DEBUG_SBNFIFO sbnfifo [ BBH_RX_DEBUG_SBNFIFO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IH_response_FIFO */
	BBH_RX_DEBUG_RESFIFO resfifo [ BBH_RX_DEBUG_RESFIFO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Epon_sync_fifo_used_words */
	BBH_RX_DEBUG_ESUW esuw __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_DEBUG ;

/*****************************************************************************************/
/* The BBH naintains per flow PM packets dropped by IH.  These registers are relevant fo */
/* r GPON only.                                                                          */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_NUMBER ( 256 )
typedef struct
{
	/* Per_flo_error */
	BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM perflowpm [ BBH_RX_PER_FLOW_PM_COUNTERS_PERFLOWPM_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX_PER_FLOW_PM_COUNTERS ;

/*****************************************************************************************/
/* These configurations and control registers contain parameters that determine the BBH  */
/* TX functionality.                                                                     */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define BBH_TX_CONFIGURATIONS_PD_BYTE_TH_NUMBER ( 5 )
typedef struct
{
	/* BB_Cfg */
	BBH_TX_CONFIGURATIONS_BBCFG_TX bbcfg_tx __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BB_Cfg_1 */
	BBH_TX_CONFIGURATIONS_BBCFG1_TX bbcfg1_tx __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_cfg */
	BBH_TX_CONFIGURATIONS_DDRCFG_TX ddrcfg_tx __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HN_BASE */
	BBH_TX_CONFIGURATIONS_HNBASE hnbase __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_numbers_LSB */
	BBH_TX_CONFIGURATIONS_TASKLSB tasklsb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_numbers_MSB */
	BBH_TX_CONFIGURATIONS_TASKMSB taskmsb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_numbers_8-39 */
	BBH_TX_CONFIGURATIONS_TASK8_39 task8_39 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_FIFO_size_0_7 */
	BBH_TX_CONFIGURATIONS_PDSIZE0_7 pdsize0_7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_FIFO_size_8_39 */
	BBH_TX_CONFIGURATIONS_PDSIZE8_39 pdsize8_39 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_FIFO_base_0_3 */
	BBH_TX_CONFIGURATIONS_PDBASE0_3 pdbase0_3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_FIFO_base_4_7 */
	BBH_TX_CONFIGURATIONS_PDBASE4_7 pdbase4_7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_FIFO_base_8_39 */
	BBH_TX_CONFIGURATIONS_PDBASE8_39 pdbase8_39 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_bytes_threshold_EN */
	BBH_TX_CONFIGURATIONS_PD_BYTE_TH_EN pd_byte_th_en __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_bytes_threshold */
	BBH_TX_CONFIGURATIONS_PD_BYTE_TH pd_byte_th [ BBH_TX_CONFIGURATIONS_PD_BYTE_TH_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 4 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_configurations */
	BBH_TX_CONFIGURATIONS_DMACFG_TX dmacfg_tx __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SDMA_configurations */
	BBH_TX_CONFIGURATIONS_SDMACFG_TX sdmacfg_tx __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_configurations */
	BBH_TX_CONFIGURATIONS_RUNNERCFG runnercfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MDU_CFG */
	BBH_TX_CONFIGURATIONS_MDUMODE mdumode __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_TM_BASE */
	BBH_TX_CONFIGURATIONS_DDRTMBASE ddrtmbase __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Debug_select */
	BBH_TX_CONFIGURATIONS_DBGSEL dbgsel __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX_reset_command */
	BBH_TX_CONFIGURATIONS_TXRSTCMD txrstcmd __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC1588 */
	BBH_TX_CONFIGURATIONS_EMAC1588 emac1588 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_configurations */
	BBH_TX_CONFIGURATIONS_SBPMCFG sbpmcfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_WKUP_THRESH_0_7 */
	BBH_TX_CONFIGURATIONS_PDWKUPH0_7 pdwkuph0_7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_WKUP_THRESH_8_31 */
	BBH_TX_CONFIGURATIONS_PDWKUPH8_31 pdwkuph8_31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_EMPTY_THRESHOLD */
	BBH_TX_CONFIGURATIONS_PDEMPTY pdempty __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH_TRANSMIT_TH */
	BBH_TX_CONFIGURATIONS_ETHTT ethtt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSL_MAXWLEN */
	BBH_TX_CONFIGURATIONS_MAXWLEN maxwlen __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DSL_FLUSH */
	BBH_TX_CONFIGURATIONS_FLUSH flush __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONFIGURATIONS ;

/*****************************************************************************************/
/* Debug features                                                                        */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define BBH_TX_DEBUG_PDVALID_NUMBER ( 4 )
#define BBH_TX_DEBUG_BPMFIFO_NUMBER ( 8 )
#define BBH_TX_DEBUG_SBPMFIFO_NUMBER ( 4 )
#define BBH_TX_DEBUG_FIRSTBNFIFO_NUMBER ( 8 )
#define BBH_TX_DEBUG_GETNEXTFIFO_NUMBER ( 8 )
#define BBH_TX_DEBUG_EPNPDVALID_NUMBER ( 8 )
typedef struct
{
	/* SRAM_PD_counter */
	BBH_TX_DEBUG_SRAMPD srampd __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_PD_counter */
	BBH_TX_DEBUG_DDRPD ddrpd __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_DROP_counter */
	BBH_TX_DEBUG_PDDROP pddrop __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_equal_0_counter */
	BBH_TX_DEBUG_PDEQ0 pdeq0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Get_next_is_null_counter */
	BBH_TX_DEBUG_GETNEXTNULL getnextnull __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_Full_LSB */
	BBH_TX_DEBUG_PDFULLLSB pdfulllsb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_Full_MSB */
	BBH_TX_DEBUG_PDFULLMSB pdfullmsb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_empty_LSB */
	BBH_TX_DEBUG_PDEMPTYLSB pdemptylsb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_empty_MSB */
	BBH_TX_DEBUG_PDEMPTYMSB pdemptymsb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_VALID */
	BBH_TX_DEBUG_PDVALID pdvalid [ BBH_TX_DEBUG_PDVALID_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_FIFO */
	BBH_TX_DEBUG_BPMFIFO bpmfifo [ BBH_TX_DEBUG_BPMFIFO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_FIFO */
	BBH_TX_DEBUG_SBPMFIFO sbpmfifo [ BBH_TX_DEBUG_SBPMFIFO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 16 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* First_BN_FIFO */
	BBH_TX_DEBUG_FIRSTBNFIFO firstbnfifo [ BBH_TX_DEBUG_FIRSTBNFIFO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Get_next_FIFO */
	BBH_TX_DEBUG_GETNEXTFIFO getnextfifo [ BBH_TX_DEBUG_GETNEXTFIFO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Debug_out_reg */
	BBH_TX_DEBUG_DBGOUTREG dbgoutreg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved3 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EPON_PD_VALID */
	BBH_TX_DEBUG_EPNPDVALID epnpdvalid [ BBH_TX_DEBUG_EPNPDVALID_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_DEBUG ;

/*****************************************************************************************/
/* PD FIFOs RAM for GPON and ETH.  For EPON PD FIFOs, refer to EPON_PD_FIFO section.     */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define BBH_TX_PD_FIFO_PDFIFO_NUMBER ( 256 )
typedef struct
{
	/* PD_FIFO */
	BBH_TX_PD_FIFO_PDFIFO pdfifo [ BBH_TX_PD_FIFO_PDFIFO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_PD_FIFO ;

/*****************************************************************************************/
/* Segmentation context                                                                  */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define BBH_TX_CONTEXT_SEGCNTXT_NUMBER ( 40 )
typedef struct
{
	/* Segmentation_context */
	BBH_TX_CONTEXT_SEGCNTXT segcntxt [ BBH_TX_CONTEXT_SEGCNTXT_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_CONTEXT ;

/*****************************************************************************************/
/* PD FIFOs RAM for EPON.                                                                */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define BBH_TX_EPON_PD_FIFO_PDFIFO_NUMBER ( 512 )
typedef struct
{
	/* PD_FIFO */
	BBH_TX_EPON_PD_FIFO_PDFIFO pdfifo [ BBH_TX_EPON_PD_FIFO_PDFIFO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_PD_FIFO ;

/*****************************************************************************************/
/* These configurations and control registers contain parameters that determine the EPON */
/*  BBH TX specific functionality. For global configurations, refer to Configurations se */
/* ction.    In this section, all the configurations that are related to PDs are reffere */
/* d to EPON status messages.                                                            */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define BBH_TX_EPON_CFG_PD_BYTE_TH_NUMBER ( 5 )
typedef struct
{
	/* Task_numbers_LSB */
	BBH_TX_EPON_CFG_TASKLSB tasklsb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_numbers_MSB */
	BBH_TX_EPON_CFG_TASKMSB taskmsb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_numbers_8-39 */
	BBH_TX_EPON_CFG_TASK8_39 task8_39 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_FIFO_size_0_3 */
	BBH_TX_EPON_CFG_PDSIZE0_3 pdsize0_3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_FIFO_size_4_7 */
	BBH_TX_EPON_CFG_PDSIZE4_7 pdsize4_7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_FIFO_size_8_31 */
	BBH_TX_EPON_CFG_PDSIZE8_31 pdsize8_31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_FIFO_base_0_3 */
	BBH_TX_EPON_CFG_PDBASE0_3 pdbase0_3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_FIFO_base_4_7 */
	BBH_TX_EPON_CFG_PDBASE4_7 pdbase4_7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_FIFO_base_8_39 */
	BBH_TX_EPON_CFG_PDBASE8_39 pdbase8_39 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_bytes_threshold_EN */
	BBH_TX_EPON_CFG_PD_BYTE_TH_EN pd_byte_th_en __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_bytes_threshold */
	BBH_TX_EPON_CFG_PD_BYTE_TH pd_byte_th [ BBH_TX_EPON_CFG_PD_BYTE_TH_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_configurations */
	BBH_TX_EPON_CFG_RUNNERCFG runnercfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MDU_CFG */
	BBH_TX_EPON_CFG_MDUMODE mdumode __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* REQ_CFG */
	BBH_TX_EPON_CFG_REQCFG reqcfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_WKUP_THRESH_0_3 */
	BBH_TX_EPON_CFG_PDWKUPH0_3 pdwkuph0_3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_WKUP_THRESH_4_7 */
	BBH_TX_EPON_CFG_PDWKUPH4_7 pdwkuph4_7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_WKUP_THRESH_8_31 */
	BBH_TX_EPON_CFG_PDWKUPH8_31 pdwkuph8_31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_EMPTY_THRESHOLD */
	BBH_TX_EPON_CFG_PDEMPTY pdempty __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_CFG ;

/*****************************************************************************************/
/* Debug features of EPON Status interface. In this section, a PD is reffered to Status  */
/* message and not a regular packet descriptor.                                          */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define BBH_TX_EPON_DBG_PDVALID_NUMBER ( 8 )
typedef struct
{
	/* DDR_PD_counter */
	BBH_TX_EPON_DBG_DDRPD ddrpd __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_DROP_counter */
	BBH_TX_EPON_DBG_PDDROP pddrop __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_equal_0_counter */
	BBH_TX_EPON_DBG_PDEQ0 pdeq0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 16 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_Full_LSB */
	BBH_TX_EPON_DBG_PDFULLLSB pdfulllsb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 4 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PD_empty_LSB */
	BBH_TX_EPON_DBG_PDEMPTYLSB pdemptylsb __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved3 [ 164 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EPON_PD_VALID */
	BBH_TX_EPON_DBG_PDVALID pdvalid [ BBH_TX_EPON_DBG_PDVALID_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* REQ_length_error_counter */
	BBH_TX_EPON_DBG_LENERR lenerr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Flushed_packets_counter */
	BBH_TX_EPON_DBG_FLUSHPKTS flushpkts __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved4 [ 8 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* REQ_FIFO_address */
	BBH_TX_EPON_DBG_REQFIFOADD reqfifoadd __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* REQ_FIFO_data */
	BBH_TX_EPON_DBG_REQFIFODATA reqfifodata __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_DBG ;

/*****************************************************************************************/
/* Status FIFOs RAM for EPON.                                                            */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define BBH_TX_EPON_STS_FIFO_PDFIFO_NUMBER ( 512 )
typedef struct
{
	/* PD_FIFO */
	BBH_TX_EPON_STS_FIFO_PDFIFO pdfifo [ BBH_TX_EPON_STS_FIFO_PDFIFO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX_EPON_STS_FIFO ;

typedef struct
{
	/* general_configuration function */
	BBH_RX_GENERAL_CONFIGURATION general_configuration __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved0 [ 136 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pm_counters function */
	BBH_RX_PM_COUNTERS pm_counters __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 184 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* debug function */
	BBH_RX_DEBUG debug __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 332 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* per_flow_pm_counters function */
	BBH_RX_PER_FLOW_PM_COUNTERS per_flow_pm_counters __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_RX ;

typedef struct
{
	/* configurations function */
	BBH_TX_CONFIGURATIONS configurations __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved0 [ 124 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* debug function */
	BBH_TX_DEBUG debug __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 56 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pd_fifo function */
	BBH_TX_PD_FIFO pd_fifo __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* context function */
	BBH_TX_CONTEXT context __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 96 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* epon_pd_fifo function */
	BBH_TX_EPON_PD_FIFO epon_pd_fifo __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved3 [ 256 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* epon_cfg function */
	BBH_TX_EPON_CFG epon_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved4 [ 168 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* epon_dbg function */
	BBH_TX_EPON_DBG epon_dbg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved5 [ 1468 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* epon_sts_fifo function */
	BBH_TX_EPON_STS_FIFO epon_sts_fifo __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BBH_TX ;

#define BBH_RX_NUMBER ( 7 )
#define BBH_TX_NUMBER ( 7 )
typedef struct
{
	/* RX */
	BBH_RX rx [ BBH_RX_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 39564 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TX */
	BBH_TX tx [ BBH_TX_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__ 
BBH_FOR_ALL ;
#endif /* BBH_H_INCLUDED */

