#ifndef __DWFB_UTILS_COMMON
#define __DWFB_UTILS_COMMON


/////////////////////////////////////////////////////////////////////////
// This is the basic RGB 565 color
// 
// Red 		- 0:4 
// Greem 	- 0:5 
// Blue 	- 0:4
// 
/////////////////////////////////////////////////////////////////////////
typedef unsigned short osdm_rgb565;

/////////////////////////////////////////////////////////////////////////
// This is the basic RGB 888 color
// 
// Red 		- 0:8 
// Greem 	- 0:8 
// Blue 	- 0:8
// 
/////////////////////////////////////////////////////////////////////////
typedef unsigned int osdm_rgb888;

/**************************************************************************
 This is the basic RGB 888 color with alpha
 
 Alpha	- 0:8
 Red	- 0:8 
 Greem 	- 0:8 
 Blue 	- 0:8
 
**************************************************************************/
typedef unsigned int osdm_abgr8888;


/**************************************************************************
 This is the basic RGBA 8888 color with alpha
 
 Red	- 0:8 
 Greem 	- 0:8 
 Blue 	- 0:8
 Alpha	- 0:8
**************************************************************************/
typedef unsigned int osdm_rgba8888;


static inline osdm_rgb565 get_rgb565(unsigned short red,unsigned short green, unsigned short blue )
{
	return ((((red)&0x1f)<<11) | (((green)&0x3f)<<5) | (((blue)&0x1f)<<0));
}

static inline unsigned short get_red_from_rgb565(osdm_rgb565 rgb565)
{
	return (((rgb565)&0xf800)>>11);
}

static inline unsigned short get_green_from_rgb565(osdm_rgb565 rgb565)
{
	return (((rgb565)&0x07E0)>>5);
}

static inline unsigned short get_blue_from_rgb565(osdm_rgb565 rgb565)
{
	return ((rgb565)&0x001f);
}

static inline osdm_rgb888 get_rgb888(unsigned short red,unsigned short green, unsigned short blue ){
	return ((((red)&0xff)<<16) | (((green)&0xff)<<8) | (((blue)&0xff)<<0));
}

static inline unsigned short get_red_from_rgb888(osdm_rgb888 rgb888) {
	return (((rgb888)&0xff0000)>>16);
}

static inline unsigned short get_green_from_rgb888(osdm_rgb888 rgb888) {
	return (((rgb888)&0x00ff00)>>8);
}

static inline unsigned short get_blue_from_rgb888(osdm_rgb888 rgb888){
	return ((rgb888)&0x0000ff);
}


static inline osdm_abgr8888 get_abgr8888(unsigned short alpha, unsigned short red, unsigned short green, unsigned short blue ){
	return ( (((red)&0xff)<<24) | (((green)&0xff)<<16) | (((blue)&0xff)<<8) | (((alpha)&0xff)<<0));
}

static inline unsigned short get_red_from_abgr8888(osdm_abgr8888 abgr8888) {
	return (((abgr8888)&0xff000000)>>24);
}

static inline unsigned short get_green_from_abgr8888(osdm_abgr8888 abgr8888) {
	return (((abgr8888)&0x00ff0000)>>16);
}

static inline unsigned short get_blue_from_abgr8888(osdm_abgr8888 abgr8888){
	return (((abgr8888)&0x0000ff00)>>8);
}

static inline unsigned short get_alpha_from_abgr8888(osdm_abgr8888 abgr8888){
	return ((abgr8888)&0x000000ff);
}



static inline osdm_rgba8888 get_rgba8888(unsigned short alpha, unsigned short red, unsigned short green, unsigned short blue ){
	return ( (((alpha)&0xff)<<24) | (((blue)&0xff)<<16) | (((green)&0xff)<<8) | (((red)&0xff)<<0) );
}

static inline unsigned short get_red_from_rgba8888(osdm_rgba8888 rgba8888) {
	return (((rgba8888)&0x00ff0000)>>16);
}

static inline unsigned short get_green_from_rgba8888(osdm_rgba8888 rgba8888) {
	return (((rgba8888)&0x0000ff00)>>8);
}

static inline unsigned short get_blue_from_rgba8888(osdm_rgba8888 rgba8888){
	return (((rgba8888)&0x000000ff)>>0);
}

static inline unsigned short get_alpha_from_rgba8888(osdm_rgba8888 rgba8888){
	return (((rgba8888)&0xff000000)>>24);
}

#endif
