/*
 *  Copyright (c) 2012 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __LINUX_DMW_GPIO_H
#define __LINUX_DMW_GPIO_H

#define XGP_DATA		0x00
#define XGP_DATA_SET		0x04
#define XGP_DATA_CLR		0x08
#define XGP_DIR			0x0C
#define XGP_DIR_OUT		0x10
#define XGP_DIR_IN		0x14
#define XGP_EN			0x18
#define XGP_EN_SET		0x1C
#define XGP_EN_CLR		0x20
#define XGP_PULL_CTRL		0x24
#define XGP_PULL_EN		0x28
#define XGP_PULL_DIS		0x2C
#define XGP_PULL_TYPE		0x30
#define XGP_PULL_UP		0x34
#define XGP_PULL_DOWN		0x38
#define XGP_KEEP		0x3C
#define XGP_KEEP_EN		0x40
#define XGP_KEEP_DIS		0x44
#define XGP_OD			0x48
#define XGP_OD_SET		0x4C
#define XGP_OD_CLR		0x50
#define XGP_IN			0x54

struct dmw_gpio_pdata {
	int num_banks;
	u32 *nx_masks;
};

/*
 * Attention: the structure of the GPIO numbers is assumed by the platform code
 * too, especially the low level sleep code.
 */
#define GPIO_PORTA(x)  ((x)&0x1f)
#define GPIO_PORTB(x) (((x)&0x1f)+ 32)
#define GPIO_PORTC(x) (((x)&0x1f)+(32*2))
#define GPIO_PORTD(x) (((x)&0x1f)+(32*3))
#define GPIO_PORTE(x) (((x)&0x1f)+(32*4))
#define GPIO_PORTF(x) (((x)&0x1f)+(32*5))
#define GPIO_PORTG(x) (((x)&0x1f)+(32*6))

#define __BANK(x)	((x) >> 5)
#define __PIN(x)	((x) & 0x1f)

#endif
