#include <linux/init.h>
#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/slab.h>
#include <asm/uaccess.h>

#include "tsc_dp52.h"

#define TSC_PROC_DIR_NAME   "tsc"
#define TSC_UNTOUCH_TIMER_PROC_FILENAME  "tsc_leave_timer"
#define TSC_PPS_PROC_FILENAME  "tsc_pps"

static  struct proc_dir_entry *s_TscProcDirEntry;



static int tsc_timer_proc_read(char *Page, 
                               char **Start,
                               off_t Off, 
                               int Count, 
                               int *Eof, 
                               void *Data)
{
	int len,timer = tsc_get_leave_timer();
    len = sprintf(Page,"untouch timer: %d\n",timer);

	return len;
}


static int tsc_timer_proc_write(struct file *File,
                    			     const char *Buffer,
                    			     unsigned long Count, 
                    			     void *Data)
{
    char buf[Count + 1];
	if (copy_from_user(buf, Buffer, Count))
    {
        printk("%s: copy_from_user failed\n",__func__);
        return -EFAULT;
    }
    buf[Count + 1] = 0;

	tsc_set_leave_timer(buf);

    printk("tsc timer proc value %s\n",buf);

    return Count;
}

static int tsc_pps_proc_read(char *Page, 
                               char **Start,
                               off_t Off, 
                               int Count, 
                               int *Eof, 
                               void *Data)
{
	int len,pps = tsc_get_pps();

    len = sprintf(Page,"pps timer: %d\n",pps);

	return len;
}


static int tsc_pps_proc_write(struct file *File,
                    			     const char *Buffer,
                    			     unsigned long Count, 
                    			     void *Data)
{
    char buf[Count + 1];

	if (copy_from_user(buf, Buffer, Count))
    {
        printk("%s: copy_from_user failed\n",__func__);
        return -EFAULT;
    }

    buf[Count + 1] = 0;

	tsc_set_pps(buf);

    printk("tsc pps proc value %s\n",buf);

    return Count;
}


int tsc_proc_init( void )
{
    struct proc_dir_entry *pTscTimerEntry,*pTscPpsEntry;

    s_TscProcDirEntry = proc_mkdir(TSC_PROC_DIR_NAME, NULL );

	if(s_TscProcDirEntry == 0)
    {
		printk("Unable to create proc node: %s\n",TSC_PROC_DIR_NAME);
		return -1;
	}


    pTscTimerEntry = create_proc_entry( TSC_UNTOUCH_TIMER_PROC_FILENAME,
                                   0666,
                                   s_TscProcDirEntry );

    pTscPpsEntry = create_proc_entry( TSC_PPS_PROC_FILENAME,
                                   0666,
                                   s_TscProcDirEntry );

    if (pTscTimerEntry == 0)
    {
        remove_proc_entry(TSC_PROC_DIR_NAME,NULL);
        printk("Unable to create proc node: %s\n",TSC_UNTOUCH_TIMER_PROC_FILENAME);
        return -1;
    }

    if (pTscPpsEntry == 0)
    {
        remove_proc_entry(TSC_PROC_DIR_NAME,NULL);
        printk("Unable to create proc node: %s\n",TSC_PPS_PROC_FILENAME);
        return -1;
    }

    pTscTimerEntry->data = 0;
    pTscTimerEntry->write_proc = tsc_timer_proc_write;
    pTscTimerEntry->read_proc  = tsc_timer_proc_read;

    pTscPpsEntry->data = 0;
    pTscPpsEntry->write_proc = tsc_pps_proc_write;
    pTscPpsEntry->read_proc  = tsc_pps_proc_read;
    return 0;
}
