/*
 * linux/arch/arm/mach-dmw/include/mach/platform.h
 *
 * Copyright (c) 2010 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MACH_PLATFORM_H
#define __MACH_PLATFORM_H

/* Chip */
#define DMW_CHIP_UNKNOWN		-1
#define DMW_CHIP_DMW96			96
#define DMW_CHIP_DMW96_REV_A		0
#define DMW_CHIP_DMW96_REV_B		1
#define DMW_CHIP_ANY			0x7fffffff

/* power management messages */
#define SEC_MSG_LATENCY			0
#define SEC_MSG_DRAM			1
#define SEC_MSG_PWR_DOWN		2
#define SEC_MSG_CLK_CMD			3
#define SEC_MSG_CLK_ARG			4
#define SEC_MSG_RST_CMD			5
/* reserved messages for COMA services */
#define SEC_MSG_COMA_START		16
#define SEC_MSG_COMA_END		32
/* panic message of the CSS side */
#define SEC_MSG_CSS_PANIC		40

#ifndef __ASSEMBLER__
int dmw_get_chip(void);
int dmw_get_chip_rev(void);
char *dmw_board_get_type(void);
bool dmw_board_is(char *board);
bool dmw_board_has_feature(char *feature);
bool dmw_debug_disabled(void);
#endif

#define DMW_DEV_BASE			0x00100000

#define DMW_SRAM_BASE			0x00200000
#define DMW_SRAM_SIZE			SZ_64K

/*
 * The internal SRAM is shared by multiple divices. Define the layout here to
 * have a single, consistent place!
 */
#define DMW_SRAM_GDMAC_BASE		(DMW_SRAM_BASE + DMW_SRAM_SIZE - 256)
#define DMW_SRAM_GDMAC_SIZE		256
#define DMW_SRAM_WIFI_BASE		DMW_SRAM_BASE
#define DMW_SRAM_WIFI_SIZE		(DMW_SRAM_GDMAC_BASE - DMW_SRAM_BASE)


#define CSS_ITCM_BASE			0x08000000
#define CSS_ITCM_SIZE			(208 * SZ_1K)

#define CSS_AHBRAM_BASE			0x08200000
#define CSS_AHBRAM_SIZE			SZ_2K

#define CSS_DTCM_BASE			0x08100000
#define CSS_DTCM_SIZE			(48 * SZ_1K)

/*
 * DW peripheral addresses
 */
#define DMW_MPMC_BASE			0x00100000
#define DMW_USB1_OTG_BASE		0x00300000
#define DMW_USB2_OTG_BASE		0x00400000
#define DMW_SONYMS_BASE			0x00500000
#define DMW_GPU_BASE			0x00600000
#define DMW_VPU_ENC_BASE		0x00700000
#define DMW_VPU_DEC_BASE		0x00800000
#define DMW_SDMMC_BASE			0x00900000
#define DMW_SEC_BASE			0x00A00000
#define DMW_WIFI_AHB_BASE		0x00B00000
#define DMW_BOOTROM_BASE		0x01200000
#define DMW_GPIO_BASE			0x05000000
#define DMW_EXTINT_BASE			(DMW_GPIO_BASE + 0x2A0)
#define DMW_PLICU_BASE			0x05100000
#define DMW_SYSCFG_BASE			0x05200000
#define DMW_CMU_BASE			0x05300000
#define DMW_NAND_LCD_BASE		0x05404000
#define DMW_REMOTE_CONTROL_BASE		0x05500000
#define DMW_RTC_BASE			0x05600000
#define DMW_WATCHDOG_BASE		0x05700000
#define DMW_TIMER0_BASE			0x05800000
#define DMW_TIMER1_BASE			0x05800020
#define DMW_TIMER2_BASE			0x05900000
#define DMW_TIMER3_BASE			0x05900020
#define DMW_UART1_BASE			0x05A00000
#define DMW_UART2_BASE			0x05B00000
#define DMW_UART3_BASE			0x05C00000
#define DMW_SPI1_BASE			0x05D00000
#define DMW_SPI2_BASE			0x05E00000
#define DMW_TDM1_BASE			0x05F00000
#define DMW_TDM2_BASE			0x06000000
#define DMW_TDM3_BASE			0x06100000
#define DMW_I2C1_BASE			0x06200000
#define DMW_I2C2_BASE			0x06300000
#define DMW_GDMAC_BASE			0x06400000
#define DMW_MII_BASE			0x06500000
#define DMW_PACP_BASE			0x06600000
#define DMW_CIU_BASE			0x06700000
#define DMW_SONYMS_DMA_BASE		0x06800000
#define DMW_OSDM_BASE			0x06A00000
#define DMW_LCDC_BASE			0x06B00000
#define DMW_SECURITY_BASE		0x06C00000
#define DMW_WIFI_APB_BASE		0x06D00000
#define DMW_MAC_BASE			0x06E00000
#define DMW_DEBUG_BASE			0x06F00000
#define DMW_CCU0_BASE			0x07000000
#define DMW_CCU1_BASE			0x07100000
#define DMW_DAP_BASE			0x07300000

/*
 * Clock management unit
 */
#define DMW_CMU_PLL1CONTROL		0x00
#define DMW_CMU_PLL2CONTROL		0x04
#define DMW_CMU_PLL3CONTROL		0x08
#define DMW_CMU_PLL4CONTROL		0x0C
#define DMW_CMU_WIFIPLLCONTROL		0x10
#define DMW_CMU_CPUCLKCNTRL		0x14
#define DMW_CMU_COMCLKSEL		0x18	/* guarded by SEC CMU mutex */
#define DMW_CMU_CLKSWCNTRL		0x1C
#define DMW_CMU_CLKDIVCNTRL1		0x20
#define DMW_CMU_CLKDIVCNTRL2		0x24
#define DMW_CMU_CLKDIVCNTRL3		0x28
#define DMW_CMU_CLKDIVCNTRL4		0x2C
#define DMW_CMU_CLKDIVCNTRL5		0x30
#define DMW_CMU_CLKDIVCNTRL6		0x34
#define DMW_CMU_LPTMRR			0x38
#define DMW_CMU_CLKOSCCR		0x3C
#define DMW_CMU_SWSYSRST		0x40
#define DMW_CMU_SWWRMRST		0x44
#define DMW_CMU_RSTSR			0x48
#define DMW_CMU_WRPR			0x4C
#define DMW_CMU_SWCHWRST1		0x50	/* guarded by SEC CMU mutex */
#define DMW_CMU_SWCHWRST2		0x54	/* guarded by SEC CMU mutex */
#define DMW_CMU_SWCLKENR1		0x58	/* guarded by SEC CMU mutex */
#define DMW_CMU_SWCLKENR2		0x5C	/* guarded by SEC CMU mutex */
#define DMW_CMU_CUSTATR			0x60
#define DMW_CMU_SWOVRCTL		0x64
#define DMW_CMU_CMU_TEST		0x68

/*
 * System configuration
 */
#define DMW_SYSCFG_GCR1			0x04
#define DMW_SYSCFG_CHIP_ID		0x1C
#define DMW_SYSCFG_CHIP_REV		0x20
#define DMW_SYSCFG_ISO_CTL		0x2C
#define DMW_SYSCFG_POWER_EN		0x30
#define DMW_SYSCFG_SPCR1		0x54
#define DMW_SYSCFG_SPCR2		0x58
#define DMW_SYSCFG_DRAMCTL_GCR1		0x6c
#define DMW_SYSCFG_MIPI_CTL1	0x78
#define DMW_SYSCFG_MIPI_CTL2	0x7c

/* SysCfg pad enable definitions */
#define DMW_SYSCFG_SPCR1_BTIF_PAD_EN       (1 << 31)
#define DMW_SYSCFG_SPCR1_MEMBOOT_PAD_EN    (1 << 30)
#define DMW_SYSCFG_SPCR1_BB_PAD_EN         (1 << 29)
#define DMW_SYSCFG_SPCR1_IR_REMCTL_PAD_EN  (1 << 28)
#define DMW_SYSCFG_SPCR1_FC_PAD_EN         (1 << 27)
#define DMW_SYSCFG_SPCR1_UART1_PAD_EN      (1 << 26)
#define DMW_SYSCFG_SPCR1_UART2_PAD_EN      (1 << 25)
#define DMW_SYSCFG_SPCR1_UART3_PAD_EN      (1 << 24)
#define DMW_SYSCFG_SPCR1_TDM1_PAD_EN       (1 << 23)
#define DMW_SYSCFG_SPCR1_TDM2_PAD_EN       (1 << 22)
#define DMW_SYSCFG_SPCR1_TDM3_PAD_EN       (1 << 21)
#define DMW_SYSCFG_SPCR1_SPI1_PAD_EN       (1 << 20)
#define DMW_SYSCFG_SPCR1_SPI2_PAD_EN       (1 << 19)
#define DMW_SYSCFG_SPCR1_SLVRMII_PAD_EN    (1 << 18)
#define DMW_SYSCFG_SPCR1_I2C_1_PAD_EN      (1 << 17)
#define DMW_SYSCFG_SPCR1_I2C_2_PAD_EN      (1 << 16)
#define DMW_SYSCFG_SPCR1_SD_PAD_EN         (1 << 15)
#define DMW_SYSCFG_SPCR1_EMACA_PAD_EN      (1 << 14)
#define DMW_SYSCFG_SPCR1_MS_PAD_EN         (1 << 13)
#define DMW_SYSCFG_SPCR1_EMMC_PAD_EN       (1 << 12)
#define DMW_SYSCFG_SPCR1_SLVMII_PAD_EN     (1 << 11)
#define DMW_SYSCFG_SPCR1_LCDC_PAD_EN       (1 << 10)
#define DMW_SYSCFG_SPCR1_LCDGP_PAD8_EN     (1 <<  8)
#define DMW_SYSCFG_SPCR1_LCDGP_PAD7_EN     (1 <<  7)
#define DMW_SYSCFG_SPCR1_LCDGP_PAD6_EN     (1 <<  6)
#define DMW_SYSCFG_SPCR1_LCDGP_PAD5_EN     (1 <<  5)
#define DMW_SYSCFG_SPCR1_LCDGP_PAD4_EN     (1 <<  4)
#define DMW_SYSCFG_SPCR1_LCDGP_PAD3_EN     (1 <<  3)
#define DMW_SYSCFG_SPCR1_LCDGP_PAD2_EN     (1 <<  2)
#define DMW_SYSCFG_SPCR1_LCDGP_PAD1_EN     (1 <<  1)
#define DMW_SYSCFG_SPCR1_LCDGP_PAD0_EN     (1 <<  0)

#define DMW_SYSCFG_SPCR2_WIFI_SER_KEEP_EN  (1 << 16)
#define DMW_SYSCFG_SPCR2_BMP_PAD_EN        (1 <<  6)
#define DMW_SYSCFG_SPCR2_CLK_OUT_PAD_EN    (1 <<  4)
#define DMW_SYSCFG_SPCR2_CIU_PAD_EN        (1 <<  3)
#define DMW_SYSCFG_SPCR2_DECT_IF_PAD_EN    (1 <<  2)
#define DMW_SYSCFG_SPCR2_DP_CLK_PAD_EN     (1 <<  1)
#define DMW_SYSCFG_SPCR2_SIM_PAD_EN        (1 <<  0)

#define DMW_SYSCFG_POWER_WIFI_LDO_SW_EN		(1 << 23)
#define DMW_SYSCFG_POWER_WIFI_LDO_ECO		(1 << 22)
#define DMW_SYSCFG_POWER_WIFI_LDO_MODE		(1 << 21)
#define DMW_SYSCFG_POWER_AUTO_PWR_HILO		(1 << 5)
#define DMW_SYSCFG_POWER_EN_CSS			(1 << 4)
#define DMW_SYSCFG_POWER_EN_GPU			(1 << 3)
#define DMW_SYSCFG_POWER_EN_VIDEO_ENC_DEC	(1 << 2)
#define DMW_SYSCFG_POWER_EN_CORTEX_ETM		(1 << 1)
#define DMW_SYSCFG_POWER_EN_CORTEX_NEON		(1 << 0)

/*
 * Interrupt controller
 */
#define DMW_PLICU_CH_CLR_INT1		0x00
#define DMW_PLICU_CH_CLR_INT2		0x04
#define DMW_PLICU_CH_EDGE_LEVEL1	0x08
#define DMW_PLICU_CH_EDGE_LEVEL2	0x0C
#define DMW_PLICU_CH_SW_TRIG_SET1	0x10
#define DMW_PLICU_CH_SW_TRIG_SET2	0x14
#define DMW_PLICU_SW_CH_REQ		0x18
#define DMW_PLICU_STATUS1		0x1C
#define DMW_PLICU_STATUS2		0x20
#define DMW_PLICU_PENDING_REQ1		0x24
#define DMW_PLICU_PENDING_REQ2		0x28
#define DMW_PLICU_CAUSE1		0x2C
#define DMW_PLICU_CAUSE2		0x30
#define DMW_PLICU_CH_MASK1		0x34
#define DMW_PLICU_CH_MASK2		0x38
#define DMW_PLICU_SET_CH_MASK1		0x3C
#define DMW_PLICU_SET_CH_MASK2		0x40
#define DMW_PLICU_CLR_CH_MASK1		0x44
#define DMW_PLICU_CLR_CH_MASK2		0x48
#define DMW_PLICU_CH_PRIORITY1		0x4C
#define DMW_PLICU_CH_PRIORITY2		0x50
#define DMW_PLICU_CH_PRIORITY3		0x54
#define DMW_PLICU_CH_PRIORITY4		0x58
#define DMW_PLICU_CH_PRIORITY5		0x5C
#define DMW_PLICU_CH_PRIORITY6		0x60
#define DMW_PLICU_CH_PRIORITY7		0x64
#define DMW_PLICU_CH_PRIORITY8		0x68
#define DMW_PLICU_FIQ_SEL1		0x6C
#define DMW_PLICU_FIQ_SEL2		0x70
#define DMW_PLICU_FIQ_PENDING_REQ1	0x74
#define DMW_PLICU_FIQ_PENDING_REQ2	0x78
#define DMW_PLICU_FIQ_CAUSE1		0x7C
#define DMW_PLICU_FIQ_CAUSE2		0x80
#define DMW_PLICU_PRI_MASK		0x84
#define DMW_PLICU_PRI_MASK_FIQ		0x88

/*
 * External interrupts - part of the GPIO block
 */
#define DMW_EXTINT_CFG			0x2A0
#define DMW_EXTINT_EDGE			0x2A4
#define DMW_EXTINT_STAT			0x2A8
#define DMW_EXTINT_EDGE_CLEAR		0x2AC


/*
 * DRAM BUS Monitor (DBM) registers
 */
#define DMW_DBM_CONFIG			0x00
#define DMW_DBM_PERF_CONFIG		0x04
#define DMW_DBM_PERF_DIR		0x08
#define DMW_DBM_PERF_START		0x0C
#define DMW_DBM_PERF_STOP		0x10
#define DMW_DBM_DRAM_PERF_CNT		0x14
#define DMW_DBM_P0_PERF_CNT		0x18
#define DMW_DBM_P1_PERF_CNT		0x1C
#define DMW_DBM_P2_PERF_CNT		0x20
#define DMW_DBM_P3_PERF_CNT		0x24
#define DMW_DBM_P4_PERF_CNT		0x28
#define DMW_DBM_P5_PERF_CNT		0x2C
#define DMW_DBM_P6_PERF_CNT		0x30
#define DMW_DBM_P7_PERF_CNT		0x34
#define DMW_DBM_MATCH_CONFIG		0x38
#define DMW_DBM_MATCH_DIR		0x3C
#define DMW_DBM_P0_MATCH_ADD		0x40
#define DMW_DBM_P0_MATCH_EN		0x44
#define DMW_DBM_P1_MATCH_ADD		0x48
#define DMW_DBM_P1_MATCH_EN		0x4C
#define DMW_DBM_P2_MATCH_ADD		0x50
#define DMW_DBM_P2_MATCH_EN		0x54
#define DMW_DBM_P3_MATCH_ADD		0x58
#define DMW_DBM_P3_MATCH_EN		0x5C
#define DMW_DBM_P4_MATCH_ADD		0x60
#define DMW_DBM_P4_MATCH_EN		0x64
#define DMW_DBM_P5_MATCH_ADD		0x68
#define DMW_DBM_P5_MATCH_E		0x6C
#define DMW_DBM_P6_MATCH_ADD		0x70
#define DMW_DBM_P6_MATCH_EN		0x74
#define DMW_DBM_P7_MATCH_ADD		0x78
#define DMW_DBM_P7_MATCH_EN		0x7C
#define DMW_DBM_STATUS			0x80
#define DMW_DBM_STATUS_CLR		0x84

#endif
