/*
 *  linux/arch/arm/mach-dmw/arch.h
 *
 *  Copyright (C) 2011 DSP Group
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __MACH_DMW_ARCH_H
#define __MACH_DMW_ARCH_H

#include <linux/types.h>

#ifndef CONFIG_DMW_RESERVEMEM_MEMALLOC
#define CONFIG_DMW_RESERVEMEM_MEMALLOC 0
#endif

#ifndef CONFIG_DMW_RESERVEMEM_CSS
#define CONFIG_DMW_RESERVEMEM_CSS 0
#endif

#define DMW_RESERVEMEM_GPU      (CONFIG_DMW_RESERVEMEM_GPU * SZ_1M)
#define DMW_RESERVEMEM_CAMERA   (CONFIG_DMW_RESERVEMEM_CAMERA * SZ_1M)
#define DMW_RESERVEMEM_MEMALLOC (CONFIG_DMW_RESERVEMEM_MEMALLOC * SZ_1M)
#define DMW_RESERVEMEM_CSS      (CONFIG_DMW_RESERVEMEM_CSS * SZ_1M)

int dmw_reservemem_get(phys_addr_t *pa, size_t size);

#endif
