// PlugInTest.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "PlugInTest.h"
#include "..\qerplugin.h"
#include "shapes.h"

#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HINSTANCE	hMainInstance;
HWND		hMainWindow;

//
//	Note!
//
//		If this DLL is dynamically linked against the MFC
//		DLLs, any functions exported from this DLL which
//		call into MFC must have the AFX_MANAGE_STATE macro
//		added at the very beginning of the function.
//
//		For example:
//
//		extern "C" BOOL PASCAL EXPORT ExportedFunction()
//		{
//			AFX_MANAGE_STATE(AfxGetStaticModuleState());
//			// normal function body here
//		}
//
//		It is very important that this macro appear in each
//		function, prior to any calls into MFC.  This means that
//		it must appear as the first statement within the 
//		function, even before any object variable declarations
//		as their constructors may generate calls into the MFC
//		DLL.
//
//		Please see MFC Technical Notes 33 and 58 for additional
//		details.
//

/////////////////////////////////////////////////////////////////////////////
// CPlugInTestApp

BEGIN_MESSAGE_MAP(CPlugInTestApp, CWinApp)
	//{{AFX_MSG_MAP(CPlugInTestApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPlugInTestApp construction

_QERFuncTable_1 g_FuncTable;


CPlugInTestApp::CPlugInTestApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CPlugInTestApp object

CPlugInTestApp theApp;


// plugin stuff
//
const char *PLUGIN_NAME = "Rogue Shapes";
// separate commands with ;
const char *PLUGIN_COMMANDS = "About...;-;Stairs;Ramp";

void _QERDeleteSelection()
{
  if (g_FuncTable.m_pfnDeleteSelection)
    (*g_FuncTable.m_pfnDeleteSelection)();
}

void _QERCreateBrush(vec3_t vMin, vec3_t vMax)
{
  if (g_FuncTable.m_pfnCreateBrush)
    (*g_FuncTable.m_pfnCreateBrush)(vMin, vMax);
}

LPVOID _QERCreateBrushHandle()
{
  if (g_FuncTable.m_pfnCreateBrushHandle)
    return (*g_FuncTable.m_pfnCreateBrushHandle)();
  else
    return NULL;
}

void _QERDeleteBrushHandle(LPVOID vp)
{
  if (g_FuncTable.m_pfnDeleteBrushHandle)
    (*g_FuncTable.m_pfnDeleteBrushHandle)(vp);
}

void _QERCommitBrushHandleToMap(LPVOID vp)
{
  if (g_FuncTable.m_pfnCommitBrushHandle)
    (*g_FuncTable.m_pfnCommitBrushHandle)(vp);
}

void _QERAddFace(LPVOID vp, vec3_t v1, vec3_t v2, vec3_t v3)
{
  if (g_FuncTable.m_pfnAddFace)
    (*g_FuncTable.m_pfnAddFace)(vp, v1, v2, v3);
}

LPVOID WINAPI QERPlug_GetFuncTable()
{
  return &g_FuncTable;
}

LPCSTR WINAPI QERPlug_Init(HMODULE hApp, HWND hwndMain)
{
   AFX_MANAGE_STATE(AfxGetStaticModuleState());
   memset(&g_FuncTable, 0, sizeof(_QERFuncTable_1));
   g_FuncTable.m_fVersion = 1.00;
   g_FuncTable.m_nSize = sizeof(_QERFuncTable_1);

   hMainWindow = hwndMain;
   hMainInstance = (HINSTANCE) GetWindowLong (hMainWindow, GWL_HINSTANCE);
   
   return "Rogue Shapes v1.0";
}

LPCSTR WINAPI QERPlug_GetName()
{
  return PLUGIN_NAME;
}

LPCSTR WINAPI QERPlug_GetCommandList()
{
  return PLUGIN_COMMANDS;
}

bool HasVolume(vec3_t vMin, vec3_t vMax)
{
  for (int i = 0; i < 3; i++)
  {
    if (vMax[i] - vMin[i] > 0)
      return true;
  }
  return false;
}

bool HasEnoughVolume(vec3_t vMin, vec3_t vMax)
{
  for (int i = 0; i < 3; i++)
  {
    if (vMax[i] - vMin[i] < 16)
      return false;
  }
  return true;
}

//FIXME: remove the above wrapper calls to the table funcs as they 
// were mainly for old style.. once this is valid, can safely direct
// call through table without sanity checks
bool TableIsValid()
{
  return ( (g_FuncTable.m_pfnActiveBrushCount != NULL) &&
           (g_FuncTable.m_pfnAddFace != NULL) &&
           (g_FuncTable.m_pfnAddFaceData != NULL) &&
           (g_FuncTable.m_pfnAllocateActiveBrushHandles != NULL) &&
           (g_FuncTable.m_pfnAllocateSelectedBrushHandles != NULL) &&
           (g_FuncTable.m_pfnCommitBrushHandle != NULL) &&
           (g_FuncTable.m_pfnCreateBrush != NULL) &&
           (g_FuncTable.m_pfnCreateBrushHandle != NULL) &&
           (g_FuncTable.m_pfnDeleteBrushHandle != NULL) &&
           (g_FuncTable.m_pfnDeleteSelection != NULL) &&
           (g_FuncTable.m_pfnGetActiveBrushHandle != NULL) &&
           (g_FuncTable.m_pfnGetCurrentTexture != NULL) &&
           (g_FuncTable.m_pfnGetFaceCount != NULL) &&
           (g_FuncTable.m_pfnGetFaceData != NULL) &&
           (g_FuncTable.m_pfnGetPoints != NULL) &&
           (g_FuncTable.m_pfnGetSelectedBrushHandle != NULL) &&
           (g_FuncTable.m_pfnGetTexture != NULL) &&
           (g_FuncTable.m_pfnHideInfoMsg != NULL) &&
           (g_FuncTable.m_pfnInfoMsg != NULL) &&
           (g_FuncTable.m_pfnReleaseActiveBrushHandles != NULL) &&
           (g_FuncTable.m_pfnReleaseSelectedBrushHandles != NULL) &&
           (g_FuncTable.m_pfnSelectedBrushCount != NULL) &&
           (g_FuncTable.m_pfnSetCurrentTexture != NULL) &&
           (g_FuncTable.m_pfnSetFaceData != NULL) &&
           (g_FuncTable.m_pfnSysMsg != NULL) &&
           (g_FuncTable.m_pfnTextureBrush != NULL) &&
           (g_FuncTable.m_pfnTextureCount != NULL) );
}

/////////////////////////////////////////////////////////////////////////////
// CStairDialog dialog


CStairDialog::CStairDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CStairDialog::IDD, pParent)
{
	stair_x = 0;
	stair_y = 0;
	stair_z = 0;
	stair_count = 0;
	stair_rot = 0;
	stair_style = 0;
	stair_orientation = 0;

	//{{AFX_DATA_INIT(CDialogTextures)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

BOOL CStairDialog::OnInitDialog()
{
	BOOL	rcode = FALSE;
	CWnd	*dlgItem, *dlgItem2;
	UDACCEL	accel;
	char	string[255];

	CDialog::OnInitDialog();

	accel.nSec = 0;
	accel.nInc = 8;
	dlgItem = GetDlgItem(IDC_SPIN1);
	dlgItem2 = GetDlgItem(IDC_SHAPES_STAIR_COUNT);
	dlgItem->SendMessage(UDM_SETBUDDY, (WPARAM)dlgItem2->m_hWnd, 0);
	dlgItem->SendMessage(UDM_SETPOS, (WPARAM)0, (LPARAM) MAKELONG((short) 8, 0));
	dlgItem->SendMessage(UDM_SETRANGE, (WPARAM)0, (LPARAM) MAKELONG(32, 1));

	dlgItem = GetDlgItem(IDC_RADIO1);		// Style -- Filled
	dlgItem->SendMessage(BM_SETCHECK, BST_CHECKED, 0);
	dlgItem = GetDlgItem(IDC_COMBO1);		// Orientation
	sprintf(string, "X Axis");
	dlgItem->SendMessage(CB_ADDSTRING, 0, (LPARAM)string);
	sprintf(string, "Y Axis");
	dlgItem->SendMessage(CB_ADDSTRING, 0, (LPARAM)string);
	sprintf(string, "Z Axis");
	dlgItem->SendMessage(CB_ADDSTRING, 0, (LPARAM)string);
	dlgItem->SendMessage(CB_SETCURSEL, 0, 0);

	return true;
}

void CStairDialog::OnOK()
{
	CWnd	*dlgItem;

	dlgItem = GetDlgItem(IDC_RADIO1);
	if(dlgItem->SendMessage(BM_GETCHECK, 0, 0) == BST_CHECKED)
		stair_style = STAIR_FILLED;
	else
		stair_style = STAIR_PLATFORM;

	dlgItem = GetDlgItem(IDC_SPIN1);
	stair_count = (int) LOWORD(dlgItem->SendMessage(UDM_GETPOS, 0, 0));

	dlgItem = GetDlgItem(IDC_COMBO1);		// Orientation
	stair_orientation = (int) dlgItem->SendMessage(CB_GETCURSEL, 0, 0);

	EndDialog(IDOK);
}

/*
==========
==========
*/
void BuildStairs (vec3_t vMin, vec3_t vMax)
{
	CStairDialog	*stairDlg;
	float			xStart, xStep, xSize, xGrowth;
	float			yStart, yStep, ySize, yGrowth;
	float			zStart, zStep, zSize, zGrowth;
	int				i;

	stairDlg = new CStairDialog(NULL);
	if(stairDlg->DoModal())
	{
		switch(stairDlg->stair_orientation)
		{
			case STAIR_X:
				xStart = vMin[0];
				xStep = (vMax[0] - vMin[0]) / stairDlg->stair_count;
				xSize = (vMax[0] - vMin[0]) / stairDlg->stair_count;
				xGrowth = 0;
				yStart = vMin[1];
				yStep = 0;
				ySize = (vMax[1] - vMin[1]);
				yGrowth = 0;
				zStart = vMin[2];
				zSize = (vMax[2] - vMin[2]) / stairDlg->stair_count;
				if(stairDlg->stair_style == STAIR_PLATFORM)
				{
					zGrowth = 0;
					zStep = (vMax[2] - vMin[2]) / stairDlg->stair_count;
				}
				else
				{
					zGrowth = (vMax[2] - vMin[2]) / stairDlg->stair_count;
					zStep = 0;
				}
				break;
			case STAIR_Y:
				xStart = vMin[0];
				xStep = 0;
				xSize = (vMax[0] - vMin[0]);
				xGrowth = 0;
				yStart = vMin[1];
				yStep = (vMax[1] - vMin[1]) / stairDlg->stair_count;
				ySize = (vMax[1] - vMin[1]) / stairDlg->stair_count;
				yGrowth = 0;
				zStart = vMin[2];
				zSize = (vMax[2] - vMin[2]) / stairDlg->stair_count;
				if(stairDlg->stair_style == STAIR_PLATFORM)
				{
					zGrowth = 0;
					zStep = (vMax[2] - vMin[2]) / stairDlg->stair_count;
				}
				else
				{
					zGrowth = (vMax[2] - vMin[2]) / stairDlg->stair_count;
					zStep = 0;
				}
				break;
			case STAIR_Z:
				xStart = vMax[0];
				xSize = (vMax[0] - vMin[0]) / stairDlg->stair_count;
				if(stairDlg->stair_style == STAIR_PLATFORM)
				{
					xGrowth = 0;
					xStep = -1 * ((vMax[0] - vMin[0]) / stairDlg->stair_count);
				}
				else
				{
					xGrowth = (vMax[0] - vMin[0]) / stairDlg->stair_count;
					xStep = -1 * ((vMax[0] - vMin[0]) / stairDlg->stair_count);
				}
				yStart = vMin[1];
				yStep = 0;
				ySize = (vMax[1] - vMin[1]);
				yGrowth = 0;
				zStart = vMin[2];
				zStep = (vMax[2] - vMin[2]) / stairDlg->stair_count;
				zSize = (vMax[2] - vMin[2]) / stairDlg->stair_count;
				zGrowth = 0;
				break;
			default:
				return;
		}

		_QERDeleteSelection();
		for(i=0;i<stairDlg->stair_count;i++)
		{
			float	xMin, xMax, yMin, yMax, zMin, zMax;
			void	*newBrush;

			newBrush = _QERCreateBrushHandle();
			
			xMin = xStart + (xStep*i);
			xMax = xMin + xSize + (xGrowth*i);
			yMin = yStart + (yStep*i);
			yMax = yMin + ySize + (yGrowth*i);
			zMin = zStart + (zStep*i);
			zMax = zMin + zSize + (zGrowth*i);

			if (newBrush != NULL)
			{
				vec3_t	pts[4][2];
				pts[0][0][0] = xMin;
				pts[0][0][1] = yMin;

				pts[1][0][0] = xMin;
				pts[1][0][1] = yMax;

				pts[2][0][0] = xMax;
				pts[2][0][1] = yMax;

				pts[3][0][0] = xMax;
				pts[3][0][1] = yMin;

				int i,j;
				for (i = 0 ; i < 4 ; i++)
				{
					pts[i][0][2] = zMin;
					pts[i][1][0] = pts[i][0][0];
					pts[i][1][1] = pts[i][0][1];
					pts[i][1][2] = zMax;
				}
				for (i = 0 ; i < 4 ; i++)
				{
					j = (i+1)%4;
					_QERAddFace(newBrush, pts[j][1], pts[i][1], pts[i][0]);
				}
				_QERAddFace(newBrush, pts[0][1], pts[1][1], pts[2][1]);
				_QERAddFace(newBrush, pts[2][0], pts[1][0], pts[0][0]);
				_QERCommitBrushHandleToMap(newBrush);
			}
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// CRampDialog dialog


CRampDialog::CRampDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CRampDialog::IDD, pParent)
{
	ramp_style = 0;
	ramp_orientation = 0;
	ramp_thickness = 0;

	//{{AFX_DATA_INIT(CDialogTextures)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

BOOL CRampDialog::OnInitDialog()
{
	CWnd	*dlgItem, *dlgItem2;
	char	string[255];
	UDACCEL	accel;

	CDialog::OnInitDialog();

	accel.nSec = 0;
	accel.nInc = 8;
	dlgItem = GetDlgItem(IDC_SPIN1);
	dlgItem2 = GetDlgItem(IDC_EDIT1);
	dlgItem->SendMessage(UDM_SETBUDDY, (WPARAM)dlgItem2->m_hWnd, 0);
	dlgItem->SendMessage(UDM_SETPOS, (WPARAM)0, (LPARAM) MAKELONG((short) 8, 0));
	dlgItem->SendMessage(UDM_SETRANGE, (WPARAM)0, (LPARAM) MAKELONG(32, 1));

	dlgItem = GetDlgItem(IDC_RADIO1);		// Style - Vertical Face
	dlgItem->SendMessage(BM_SETCHECK, BST_CHECKED, 0);

	dlgItem = GetDlgItem(IDC_COMBO1);		// Orientation
	sprintf(string, "X Axis");
	dlgItem->SendMessage(CB_ADDSTRING, 0, (LPARAM)string);
	sprintf(string, "Y Axis");
	dlgItem->SendMessage(CB_ADDSTRING, 0, (LPARAM)string);

	dlgItem->SendMessage(CB_SETCURSEL, 0, 0);

	return true;
}

void CRampDialog::OnOK()
{
	CWnd	*dlgItem;

	dlgItem = GetDlgItem(IDC_RADIO1);
	if(dlgItem->SendMessage(BM_GETCHECK, 0, 0) == BST_CHECKED)
		ramp_style = RAMP_VERTICAL;
	else
		ramp_style = RAMP_HORIZONTAL;

	dlgItem = GetDlgItem(IDC_COMBO1);		// Orientation
	ramp_orientation = (int) dlgItem->SendMessage(CB_GETCURSEL, 0, 0);

	dlgItem = GetDlgItem(IDC_SPIN1);
	ramp_thickness = (int) LOWORD(dlgItem->SendMessage(UDM_GETPOS, 0, 0));

	EndDialog(IDOK);
}

/*
==========
==========
*/
void BuildRamp (vec3_t vMin, vec3_t vMax)
{
	CRampDialog		*RampDlg;
	vec3_t			v1, v2, v3;

	RampDlg = new CRampDialog(NULL);
	if(RampDlg->DoModal())
	{
		void	*newBrush;
		vec3_t	pts[4][2];

		pts[0][0][0] = vMin[0];
		pts[0][0][1] = vMin[1];

		pts[1][0][0] = vMin[0];
		pts[1][0][1] = vMax[1];

		pts[2][0][0] = vMax[0];
		pts[2][0][1] = vMax[1];

		pts[3][0][0] = vMax[0];
		pts[3][0][1] = vMin[1];

		int i,j;
		for (i = 0 ; i < 4 ; i++)
		{
			pts[i][0][2] = vMin[2];
			pts[i][1][0] = pts[i][0][0];
			pts[i][1][1] = pts[i][0][1];
			pts[i][1][2] = vMax[2];
		}
		
		_QERDeleteSelection();
		newBrush = _QERCreateBrushHandle();

		// First add the ordinal faces we want
		if(RampDlg->ramp_orientation == RAMP_X)
		{
			for (i = 0 ; i < 4 ; i++)
			{
				if((RampDlg->ramp_style == RAMP_HORIZONTAL) && (i==0 || i==2))
					continue;
				j = (i+1)%4;
				_QERAddFace(newBrush, pts[j][1], pts[i][1], pts[i][0]);
			}
		}
		else
		{
			for (i = 0 ; i < 4 ; i++)
			{
				if((RampDlg->ramp_style == RAMP_HORIZONTAL) && (i==1 || i==3))
					continue;
				j = (i+1)%4;
				_QERAddFace(newBrush, pts[j][1], pts[i][1], pts[i][0]);
			}
		}

		// add top and bottom if we're making horizontal ramps
		if(RampDlg->ramp_style == RAMP_HORIZONTAL)
		{
			_QERAddFace(newBrush, pts[0][1], pts[1][1], pts[2][1]);
			_QERAddFace(newBrush, pts[2][0], pts[1][0], pts[0][0]);
		}

		if(RampDlg->ramp_style == RAMP_HORIZONTAL)
		{
			// add top angled face
			if(RampDlg->ramp_orientation == RAMP_X)
			{
				v1[0]=vMin[0] + RampDlg->ramp_thickness;
				v1[1]=vMin[1];
				v1[2]=vMax[2];
				v2[0]=vMin[0] + RampDlg->ramp_thickness;
				v2[1]=vMax[1];
				v2[2]=vMax[2];
				v3[0]=vMax[0];
				v3[1]=vMax[1];
				v3[2]=vMin[2];
				_QERAddFace(newBrush, v1, v2, v3);
			}
			else
			{
				v1[0]=vMin[0];
				v1[1]=vMax[1] - RampDlg->ramp_thickness;
				v1[2]=vMax[2];
				v2[0]=vMax[0];
				v2[1]=vMax[1] - RampDlg->ramp_thickness;
				v2[2]=vMax[2];
				v3[0]=vMax[0];
				v3[1]=vMin[1];
				v3[2]=vMin[2];
				_QERAddFace(newBrush, v1, v2, v3);
			}
			
			// add bottom angled face
			if(RampDlg->ramp_orientation == RAMP_X)
			{
				v3[0]=vMin[0];
				v3[1]=vMin[1];
				v3[2]=vMax[2];
				v2[0]=vMin[0];
				v2[1]=vMax[1];
				v2[2]=vMax[2];
				v1[0]=vMax[0] - RampDlg->ramp_thickness;
				v1[1]=vMax[1];
				v1[2]=vMin[2];
				_QERAddFace(newBrush, v1, v2, v3);
			}
			else
			{
				v3[0]=vMax[0];
				v3[1]=vMax[1];
				v3[2]=vMax[2];
				v2[0]=vMin[0];
				v2[1]=vMax[1];
				v2[2]=vMax[2];
				v1[0]=vMin[0];
				v1[1]=vMin[1] + RampDlg->ramp_thickness;
				v1[2]=vMin[2];
				_QERAddFace(newBrush, v3, v2, v1);
			}
		}
		else if(RampDlg->ramp_style == RAMP_VERTICAL)
		{
			// add top angled face
			if(RampDlg->ramp_orientation == RAMP_X)
			{
				v1[0]=vMin[0];
				v1[1]=vMin[1];
				v1[2]=vMax[2];
				v2[0]=vMin[0];
				v2[1]=vMax[1];
				v2[2]=vMax[2];
				v3[0]=vMax[0];
				v3[1]=vMax[1];
				v3[2]=vMin[2] + RampDlg->ramp_thickness;
				_QERAddFace(newBrush, v1, v2, v3);
			}
			else
			{
				v1[0]=vMin[0];
				v1[1]=vMin[1];
				v1[2]=vMin[2] + RampDlg->ramp_thickness;
					v2[0]=vMin[0];
					v2[1]=vMax[1];
					v2[2]=vMax[2];
				v3[0]=vMax[0];
				v3[1]=vMax[1];
				v3[2]=vMax[2];
				_QERAddFace(newBrush, v1, v2, v3);
			}

			if(RampDlg->ramp_orientation == RAMP_X)
			{
				v3[0]=vMin[0];
				v3[1]=vMin[1];
				v3[2]=vMax[2] - RampDlg->ramp_thickness;
				v2[0]=vMin[0];
				v2[1]=vMax[1];
				v2[2]=vMax[2] - RampDlg->ramp_thickness;
				v1[0]=vMax[0];
				v1[1]=vMax[1];
				v1[2]=vMin[2];
				_QERAddFace(newBrush, v1, v2, v3);
			}
			else
			{
				v1[0]=vMin[0];
				v1[1]=vMin[1];
				v1[2]=vMin[2];
					v2[0]=vMax[0];
					v2[1]=vMax[1];
					v2[2]=vMax[2] - RampDlg->ramp_thickness;
				v3[0]=vMin[0];
				v3[1]=vMax[1];
				v3[2]=vMax[2] - RampDlg->ramp_thickness;
				_QERAddFace(newBrush, v2, v3, v1);
			}
		}
		_QERCommitBrushHandleToMap(newBrush);
	}
}

void AboutBox()
{
	CDialog	aboutDlg(IDD_ABOUT, NULL);

	aboutDlg.DoModal();
}

// vMin/vMax provide the bounds of the selection, they are zero if there is no selection
// if there is a selection, bSingleBrush will be true if a single brush is selected
// if so, typical plugin behaviour (such as primitive creation) would use the bounds as
// a rule to create the primitive, then delete the selection
// FIXME: pretty lame ass.. fixup before releasing.. 
void WINAPI QERPlug_Dispatch(LPCSTR p, vec3_t vMin, vec3_t vMax, BOOL bSingleBrush)
{
	char	message[256];
	CString str = p;
	
	ASSERT(TableIsValid());

	if(str.Find("About...") >= 0)
	{
		AboutBox();
		return;
	}

	if(!bSingleBrush)
	{
		sprintf(message, "You must have a single brush selected.");
		g_FuncTable.m_pfnSysMsg ( message );
		return;
	}

	if(!HasVolume(vMin, vMax))
	{
		sprintf(message, "Please select a bounding brush.");
		g_FuncTable.m_pfnSysMsg ( message );
		return;
	}

	if (str.Find("Stairs") >= 0)
	{
		BuildStairs (vMin, vMax);
	}
	else if(str.Find("Ramp") >= 0)
	{
		if(!HasEnoughVolume(vMin, vMax))
		{
			sprintf(message, "Brush must be at least 16x16x16");
			g_FuncTable.m_pfnSysMsg ( message );
		}
		else
		{
			BuildRamp (vMin, vMax);
		}
	}
}


