/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader;

import java.util.HashMap;
import java.util.Map;
import org.jline.reader.Completer;
import org.jline.reader.Expander;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.Parser;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.reader.impl.history.history.MemoryHistory;
import org.jline.terminal.Terminal;

public final class LineReaderBuilder {
    Terminal terminal;
    String appName;
    Map<String, Object> variables;
    History history;
    Completer completer;
    History memoryHistory;
    Highlighter highlighter;
    Parser parser;
    Expander expander;

    public static LineReaderBuilder builder() {
        return new LineReaderBuilder();
    }

    private LineReaderBuilder() {
    }

    public LineReaderBuilder terminal(Terminal terminal) {
        this.terminal = terminal;
        return this;
    }

    public LineReaderBuilder appName(String appName) {
        this.appName = appName;
        return this;
    }

    public LineReaderBuilder variables(Map<String, Object> variables) {
        Map<String, Object> old = this.variables;
        this.variables = variables;
        if (old != null) {
            this.variables.putAll(old);
        }
        return this;
    }

    public LineReaderBuilder variable(String name, Object value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(name, value);
        return this;
    }

    public LineReaderBuilder history(History history) {
        this.history = history;
        return this;
    }

    public LineReaderBuilder completer(Completer completer) {
        this.completer = completer;
        return this;
    }

    public LineReaderBuilder highlighter(Highlighter highlighter) {
        this.highlighter = highlighter;
        return this;
    }

    public LineReaderBuilder parser(Parser parser) {
        this.parser = parser;
        return this;
    }

    public LineReaderBuilder expander(Expander expander) {
        this.expander = expander;
        return this;
    }

    public LineReader build() {
        LineReaderImpl reader = new LineReaderImpl(this.terminal, this.appName, this.variables);
        if (this.history != null) {
            reader.setHistory(this.history);
        } else {
            if (this.memoryHistory == null) {
                this.memoryHistory = new MemoryHistory();
            }
            reader.setHistory(this.memoryHistory);
        }
        if (this.completer != null) {
            reader.setCompleter(this.completer);
        }
        if (this.highlighter != null) {
            reader.setHighlighter(this.highlighter);
        }
        if (this.parser != null) {
            reader.setParser(this.parser);
        }
        if (this.expander != null) {
            reader.setExpander(this.expander);
        }
        return reader;
    }
}

