/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.ConstantValueAttr;
import gnu.bytecode.CpoolClass;
import gnu.bytecode.CpoolUtf8;
import gnu.bytecode.Field;
import gnu.bytecode.InnerClassesAttr;
import gnu.bytecode.Label;
import gnu.bytecode.LineNumbersAttr;
import gnu.bytecode.LocalVarsAttr;
import gnu.bytecode.Method;
import gnu.bytecode.MiscAttr;
import gnu.bytecode.Scope;
import gnu.bytecode.SourceDebugExtAttr;
import gnu.bytecode.SourceFileAttr;
import gnu.bytecode.Variable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ClassFileInput
extends DataInputStream {
    ClassType ctype;
    InputStream str;

    public ClassFileInput(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public ClassFileInput(ClassType classType, InputStream inputStream) throws IOException, ClassFormatError {
        super(inputStream);
        this.ctype = classType;
        if (!this.readHeader()) {
            throw new ClassFormatError("invalid magic number");
        }
        classType.constants = this.readConstants();
        this.readClassInfo();
        this.readFields();
        this.readMethods();
        this.readAttributes(classType);
    }

    public static ClassType readClassType(InputStream inputStream) throws IOException, ClassFormatError {
        ClassType classType = new ClassType();
        ClassFileInput classFileInput = new ClassFileInput(classType, inputStream);
        return classType;
    }

    public boolean readHeader() throws IOException {
        int n = this.readInt();
        if (n != -889275714) {
            return false;
        }
        short s = this.readShort();
        short s2 = this.readShort();
        return true;
    }

    public ConstantPool readConstants() throws IOException {
        return new ConstantPool(this);
    }

    public void readClassInfo() throws IOException {
        this.ctype.access_flags = this.readUnsignedShort();
        this.ctype.thisClassIndex = this.readUnsignedShort();
        CpoolClass cpoolClass = (CpoolClass)this.ctype.constants.getForced(this.ctype.thisClassIndex, 7);
        String string = cpoolClass.name.string;
        this.ctype.this_name = string.replace('/', '.');
        this.ctype.setSignature("L" + string + ";");
        this.ctype.superClassIndex = this.readUnsignedShort();
        if (this.ctype.superClassIndex == 0) {
            this.ctype.setSuper((ClassType)null);
        } else {
            cpoolClass = (CpoolClass)this.ctype.constants.getForced(this.ctype.superClassIndex, 7);
            string = cpoolClass.name.string;
            this.ctype.setSuper(string.replace('/', '.'));
        }
        int n = this.readUnsignedShort();
        if (n > 0) {
            this.ctype.interfaces = new ClassType[n];
            this.ctype.interfaceIndexes = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2;
                this.ctype.interfaceIndexes[i] = n2 = this.readUnsignedShort();
                cpoolClass = (CpoolClass)this.ctype.constants.getForced(n2, 7);
                string = cpoolClass.name.string.replace('/', '.');
                this.ctype.interfaces[i] = ClassType.make(string);
            }
        }
    }

    public int readAttributes(AttrContainer attrContainer) throws IOException {
        int n = this.readUnsignedShort();
        Attribute attribute = attrContainer.getAttributes();
        for (int i = 0; i < n; ++i) {
            if (attribute != null) {
                Attribute attribute2;
                while ((attribute2 = attribute.getNext()) != null) {
                    attribute = attribute2;
                }
            }
            int n2 = this.readUnsignedShort();
            CpoolUtf8 cpoolUtf8 = (CpoolUtf8)this.ctype.constants.getForced(n2, 1);
            int n3 = this.readInt();
            cpoolUtf8.intern();
            Attribute attribute3 = this.readAttribute(cpoolUtf8.string, n3, attrContainer);
            if (attribute3 == null) continue;
            if (attribute3.getNameIndex() == 0) {
                attribute3.setNameIndex(n2);
            }
            if (attribute == null) {
                attrContainer.setAttributes(attribute3);
            } else {
                if (attrContainer.getAttributes() == attribute3) {
                    attrContainer.setAttributes(attribute3.getNext());
                    attribute3.setNext(null);
                }
                attribute.setNext(attribute3);
            }
            attribute = attribute3;
        }
        return n;
    }

    public final void skipAttribute(int n) throws IOException {
        int n2;
        for (int i = 0; i < n; i += n2) {
            n2 = (int)this.skip(n - i);
            if (n2 != 0) continue;
            if (this.read() < 0) {
                throw new EOFException("EOF while reading class files attributes");
            }
            n2 = 1;
        }
    }

    public Attribute readAttribute(String string, int n, AttrContainer attrContainer) throws IOException {
        if (string == "SourceFile" && attrContainer instanceof ClassType) {
            return new SourceFileAttr(this.readUnsignedShort(), (ClassType)attrContainer);
        }
        if (string == "Code" && attrContainer instanceof Method) {
            CodeAttr codeAttr = new CodeAttr((Method)attrContainer);
            codeAttr.setMaxStack(this.readUnsignedShort());
            codeAttr.setMaxLocals(this.readUnsignedShort());
            int n2 = this.readInt();
            byte[] byArray = new byte[n2];
            this.readFully(byArray);
            codeAttr.setCode(byArray);
            int n3 = this.readUnsignedShort();
            for (int i = 0; i < n3; ++i) {
                int n4 = this.readUnsignedShort();
                int n5 = this.readUnsignedShort();
                int n6 = this.readUnsignedShort();
                int n7 = this.readUnsignedShort();
                codeAttr.addHandler(n4, n5, n6, n7);
            }
            this.readAttributes(codeAttr);
            return codeAttr;
        }
        if (string == "LineNumberTable" && attrContainer instanceof CodeAttr) {
            int n8 = 2 * this.readUnsignedShort();
            short[] sArray = new short[n8];
            for (int i = 0; i < n8; ++i) {
                sArray[i] = this.readShort();
            }
            return new LineNumbersAttr(sArray, (CodeAttr)attrContainer);
        }
        if (string == "LocalVariableTable" && attrContainer instanceof CodeAttr) {
            CodeAttr codeAttr = (CodeAttr)attrContainer;
            LocalVarsAttr localVarsAttr = new LocalVarsAttr(codeAttr);
            Method method = localVarsAttr.getMethod();
            if (localVarsAttr.parameter_scope == null) {
                localVarsAttr.parameter_scope = method.pushScope();
            }
            Scope scope = localVarsAttr.parameter_scope;
            if (scope.end == null) {
                scope.end = new Label(codeAttr.PC);
            }
            ConstantPool constantPool = method.getConstants();
            int n9 = this.readUnsignedShort();
            int n10 = scope.start.position;
            int n11 = scope.end.position;
            for (int i = 0; i < n9; ++i) {
                Variable variable = new Variable();
                int n12 = this.readUnsignedShort();
                int n13 = n12 + this.readUnsignedShort();
                if (n12 != n10 || n13 != n11) {
                    while (scope.parent != null && (n12 < scope.start.position || n13 > scope.end.position)) {
                        scope = scope.parent;
                    }
                    Scope scope2 = scope;
                    scope = new Scope(new Label(n12), new Label(n13));
                    scope.linkChild(scope2);
                    n10 = n12;
                    n11 = n13;
                }
                scope.addVariable(variable);
                variable.setName(this.readUnsignedShort(), constantPool);
                variable.setSignature(this.readUnsignedShort(), constantPool);
                variable.offset = this.readUnsignedShort();
            }
            return localVarsAttr;
        }
        if (string == "ConstantValue" && attrContainer instanceof Field) {
            return new ConstantValueAttr(this.readUnsignedShort());
        }
        if (string == "InnerClasses" && attrContainer instanceof ClassType) {
            int n14 = 4 * this.readUnsignedShort();
            short[] sArray = new short[n14];
            for (int i = 0; i < n14; ++i) {
                sArray[i] = this.readShort();
            }
            return new InnerClassesAttr(sArray, (ClassType)attrContainer);
        }
        if (string == "Exceptions" && attrContainer instanceof Method) {
            Method method = (Method)attrContainer;
            int n15 = this.readUnsignedShort();
            short[] sArray = new short[n15];
            for (int i = 0; i < n15; ++i) {
                sArray[i] = this.readShort();
            }
            method.setExceptions(sArray);
            return method.getExceptionAttr();
        }
        if (string == "SourceDebugExtension" && attrContainer instanceof ClassType) {
            SourceDebugExtAttr sourceDebugExtAttr = new SourceDebugExtAttr((ClassType)attrContainer);
            byte[] byArray = new byte[n];
            this.readFully(byArray, 0, n);
            sourceDebugExtAttr.data = byArray;
            sourceDebugExtAttr.dlength = n;
            return sourceDebugExtAttr;
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray, 0, n);
        return new MiscAttr(string, byArray);
    }

    public void readFields() throws IOException {
        int n = this.readUnsignedShort();
        ConstantPool constantPool = this.ctype.constants;
        for (int i = 0; i < n; ++i) {
            int n2 = this.readUnsignedShort();
            int n3 = this.readUnsignedShort();
            int n4 = this.readUnsignedShort();
            Field field = this.ctype.addField();
            field.setName(n3, constantPool);
            field.setSignature(n4, constantPool);
            field.flags = n2;
            this.readAttributes(field);
        }
    }

    public void readMethods() throws IOException {
        int n = this.readUnsignedShort();
        ConstantPool constantPool = this.ctype.constants;
        for (int i = 0; i < n; ++i) {
            int n2 = this.readUnsignedShort();
            int n3 = this.readUnsignedShort();
            int n4 = this.readUnsignedShort();
            Method method = this.ctype.addMethod(null, n2);
            method.setName(n3);
            method.setSignature(n4);
            this.readAttributes(method);
        }
    }
}

