/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;

public class ArrayType
extends ObjectType {
    public Type elements;

    public ArrayType(Type type) {
        this(type, type.getName() + "[]");
    }

    ArrayType(Type type, String string) {
        this.this_name = string;
        this.setSignature("[" + type.getSignature());
        this.elements = type;
    }

    public Type getImplementationType() {
        Type type = this.elements.getImplementationType();
        return this.elements == type ? this : ArrayType.make(type);
    }

    public static ArrayType make(Type type) {
        String string = type.getName() + "[]";
        ArrayType arrayType = (ArrayType)Type.lookupType(string);
        if (arrayType == null || arrayType.elements != type) {
            arrayType = new ArrayType(type, string);
            Type.mapNameToType.put(string, arrayType);
        }
        return arrayType;
    }

    public Type getComponentType() {
        return this.elements;
    }

    public String getInternalName() {
        return this.getSignature();
    }

    public int compare(Type type) {
        if (type == Type.nullType) {
            return 1;
        }
        if (type instanceof ArrayType) {
            return this.elements.compare(((ArrayType)type).elements);
        }
        if (type.getName().equals("java.lang.Object") || type == Type.tostring_type) {
            return -1;
        }
        return -3;
    }
}

