/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.S8Vector;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class U8Vector
extends SimpleVector
implements Externalizable {
    byte[] data;

    public U8Vector() {
        this.data = S8Vector.empty;
    }

    public U8Vector(int n, byte by) {
        byte[] byArray = new byte[n];
        this.data = byArray;
        this.size = n;
        while (--n >= 0) {
            byArray[n] = by;
        }
    }

    public U8Vector(int n) {
        this.data = new byte[n];
        this.size = n;
    }

    public U8Vector(byte[] byArray) {
        this.data = byArray;
        this.size = byArray.length;
    }

    public U8Vector(Sequence sequence) {
        this.data = new byte[sequence.size()];
        this.addAll((Collection)sequence);
    }

    public int getBufferLength() {
        return this.data.length;
    }

    public void setBufferLength(int n) {
        int n2 = this.data.length;
        if (n2 != n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.data, 0, byArray, 0, n2 < n ? n2 : n);
            this.data = byArray;
        }
    }

    protected Object getBuffer() {
        return this.data;
    }

    public final byte byteAt(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[n];
    }

    public final byte byteAtBuffer(int n) {
        return this.data[n];
    }

    public final int intAtBuffer(int n) {
        return this.data[n] & 0xFF;
    }

    public final Object get(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObjectUnsigned(this.data[n]);
    }

    public final Object getBuffer(int n) {
        return Convert.toObjectUnsigned(this.data[n]);
    }

    public Object setBuffer(int n, Object object2) {
        byte by = this.data[n];
        this.data[n] = Convert.toByteUnsigned(object2);
        return Convert.toObjectUnsigned(by);
    }

    public final void setByteAt(int n, byte by) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[n] = by;
    }

    public final void setByteAtBuffer(int n, byte by) {
        this.data[n] = by;
    }

    protected void clearBuffer(int n, int n2) {
        while (--n2 >= 0) {
            this.data[n++] = 0;
        }
    }

    public int getElementKind() {
        return 17;
    }

    public String getTag() {
        return "u8";
    }

    public boolean consumeNext(int n, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.writeInt(this.data[n2] & 0xFF);
        return true;
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        if (n4 > this.size) {
            n4 = this.size;
        }
        while (n3 < n4) {
            consumer.writeInt(this.data[n3] & 0xFF);
            ++n3;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeByte(this.data[i]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = objectInput.readByte();
        }
        this.data = byArray;
        this.size = n;
    }
}

