/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.BufferReader;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.buffer.Signal;
import gnu.jemacs.swing.BufferContent;
import gnu.lists.CharSeq;
import gnu.mapping.InPort;
import gnu.mapping.WrappedException;
import java.awt.Color;
import java.io.Reader;
import java.io.Writer;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Segment;
import javax.swing.text.StringContent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class SwingBuffer
extends Buffer {
    public DefaultStyledDocument doc;
    public Caret curPosition = null;
    public BufferContent content;
    public StyledDocument modelineDocument;
    public static StyleContext styles = new StyleContext();
    public static Style defaultStyle = styles.addStyle("default", null);
    public Style inputStyle = defaultStyle;
    public static Style redStyle = styles.addStyle("red", null);
    static Style blueStyle = styles.addStyle("blue", null);

    public SwingBuffer(String name) {
        this(name, new BufferContent());
    }

    public SwingBuffer(String name, BufferContent content) {
        super(name);
        this.doc = new DefaultStyledDocument((AbstractDocument.Content)content, styles);
        this.content = content;
        this.pointMarker = new Marker(this, 0, true);
        this.markMarker = new Marker();
        this.modelineDocument = new DefaultStyledDocument((AbstractDocument.Content)new StringContent(), styles);
        this.doc.putProperty("i18n", Boolean.TRUE);
        this.redrawModeline();
    }

    @Override
    public void removeRegion(int start, int end) {
        try {
            this.doc.remove(start, end - start);
        }
        catch (BadLocationException ex) {
            throw new WrappedException(ex);
        }
    }

    @Override
    public void removeChar(int count) {
        this.remove(this.getDot(), count);
    }

    void remove(int point, int count) {
        try {
            if (count < 0) {
                if (point - (count = -count) < this.minDot()) {
                    Signal.signal("Beginning of buffer");
                }
                point -= count;
            } else if (point + count > this.maxDot()) {
                Signal.signal("End of buffer");
            }
            this.doc.remove(point, count);
            this.setDot(point);
        }
        catch (BadLocationException ex) {
            throw new Error("bad location: " + ex);
        }
    }

    @Override
    public void removePos(int ipos, int count) {
        this.remove(this.nextIndex(ipos), count);
    }

    @Override
    public void save(Writer out) throws Exception {
        int count;
        int length;
        int todo = length = this.getLength();
        Segment segment = new Segment();
        for (int offset = 0; offset < length; offset += count) {
            count = length;
            if (count > 4096) {
                count = 4096;
            }
            this.doc.getText(offset, count, segment);
            out.write(segment.array, segment.offset, segment.count);
        }
    }

    @Override
    public void insertChar(int ch, int count) {
        this.pointMarker.insertChar(ch, count, this.inputStyle);
    }

    public void insert(int index, String string, Object style) {
        if (style == null) {
            style = defaultStyle;
        }
        try {
            this.doc.insertString(index, string, (Style)style);
        }
        catch (BadLocationException ex) {
            throw new Error("bad location: " + ex);
        }
    }

    @Override
    public void insert(String string, Object style) {
        this.insert(this.getDot(), string, style);
    }

    @Override
    public void insert(String string, Object style, int ipos) {
        this.insert(this.nextIndex(ipos), string, style);
    }

    @Override
    public void insertFile(Reader in) throws Exception {
        int count;
        char[] buffer = new char[2048];
        int offset = this.getDot();
        while ((count = in.read(buffer, 0, buffer.length)) > 0) {
            this.doc.insertString(offset, new String(buffer, 0, count), null);
            offset += count;
        }
    }

    @Override
    public void redrawModeline() {
        try {
            this.modelineDocument.remove(0, this.modelineDocument.getLength());
            this.modelineDocument.insertString(0, "-----", redStyle);
            this.modelineDocument.insertString(this.modelineDocument.getLength(), "JEmacs: " + this.getName(), blueStyle);
            this.modelineDocument.insertString(this.modelineDocument.getLength(), " ---", redStyle);
        }
        catch (BadLocationException ex) {
            throw new Error("internal error in redraw-modeline- " + ex);
        }
    }

    @Override
    public long scan(char target, int start, int end, int count, boolean allowQuit) {
        if (end == 0) {
            end = count > 0 ? this.content.length() - 1 : 0;
        }
        return this.content.scan(target, start, end, count, allowQuit);
    }

    @Override
    public int lineStartOffset(int offset) {
        return (int)this.content.scan('\n', offset, this.minDot(), -1, true);
    }

    @Override
    public int getDot() {
        if (this.pointMarker.sequence == null) {
            return this.curPosition.getDot();
        }
        return this.pointMarker.getOffset();
    }

    @Override
    public void setDot(int i) {
        if (i > this.maxDot()) {
            throw new Error("set dot to " + i + " max:" + this.maxDot());
        }
        if (this.pointMarker.sequence == null) {
            this.curPosition.setDot(i);
        } else {
            this.pointMarker.set(this, i);
        }
    }

    @Override
    public int maxDot() {
        return this.content.length() - 1;
    }

    @Override
    public int getLength() {
        return this.doc.getLength();
    }

    @Override
    public CharSeq getStringContent() {
        return this.content.buffer;
    }

    @Override
    public int createPos(int index, boolean isAfter) {
        return this.content.buffer.createPos(index, isAfter);
    }

    @Override
    public Object get(int index) {
        return this.content.buffer.get(index);
    }

    @Override
    public int size() {
        return this.content.buffer.size();
    }

    @Override
    public int nextIndex(int ipos) {
        return this.content.buffer.nextIndex(ipos);
    }

    @Override
    public long savePointMark() {
        int pointPosition = this.content.buffer.createPos(this.getDot(), false);
        int markPosition = 0;
        return (long)markPosition << 32 | (long)pointPosition & 0xFFFFFFFFL;
    }

    @Override
    public void restorePointMark(long pointMark) {
        int pointPosition = (int)pointMark;
        int markPosition = (int)(pointMark >> 32);
        this.setDot(this.content.buffer.nextIndex(pointPosition));
        this.content.buffer.releasePos(pointPosition);
    }

    @Override
    public InPort openReader(int start, int count) {
        return new BufferReader(this.content.buffer, this.getPath(), start, count);
    }

    @Override
    public void invoke(Runnable doRun) {
        try {
            SwingUtilities.invokeAndWait(doRun);
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    static {
        String version = System.getProperty("java.version");
        if (version != null && (version.startsWith("1.2") || version.startsWith("1.3"))) {
            StyleConstants.setFontFamily(defaultStyle, "Lucida Sans TypeWriter");
            StyleConstants.setFontSize(defaultStyle, 14);
        }
        StyleConstants.setForeground(redStyle, Color.red);
        StyleConstants.setForeground(blueStyle, Color.blue);
    }
}

