# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# $Id: label.py 9956 2009-10-11 18:54:57Z reinhard $
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#

import win32con

from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Window
from gnue.forms.uidrivers.win32.common import *

#
# UILabel
#
# Widget set specific function that creates a single instance of a label
#
class UILabel(UIHelper):
    alignmentStyle = {'left'  : win32con.SS_LEFT,
                      'center': win32con.SS_CENTER,
                      'right' : win32con.SS_RIGHT}

    def _create_widget(self, event, spacer):
        object = event.object
        if self.itemWidth == -1:
            self.itemWidth = len(str(textEncode(object.text)))*event.widgetWidth
        if self.itemHeight == -1:
            self.itemHeight = event.widgetHeight

        style = self.alignmentStyle[object.alignment] | win32con.WS_CHILD #| win32con.WS_BORDER
        styleEx = 0
        newWidget = Win32Window(self._uiDriver, styleEx, 'STATIC', textEncode(object.text), style,
                            self.itemX,
        # Make sure the baseline of labels and widgets are the same
                            self.itemY + 3,
                            self.itemWidth,
                            self.itemHeight,
                            event.container)
        return newWidget


configuration = {
    'baseClass'  : UILabel,
    'provides'   : 'GFLabel',
    'container'  : 0,
    }
