#!/usr/bin/env python
#
# GNU Enterprise Forms - Installation Procedure
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: setup.py,v 1.92 2003/10/28 09:45:38 siesel Exp $

import sys
import os

from src import PACKAGE, VERSION

try:
  from gnue.common.setup import GSetup
except ImportError:
  print "You need GNUe-Common 0.5.2 or newer installed to install %s" % PACKAGE
  sys.exit (1)

# =============================================================================

class setup (GSetup.GSetup):

  # ---------------------------------------------------------------------------
  # Definition of basic parameters for distribution and installation.
  # Please add new files/directories that should be installed here.
  # Note that you also have to add them to MANIFEST.in.
  # ---------------------------------------------------------------------------

  def set_params (self, params):

    # The Work
    params ["name"]             = PACKAGE.lower ()
    params ["version"]          = VERSION
    params ["description"]      = "GNU Enterprise Forms"
    params ["long_description"] = ""
    params ["license"]          = "GPL"

    # The Author
    params ["author"]       = "GNU Enterprise Team"
    params ["author_email"] = "gnue-dev@gnu.org"
    params ["url"]          = "http://www.gnue.org"

    # The Programs
    params ["package_dir"] = {"gnue.forms": "src"}
    params ["scripts"]     = ["scripts/gnue-forms"]

    # The Data
    defaultsfiles = self.allfiles ("defaults")
    defaultfiles  = self.allfiles ("defaults/default")
    image01files  = self.allfiles ("images")
    image02files  = self.allfiles ("images/default")
    image03files  = self.allfiles ("images/gnome")
    image04files  = self.allfiles ("images/kde3")
    man1files     = self.allfiles ("doc/man")
    docfiles      = self.allfiles ("doc")

    params ["data_files"] = [
       ("share/gnue/forms/defaults",         defaultsfiles),
       ("share/gnue/forms/defaults/default", defaultfiles),
       ("share/gnue/images/forms",           image01files),
       ("share/gnue/images/forms/default",   image02files),
       ("share/gnue/images/forms/gnome",     image03files),
       ("share/gnue/images/forms/kde3",      image04files),
       ("share/man/man1",                    man1files),
       ("share/doc/gnue-forms",              docfiles)]

  # ---------------------------------------------------------------------------
  # Build files to be distributed and installed:
  # Should generate the files that go in a distribution but aren't in SVN.
  # Gets called on sdist (always) and on build/install (only when run from SVN).
  # ---------------------------------------------------------------------------

  def build_files (self, action):
    # nothing to do here
    pass

  # ---------------------------------------------------------------------------
  # Check dependencies for installation:
  # Should sys.exit(1) in case any requirement isn't met.
  # Gets called on install.
  # ---------------------------------------------------------------------------

  def check_dependencies (self):

    # -------------------------------------------------------------------------
    # GNUe Common
    try:
      print "checking GNUe Common Library"
      from gnue.common import HEXVERSION
      if HEXVERSION < '0006f800':
        print "---"
        print "GNUe Common Library 0.6.8 or newer required."
        sys.exit(1)
    except ImportError:
      print "---"
      print "GNUe Common Library 0.6.8 or newer required."
      sys.exit(1)

    # -------------------------------------------------------------------------
    # Verify at least one UI is installed
    UIOK = 0

    # Curses
    print "checking Python curses library (curses)"
    try:
      import curses
      UIOK = 0
    except ImportError:
      pass

    # wxPython
    print "checking wxPython library: ",
    if (os.environ.has_key('DISPLAY') and len(os.environ["DISPLAY"])) or \
       os.name!='posix':
      try:
        import wx
        if wx.__version__[0:2]=='2.':
          print "ok (%s)" % wx.__version__
          UIOK = 1
          # WORKAROUND:
          # return now because subsequent import of pygtk will segfault.
          return
        else:
          print "Version 2.6 or greater needed"
      except ImportError:
        pass
    else:
      print "check not possible, X11 not working, assuming wxPython is there"
      UIOK = 1

    # pyGTK 2.0
    print "checking pyGTK 2.0 library: ",
    try:
      import pygtk
      pygtk.require('2.0')
      import gtk
      print 'ok.'
      UIOK = 1
    except ImportError:
      print 'not found.'
    except RuntimeError:
      print 'found (but X is not running).'
      UIOK = 1

    # win32ui
    print "checking win32all extensions: ",
    try:
      import win32ui
      print 'ok.'
      UIOK = 1
      return
    except ImportError:
      print 'not found.'

    # FIXME: We have more UIDrivers, add check for qt!

    if UIOK != 1:
      print "---"
      print """
No valid UI drivers are installed on this machine.
Please install one of the following packages:
  wxPython      - www.wxpython.org
  pyGTK2        - ftp://ftp.gtk.org/pub/gtk/python/v2.0/
  python curses - Read python install docs on how to activate
The file 'INSTALL' contains more information about dependencies.
"""
      sys.exit (1)

# =============================================================================

if __name__ == "__main__":
  setup().run()
