#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2007 Free Software Foundation
#
# FILE:
# Dialog.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
import sio
from utility import _paintBorder
from Frame import Frame

class Notebook(Frame):
  """
    like a full screen container, but only a smaller portion of it.
    the user defines a screen region which makes up the Notebook...
    they may only put controls within this region.
  """
  def __init__(self, ParentContainer, r1=0, c1=0, r2=0, c2=0,
                **properties):
    SIOInstance = ParentContainer.Screen()
    Frame.__init__(ParentContainer, r1, c1, r2, c2, border=1, dropshadow=0)
    Container.__init__(self, SIOInstance, **properties)
    self._ChildOffsetY += 2

  def __del__(self):
     pass

  def SetPage(self, index):
    self._CurrentFrame = self.Frames[index]
    self.Paint()

  def _PaintBorder(self):
    self.LoLight()
    _paintBorder( self, self.Y+2, self.X, self._DialogHeight + 2,
      self._DialogWidth + 2, self.INSET, caption=self.CAPTION,
      captionColor=sio.C_DIALOG_TITLE)

  def NewPage(self, title):
    page = NotebookPage(self, r1=self.r1, c1=self.c1, r2=self.r2, c2=self.c2, title=title)
    self.AddFrame(page)
    self._AddButton(page)
    if self._CurrentFrame == self:
      self._CurrentFrame = page

  def _AddButton(self,page):
 ##   ctrl =
    newX = 0
    if len(self.Controls) > 0:
      newX  = self.Controls[-1:][0].X
      newX += len(self.Controls[-1:][0].CAPTION) + 2

    ctrl.X = newX
    ctrl.Y = self.Y

    self.AddControl(ctrl)

    for page in self.Frames:
      page.SetPageControls(self.Controls)




class NotebookButton(FocusedLabel):
  def __init__(self,Parent,MenuName,Y,X,DisplayName = "",
               **properties):
    self.maxLengthFixed = 0
    DisplayName = self.__FixDisplay(DisplayName)
    FocusedLabel.__init__(self,Parent,MenuName,Y,X,DisplayName, **properties)
    self.PARENT = Parent
    self.SetMethod("CLICK",self.ShowOff)
    self.items = []
    self.maxLength = 0

  def Run(self,v1,v2,v3):
    if v1 :
      self.ExecMethod("CLICK", self, None, None)
      if self.EXITFORM:
        return 1
    Container = self.SCREEN;
    global BACKWARDS
    while 1:
      if self.active != 1:
        self.breakUp = 1
      if self.breakUp :
        self.breakUp = 0
        return 0
      ch = Container.GetChar()
      if self.PARENT.BreakOrder(ch) :
        return
      if ch in (Container.TokNextField, Container.TokRightArrow):
        BACKWARDS=0
        return
      elif ch == Container.TokLeftArrow:
        BACKWARDS=1
        return
      elif ch in (Container.TokDownArrow,  Container.TokActivate):
        self.ExecMethod("CLICK", self, None, None)
        if self.EXITFORM:
          self.PARENT.Paint()
          if self.PARENT.__class__ != Container:
            self.PARENT.Refresh(None,None,None)
          return 1
        self.ExecMethod("SYSGOTFOCUS", None, None, None)

  def ShowOff(self,arg1, arg2,arg3):
    MenuHeight = len(self.items) + 2
    MenuWidth  = self.maxLength
    X = self.X
    Y = self.Y + 1
    Parent = self.PARENT
    Screen = Parent.SCREEN
    self.myscreen = Screen.CaptureScreen( Y, X, Y + MenuHeight ,
      X + MenuWidth )
    MenuWin = Dialog(Parent, Y, X, Y + MenuHeight, X + MenuWidth )
    count = 1
    self.EXITFORM = 0
    for i in range(len(self.items)):
      text = ''
      if self.items[i][0] == -1:
        text = (self.maxLength - 4) * chr(tiHLINE)
      else:
        newTitle = self.items[i][1]
        text = self.__FixDisplay(newTitle)
      item = MenuItem(MenuWin,str(self.items[i][0]),count,2,text,
          self.items[i][2], self.STATUSBARLINK)
      item.ITEMID = self.items[i][0]
      count += 1
      item.SetMethod("CLICK",self.ItemSelected)
      MenuWin.AddDialogControl(item)
      item.DeActivate(self.items[i][2])
    MenuWin.SetColor(sio.C_MENUBAR)
    MenuWin.INSET = 1
    MenuWin.RunDialog()
    Parent.Paint()
    Parent.Screen().Refresh()

  def __FixDisplay(self, newTitle):
    erg = newTitle
    if self.maxLengthFixed :
      newLen = len(newTitle)
      oldLen = self.maxLength -  4
      if newLen >= oldLen:
        oldLen -= 3
        oldLen = oldLen / 2
        erg = newTitle[:oldLen] + '...' + newTitle[-oldLen:]
      else:
        erg = newTitle + (oldLen-newLen)*' '
    return erg

  def Finalize(self):
    self.PARENT.AddControl(self)

  def ItemSelected(self,control, arg2,arg3):
    MenuHeight = len(self.items) + 2
    MenuWidth  = self.maxLength
    X = self.X
    Y = self.Y+ 1
    Parent = self.PARENT
    Screen = Parent.SCREEN
    Screen.RestoreScreen(Y,X, Y + MenuHeight , X + MenuWidth ,
      self.myscreen )
    if(self.GetMethod("CHOSEN") <> None):
      apply(self.GetMethod("CHOSEN"),(self,control.ITEMID,control.TITLE))

  def DeActivateItem(self,itemId,state):
    for i in range(0,len(self.items)):
      if self.items[i][0] == itemId:
        self.items[i][2] = state
        return

  def AddItem(self, itemId, itemCaption, itemDescription = "", initialState = 1):
    self.items.append( [ itemId, itemCaption, itemDescription, initialState ] )
    if not self.maxLengthFixed and self.maxLength < len(itemCaption)+4:
      self.maxLength = len(itemCaption)+4

  def InsertSeperator(self):
    self.items.append( [ -1, '', 0 ])

  def ChangeTitle(self,newTitle):
    newLen = len(newTitle)
    oldLen = len(self.CAPTION)
    if newLen >= oldLen:
      newTitle = self.__FixDisplay(newTitle)
      self.CAPTION = newTitle[:oldLen]
    else:
      newTitle = newTitle + (oldLen-newLen)*' '
      self.CAPTION = newTitle

  def Clear(self):
    self.items = []

  def GetWidth(self):
    return self.maxLength
