/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesCellBuilder;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.user.ErrorLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class SeaOfGatesHandlers {
    private static final Save SAVE_DEFAULT = Save.SAVE_PERIODIC;

    private SeaOfGatesHandlers() {
    }

    public static void startInJob(Cell cell, Collection<ArcInst> selected, SeaOfGatesEngineFactory.SeaOfGatesEngineType version) {
        SeaOfGatesHandlers.startInJob(cell, selected, version, SAVE_DEFAULT);
    }

    public static void startInJob(Cell cell, Collection<ArcInst> selected, SeaOfGatesEngineFactory.SeaOfGatesEngineType version, Save save) {
        new SeaOfGatesJob(cell, selected, version, save).startJob();
    }

    public static SeaOfGatesEngine.Handler getDefault(Cell cell, String resultCellName, Routing.SoGContactsStrategy contactPlacementAction, Job job, EditingPreferences ep) {
        return SeaOfGatesHandlers.getDefault(cell, resultCellName, contactPlacementAction, job, ep, SAVE_DEFAULT);
    }

    public static SeaOfGatesEngine.Handler getDefault(Cell cell, String resultCellName, Routing.SoGContactsStrategy contactPlacementAction, Job job, EditingPreferences ep, Save save) {
        return new DefaultSeaOfGatesHook(cell, resultCellName, contactPlacementAction, job, ep, save);
    }

    public static SeaOfGatesEngine.Handler getDummy(EditingPreferences ep, PrintStream out) {
        return new DummySeaOfGatesHandler(ep, out);
    }

    private static class DummySeaOfGatesHandler
    implements SeaOfGatesEngine.Handler {
        private final EditingPreferences ep;
        private final PrintStream out;

        private DummySeaOfGatesHandler(EditingPreferences ep, PrintStream out) {
            this.ep = ep;
            this.out = out;
        }

        @Override
        public EditingPreferences getEditingPreferences() {
            return this.ep;
        }

        @Override
        public boolean checkAbort() {
            return false;
        }

        @Override
        public void trace(String msg) {
        }

        @Override
        public void debug(String msg) {
            this.out.println(msg);
        }

        @Override
        public void info(String msg) {
            this.out.println(msg);
        }

        @Override
        public void warn(String msg) {
            this.out.println("WARN: " + msg);
        }

        @Override
        public void error(String msg) {
            this.out.println("ERROR: " + msg);
        }

        @Override
        public void termLogging(ErrorLogger errorLogger) {
        }

        @Override
        public void startProgressDialog(String msg) {
        }

        @Override
        public void stopProgressDialog() {
        }

        @Override
        public void setProgressNote(String message) {
        }

        @Override
        public void setProgressValue(long done, long total) {
        }

        @Override
        public void instantiate(SeaOfGatesEngine.RouteResolution resolution) {
        }

        @Override
        public void flush(boolean force) {
        }
    }

    private static class DefaultSeaOfGatesHook
    implements SeaOfGatesEngine.Handler {
        private final EDatabase database;
        private final Job job;
        private final EditingPreferences ep;
        private final Save save;
        private final SeaOfGatesCellBuilder cellBuilder;
        private final UserInterface ui = Job.getUserInterface();
        private int periodicCounter;

        private DefaultSeaOfGatesHook(Cell cell, String resultCellName, Routing.SoGContactsStrategy contactPlacementAction, Job job, EditingPreferences ep, Save save) {
            this.database = cell.getDatabase();
            this.job = job;
            this.ep = ep;
            this.save = save;
            this.cellBuilder = new SeaOfGatesCellBuilder(this.database.backup(), cell.getId(), resultCellName, contactPlacementAction, ep);
            this.periodicCounter = 0;
        }

        @Override
        public EditingPreferences getEditingPreferences() {
            return this.ep;
        }

        @Override
        public boolean checkAbort() {
            return this.job != null && this.job.checkAbort();
        }

        @Override
        public void trace(String msg) {
            this.printMessage(msg, true);
        }

        @Override
        public void debug(String msg) {
            if (Job.getDebug()) {
                this.printMessage(msg, true);
            }
        }

        @Override
        public void info(String msg) {
            this.printMessage(msg, true);
        }

        @Override
        public void warn(String msg) {
            this.printMessage("WARNING: " + msg, true);
        }

        @Override
        public void error(String msg) {
            this.printMessage("ERROR: " + msg, true);
        }

        private void printMessage(String s2, boolean newLine) {
            if (newLine) {
                System.out.println(s2);
            } else {
                System.out.print(s2);
            }
        }

        @Override
        public void termLogging(ErrorLogger errorLogger) {
            errorLogger.termLogging(true);
        }

        @Override
        public void startProgressDialog(String msg) {
            this.ui.startProgressDialog(msg, null);
        }

        @Override
        public void stopProgressDialog() {
            this.ui.stopProgressDialog();
        }

        @Override
        public void setProgressNote(String message) {
            this.ui.setProgressNote(message);
            if (Job.getDebug()) {
                System.out.println(message);
            }
        }

        @Override
        public void setProgressValue(long done, long total) {
            int val = (int)(done * 100L / total);
            this.ui.setProgressValue(val);
        }

        @Override
        public void instantiate(SeaOfGatesEngine.RouteResolution resolution) {
            this.cellBuilder.instantiate(resolution);
        }

        @Override
        public void flush(boolean force) {
            switch (this.save) {
                case SAVE_SNAPSHOTS: {
                    force = true;
                    break;
                }
                case SAVE_PERIODIC: {
                    if (this.periodicCounter++ <= 100) break;
                    this.periodicCounter = 0;
                    force = true;
                }
            }
            if (force) {
                Snapshot snapshot = this.cellBuilder.commit();
                this.database.checkChanging();
                this.database.lowLevelSetCanUndoing(true);
                this.database.undo(snapshot);
                this.database.lowLevelSetCanUndoing(false);
                this.database.getCell(this.cellBuilder.cellId).getLibrary().setChanged();
                if (this.job instanceof SeaOfGatesJob) {
                    ((SeaOfGatesJob)this.job).showSnapshot();
                }
            }
        }
    }

    private static class SeaOfGatesJob
    extends Job {
        private final Cell cell;
        private final int[] arcIdsToRoute;
        private final SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
        private final SeaOfGatesEngineFactory.SeaOfGatesEngineType version;
        private final Save save;

        protected SeaOfGatesJob(Cell cell, Collection<ArcInst> arcsToRoute, SeaOfGatesEngineFactory.SeaOfGatesEngineType version, Save save) {
            super("Sea-Of-Gates Route", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            if (arcsToRoute != null) {
                this.arcIdsToRoute = new int[arcsToRoute.size()];
                Iterator<ArcInst> it = arcsToRoute.iterator();
                for (int i = 0; i < arcsToRoute.size(); ++i) {
                    this.arcIdsToRoute[i] = it.next().getArcId();
                }
            } else {
                this.arcIdsToRoute = null;
            }
            this.prefs.getOptionsFromPreferences(false);
            this.version = version;
            this.save = save;
        }

        @Override
        public boolean doIt() throws JobException {
            SeaOfGatesEngine router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(this.version);
            router.setPrefs(this.prefs);
            Layout.changesQuiet(true);
            SeaOfGatesEngine.Handler handler = SeaOfGatesHandlers.getDefault(this.cell, router.getPrefs().resultCellName, router.getPrefs().contactPlacementAction, this, this.getEditingPreferences(), this.save);
            if (this.arcIdsToRoute != null) {
                ArrayList<ArcInst> arcsToRoute = new ArrayList<ArcInst>();
                for (int arcId : this.arcIdsToRoute) {
                    arcsToRoute.add(this.cell.getArcById(arcId));
                }
                router.routeIt(handler, this.cell, false, arcsToRoute);
            } else {
                router.routeIt(handler, this.cell, false);
            }
            return true;
        }

        @Override
        public void showSnapshot() {
            if (this.save != Save.SAVE_ONCE) {
                super.showSnapshot();
            }
        }
    }

    public static enum Save {
        SAVE_ONCE,
        SAVE_PERIODIC,
        SAVE_SNAPSHOTS;

    }
}

