/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.tool.routing.RoutingFrame;
import java.awt.geom.Point2D;

public class Path {
    RoutingFrame.RoutingSegment segment;
    int minX;
    int maxX;
    int minY;
    int maxY;
    int startX;
    int finishX;
    int startY;
    int finishY;
    int[] startZ = null;
    int[] finishZ = null;
    boolean startRight;
    boolean startAbove;
    boolean finishRight;
    boolean finishAbove;
    int[] nodesX;
    int[] nodesY;
    int[] nodesZ;
    int totalCost;
    boolean pathDone = false;
    boolean pathUnroutable = false;

    public Path(RoutingFrame.RoutingSegment rs, double dispX, double dispY, double scalingFactor) {
        this.segment = rs;
        Point2D startLoc = this.segment.getStartEnd().getLocation();
        this.startX = (int)Math.floor((startLoc.getX() + dispX) / scalingFactor);
        this.startY = (int)Math.floor((startLoc.getY() + dispY) / scalingFactor);
        Point2D finishLoc = this.segment.getFinishEnd().getLocation();
        this.finishX = (int)Math.floor((finishLoc.getX() + dispX) / scalingFactor);
        this.finishY = (int)Math.floor((finishLoc.getY() + dispY) / scalingFactor);
        this.startRight = (startLoc.getX() + dispX) % scalingFactor >= scalingFactor / 2.0;
        this.startAbove = (startLoc.getY() + dispY) % scalingFactor >= scalingFactor / 2.0;
        this.finishRight = (finishLoc.getX() + dispX) % scalingFactor >= scalingFactor / 2.0;
        this.finishAbove = (finishLoc.getY() + dispY) % scalingFactor >= scalingFactor / 2.0;
    }

    public void initialize() {
        this.nodesX = null;
        this.nodesY = null;
        this.nodesZ = null;
        this.totalCost = -1;
    }

    public void updateBoundingBox() {
        this.minX = Math.min(this.startX, this.finishX);
        this.maxX = Math.max(this.startX, this.finishX);
        this.minY = Math.min(this.startY, this.finishY);
        this.maxY = Math.max(this.startY, this.finishY);
    }

    public boolean overlaps(Path other) {
        return (this.minX >= other.minX && this.minX <= other.maxX || other.minX >= this.minX && other.minX <= this.maxX) && (this.minY >= other.minY && this.minY <= other.maxY || other.minY >= this.minY && other.minY <= this.maxY);
    }

    public int getOverlapAmount(Path other) {
        int ox = 0;
        if (this.minX >= other.minX && this.minX <= other.maxX) {
            ox = Math.min(this.maxX, other.maxX) - this.minX;
        } else if (other.minX >= this.minX && other.minX <= this.maxX) {
            ox = Math.min(this.maxX, other.maxX) - other.minX;
        } else {
            return 0;
        }
        int oy = 0;
        if (this.minY >= other.minY && this.minY <= other.maxY) {
            oy = Math.min(this.maxY, other.maxY) - this.minY;
        } else if (other.minY >= this.minY && other.minY <= this.maxY) {
            oy = Math.min(this.maxY, other.maxY) - other.minY;
        } else {
            return 0;
        }
        return ox * oy;
    }

    public int getLengthEstimate() {
        Point2D start = this.segment.getStartEnd().getLocation();
        Point2D finish = this.segment.getFinishEnd().getLocation();
        int xDiff = (int)Math.abs(start.getX() - finish.getX());
        int yDiff = (int)Math.abs(start.getY() - finish.getY());
        return xDiff + yDiff;
    }
}

