/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.ErrorLogger;
import java.util.ArrayList;

public class NetworkManager {
    private Cell currentErrorCell;
    private ArrayList<ErrorHighlight> errorHighlights = new ArrayList();
    private ArrayList<ErrorLogger.MessageLog> errors = new ArrayList();

    void startErrorLogging(Cell cell) {
        this.currentErrorCell = cell;
        this.errorHighlights.clear();
        this.errors.clear();
    }

    void pushHighlight(Export e) {
        this.errorHighlights.add(ErrorHighlight.newInstance(e));
    }

    void pushHighlight(Geometric geom) {
        assert (geom.getParent() == this.currentErrorCell);
        this.errorHighlights.add(ErrorHighlight.newInstance(null, geom));
    }

    void pushHighlight(PortInst pi) {
        Poly poly = pi.getPoly();
        PolyBase.Point[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            int prev = i - 1;
            if (i == 0) {
                prev = points.length - 1;
            }
            this.errorHighlights.add(ErrorHighlight.newInstance(this.currentErrorCell, points[prev], points[i]));
        }
    }

    void logError(String message, int sortKey) {
        this.errors.add(new ErrorLogger.MessageLog(message, this.currentErrorCell, sortKey, this.errorHighlights));
        this.errorHighlights.clear();
    }

    void logWarning(String message, int sortKey) {
        this.errors.add(new ErrorLogger.WarningLog(message, this.currentErrorCell, sortKey, this.errorHighlights));
        this.errorHighlights.clear();
    }

    void finishErrorLogging() {
        Job.updateNetworkErrors(this.currentErrorCell, this.errors);
        this.errorHighlights.clear();
        NetworkTool.totalNumErrors += this.errors.size();
        this.errors.clear();
    }
}

