/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.Highlighter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ErrorHighPoly
extends ErrorHighlight {
    List<ErrorHighlight> linesList = new ArrayList<ErrorHighlight>();
    private final int origId;
    private final CellId origCellId;

    public ErrorHighPoly(Cell c, Geometric o, List<ErrorHighlight> list2) {
        super(c, null);
        if (list2 != null) {
            this.linesList.addAll(list2);
        }
        if (o != null) {
            this.origCellId = o.getParent().getId();
            this.origId = o instanceof NodeInst ? ((NodeInst)o).getD().nodeId : ((ArcInst)o).getD().arcId;
        } else {
            this.origId = -1;
            this.origCellId = null;
        }
    }

    ErrorHighPoly(CellId cellId) {
        super(cellId);
        this.origId = -1;
        this.origCellId = null;
    }

    public static void writeXmlHeader(String indent, PrintStream ps) {
        ps.println(indent + "<!ELEMENT ERRORTYPEPOLY (ERRORTYPETHICKLINE|ERRORTYPELINE)*>");
        ps.println(indent + "<!ATTLIST ERRORTYPEPOLY");
        ps.println(indent + "   cellName CDATA #REQUIRED");
        ps.println(indent + "   origCellName CDATA #IMPLIED");
        ps.println(indent + "   origGeoName CDATA #IMPLIED");
        ps.println(indent + ">");
    }

    @Override
    void writeXmlDescription(String tabs, PrintStream msg, EDatabase database) {
        msg.append(tabs + "<ERRORTYPEPOLY ");
        msg.append("cellName=\"" + this.getCellName(database) + "\" ");
        if (this.origId != -1) {
            Cell cell = this.getOrigCell(database);
            Geometric geo = cell.getNodeById(this.origId);
            if (geo == null) {
                geo = cell.getArcById(this.origId);
            }
            msg.append("origCellName=\"" + cell.describe(false) + "\" ");
            msg.append("origGeoName=\"" + geo.describe(false) + "\" ");
        }
        msg.append(">\n");
        for (ErrorHighlight line : this.linesList) {
            line.writeXmlDescription(tabs + "\t", msg, database);
        }
        msg.append(tabs + "</ERRORTYPEPOLY>\n");
    }

    Cell getOrigCell(EDatabase database) {
        return this.origCellId != null ? database.getCell(this.origCellId) : null;
    }

    @Override
    public void addToHighlighter(Highlighter h, EDatabase database) {
        for (ErrorHighlight line : this.linesList) {
            line.addToHighlighter(h, database);
        }
    }

    @Override
    void write(IdWriter writer) throws IOException {
        this.writeTag(writer, (byte)2);
        writer.writeInt(this.linesList.size());
        for (ErrorHighlight line : this.linesList) {
            line.write(writer);
        }
    }
}

