/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BERT;
import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.NanosimBERT;
import com.sun.electric.tool.simulation.test.NanosimDataGen;
import java.util.Set;
import java.util.TreeSet;

public class NanosimDataAnalyzer
extends NanosimBERT.NanosimTerminal
implements BERT.DataAnalyzer {
    private int delayPeriods = 0;
    private double delayNS = 0.0;
    private NanosimDataGen checkGenerator;
    private StringBuffer capturedData = new StringBuffer();
    private String pinName = null;
    private double voltageLowThreshold = 0.5;
    private double voltageHighThreshold = 0.5;
    private int numErrors = 0;

    NanosimDataAnalyzer(NanosimBERT.NanosimDataModule parentModule) {
        super(parentModule);
    }

    public void measureBER(BERT.DataGenerator expectedData) {
        if (!(expectedData instanceof NanosimDataGen)) {
            System.out.println("Invalid argument to NanosimDataAcquire.acquireDataFor(): can only acquire data for NanosimDataGen");
            return;
        }
        this.checkGenerator = (NanosimDataGen)expectedData;
    }

    public void setDelay(int periods, double ns) {
        this.delayNS = ns;
        this.delayPeriods = periods;
    }

    public void setPinName(String pin) {
        this.pinName = pin;
    }

    public String getPinName() {
        return this.pinName;
    }

    public void setVoltageThreshold(double voltageLowThreshold, double voltageHighThreshold) {
        this.voltageLowThreshold = voltageLowThreshold;
        this.voltageHighThreshold = voltageHighThreshold;
    }

    public double getMeasuredBER() {
        if (this.capturedData.length() == 0) {
            return 0.0;
        }
        return (double)this.numErrors / (double)this.capturedData.length();
    }

    public int voltageToState(double voltage) {
        if (voltage < this.voltageLowThreshold) {
            return 0;
        }
        if (voltage >= this.voltageHighThreshold) {
            return 1;
        }
        return -1;
    }

    private double getDelay() {
        double delay = this.getParentModule().getPeriod() * (double)this.delayPeriods + this.delayNS;
        return delay;
    }

    void logError() {
        ++this.numErrors;
    }

    public Set generateEvents(double startTimeNS, double stopTimeNS) {
        TreeSet<NanosimBERT.Event> set = new TreeSet<NanosimBERT.Event>();
        double curTime = startTimeNS;
        curTime += this.getDelay();
        String node = this.pinName;
        if (node == null) {
            System.out.println("Error: no pin defined for DataAnalyzer, will not capture or check data");
            return set;
        }
        if (this.checkGenerator != null) {
            int bitIndex = 0;
            while (curTime < stopTimeNS) {
                boolean val = this.checkGenerator.getBit(bitIndex);
                NanosimBERT.Event e = NanosimBERT.Event.createCaptureAndCheckNodeEvent(curTime, node, val ? 1 : 0, this);
                set.add(e);
                curTime += this.getParentModule().getPeriod();
                ++bitIndex;
            }
        } else {
            while (curTime < stopTimeNS) {
                NanosimBERT.Event e = NanosimBERT.Event.createCaptureNodeEvent(curTime, node, this);
                set.add(e);
                curTime += this.getParentModule().getPeriod();
            }
        }
        return set;
    }

    void captureBit(boolean b) {
        this.capturedData.append(b ? (char)'1' : '0');
    }

    public BitVector getCapturedData() {
        return new BitVector(this.capturedData.toString(), "captured data");
    }

    public void clearCapturedData() {
        this.capturedData.delete(0, this.capturedData.length());
        this.numErrors = 0;
    }

    public void printCapturedData() {
        String status = this.checkGenerator == null ? "" : (this.numErrors != 0 ? "ERRORS!" : "OK");
        System.out.println("Analyzer on pin '" + this.getPinName() + "' captured " + status + ": " + this.getCapturedData().getState());
    }

    public static void main(String[] args) {
        NanosimBERT.NanosimDataModule module = new NanosimBERT.NanosimDataModule();
        module.setFrequency(1000000.0);
        NanosimDataGen gen = (NanosimDataGen)module.createDataGenerator();
        gen.addPinName("testpin");
        NanosimDataAnalyzer ana = (NanosimDataAnalyzer)module.createDataAnalyzer();
        ana.setPinName("testpinOut");
        ana.setDelay(1, 0.5);
        double time = 10.0;
        System.out.println("Capture only, " + time + "ns");
        NanosimBERT.printEvents(ana.generateEvents(0.0, time));
        time = 30.0;
        System.out.println("-----------------------------------");
        System.out.println("Capture plus Check, " + time + "ns");
        gen.setPattern(new BitVector("1011110", "blah"), new BitVector("0100001011", ""));
        ana.measureBER(gen);
        NanosimBERT.printEvents(ana.generateEvents(0.0, time));
    }
}

