/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Block;
import com.sun.electric.tool.placement.genetic2.DeltaIndividual;
import com.sun.electric.tool.placement.genetic2.UniformGrid;
import com.sun.electric.tool.placement.genetic2.metrics.DeltaBBMetric;
import com.sun.electric.util.math.Orientation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reference {
    double p = 0.0;
    public double[] badnessComponents;
    public double[] overlaps;
    public double[] netLengths;
    public double overlap;
    public double netLength;
    public double spread;
    public UniformGrid grid;
    public List<PlacementFrame.PlacementNode> nodesToPlace;
    public List<PlacementFrame.PlacementNetwork> allNetworks;
    Random rand;
    public double avgW;

    public Reference(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, Random rand) {
        this.nodesToPlace = nodesToPlace;
        this.allNetworks = allNetworks;
        this.rand = rand;
        this.overlap = 0.0;
        this.overlaps = new double[nodesToPlace.size()];
        this.netLengths = new double[allNetworks.size()];
        this.badnessComponents = new double[3];
        this.init();
        this.createGrid();
        this.calculateRefOverlap();
        this.badnessComponents[0] = this.netLength;
        this.badnessComponents[1] = this.overlap;
    }

    public void init() {
        int i;
        PlacementFrame.PlacementNode n;
        for (int i2 = 0; i2 < this.nodesToPlace.size(); ++i2) {
            n = this.nodesToPlace.get(i2);
            this.avgW += Math.max(n.getWidth(), n.getHeight()) / (double)this.nodesToPlace.size();
        }
        int l = (int)Math.sqrt(this.nodesToPlace.size());
        double s = 0.0;
        double m = 0.0;
        for (i = 0; i < this.nodesToPlace.size(); ++i) {
            m = Math.max(this.nodesToPlace.get(i).getHeight(), this.nodesToPlace.get(i).getWidth());
            s = Math.max(s, m);
        }
        for (i = 0; i < this.nodesToPlace.size(); ++i) {
            n = this.nodesToPlace.get(i);
            n.setPlacement((double)(-l / 2) * s + (double)(i % l) * s, (double)(-l / 2) * s + (double)((int)((double)i / (double)l)) * s);
            n.setOrientation(Orientation.IDENT);
        }
    }

    public double getSemiperimeterLength() {
        Block b = new Block();
        b.valuesFrom(this.nodesToPlace.get(0));
        double left = b.getLeft();
        double top = b.getTop();
        double right = b.getRight();
        double bottom = b.getBottom();
        for (int i = 0; i < this.nodesToPlace.size(); ++i) {
            b.valuesFrom(this.nodesToPlace.get(i));
            if (b.getLeft() < left) {
                left = b.getLeft();
            }
            if (b.getTop() > top) {
                top = b.getTop();
            }
            if (b.getRight() > right) {
                right = b.getRight();
            }
            if (!(b.getBottom() < bottom)) continue;
            bottom = b.getBottom();
        }
        return top - bottom + (right - left);
    }

    public double calculateSpread() {
        this.spread = 0.0;
        Block b = new Block();
        for (int i = 0; i < this.nodesToPlace.size(); ++i) {
            b.valuesFrom(this.nodesToPlace.get(i));
            this.spread += Math.sqrt(b.getX() * b.getX() + b.getY() * b.getY()) * b.getWidth() * b.getHeight();
        }
        return this.spread;
    }

    public void setProgress(double p) {
        this.p = p;
    }

    public double getBadness() {
        double badness = 0.0;
        badness += this.badnessComponents[0];
        badness += this.badnessComponents[1] * (1.0 + 300.0 * this.p * this.p);
        return badness += 1.0E-5 * this.spread;
    }

    public double[] getBadnessComponents() {
        return this.badnessComponents;
    }

    public void calculateFirstTime() {
        this.createGrid();
        this.calculateRefOverlap();
        this.calculateRefNetLength();
        this.calculateSpread();
        this.badnessComponents[0] = this.netLength;
        this.badnessComponents[1] = this.overlap;
    }

    public void calculateRefOverlap() {
        this.overlap = 0.0;
        for (int i = 0; i < this.nodesToPlace.size(); ++i) {
            this.overlap += this.grid.collide(i, this.nodesToPlace, this.overlaps);
        }
    }

    public double getNaiveOverlap() {
        Block a = new Block();
        Block b = new Block();
        double naiveOverlap = 0.0;
        for (int i = 0; i < this.nodesToPlace.size(); ++i) {
            PlacementFrame.PlacementNode n1 = this.nodesToPlace.get(i);
            a.valuesFrom(n1);
            for (int j = 0; j < i; ++j) {
                if (i == j) continue;
                PlacementFrame.PlacementNode n2 = this.nodesToPlace.get(j);
                b.valuesFrom(n2);
                naiveOverlap += a.intersectionArea(b);
            }
        }
        return naiveOverlap;
    }

    public void calculateRefNetLength() {
        this.netLength = DeltaBBMetric.compute();
    }

    public void update(DeltaIndividual indi) {
        int i;
        this.netLength = indi.getBadnessComponents()[0];
        this.overlap = indi.getBadnessComponents()[1];
        this.netLengths = new double[indi.netLengths.length];
        for (i = 0; i < indi.netLengths.length; ++i) {
            this.netLengths[i] = indi.netLengths[i];
        }
        this.overlaps = new double[indi.overlaps.length];
        for (i = 0; i < indi.overlaps.length; ++i) {
            this.overlaps[i] = indi.overlaps[i];
        }
        this.spread = indi.getBadnessComponents()[2];
        for (Block b : indi.blocks) {
            this.grid.remove(b.getNr());
            Collections.sort(this.grid.insert(b.getNr(), b.getX(), b.getY()));
            this.nodesToPlace.get(b.getNr()).setPlacement(b.getX(), b.getY());
            this.nodesToPlace.get(b.getNr()).setOrientation(b.getOrientation());
        }
        this.badnessComponents[0] = this.netLength;
        this.badnessComponents[1] = this.overlap;
        this.badnessComponents[2] = this.spread;
    }

    public void createGrid() {
        double left = Double.POSITIVE_INFINITY;
        double right = Double.NEGATIVE_INFINITY;
        double top = Double.NEGATIVE_INFINITY;
        double bottom = Double.POSITIVE_INFINITY;
        double maxW = 0.0;
        ArrayList<Double> xPositions = new ArrayList<Double>();
        ArrayList<Double> yPositions = new ArrayList<Double>();
        Block b = new Block();
        for (PlacementFrame.PlacementNode n : this.nodesToPlace) {
            b.valuesFrom(n);
            xPositions.add(new Double(b.getX()));
            yPositions.add(new Double(b.getY()));
            if (b.getWidth() > maxW) {
                maxW = b.getWidth();
            }
            if (!(b.getHeight() > maxW)) continue;
            maxW = b.getHeight();
        }
        Collections.sort(xPositions);
        Collections.sort(yPositions);
        left = (Double)xPositions.get(xPositions.size() / 10);
        right = (Double)xPositions.get(xPositions.size() - xPositions.size() / 10 - 1);
        bottom = (Double)yPositions.get(yPositions.size() / 10);
        top = (Double)yPositions.get(yPositions.size() - yPositions.size() / 10 - 1);
        this.grid = new UniformGrid(this.nodesToPlace, left, right, top, bottom, maxW);
        for (int i = 0; i < this.nodesToPlace.size(); ++i) {
            this.grid.insert(i, this.nodesToPlace.get(i).getPlacementX(), this.nodesToPlace.get(i).getPlacementY());
        }
    }
}

