/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.metrics;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingField;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingPattern;
import com.sun.electric.tool.placement.forceDirected2.metrics.AbstractMetric;
import java.math.BigDecimal;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverallAreaMetric
extends AbstractMetric {
    private static final String metricName = "Overall Area Metric";
    private CheckboardingPattern checkPattern;

    public OverallAreaMetric(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, CheckboardingPattern pattern) {
        super(nodesToPlace, allNetworks);
        this.checkPattern = pattern;
    }

    @Override
    public Double compute() {
        return new Double(this.computeAsBigDecimal().doubleValue());
    }

    public BigDecimal computeAsBigDecimal() {
        if (this.checkPattern == null) {
            return new BigDecimal(-1.0);
        }
        BigDecimal minX = null;
        BigDecimal maxX = null;
        BigDecimal minY = new BigDecimal(-1);
        BigDecimal maxY = new BigDecimal(-1);
        for (int i = 0; i < this.checkPattern.getAll().length; ++i) {
            for (int j = 0; j < this.checkPattern.getAll()[i].length; ++j) {
                CheckboardingField field2 = this.checkPattern.getField(j, i);
                if (field2.getNode() == null) continue;
                if (minX == null) {
                    minX = new BigDecimal(field2.getLocation().getX() - field2.getNode().getWidth() / 2.0);
                    maxX = new BigDecimal(field2.getLocation().getX() - field2.getNode().getWidth() / 2.0);
                }
                if (minY == null) {
                    minY = new BigDecimal(field2.getLocation().getY() - field2.getNode().getHeight() / 2.0);
                    maxY = new BigDecimal(field2.getLocation().getY() - field2.getNode().getHeight() / 2.0);
                }
                BigDecimal tmpX = new BigDecimal(field2.getLocation().getX() + field2.getNode().getWidth() / 2.0);
                maxX = maxX.max(tmpX);
                BigDecimal tmpY = new BigDecimal(field2.getLocation().getY() + field2.getNode().getHeight() / 2.0);
                maxY = maxY.max(tmpY);
            }
        }
        BigDecimal x = maxX.subtract(minX);
        BigDecimal y = maxY.subtract(minY);
        return x.multiply(y);
    }

    public CheckboardingPattern getCheckPattern() {
        return this.checkPattern;
    }

    @Override
    public String getMetricName() {
        return metricName;
    }

    public void setCheckPattern(CheckboardingPattern checkPattern) {
        this.checkPattern = checkPattern;
    }
}

