/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.Aborter;
import com.sun.electric.tool.ncc.NccEngine;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.PassedNcc;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.CompareList;
import com.sun.electric.tool.ncc.basic.CompareLists;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.ncc.result.NccResults;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NccBottomUp {
    private void prln(String s) {
        System.out.println(s);
    }

    private CellContext selectAndRemoveReferenceCellContext(List<CellContext> cellCtxts) {
        Iterator<CellContext> it = cellCtxts.iterator();
        while (it.hasNext()) {
            CellContext cc = it.next();
            if (!cc.cell.isSchematic()) continue;
            it.remove();
            return cc;
        }
        it = cellCtxts.iterator();
        CellContext refCell = it.next();
        it.remove();
        return refCell;
    }

    private boolean hasBlackBoxAnnotation(CompareList compareList) {
        Iterator<CellContext> it = compareList.iterator();
        while (it.hasNext()) {
            String reason;
            Cell c = it.next().cell;
            NccCellAnnotations ann = NccCellAnnotations.getAnnotations(c);
            if (ann == null || (reason = ann.getBlackBoxReason()) == null) continue;
            this.prln("Black box: " + NccUtils.fullName(c) + " because " + reason);
            return true;
        }
        return false;
    }

    private NccResult compareAndPrintStatus(Cell cell1, VarContext ctxt1, Cell cell2, VarContext ctxt2, HierarchyInfo hierInfo, NccOptions options, Aborter aborter) {
        this.prln("Comparing: " + NccUtils.fullName(cell1) + " with: " + NccUtils.fullName(cell2));
        System.out.flush();
        Date before = new Date();
        NccResult result2 = NccEngine.compare(cell1, ctxt1, cell2, ctxt2, hierInfo, options, aborter);
        Date after = new Date();
        if (!aborter.userWantsToAbort()) {
            String timeStr = NccUtils.hourMinSec(before, after);
            this.prln(result2.summary(options.checkSizes) + " in " + timeStr + ".");
            System.out.flush();
        }
        return result2;
    }

    private boolean compareCellsInCompareList(NccResults results, CompareList compareList, HierarchyInfo hierInfo, boolean blackBoxAnn, PassedNcc passed, NccOptions options, Aborter aborter) {
        ArrayList<CellContext> cellCntxts = new ArrayList<CellContext>();
        HashSet<Cell> compareListCells = new HashSet<Cell>();
        for (CellContext cc : compareList) {
            cellCntxts.add(cc);
            compareListCells.add(cc.cell);
        }
        Cell cell = ((CellContext)cellCntxts.iterator().next()).cell;
        String grpNm = cell.getLibrary().getName() + ":" + cell.getName();
        hierInfo.beginNextCompareList(grpNm);
        if (this.hasNotSubcircuitAnnotation(cellCntxts)) {
            hierInfo.purgeCurrentCompareList();
        }
        CellContext refCC = this.selectAndRemoveReferenceCellContext(cellCntxts);
        for (CellContext thisCC : cellCntxts) {
            NccResult r;
            if (blackBoxAnn || options.skipPassed && passed.getPassed(refCC.cell, thisCC.cell)) {
                if (hierInfo == null) continue;
                r = NccUtils.buildBlackBoxes(refCC, thisCC, hierInfo, options, aborter);
                results.add(r);
                return !r.match();
            }
            hierInfo.restrictSubcktDetection(refCC, thisCC, compareListCells);
            if (options.operation == 1) {
                results.abandonPriorResults();
            }
            r = this.compareAndPrintStatus(refCC.cell, refCC.context, thisCC.cell, thisCC.context, hierInfo, options, aborter);
            results.add(r);
            if (r.match()) {
                passed.setPassed(refCC.cell, thisCC.cell);
            }
            if ((r.match() || !options.haltAfterFirstMismatch) && !aborter.userWantsToAbort()) continue;
            break;
        }
        if (!blackBoxAnn && options.operation != 0) {
            hierInfo.purgeCurrentCompareList();
        }
        return false;
    }

    private boolean hasNotSubcircuitAnnotation(List<CellContext> cellContextsInGroup) {
        for (CellContext cc : cellContextsInGroup) {
            String notSubcktReason;
            Cell c = cc.cell;
            NccCellAnnotations anns = NccCellAnnotations.getAnnotations(c);
            if (anns == null || (notSubcktReason = anns.getNotSubcircuitReason()) == null) continue;
            System.out.println("For this hierarchical NCC I'm not treating " + NccUtils.fullName(c) + " as a subcircuit because " + notSubcktReason);
            return true;
        }
        return false;
    }

    private NccResults processCompareLists(List<CompareList> compareLists, PassedNcc passed, NccOptions options, Aborter aborter) {
        NccResults results = new NccResults();
        HierarchyInfo hierInfo = new HierarchyInfo();
        Iterator<CompareList> it = compareLists.iterator();
        while (it.hasNext()) {
            boolean blackBoxErr;
            CompareList compareList = it.next();
            boolean blackBoxAnn = this.hasBlackBoxAnnotation(compareList);
            if (options.operation == 2 && !blackBoxAnn && it.hasNext()) continue;
            if (options.operation == 1) {
                results.abandonPriorResults();
            }
            if (!compareList.isSafeToCheckSizes() && options.operation != 2 && !blackBoxAnn) {
                NccOptions tmpOptions = new NccOptions(options);
                tmpOptions.checkSizes = false;
                blackBoxErr = this.compareCellsInCompareList(results, compareList, hierInfo, blackBoxAnn, passed, tmpOptions, aborter);
                hierInfo.purgeCurrentCompareList();
            } else {
                blackBoxErr = this.compareCellsInCompareList(results, compareList, hierInfo, blackBoxAnn, passed, options, aborter);
            }
            if (blackBoxErr) {
                this.prln("Halting multiple cell NCC because of failure to build a black box");
                return results;
            }
            if (aborter.userWantsToAbort()) {
                return results;
            }
            if (results.exportMatch() && results.topologyMatch() || !options.haltAfterFirstMismatch) continue;
            this.prln("Halting NCC after finding first mismatch");
            return results;
        }
        return results;
    }

    private NccResults compareCells(CellContext cc1, CellContext cc2, PassedNcc passed, NccOptions options, Aborter aborter) {
        List<CompareList> compareLists = CompareLists.getCompareLists(cc1, cc2);
        return this.processCompareLists(compareLists, passed, options, aborter);
    }

    public static NccResults compare(CellContext cc1, CellContext cc2, PassedNcc passed, NccOptions options, Aborter aborter) {
        NccBottomUp bo = new NccBottomUp();
        return bo.compareCells(cc1, cc2, passed, options, aborter);
    }
}

