/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc.wellcheck;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.erc.wellcheck.WellCheckAnalysisStrategy;
import com.sun.electric.tool.util.concurrent.utils.ElapseTimer;
import com.sun.electric.util.TextUtils;
import java.awt.geom.Rectangle2D;

public class DRCCheck
implements WellCheckAnalysisStrategy {
    private Layer pWellLayer;
    private Layer nWellLayer;
    private RTNode pWellRoot;
    private RTNode nWellRoot;
    private ERCWellCheck.StrategyParameter parameters;

    public DRCCheck(ERCWellCheck.StrategyParameter parameters, Layer pWellLayer, Layer nWellLayer, RTNode pWellRoot, RTNode nWellRoot) {
        this.parameters = parameters;
        this.pWellLayer = pWellLayer;
        this.nWellLayer = nWellLayer;
        this.pWellRoot = pWellRoot;
        this.nWellRoot = nWellRoot;
    }

    public void execute() {
        if (this.parameters.getWellPrefs().drcCheck) {
            ElapseTimer timer = ElapseTimer.createInstance();
            timer.start();
            DRCTemplate pRule = DRC.getSpacingRule(this.pWellLayer, null, this.pWellLayer, null, false, -1, 0.0, 0.0);
            DRCTemplate nRule = DRC.getSpacingRule(this.nWellLayer, null, this.nWellLayer, null, false, -1, 0.0, 0.0);
            if (pRule != null) {
                this.findDRCViolations(this.pWellRoot, pRule.getValue(0));
            }
            if (nRule != null) {
                this.findDRCViolations(this.nWellRoot, nRule.getValue(0));
            }
            timer.end();
            System.out.println("   Design rule check took " + timer.toString());
        }
    }

    private void findDRCViolations(RTNode rtree, double minDist) {
        for (int j = 0; j < rtree.getTotal(); ++j) {
            Object child;
            if (rtree.getFlag()) {
                child = (ERCWellCheck.WellBound)rtree.getChild(j);
                if (((ERCWellCheck.WellBound)child).getNetID() == null) continue;
                Rectangle2D.Double searchArea = new Rectangle2D.Double(((ERCWellCheck.WellBound)child).getBounds().getMinX() - minDist, ((ERCWellCheck.WellBound)child).getBounds().getMinY() - minDist, ((ERCWellCheck.WellBound)child).getBounds().getWidth() + minDist * 2.0, ((ERCWellCheck.WellBound)child).getBounds().getHeight() + minDist * 2.0);
                RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
                while (sea.hasNext()) {
                    PolyBase pb;
                    double trueDist;
                    ERCWellCheck.WellBound other = (ERCWellCheck.WellBound)sea.next();
                    if (other.getNetID().getIndex() <= ((ERCWellCheck.WellBound)child).getNetID().getIndex() || ((ERCWellCheck.WellBound)child).getBounds().getMinX() > other.getBounds().getMaxX() + minDist || other.getBounds().getMinX() > ((ERCWellCheck.WellBound)child).getBounds().getMaxX() + minDist || ((ERCWellCheck.WellBound)child).getBounds().getMinY() > other.getBounds().getMaxY() + minDist || other.getBounds().getMinY() > ((ERCWellCheck.WellBound)child).getBounds().getMaxY() + minDist || !((trueDist = (pb = new PolyBase(((ERCWellCheck.WellBound)child).getBounds())).polyDistance(other.getBounds())) < minDist)) continue;
                    this.parameters.logError("Well areas too close (are " + TextUtils.formatDistance(trueDist) + " but should be " + TextUtils.formatDistance(minDist) + " apart)", child, other);
                }
                continue;
            }
            child = (RTNode)rtree.getChild(j);
            this.findDRCViolations((RTNode)child, minDist);
        }
    }
}

